import { createTimes, setMidnight, createDate, createSlotTimeLimits, sortEventChunks, setContent, keyEnter, bgEvent, helperEvent, toEventWithLocalDates, toViewWithLocalDates, task, ghostEvent, createEventClasses, createEventContent, addDuration, cloneDate, eventIntersects, createEventChunk, datesEqual, setPayload, rect, floor, ancestor, repositionEvent, height, runReposition, addDay, prepareEventChunks, debounce, toISOString, btnTextDay, themeView, btnTextWeek } from '@event-calendar/core';
import { derived } from 'svelte/store';
import { is_function, SvelteComponent, init, safe_not_equal, ensure_array_like, create_slot, element, space, attr, insert, append, action_destroyer, update_slot_base, get_all_dirty_from_scope, get_slot_changes, transition_in, transition_out, detach, destroy_each, component_subscribe, create_component, mount_component, destroy_component, set_store_value, empty, binding_callbacks, construct_svelte_component, listen, group_outros, check_outros, run_all, set_style, noop, update_keyed_each, outro_and_destroy_block } from 'svelte/internal';
import { getContext, onMount, afterUpdate } from 'svelte';

function times(state) {
    return derived(
        [state.slotDuration, state._slotTimeLimits, state._intlSlotLabel],
        args => createTimes(setMidnight(createDate()), ...args)
    );
}

function slotTimeLimits(state) {
    return derived(
        [state.slotMinTime, state.slotMaxTime, state.flexibleSlotTimeLimits, state._viewDates, state._events],
        args => createSlotTimeLimits(...args)
    );
}

function groupEventChunks(chunks) {
    if (!chunks.length) {
        return;
    }

    sortEventChunks(chunks);

    // Group
    let group = {
        columns: [],
        end: chunks[0].end
    };
    for (let chunk of chunks) {
        let c = 0;
        if (chunk.start < group.end) {
            for (; c < group.columns.length; ++c) {
                if (group.columns[c][group.columns[c].length - 1].end <= chunk.start) {
                    break;
                }
            }
            if (chunk.end > group.end) {
                group.end = chunk.end;
            }
        } else {
            group = {
                columns: [],
                end: chunk.end
            };
        }

        if (group.columns.length < c + 1) {
            group.columns.push([]);
        }
        group.columns[c].push(chunk);

        chunk.group = group;
        chunk.column = c;
    }
}

function createAllDayContent(allDayContent) {
    let text = 'all-day';
    let content;
    if (allDayContent) {
        content = is_function(allDayContent) ? allDayContent({text}) : allDayContent;
        if (typeof content === 'string') {
            content = {html: content};
        }
    } else {
        content = {
            html: text
        };
    }

    return content;
}

/* packages/time-grid/src/Section.svelte generated by Svelte v4.2.18 */
const get_lines_slot_changes = dirty => ({});
const get_lines_slot_context = ctx => ({});

function get_each_context$5(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[9] = list[i];
	return child_ctx;
}

// (14:4) {#each $_times as time}
function create_each_block$5(ctx) {
	let time_1;
	let time_1_class_value;
	let time_1_datetime_value;
	let setContent_action;
	let mounted;
	let dispose;

	return {
		c() {
			time_1 = element("time");
			attr(time_1, "class", time_1_class_value = /*$theme*/ ctx[1].time);
			attr(time_1, "datetime", time_1_datetime_value = /*time*/ ctx[9][0]);
		},
		m(target, anchor) {
			insert(target, time_1, anchor);

			if (!mounted) {
				dispose = action_destroyer(setContent_action = setContent.call(null, time_1, /*time*/ ctx[9][2] ? /*time*/ ctx[9][1] : ''));
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty & /*$theme*/ 2 && time_1_class_value !== (time_1_class_value = /*$theme*/ ctx[1].time)) {
				attr(time_1, "class", time_1_class_value);
			}

			if (dirty & /*$_times*/ 4 && time_1_datetime_value !== (time_1_datetime_value = /*time*/ ctx[9][0])) {
				attr(time_1, "datetime", time_1_datetime_value);
			}

			if (setContent_action && is_function(setContent_action.update) && dirty & /*$_times*/ 4) setContent_action.update.call(null, /*time*/ ctx[9][2] ? /*time*/ ctx[9][1] : '');
		},
		d(detaching) {
			if (detaching) {
				detach(time_1);
			}

			mounted = false;
			dispose();
		}
	};
}

function create_fragment$8(ctx) {
	let div1;
	let div0;
	let div0_class_value;
	let setContent_action;
	let t0;
	let div1_class_value;
	let t1;
	let div3;
	let div2;
	let div2_class_value;
	let t2;
	let div3_class_value;
	let current;
	let mounted;
	let dispose;
	let each_value = ensure_array_like(/*$_times*/ ctx[2]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$5(get_each_context$5(ctx, each_value, i));
	}

	const lines_slot_template = /*#slots*/ ctx[8].lines;
	const lines_slot = create_slot(lines_slot_template, ctx, /*$$scope*/ ctx[7], get_lines_slot_context);
	const default_slot_template = /*#slots*/ ctx[8].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[7], null);

	return {
		c() {
			div1 = element("div");
			div0 = element("div");
			t0 = space();

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t1 = space();
			div3 = element("div");
			div2 = element("div");
			if (lines_slot) lines_slot.c();
			t2 = space();
			if (default_slot) default_slot.c();
			attr(div0, "class", div0_class_value = /*$theme*/ ctx[1].sidebarTitle);
			attr(div1, "class", div1_class_value = /*$theme*/ ctx[1].sidebar);
			attr(div2, "class", div2_class_value = /*$theme*/ ctx[1].lines);
			attr(div3, "class", div3_class_value = /*$theme*/ ctx[1].days);
			attr(div3, "role", "row");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			append(div1, t0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(div1, null);
				}
			}

			insert(target, t1, anchor);
			insert(target, div3, anchor);
			append(div3, div2);

			if (lines_slot) {
				lines_slot.m(div2, null);
			}

			append(div3, t2);

			if (default_slot) {
				default_slot.m(div3, null);
			}

			current = true;

			if (!mounted) {
				dispose = action_destroyer(setContent_action = setContent.call(null, div0, /*allDayText*/ ctx[0]));
				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (!current || dirty & /*$theme*/ 2 && div0_class_value !== (div0_class_value = /*$theme*/ ctx[1].sidebarTitle)) {
				attr(div0, "class", div0_class_value);
			}

			if (setContent_action && is_function(setContent_action.update) && dirty & /*allDayText*/ 1) setContent_action.update.call(null, /*allDayText*/ ctx[0]);

			if (dirty & /*$theme, $_times*/ 6) {
				each_value = ensure_array_like(/*$_times*/ ctx[2]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$5(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$5(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(div1, null);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}

			if (!current || dirty & /*$theme*/ 2 && div1_class_value !== (div1_class_value = /*$theme*/ ctx[1].sidebar)) {
				attr(div1, "class", div1_class_value);
			}

			if (lines_slot) {
				if (lines_slot.p && (!current || dirty & /*$$scope*/ 128)) {
					update_slot_base(
						lines_slot,
						lines_slot_template,
						ctx,
						/*$$scope*/ ctx[7],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[7])
						: get_slot_changes(lines_slot_template, /*$$scope*/ ctx[7], dirty, get_lines_slot_changes),
						get_lines_slot_context
					);
				}
			}

			if (!current || dirty & /*$theme*/ 2 && div2_class_value !== (div2_class_value = /*$theme*/ ctx[1].lines)) {
				attr(div2, "class", div2_class_value);
			}

			if (default_slot) {
				if (default_slot.p && (!current || dirty & /*$$scope*/ 128)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[7],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[7])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[7], dirty, null),
						null
					);
				}
			}

			if (!current || dirty & /*$theme*/ 2 && div3_class_value !== (div3_class_value = /*$theme*/ ctx[1].days)) {
				attr(div3, "class", div3_class_value);
			}
		},
		i(local) {
			if (current) return;
			transition_in(lines_slot, local);
			transition_in(default_slot, local);
			current = true;
		},
		o(local) {
			transition_out(lines_slot, local);
			transition_out(default_slot, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(div1);
				detach(t1);
				detach(div3);
			}

			destroy_each(each_blocks, detaching);
			if (lines_slot) lines_slot.d(detaching);
			if (default_slot) default_slot.d(detaching);
			mounted = false;
			dispose();
		}
	};
}

function instance$8($$self, $$props, $$invalidate) {
	let $allDayContent;
	let $theme;
	let $_times;
	let { $$slots: slots = {}, $$scope } = $$props;
	let { allDayContent, theme, _times } = getContext('state');
	component_subscribe($$self, allDayContent, value => $$invalidate(6, $allDayContent = value));
	component_subscribe($$self, theme, value => $$invalidate(1, $theme = value));
	component_subscribe($$self, _times, value => $$invalidate(2, $_times = value));
	let allDayText;

	$$self.$$set = $$props => {
		if ('$$scope' in $$props) $$invalidate(7, $$scope = $$props.$$scope);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*$allDayContent*/ 64) {
			$$invalidate(0, allDayText = createAllDayContent($allDayContent));
		}
	};

	return [
		allDayText,
		$theme,
		$_times,
		allDayContent,
		theme,
		_times,
		$allDayContent,
		$$scope,
		slots
	];
}

class Section extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$8, create_fragment$8, safe_not_equal, {});
	}
}

/* packages/time-grid/src/Body.svelte generated by Svelte v4.2.18 */

function get_each_context$4(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[23] = list[i];
	return child_ctx;
}

// (34:8) <Section>
function create_default_slot$1(ctx) {
	let current;
	const default_slot_template = /*#slots*/ ctx[16].default;
	const default_slot = create_slot(default_slot_template, ctx, /*$$scope*/ ctx[18], null);

	return {
		c() {
			if (default_slot) default_slot.c();
		},
		m(target, anchor) {
			if (default_slot) {
				default_slot.m(target, anchor);
			}

			current = true;
		},
		p(ctx, dirty) {
			if (default_slot) {
				if (default_slot.p && (!current || dirty & /*$$scope*/ 262144)) {
					update_slot_base(
						default_slot,
						default_slot_template,
						ctx,
						/*$$scope*/ ctx[18],
						!current
						? get_all_dirty_from_scope(/*$$scope*/ ctx[18])
						: get_slot_changes(default_slot_template, /*$$scope*/ ctx[18], dirty, null),
						null
					);
				}
			}
		},
		i(local) {
			if (current) return;
			transition_in(default_slot, local);
			current = true;
		},
		o(local) {
			transition_out(default_slot, local);
			current = false;
		},
		d(detaching) {
			if (default_slot) default_slot.d(detaching);
		}
	};
}

// (36:16) {#each lines as line}
function create_each_block$4(ctx) {
	let div;
	let div_class_value;

	return {
		c() {
			div = element("div");
			attr(div, "class", div_class_value = /*$theme*/ ctx[3].line);
		},
		m(target, anchor) {
			insert(target, div, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*$theme*/ 8 && div_class_value !== (div_class_value = /*$theme*/ ctx[3].line)) {
				attr(div, "class", div_class_value);
			}
		},
		d(detaching) {
			if (detaching) {
				detach(div);
			}
		}
	};
}

// (35:12) <svelte:fragment slot="lines">
function create_lines_slot(ctx) {
	let each_1_anchor;
	let each_value = ensure_array_like(/*lines*/ ctx[2]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$4(get_each_context$4(ctx, each_value, i));
	}

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert(target, each_1_anchor, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*$theme, lines*/ 12) {
				each_value = ensure_array_like(/*lines*/ ctx[2]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$4(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block$4(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value.length;
			}
		},
		d(detaching) {
			if (detaching) {
				detach(each_1_anchor);
			}

			destroy_each(each_blocks, detaching);
		}
	};
}

function create_fragment$7(ctx) {
	let div1;
	let div0;
	let section;
	let div0_class_value;
	let div1_class_value;
	let current;

	section = new Section({
			props: {
				$$slots: {
					lines: [create_lines_slot],
					default: [create_default_slot$1]
				},
				$$scope: { ctx }
			}
		});

	return {
		c() {
			div1 = element("div");
			div0 = element("div");
			create_component(section.$$.fragment);
			attr(div0, "class", div0_class_value = /*$theme*/ ctx[3].content);

			attr(div1, "class", div1_class_value = "" + (/*$theme*/ ctx[3].body + (/*compact*/ ctx[1]
			? ' ' + /*$theme*/ ctx[3].compact
			: '')));
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			mount_component(section, div0, null);
			/*div1_binding*/ ctx[17](div1);
			current = true;
		},
		p(ctx, [dirty]) {
			const section_changes = {};

			if (dirty & /*$$scope, lines, $theme*/ 262156) {
				section_changes.$$scope = { dirty, ctx };
			}

			section.$set(section_changes);

			if (!current || dirty & /*$theme*/ 8 && div0_class_value !== (div0_class_value = /*$theme*/ ctx[3].content)) {
				attr(div0, "class", div0_class_value);
			}

			if (!current || dirty & /*$theme, compact*/ 10 && div1_class_value !== (div1_class_value = "" + (/*$theme*/ ctx[3].body + (/*compact*/ ctx[1]
			? ' ' + /*$theme*/ ctx[3].compact
			: '')))) {
				attr(div1, "class", div1_class_value);
			}
		},
		i(local) {
			if (current) return;
			transition_in(section.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(section.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(div1);
			}

			destroy_component(section);
			/*div1_binding*/ ctx[17](null);
		}
	};
}

function instance$7($$self, $$props, $$invalidate) {
	let $slotHeight;
	let $slotDuration;
	let $_slotTimeLimits;
	let $scrollTime;
	let $_viewDates;
	let $_times;
	let $_bodyEl;
	let $theme;
	let { $$slots: slots = {}, $$scope } = $$props;
	let { _bodyEl, _viewDates, _slotTimeLimits, _times, scrollTime, slotDuration, slotHeight, theme } = getContext('state');
	component_subscribe($$self, _bodyEl, value => $$invalidate(21, $_bodyEl = value));
	component_subscribe($$self, _viewDates, value => $$invalidate(14, $_viewDates = value));
	component_subscribe($$self, _slotTimeLimits, value => $$invalidate(20, $_slotTimeLimits = value));
	component_subscribe($$self, _times, value => $$invalidate(15, $_times = value));
	component_subscribe($$self, scrollTime, value => $$invalidate(13, $scrollTime = value));
	component_subscribe($$self, slotDuration, value => $$invalidate(12, $slotDuration = value));
	component_subscribe($$self, slotHeight, value => $$invalidate(19, $slotHeight = value));
	component_subscribe($$self, theme, value => $$invalidate(3, $theme = value));
	let el;
	let compact;
	let lines = [];

	function scrollToTime() {
		$$invalidate(0, el.scrollTop = (($scrollTime.seconds - $_slotTimeLimits.min.seconds) / $slotDuration.seconds - 0.5) * $slotHeight, el);
	}

	function div1_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(0, el);
		});
	}

	$$self.$$set = $$props => {
		if ('$$scope' in $$props) $$invalidate(18, $$scope = $$props.$$scope);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*el*/ 1) {
			set_store_value(_bodyEl, $_bodyEl = el, $_bodyEl);
		}

		if ($$self.$$.dirty & /*$slotDuration, $_times*/ 36864) {
			{
				$$invalidate(1, compact = $slotDuration.seconds >= 3600);
				$$invalidate(2, lines.length = $_times.length, lines);
			}
		}

		if ($$self.$$.dirty & /*el, $_viewDates, $scrollTime*/ 24577) {
			if (el) {
				scrollToTime();
			}
		}
	};

	return [
		el,
		compact,
		lines,
		$theme,
		_bodyEl,
		_viewDates,
		_slotTimeLimits,
		_times,
		scrollTime,
		slotDuration,
		slotHeight,
		theme,
		$slotDuration,
		$scrollTime,
		$_viewDates,
		$_times,
		slots,
		div1_binding,
		$$scope
	];
}

class Body extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$7, create_fragment$7, safe_not_equal, {});
	}
}

/* packages/time-grid/src/Event.svelte generated by Svelte v4.2.18 */

function create_fragment$6(ctx) {
	let article;
	let div;
	let div_class_value;
	let setContent_action;
	let t;
	let switch_instance;
	let article_role_value;
	let article_tabindex_value;
	let current;
	let mounted;
	let dispose;
	var switch_value = /*$_interaction*/ ctx[10].resizer;

	function switch_props(ctx, dirty) {
		return { props: { event: /*event*/ ctx[0] } };
	}

	if (switch_value) {
		switch_instance = construct_svelte_component(switch_value, switch_props(ctx));

		switch_instance.$on("pointerdown", function () {
			if (is_function(/*createDragHandler*/ ctx[34](/*$_interaction*/ ctx[10], 'y'))) /*createDragHandler*/ ctx[34](/*$_interaction*/ ctx[10], 'y').apply(this, arguments);
		});
	}

	return {
		c() {
			article = element("article");
			div = element("div");
			t = space();
			if (switch_instance) create_component(switch_instance.$$.fragment);
			attr(div, "class", div_class_value = /*$theme*/ ctx[2].eventBody);
			attr(article, "class", /*classes*/ ctx[4]);
			attr(article, "style", /*style*/ ctx[5]);
			attr(article, "role", article_role_value = /*onclick*/ ctx[7] ? 'button' : undefined);
			attr(article, "tabindex", article_tabindex_value = /*onclick*/ ctx[7] ? 0 : undefined);
		},
		m(target, anchor) {
			insert(target, article, anchor);
			append(article, div);
			append(article, t);
			if (switch_instance) mount_component(switch_instance, article, null);
			/*article_binding*/ ctx[53](article);
			current = true;

			if (!mounted) {
				dispose = [
					action_destroyer(setContent_action = setContent.call(null, div, /*content*/ ctx[6])),
					listen(article, "click", function () {
						if (is_function(/*onclick*/ ctx[7])) /*onclick*/ ctx[7].apply(this, arguments);
					}),
					listen(article, "keydown", function () {
						if (is_function(/*onclick*/ ctx[7] && keyEnter(/*onclick*/ ctx[7]))) (/*onclick*/ ctx[7] && keyEnter(/*onclick*/ ctx[7])).apply(this, arguments);
					}),
					listen(article, "mouseenter", function () {
						if (is_function(/*createHandler*/ ctx[33](/*$eventMouseEnter*/ ctx[8], /*display*/ ctx[1]))) /*createHandler*/ ctx[33](/*$eventMouseEnter*/ ctx[8], /*display*/ ctx[1]).apply(this, arguments);
					}),
					listen(article, "mouseleave", function () {
						if (is_function(/*createHandler*/ ctx[33](/*$eventMouseLeave*/ ctx[9], /*display*/ ctx[1]))) /*createHandler*/ ctx[33](/*$eventMouseLeave*/ ctx[9], /*display*/ ctx[1]).apply(this, arguments);
					}),
					listen(article, "pointerdown", function () {
						if (is_function(!bgEvent(/*display*/ ctx[1]) && !helperEvent(/*display*/ ctx[1]) && /*createDragHandler*/ ctx[34](/*$_interaction*/ ctx[10]))) (!bgEvent(/*display*/ ctx[1]) && !helperEvent(/*display*/ ctx[1]) && /*createDragHandler*/ ctx[34](/*$_interaction*/ ctx[10])).apply(this, arguments);
					})
				];

				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (!current || dirty[0] & /*$theme*/ 4 && div_class_value !== (div_class_value = /*$theme*/ ctx[2].eventBody)) {
				attr(div, "class", div_class_value);
			}

			if (setContent_action && is_function(setContent_action.update) && dirty[0] & /*content*/ 64) setContent_action.update.call(null, /*content*/ ctx[6]);

			if (dirty[0] & /*$_interaction*/ 1024 && switch_value !== (switch_value = /*$_interaction*/ ctx[10].resizer)) {
				if (switch_instance) {
					group_outros();
					const old_component = switch_instance;

					transition_out(old_component.$$.fragment, 1, 0, () => {
						destroy_component(old_component, 1);
					});

					check_outros();
				}

				if (switch_value) {
					switch_instance = construct_svelte_component(switch_value, switch_props(ctx));

					switch_instance.$on("pointerdown", function () {
						if (is_function(/*createDragHandler*/ ctx[34](/*$_interaction*/ ctx[10], 'y'))) /*createDragHandler*/ ctx[34](/*$_interaction*/ ctx[10], 'y').apply(this, arguments);
					});

					create_component(switch_instance.$$.fragment);
					transition_in(switch_instance.$$.fragment, 1);
					mount_component(switch_instance, article, null);
				} else {
					switch_instance = null;
				}
			} else if (switch_value) {
				const switch_instance_changes = {};
				if (dirty[0] & /*event*/ 1) switch_instance_changes.event = /*event*/ ctx[0];
				switch_instance.$set(switch_instance_changes);
			}

			if (!current || dirty[0] & /*classes*/ 16) {
				attr(article, "class", /*classes*/ ctx[4]);
			}

			if (!current || dirty[0] & /*style*/ 32) {
				attr(article, "style", /*style*/ ctx[5]);
			}

			if (!current || dirty[0] & /*onclick*/ 128 && article_role_value !== (article_role_value = /*onclick*/ ctx[7] ? 'button' : undefined)) {
				attr(article, "role", article_role_value);
			}

			if (!current || dirty[0] & /*onclick*/ 128 && article_tabindex_value !== (article_tabindex_value = /*onclick*/ ctx[7] ? 0 : undefined)) {
				attr(article, "tabindex", article_tabindex_value);
			}
		},
		i(local) {
			if (current) return;
			if (switch_instance) transition_in(switch_instance.$$.fragment, local);
			current = true;
		},
		o(local) {
			if (switch_instance) transition_out(switch_instance.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(article);
			}

			if (switch_instance) destroy_component(switch_instance);
			/*article_binding*/ ctx[53](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance$6($$self, $$props, $$invalidate) {
	let $eventClick;
	let $_view;
	let $eventAllUpdated;
	let $eventDidMount;
	let $_intlEventTime;
	let $theme;
	let $eventContent;
	let $displayEventEnd;
	let $eventClassNames;
	let $_iClasses;
	let $slotEventOverlap;
	let $eventTextColor;
	let $_resTxtColor;
	let $eventColor;
	let $eventBackgroundColor;
	let $_resBgColor;
	let $slotHeight;
	let $_slotTimeLimits;
	let $slotDuration;
	let $eventMouseEnter;
	let $eventMouseLeave;
	let $_interaction;
	let { date } = $$props;
	let { chunk } = $$props;
	let { displayEventEnd, eventAllUpdated, eventBackgroundColor, eventTextColor, eventColor, eventContent, eventClick, eventDidMount, eventClassNames, eventMouseEnter, eventMouseLeave, slotEventOverlap, slotDuration, slotHeight, theme, _view, _intlEventTime, _interaction, _iClasses, _resBgColor, _resTxtColor, _slotTimeLimits, _tasks } = getContext('state');
	component_subscribe($$self, displayEventEnd, value => $$invalidate(41, $displayEventEnd = value));
	component_subscribe($$self, eventAllUpdated, value => $$invalidate(55, $eventAllUpdated = value));
	component_subscribe($$self, eventBackgroundColor, value => $$invalidate(48, $eventBackgroundColor = value));
	component_subscribe($$self, eventTextColor, value => $$invalidate(45, $eventTextColor = value));
	component_subscribe($$self, eventColor, value => $$invalidate(47, $eventColor = value));
	component_subscribe($$self, eventContent, value => $$invalidate(40, $eventContent = value));
	component_subscribe($$self, eventClick, value => $$invalidate(37, $eventClick = value));
	component_subscribe($$self, eventDidMount, value => $$invalidate(56, $eventDidMount = value));
	component_subscribe($$self, eventClassNames, value => $$invalidate(42, $eventClassNames = value));
	component_subscribe($$self, eventMouseEnter, value => $$invalidate(8, $eventMouseEnter = value));
	component_subscribe($$self, eventMouseLeave, value => $$invalidate(9, $eventMouseLeave = value));
	component_subscribe($$self, slotEventOverlap, value => $$invalidate(44, $slotEventOverlap = value));
	component_subscribe($$self, slotDuration, value => $$invalidate(52, $slotDuration = value));
	component_subscribe($$self, slotHeight, value => $$invalidate(50, $slotHeight = value));
	component_subscribe($$self, theme, value => $$invalidate(2, $theme = value));
	component_subscribe($$self, _view, value => $$invalidate(38, $_view = value));
	component_subscribe($$self, _intlEventTime, value => $$invalidate(39, $_intlEventTime = value));
	component_subscribe($$self, _interaction, value => $$invalidate(10, $_interaction = value));
	component_subscribe($$self, _iClasses, value => $$invalidate(43, $_iClasses = value));
	component_subscribe($$self, _resBgColor, value => $$invalidate(49, $_resBgColor = value));
	component_subscribe($$self, _resTxtColor, value => $$invalidate(46, $_resTxtColor = value));
	component_subscribe($$self, _slotTimeLimits, value => $$invalidate(51, $_slotTimeLimits = value));
	let el;
	let event;
	let display;
	let classes;
	let style;
	let content;
	let timeText;
	let onclick;

	onMount(() => {
		if (is_function($eventDidMount)) {
			$eventDidMount({
				event: toEventWithLocalDates(event),
				timeText,
				el,
				view: toViewWithLocalDates($_view)
			});
		}
	});

	afterUpdate(() => {
		if (is_function($eventAllUpdated) && !helperEvent(display)) {
			task(() => $eventAllUpdated({ view: toViewWithLocalDates($_view) }), 'eau', _tasks);
		}
	});

	function createHandler(fn, display) {
		return !helperEvent(display) && is_function(fn)
		? jsEvent => fn({
				event: toEventWithLocalDates(event),
				el,
				jsEvent,
				view: toViewWithLocalDates($_view)
			})
		: undefined;
	}

	function createDragHandler(interaction, resize) {
		return interaction.action
		? jsEvent => interaction.action.drag(event, jsEvent, resize)
		: undefined;
	}

	function article_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(3, el);
		});
	}

	$$self.$$set = $$props => {
		if ('date' in $$props) $$invalidate(35, date = $$props.date);
		if ('chunk' in $$props) $$invalidate(36, chunk = $$props.chunk);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[1] & /*chunk*/ 32) {
			$$invalidate(0, event = chunk.event);
		}

		if ($$self.$$.dirty[0] & /*event, style, display, $theme*/ 39 | $$self.$$.dirty[1] & /*$slotDuration, $_slotTimeLimits, chunk, date, $slotHeight, $_resBgColor, $eventBackgroundColor, $eventColor, $_resTxtColor, $eventTextColor, $slotEventOverlap, $_iClasses, $eventClassNames, $_view*/ 4192432) {
			{
				$$invalidate(1, display = event.display);

				// Style
				let step = $slotDuration.seconds;

				let offset = $_slotTimeLimits.min.seconds;
				let start = (chunk.start - date) / 1000;
				let end = (chunk.end - date) / 1000;
				let top = (start - offset) / step * $slotHeight;
				let height = (end - start) / step * $slotHeight;
				let maxHeight = ($_slotTimeLimits.max.seconds - start) / step * $slotHeight;
				let bgColor = event.backgroundColor || $_resBgColor(event) || $eventBackgroundColor || $eventColor;
				let txtColor = event.textColor || $_resTxtColor(event) || $eventTextColor;
				$$invalidate(5, style = `top:${top}px;` + `min-height:${height}px;` + `height:${height}px;` + `max-height:${maxHeight}px;`);

				if (bgColor) {
					$$invalidate(5, style += `background-color:${bgColor};`);
				}

				if (txtColor) {
					$$invalidate(5, style += `color:${txtColor};`);
				}

				if (!bgEvent(display) && !helperEvent(display) || ghostEvent(display)) {
					$$invalidate(5, style += `z-index:${chunk.column + 1};` + `left:${100 / chunk.group.columns.length * chunk.column}%;` + `width:${100 / chunk.group.columns.length * ($slotEventOverlap
					? 0.5 * (1 + chunk.group.columns.length - chunk.column)
					: 1)}%;`);
				}

				// Class
				$$invalidate(4, classes = [
					bgEvent(display) ? $theme.bgEvent : $theme.event,
					...$_iClasses([], event),
					...createEventClasses($eventClassNames, event, $_view)
				].join(' '));
			}
		}

		if ($$self.$$.dirty[0] & /*$theme*/ 4 | $$self.$$.dirty[1] & /*chunk, $displayEventEnd, $eventContent, $_intlEventTime, $_view*/ 1952) {
			// Content
			$$invalidate(6, [timeText, content] = createEventContent(chunk, $displayEventEnd, $eventContent, $theme, $_intlEventTime, $_view), content);
		}

		if ($$self.$$.dirty[0] & /*display*/ 2 | $$self.$$.dirty[1] & /*$eventClick*/ 64) {
			// Onclick handler
			$$invalidate(7, onclick = !bgEvent(display) && createHandler($eventClick, display));
		}
	};

	return [
		event,
		display,
		$theme,
		el,
		classes,
		style,
		content,
		onclick,
		$eventMouseEnter,
		$eventMouseLeave,
		$_interaction,
		displayEventEnd,
		eventAllUpdated,
		eventBackgroundColor,
		eventTextColor,
		eventColor,
		eventContent,
		eventClick,
		eventDidMount,
		eventClassNames,
		eventMouseEnter,
		eventMouseLeave,
		slotEventOverlap,
		slotDuration,
		slotHeight,
		theme,
		_view,
		_intlEventTime,
		_interaction,
		_iClasses,
		_resBgColor,
		_resTxtColor,
		_slotTimeLimits,
		createHandler,
		createDragHandler,
		date,
		chunk,
		$eventClick,
		$_view,
		$_intlEventTime,
		$eventContent,
		$displayEventEnd,
		$eventClassNames,
		$_iClasses,
		$slotEventOverlap,
		$eventTextColor,
		$_resTxtColor,
		$eventColor,
		$eventBackgroundColor,
		$_resBgColor,
		$slotHeight,
		$_slotTimeLimits,
		$slotDuration,
		article_binding
	];
}

let Event$1 = class Event extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$6, create_fragment$6, safe_not_equal, { date: 35, chunk: 36 }, null, [-1, -1]);
	}
};

/* packages/time-grid/src/NowIndicator.svelte generated by Svelte v4.2.18 */

function create_fragment$5(ctx) {
	let div;
	let div_class_value;

	return {
		c() {
			div = element("div");
			attr(div, "class", div_class_value = /*$theme*/ ctx[1].nowIndicator);
			set_style(div, "top", /*top*/ ctx[0] + "px");
		},
		m(target, anchor) {
			insert(target, div, anchor);
		},
		p(ctx, [dirty]) {
			if (dirty & /*$theme*/ 2 && div_class_value !== (div_class_value = /*$theme*/ ctx[1].nowIndicator)) {
				attr(div, "class", div_class_value);
			}

			if (dirty & /*top*/ 1) {
				set_style(div, "top", /*top*/ ctx[0] + "px");
			}
		},
		i: noop,
		o: noop,
		d(detaching) {
			if (detaching) {
				detach(div);
			}
		}
	};
}

function instance$5($$self, $$props, $$invalidate) {
	let $slotHeight;
	let $_slotTimeLimits;
	let $slotDuration;
	let $_today;
	let $_now;
	let $theme;
	let { slotDuration, slotHeight, theme, _now, _today, _slotTimeLimits } = getContext('state');
	component_subscribe($$self, slotDuration, value => $$invalidate(11, $slotDuration = value));
	component_subscribe($$self, slotHeight, value => $$invalidate(9, $slotHeight = value));
	component_subscribe($$self, theme, value => $$invalidate(1, $theme = value));
	component_subscribe($$self, _now, value => $$invalidate(13, $_now = value));
	component_subscribe($$self, _today, value => $$invalidate(12, $_today = value));
	component_subscribe($$self, _slotTimeLimits, value => $$invalidate(10, $_slotTimeLimits = value));
	let start;
	let top = 0;

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*$_now, $_today*/ 12288) {
			$$invalidate(8, start = ($_now - $_today) / 1000 / 60);
		}

		if ($$self.$$.dirty & /*$slotDuration, $_slotTimeLimits, start, $slotHeight*/ 3840) {
			{
				// Style
				let step = $slotDuration.seconds / 60;

				let offset = $_slotTimeLimits.min.seconds / 60;
				$$invalidate(0, top = (start - offset) / step * $slotHeight);
			}
		}
	};

	return [
		top,
		$theme,
		slotDuration,
		slotHeight,
		theme,
		_now,
		_today,
		_slotTimeLimits,
		start,
		$slotHeight,
		$_slotTimeLimits,
		$slotDuration,
		$_today,
		$_now
	];
}

class NowIndicator extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$5, create_fragment$5, safe_not_equal, {});
	}
}

/* packages/time-grid/src/Day.svelte generated by Svelte v4.2.18 */

function get_each_context$3(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[32] = list[i];
	return child_ctx;
}

function get_each_context_1$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[32] = list[i];
	return child_ctx;
}

// (83:8) {#each bgChunks as chunk (chunk.event)}
function create_each_block_1$1(key_1, ctx) {
	let first;
	let event;
	let current;

	event = new Event$1({
			props: {
				date: /*date*/ ctx[0],
				chunk: /*chunk*/ ctx[32]
			}
		});

	return {
		key: key_1,
		first: null,
		c() {
			first = empty();
			create_component(event.$$.fragment);
			this.first = first;
		},
		m(target, anchor) {
			insert(target, first, anchor);
			mount_component(event, target, anchor);
			current = true;
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
			const event_changes = {};
			if (dirty[0] & /*date*/ 1) event_changes.date = /*date*/ ctx[0];
			if (dirty[0] & /*bgChunks*/ 8) event_changes.chunk = /*chunk*/ ctx[32];
			event.$set(event_changes);
		},
		i(local) {
			if (current) return;
			transition_in(event.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(event.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(first);
			}

			destroy_component(event, detaching);
		}
	};
}

// (89:8) {#if iChunks[1]}
function create_if_block_2(ctx) {
	let event;
	let current;

	event = new Event$1({
			props: {
				date: /*date*/ ctx[0],
				chunk: /*iChunks*/ ctx[4][1]
			}
		});

	return {
		c() {
			create_component(event.$$.fragment);
		},
		m(target, anchor) {
			mount_component(event, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const event_changes = {};
			if (dirty[0] & /*date*/ 1) event_changes.date = /*date*/ ctx[0];
			if (dirty[0] & /*iChunks*/ 16) event_changes.chunk = /*iChunks*/ ctx[4][1];
			event.$set(event_changes);
		},
		i(local) {
			if (current) return;
			transition_in(event.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(event.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(event, detaching);
		}
	};
}

// (92:8) {#each chunks as chunk (chunk.event)}
function create_each_block$3(key_1, ctx) {
	let first;
	let event;
	let current;

	event = new Event$1({
			props: {
				date: /*date*/ ctx[0],
				chunk: /*chunk*/ ctx[32]
			}
		});

	return {
		key: key_1,
		first: null,
		c() {
			first = empty();
			create_component(event.$$.fragment);
			this.first = first;
		},
		m(target, anchor) {
			insert(target, first, anchor);
			mount_component(event, target, anchor);
			current = true;
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;
			const event_changes = {};
			if (dirty[0] & /*date*/ 1) event_changes.date = /*date*/ ctx[0];
			if (dirty[0] & /*chunks*/ 4) event_changes.chunk = /*chunk*/ ctx[32];
			event.$set(event_changes);
		},
		i(local) {
			if (current) return;
			transition_in(event.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(event.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(first);
			}

			destroy_component(event, detaching);
		}
	};
}

// (96:8) {#if iChunks[0] && !iChunks[0].event.allDay}
function create_if_block_1(ctx) {
	let event;
	let current;

	event = new Event$1({
			props: {
				date: /*date*/ ctx[0],
				chunk: /*iChunks*/ ctx[4][0]
			}
		});

	return {
		c() {
			create_component(event.$$.fragment);
		},
		m(target, anchor) {
			mount_component(event, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const event_changes = {};
			if (dirty[0] & /*date*/ 1) event_changes.date = /*date*/ ctx[0];
			if (dirty[0] & /*iChunks*/ 16) event_changes.chunk = /*iChunks*/ ctx[4][0];
			event.$set(event_changes);
		},
		i(local) {
			if (current) return;
			transition_in(event.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(event.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(event, detaching);
		}
	};
}

// (102:8) {#if $nowIndicator && isToday}
function create_if_block$2(ctx) {
	let nowindicator;
	let current;
	nowindicator = new NowIndicator({});

	return {
		c() {
			create_component(nowindicator.$$.fragment);
		},
		m(target, anchor) {
			mount_component(nowindicator, target, anchor);
			current = true;
		},
		i(local) {
			if (current) return;
			transition_in(nowindicator.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(nowindicator.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(nowindicator, detaching);
		}
	};
}

function create_fragment$4(ctx) {
	let div3;
	let div0;
	let each_blocks_1 = [];
	let each0_lookup = new Map();
	let div0_class_value;
	let t0;
	let div1;
	let t1;
	let each_blocks = [];
	let each1_lookup = new Map();
	let t2;
	let div1_class_value;
	let t3;
	let div2;
	let div2_class_value;
	let div3_class_value;
	let current;
	let mounted;
	let dispose;
	let each_value_1 = ensure_array_like(/*bgChunks*/ ctx[3]);
	const get_key = ctx => /*chunk*/ ctx[32].event;

	for (let i = 0; i < each_value_1.length; i += 1) {
		let child_ctx = get_each_context_1$1(ctx, each_value_1, i);
		let key = get_key(child_ctx);
		each0_lookup.set(key, each_blocks_1[i] = create_each_block_1$1(key, child_ctx));
	}

	let if_block0 = /*iChunks*/ ctx[4][1] && create_if_block_2(ctx);
	let each_value = ensure_array_like(/*chunks*/ ctx[2]);
	const get_key_1 = ctx => /*chunk*/ ctx[32].event;

	for (let i = 0; i < each_value.length; i += 1) {
		let child_ctx = get_each_context$3(ctx, each_value, i);
		let key = get_key_1(child_ctx);
		each1_lookup.set(key, each_blocks[i] = create_each_block$3(key, child_ctx));
	}

	let if_block1 = /*iChunks*/ ctx[4][0] && !/*iChunks*/ ctx[4][0].event.allDay && create_if_block_1(ctx);
	let if_block2 = /*$nowIndicator*/ ctx[9] && /*isToday*/ ctx[5] && create_if_block$2();

	return {
		c() {
			div3 = element("div");
			div0 = element("div");

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				each_blocks_1[i].c();
			}

			t0 = space();
			div1 = element("div");
			if (if_block0) if_block0.c();
			t1 = space();

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			t2 = space();
			if (if_block1) if_block1.c();
			t3 = space();
			div2 = element("div");
			if (if_block2) if_block2.c();
			attr(div0, "class", div0_class_value = /*$theme*/ ctx[7].bgEvents);
			attr(div1, "class", div1_class_value = /*$theme*/ ctx[7].events);
			attr(div2, "class", div2_class_value = /*$theme*/ ctx[7].extra);

			attr(div3, "class", div3_class_value = "" + (/*$theme*/ ctx[7].day + " " + /*$theme*/ ctx[7].weekdays?.[/*date*/ ctx[0].getUTCDay()] + (/*isToday*/ ctx[5] ? ' ' + /*$theme*/ ctx[7].today : '') + (/*highlight*/ ctx[6]
			? ' ' + /*$theme*/ ctx[7].highlight
			: '')));

			attr(div3, "role", "cell");
		},
		m(target, anchor) {
			insert(target, div3, anchor);
			append(div3, div0);

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				if (each_blocks_1[i]) {
					each_blocks_1[i].m(div0, null);
				}
			}

			append(div3, t0);
			append(div3, div1);
			if (if_block0) if_block0.m(div1, null);
			append(div1, t1);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(div1, null);
				}
			}

			append(div1, t2);
			if (if_block1) if_block1.m(div1, null);
			append(div3, t3);
			append(div3, div2);
			if (if_block2) if_block2.m(div2, null);
			/*div3_binding*/ ctx[28](div3);
			current = true;

			if (!mounted) {
				dispose = [
					listen(div3, "pointerleave", function () {
						if (is_function(/*$_interaction*/ ctx[8].pointer?.leave)) /*$_interaction*/ ctx[8].pointer?.leave.apply(this, arguments);
					}),
					listen(div3, "pointerdown", function () {
						if (is_function(/*$_interaction*/ ctx[8].action?.select)) /*$_interaction*/ ctx[8].action?.select.apply(this, arguments);
					})
				];

				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty[0] & /*date, bgChunks*/ 9) {
				each_value_1 = ensure_array_like(/*bgChunks*/ ctx[3]);
				group_outros();
				each_blocks_1 = update_keyed_each(each_blocks_1, dirty, get_key, 1, ctx, each_value_1, each0_lookup, div0, outro_and_destroy_block, create_each_block_1$1, null, get_each_context_1$1);
				check_outros();
			}

			if (!current || dirty[0] & /*$theme*/ 128 && div0_class_value !== (div0_class_value = /*$theme*/ ctx[7].bgEvents)) {
				attr(div0, "class", div0_class_value);
			}

			if (/*iChunks*/ ctx[4][1]) {
				if (if_block0) {
					if_block0.p(ctx, dirty);

					if (dirty[0] & /*iChunks*/ 16) {
						transition_in(if_block0, 1);
					}
				} else {
					if_block0 = create_if_block_2(ctx);
					if_block0.c();
					transition_in(if_block0, 1);
					if_block0.m(div1, t1);
				}
			} else if (if_block0) {
				group_outros();

				transition_out(if_block0, 1, 1, () => {
					if_block0 = null;
				});

				check_outros();
			}

			if (dirty[0] & /*date, chunks*/ 5) {
				each_value = ensure_array_like(/*chunks*/ ctx[2]);
				group_outros();
				each_blocks = update_keyed_each(each_blocks, dirty, get_key_1, 1, ctx, each_value, each1_lookup, div1, outro_and_destroy_block, create_each_block$3, t2, get_each_context$3);
				check_outros();
			}

			if (/*iChunks*/ ctx[4][0] && !/*iChunks*/ ctx[4][0].event.allDay) {
				if (if_block1) {
					if_block1.p(ctx, dirty);

					if (dirty[0] & /*iChunks*/ 16) {
						transition_in(if_block1, 1);
					}
				} else {
					if_block1 = create_if_block_1(ctx);
					if_block1.c();
					transition_in(if_block1, 1);
					if_block1.m(div1, null);
				}
			} else if (if_block1) {
				group_outros();

				transition_out(if_block1, 1, 1, () => {
					if_block1 = null;
				});

				check_outros();
			}

			if (!current || dirty[0] & /*$theme*/ 128 && div1_class_value !== (div1_class_value = /*$theme*/ ctx[7].events)) {
				attr(div1, "class", div1_class_value);
			}

			if (/*$nowIndicator*/ ctx[9] && /*isToday*/ ctx[5]) {
				if (if_block2) {
					if (dirty[0] & /*$nowIndicator, isToday*/ 544) {
						transition_in(if_block2, 1);
					}
				} else {
					if_block2 = create_if_block$2();
					if_block2.c();
					transition_in(if_block2, 1);
					if_block2.m(div2, null);
				}
			} else if (if_block2) {
				group_outros();

				transition_out(if_block2, 1, 1, () => {
					if_block2 = null;
				});

				check_outros();
			}

			if (!current || dirty[0] & /*$theme*/ 128 && div2_class_value !== (div2_class_value = /*$theme*/ ctx[7].extra)) {
				attr(div2, "class", div2_class_value);
			}

			if (!current || dirty[0] & /*$theme, date, isToday, highlight*/ 225 && div3_class_value !== (div3_class_value = "" + (/*$theme*/ ctx[7].day + " " + /*$theme*/ ctx[7].weekdays?.[/*date*/ ctx[0].getUTCDay()] + (/*isToday*/ ctx[5] ? ' ' + /*$theme*/ ctx[7].today : '') + (/*highlight*/ ctx[6]
			? ' ' + /*$theme*/ ctx[7].highlight
			: '')))) {
				attr(div3, "class", div3_class_value);
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value_1.length; i += 1) {
				transition_in(each_blocks_1[i]);
			}

			transition_in(if_block0);

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			transition_in(if_block1);
			transition_in(if_block2);
			current = true;
		},
		o(local) {
			for (let i = 0; i < each_blocks_1.length; i += 1) {
				transition_out(each_blocks_1[i]);
			}

			transition_out(if_block0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			transition_out(if_block1);
			transition_out(if_block2);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(div3);
			}

			for (let i = 0; i < each_blocks_1.length; i += 1) {
				each_blocks_1[i].d();
			}

			if (if_block0) if_block0.d();

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].d();
			}

			if (if_block1) if_block1.d();
			if (if_block2) if_block2.d();
			/*div3_binding*/ ctx[28](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance$4($$self, $$props, $$invalidate) {
	let $slotHeight;
	let $slotDuration;
	let $_slotTimeLimits;
	let $highlightedDates;
	let $_today;
	let $_iEvents;
	let $_events;
	let $theme;
	let $_interaction;
	let $nowIndicator;
	let { date } = $$props;
	let { resource = undefined } = $$props;
	let { _events, _iEvents, highlightedDates, nowIndicator, slotDuration, slotHeight, theme, _interaction, _today, _slotTimeLimits } = getContext('state');
	component_subscribe($$self, _events, value => $$invalidate(27, $_events = value));
	component_subscribe($$self, _iEvents, value => $$invalidate(26, $_iEvents = value));
	component_subscribe($$self, highlightedDates, value => $$invalidate(24, $highlightedDates = value));
	component_subscribe($$self, nowIndicator, value => $$invalidate(9, $nowIndicator = value));
	component_subscribe($$self, slotDuration, value => $$invalidate(30, $slotDuration = value));
	component_subscribe($$self, slotHeight, value => $$invalidate(29, $slotHeight = value));
	component_subscribe($$self, theme, value => $$invalidate(7, $theme = value));
	component_subscribe($$self, _interaction, value => $$invalidate(8, $_interaction = value));
	component_subscribe($$self, _today, value => $$invalidate(25, $_today = value));
	component_subscribe($$self, _slotTimeLimits, value => $$invalidate(23, $_slotTimeLimits = value));
	let el;
	let chunks, bgChunks, iChunks = [];
	let isToday, highlight;
	let start, end;

	function dateFromPoint(x, y) {
		y -= rect(el).top;

		return {
			allDay: false,
			date: addDuration(addDuration(cloneDate(date), $_slotTimeLimits.min), $slotDuration, floor(y / $slotHeight)),
			resource,
			dayEl: el
		};
	}

	function div3_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(1, el);
		});
	}

	$$self.$$set = $$props => {
		if ('date' in $$props) $$invalidate(0, date = $$props.date);
		if ('resource' in $$props) $$invalidate(20, resource = $$props.resource);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[0] & /*date, $_slotTimeLimits*/ 8388609) {
			{
				$$invalidate(21, start = addDuration(cloneDate(date), $_slotTimeLimits.min));
				$$invalidate(22, end = addDuration(cloneDate(date), $_slotTimeLimits.max));
			}
		}

		if ($$self.$$.dirty[0] & /*$_events, start, end, resource, bgChunks, chunks*/ 141557772) {
			{
				$$invalidate(2, chunks = []);
				$$invalidate(3, bgChunks = []);

				for (let event of $_events) {
					if (!event.allDay && eventIntersects(event, start, end, resource)) {
						let chunk = createEventChunk(event, start, end);

						switch (event.display) {
							case 'background':
								bgChunks.push(chunk);
								break;
							default:
								chunks.push(chunk);
						}
					}
				}

				groupEventChunks(chunks);
			}
		}

		if ($$self.$$.dirty[0] & /*$_iEvents, start, end, resource*/ 74448896) {
			$$invalidate(4, iChunks = $_iEvents.map(event => event && eventIntersects(event, start, end, resource)
			? createEventChunk(event, start, end)
			: null));
		}

		if ($$self.$$.dirty[0] & /*date, $_today*/ 33554433) {
			$$invalidate(5, isToday = datesEqual(date, $_today));
		}

		if ($$self.$$.dirty[0] & /*$highlightedDates, date*/ 16777217) {
			$$invalidate(6, highlight = $highlightedDates.some(d => datesEqual(d, date)));
		}

		if ($$self.$$.dirty[0] & /*el*/ 2) {
			if (el) {
				setPayload(el, dateFromPoint);
			}
		}
	};

	return [
		date,
		el,
		chunks,
		bgChunks,
		iChunks,
		isToday,
		highlight,
		$theme,
		$_interaction,
		$nowIndicator,
		_events,
		_iEvents,
		highlightedDates,
		nowIndicator,
		slotDuration,
		slotHeight,
		theme,
		_interaction,
		_today,
		_slotTimeLimits,
		resource,
		start,
		end,
		$_slotTimeLimits,
		$highlightedDates,
		$_today,
		$_iEvents,
		$_events,
		div3_binding
	];
}

let Day$1 = class Day extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$4, create_fragment$4, safe_not_equal, { date: 0, resource: 20 }, null, [-1, -1]);
	}
};

/* packages/time-grid/src/all-day/Event.svelte generated by Svelte v4.2.18 */

function create_fragment$3(ctx) {
	let article;
	let div;
	let div_class_value;
	let setContent_action;
	let t;
	let switch_instance;
	let article_role_value;
	let article_tabindex_value;
	let current;
	let mounted;
	let dispose;
	var switch_value = /*$_interaction*/ ctx[10].resizer;

	function switch_props(ctx, dirty) {
		return { props: { event: /*event*/ ctx[0] } };
	}

	if (switch_value) {
		switch_instance = construct_svelte_component(switch_value, switch_props(ctx));

		switch_instance.$on("pointerdown", function () {
			if (is_function(/*createDragHandler*/ ctx[30](/*$_interaction*/ ctx[10], 'x'))) /*createDragHandler*/ ctx[30](/*$_interaction*/ ctx[10], 'x').apply(this, arguments);
		});
	}

	return {
		c() {
			article = element("article");
			div = element("div");
			t = space();
			if (switch_instance) create_component(switch_instance.$$.fragment);
			attr(div, "class", div_class_value = /*$theme*/ ctx[2].eventBody);
			attr(article, "class", /*classes*/ ctx[4]);
			attr(article, "style", /*style*/ ctx[5]);
			attr(article, "role", article_role_value = /*onclick*/ ctx[7] ? 'button' : undefined);
			attr(article, "tabindex", article_tabindex_value = /*onclick*/ ctx[7] ? 0 : undefined);
		},
		m(target, anchor) {
			insert(target, article, anchor);
			append(article, div);
			append(article, t);
			if (switch_instance) mount_component(switch_instance, article, null);
			/*article_binding*/ ctx[47](article);
			current = true;

			if (!mounted) {
				dispose = [
					action_destroyer(setContent_action = setContent.call(null, div, /*content*/ ctx[6])),
					listen(article, "click", function () {
						if (is_function(/*onclick*/ ctx[7])) /*onclick*/ ctx[7].apply(this, arguments);
					}),
					listen(article, "keydown", function () {
						if (is_function(/*onclick*/ ctx[7] && keyEnter(/*onclick*/ ctx[7]))) (/*onclick*/ ctx[7] && keyEnter(/*onclick*/ ctx[7])).apply(this, arguments);
					}),
					listen(article, "mouseenter", function () {
						if (is_function(/*createHandler*/ ctx[29](/*$eventMouseEnter*/ ctx[8], /*display*/ ctx[1]))) /*createHandler*/ ctx[29](/*$eventMouseEnter*/ ctx[8], /*display*/ ctx[1]).apply(this, arguments);
					}),
					listen(article, "mouseleave", function () {
						if (is_function(/*createHandler*/ ctx[29](/*$eventMouseLeave*/ ctx[9], /*display*/ ctx[1]))) /*createHandler*/ ctx[29](/*$eventMouseLeave*/ ctx[9], /*display*/ ctx[1]).apply(this, arguments);
					}),
					listen(article, "pointerdown", function () {
						if (is_function(!helperEvent(/*display*/ ctx[1]) && /*createDragHandler*/ ctx[30](/*$_interaction*/ ctx[10]))) (!helperEvent(/*display*/ ctx[1]) && /*createDragHandler*/ ctx[30](/*$_interaction*/ ctx[10])).apply(this, arguments);
					})
				];

				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (!current || dirty[0] & /*$theme*/ 4 && div_class_value !== (div_class_value = /*$theme*/ ctx[2].eventBody)) {
				attr(div, "class", div_class_value);
			}

			if (setContent_action && is_function(setContent_action.update) && dirty[0] & /*content*/ 64) setContent_action.update.call(null, /*content*/ ctx[6]);

			if (dirty[0] & /*$_interaction*/ 1024 && switch_value !== (switch_value = /*$_interaction*/ ctx[10].resizer)) {
				if (switch_instance) {
					group_outros();
					const old_component = switch_instance;

					transition_out(old_component.$$.fragment, 1, 0, () => {
						destroy_component(old_component, 1);
					});

					check_outros();
				}

				if (switch_value) {
					switch_instance = construct_svelte_component(switch_value, switch_props(ctx));

					switch_instance.$on("pointerdown", function () {
						if (is_function(/*createDragHandler*/ ctx[30](/*$_interaction*/ ctx[10], 'x'))) /*createDragHandler*/ ctx[30](/*$_interaction*/ ctx[10], 'x').apply(this, arguments);
					});

					create_component(switch_instance.$$.fragment);
					transition_in(switch_instance.$$.fragment, 1);
					mount_component(switch_instance, article, null);
				} else {
					switch_instance = null;
				}
			} else if (switch_value) {
				const switch_instance_changes = {};
				if (dirty[0] & /*event*/ 1) switch_instance_changes.event = /*event*/ ctx[0];
				switch_instance.$set(switch_instance_changes);
			}

			if (!current || dirty[0] & /*classes*/ 16) {
				attr(article, "class", /*classes*/ ctx[4]);
			}

			if (!current || dirty[0] & /*style*/ 32) {
				attr(article, "style", /*style*/ ctx[5]);
			}

			if (!current || dirty[0] & /*onclick*/ 128 && article_role_value !== (article_role_value = /*onclick*/ ctx[7] ? 'button' : undefined)) {
				attr(article, "role", article_role_value);
			}

			if (!current || dirty[0] & /*onclick*/ 128 && article_tabindex_value !== (article_tabindex_value = /*onclick*/ ctx[7] ? 0 : undefined)) {
				attr(article, "tabindex", article_tabindex_value);
			}
		},
		i(local) {
			if (current) return;
			if (switch_instance) transition_in(switch_instance.$$.fragment, local);
			current = true;
		},
		o(local) {
			if (switch_instance) transition_out(switch_instance.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(article);
			}

			if (switch_instance) destroy_component(switch_instance);
			/*article_binding*/ ctx[47](null);
			mounted = false;
			run_all(dispose);
		}
	};
}

function instance$3($$self, $$props, $$invalidate) {
	let $eventClick;
	let $_view;
	let $eventAllUpdated;
	let $eventDidMount;
	let $_intlEventTime;
	let $theme;
	let $eventContent;
	let $displayEventEnd;
	let $eventClassNames;
	let $_iClasses;
	let $eventTextColor;
	let $_resTxtColor;
	let $eventColor;
	let $eventBackgroundColor;
	let $_resBgColor;
	let $eventMouseEnter;
	let $eventMouseLeave;
	let $_interaction;
	let { chunk } = $$props;
	let { longChunks = {} } = $$props;
	let { displayEventEnd, eventAllUpdated, eventBackgroundColor, eventTextColor, eventClick, eventColor, eventContent, eventClassNames, eventDidMount, eventMouseEnter, eventMouseLeave, theme, _view, _intlEventTime, _interaction, _iClasses, _resBgColor, _resTxtColor, _tasks } = getContext('state');
	component_subscribe($$self, displayEventEnd, value => $$invalidate(39, $displayEventEnd = value));
	component_subscribe($$self, eventAllUpdated, value => $$invalidate(49, $eventAllUpdated = value));
	component_subscribe($$self, eventBackgroundColor, value => $$invalidate(45, $eventBackgroundColor = value));
	component_subscribe($$self, eventTextColor, value => $$invalidate(42, $eventTextColor = value));
	component_subscribe($$self, eventClick, value => $$invalidate(35, $eventClick = value));
	component_subscribe($$self, eventColor, value => $$invalidate(44, $eventColor = value));
	component_subscribe($$self, eventContent, value => $$invalidate(38, $eventContent = value));
	component_subscribe($$self, eventClassNames, value => $$invalidate(40, $eventClassNames = value));
	component_subscribe($$self, eventDidMount, value => $$invalidate(50, $eventDidMount = value));
	component_subscribe($$self, eventMouseEnter, value => $$invalidate(8, $eventMouseEnter = value));
	component_subscribe($$self, eventMouseLeave, value => $$invalidate(9, $eventMouseLeave = value));
	component_subscribe($$self, theme, value => $$invalidate(2, $theme = value));
	component_subscribe($$self, _view, value => $$invalidate(36, $_view = value));
	component_subscribe($$self, _intlEventTime, value => $$invalidate(37, $_intlEventTime = value));
	component_subscribe($$self, _interaction, value => $$invalidate(10, $_interaction = value));
	component_subscribe($$self, _iClasses, value => $$invalidate(41, $_iClasses = value));
	component_subscribe($$self, _resBgColor, value => $$invalidate(46, $_resBgColor = value));
	component_subscribe($$self, _resTxtColor, value => $$invalidate(43, $_resTxtColor = value));
	let el;
	let event;
	let classes;
	let style;
	let content;
	let timeText;
	let margin = 1;
	let display;
	let onclick;

	onMount(() => {
		if (is_function($eventDidMount)) {
			$eventDidMount({
				event: toEventWithLocalDates(event),
				timeText,
				el,
				view: toViewWithLocalDates($_view)
			});
		}
	});

	afterUpdate(() => {
		if (is_function($eventAllUpdated) && !helperEvent(display)) {
			task(() => $eventAllUpdated({ view: toViewWithLocalDates($_view) }), 'eau', _tasks);
		}
	});

	function createHandler(fn, display) {
		return !helperEvent(display) && is_function(fn)
		? jsEvent => fn({
				event: toEventWithLocalDates(event),
				el,
				jsEvent,
				view: toViewWithLocalDates($_view)
			})
		: undefined;
	}

	function createDragHandler(interaction, resize) {
		return interaction.action
		? jsEvent => interaction.action.drag(event, jsEvent, resize, null, rect(el).top - rect(ancestor(el, 1)).top)
		: undefined;
	}

	function reposition() {
		if (!el) {
			return;
		}

		$$invalidate(34, margin = repositionEvent(chunk, longChunks, height(el)));
	}

	function article_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(3, el);
		});
	}

	$$self.$$set = $$props => {
		if ('chunk' in $$props) $$invalidate(31, chunk = $$props.chunk);
		if ('longChunks' in $$props) $$invalidate(32, longChunks = $$props.longChunks);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty[1] & /*chunk*/ 1) {
			$$invalidate(0, event = chunk.event);
		}

		if ($$self.$$.dirty[0] & /*event, style, $theme*/ 37 | $$self.$$.dirty[1] & /*$_resBgColor, $eventBackgroundColor, $eventColor, $_resTxtColor, $eventTextColor, chunk, margin, $_iClasses, $eventClassNames, $_view*/ 65065) {
			{
				$$invalidate(1, display = event.display);

				// Class & Style
				let bgColor = event.backgroundColor || $_resBgColor(event) || $eventBackgroundColor || $eventColor;

				let txtColor = event.textColor || $_resTxtColor(event) || $eventTextColor;
				$$invalidate(5, style = `width:calc(${chunk.days * 100}% + ${(chunk.days - 1) * 7}px);` + `margin-top:${event._margin ?? margin}px;`);

				if (bgColor) {
					$$invalidate(5, style += `background-color:${bgColor};`);
				}

				if (txtColor) {
					$$invalidate(5, style += `color:${txtColor};`);
				}

				$$invalidate(4, classes = [
					$theme.event,
					...$_iClasses([], event),
					...createEventClasses($eventClassNames, event, $_view)
				].join(' '));
			}
		}

		if ($$self.$$.dirty[0] & /*$theme*/ 4 | $$self.$$.dirty[1] & /*chunk, $displayEventEnd, $eventContent, $_intlEventTime, $_view*/ 481) {
			// Content
			$$invalidate(6, [timeText, content] = createEventContent(chunk, $displayEventEnd, $eventContent, $theme, $_intlEventTime, $_view), content);
		}

		if ($$self.$$.dirty[0] & /*display*/ 2 | $$self.$$.dirty[1] & /*$eventClick*/ 16) {
			// Onclick handler
			$$invalidate(7, onclick = createHandler($eventClick, display));
		}
	};

	return [
		event,
		display,
		$theme,
		el,
		classes,
		style,
		content,
		onclick,
		$eventMouseEnter,
		$eventMouseLeave,
		$_interaction,
		displayEventEnd,
		eventAllUpdated,
		eventBackgroundColor,
		eventTextColor,
		eventClick,
		eventColor,
		eventContent,
		eventClassNames,
		eventDidMount,
		eventMouseEnter,
		eventMouseLeave,
		theme,
		_view,
		_intlEventTime,
		_interaction,
		_iClasses,
		_resBgColor,
		_resTxtColor,
		createHandler,
		createDragHandler,
		chunk,
		longChunks,
		reposition,
		margin,
		$eventClick,
		$_view,
		$_intlEventTime,
		$eventContent,
		$displayEventEnd,
		$eventClassNames,
		$_iClasses,
		$eventTextColor,
		$_resTxtColor,
		$eventColor,
		$eventBackgroundColor,
		$_resBgColor,
		article_binding
	];
}

class Event extends SvelteComponent {
	constructor(options) {
		super();

		init(
			this,
			options,
			instance$3,
			create_fragment$3,
			safe_not_equal,
			{
				chunk: 31,
				longChunks: 32,
				reposition: 33
			},
			null,
			[-1, -1]
		);
	}

	get reposition() {
		return this.$$.ctx[33];
	}
}

/* packages/time-grid/src/all-day/Day.svelte generated by Svelte v4.2.18 */

function get_each_context$2(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[21] = list[i];
	child_ctx[22] = list;
	child_ctx[23] = i;
	return child_ctx;
}

// (49:4) {#if iChunks[0] && datesEqual(iChunks[0].date, date)}
function create_if_block$1(ctx) {
	let div;
	let event;
	let div_class_value;
	let current;
	event = new Event({ props: { chunk: /*iChunks*/ ctx[2][0] } });

	return {
		c() {
			div = element("div");
			create_component(event.$$.fragment);
			attr(div, "class", div_class_value = "" + (/*$theme*/ ctx[8].events + " " + /*$theme*/ ctx[8].preview));
		},
		m(target, anchor) {
			insert(target, div, anchor);
			mount_component(event, div, null);
			current = true;
		},
		p(ctx, dirty) {
			const event_changes = {};
			if (dirty & /*iChunks*/ 4) event_changes.chunk = /*iChunks*/ ctx[2][0];
			event.$set(event_changes);

			if (!current || dirty & /*$theme*/ 256 && div_class_value !== (div_class_value = "" + (/*$theme*/ ctx[8].events + " " + /*$theme*/ ctx[8].preview))) {
				attr(div, "class", div_class_value);
			}
		},
		i(local) {
			if (current) return;
			transition_in(event.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(event.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(div);
			}

			destroy_component(event);
		}
	};
}

// (55:8) {#each dayChunks as chunk, i (chunk.event)}
function create_each_block$2(key_1, ctx) {
	let first;
	let event;
	let i = /*i*/ ctx[23];
	let current;
	const assign_event = () => /*event_binding*/ ctx[19](event, i);
	const unassign_event = () => /*event_binding*/ ctx[19](null, i);

	let event_props = {
		chunk: /*chunk*/ ctx[21],
		longChunks: /*longChunks*/ ctx[1]
	};

	event = new Event({ props: event_props });
	assign_event();

	return {
		key: key_1,
		first: null,
		c() {
			first = empty();
			create_component(event.$$.fragment);
			this.first = first;
		},
		m(target, anchor) {
			insert(target, first, anchor);
			mount_component(event, target, anchor);
			current = true;
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (i !== /*i*/ ctx[23]) {
				unassign_event();
				i = /*i*/ ctx[23];
				assign_event();
			}

			const event_changes = {};
			if (dirty & /*dayChunks*/ 16) event_changes.chunk = /*chunk*/ ctx[21];
			if (dirty & /*longChunks*/ 2) event_changes.longChunks = /*longChunks*/ ctx[1];
			event.$set(event_changes);
		},
		i(local) {
			if (current) return;
			transition_in(event.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(event.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(first);
			}

			unassign_event();
			destroy_component(event, detaching);
		}
	};
}

function create_fragment$2(ctx) {
	let div1;
	let show_if = /*iChunks*/ ctx[2][0] && datesEqual(/*iChunks*/ ctx[2][0].date, /*date*/ ctx[0]);
	let t;
	let div0;
	let each_blocks = [];
	let each_1_lookup = new Map();
	let div0_class_value;
	let div1_class_value;
	let current;
	let mounted;
	let dispose;
	let if_block = show_if && create_if_block$1(ctx);
	let each_value = ensure_array_like(/*dayChunks*/ ctx[4]);
	const get_key = ctx => /*chunk*/ ctx[21].event;

	for (let i = 0; i < each_value.length; i += 1) {
		let child_ctx = get_each_context$2(ctx, each_value, i);
		let key = get_key(child_ctx);
		each_1_lookup.set(key, each_blocks[i] = create_each_block$2(key, child_ctx));
	}

	return {
		c() {
			div1 = element("div");
			if (if_block) if_block.c();
			t = space();
			div0 = element("div");

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			attr(div0, "class", div0_class_value = /*$theme*/ ctx[8].events);

			attr(div1, "class", div1_class_value = "" + (/*$theme*/ ctx[8].day + " " + /*$theme*/ ctx[8].weekdays?.[/*date*/ ctx[0].getUTCDay()] + (/*isToday*/ ctx[5] ? ' ' + /*$theme*/ ctx[8].today : '') + (/*highlight*/ ctx[6]
			? ' ' + /*$theme*/ ctx[8].highlight
			: '')));

			attr(div1, "role", "cell");
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			if (if_block) if_block.m(div1, null);
			append(div1, t);
			append(div1, div0);

			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(div0, null);
				}
			}

			/*div1_binding*/ ctx[20](div1);
			current = true;

			if (!mounted) {
				dispose = listen(div1, "pointerdown", function () {
					if (is_function(/*$_interaction*/ ctx[9].action?.select)) /*$_interaction*/ ctx[9].action?.select.apply(this, arguments);
				});

				mounted = true;
			}
		},
		p(new_ctx, [dirty]) {
			ctx = new_ctx;
			if (dirty & /*iChunks, date*/ 5) show_if = /*iChunks*/ ctx[2][0] && datesEqual(/*iChunks*/ ctx[2][0].date, /*date*/ ctx[0]);

			if (show_if) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*iChunks, date*/ 5) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block$1(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(div1, t);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}

			if (dirty & /*dayChunks, longChunks, refs*/ 146) {
				each_value = ensure_array_like(/*dayChunks*/ ctx[4]);
				group_outros();
				each_blocks = update_keyed_each(each_blocks, dirty, get_key, 1, ctx, each_value, each_1_lookup, div0, outro_and_destroy_block, create_each_block$2, null, get_each_context$2);
				check_outros();
			}

			if (!current || dirty & /*$theme*/ 256 && div0_class_value !== (div0_class_value = /*$theme*/ ctx[8].events)) {
				attr(div0, "class", div0_class_value);
			}

			if (!current || dirty & /*$theme, date, isToday, highlight*/ 353 && div1_class_value !== (div1_class_value = "" + (/*$theme*/ ctx[8].day + " " + /*$theme*/ ctx[8].weekdays?.[/*date*/ ctx[0].getUTCDay()] + (/*isToday*/ ctx[5] ? ' ' + /*$theme*/ ctx[8].today : '') + (/*highlight*/ ctx[6]
			? ' ' + /*$theme*/ ctx[8].highlight
			: '')))) {
				attr(div1, "class", div1_class_value);
			}
		},
		i(local) {
			if (current) return;
			transition_in(if_block);

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			transition_out(if_block);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(div1);
			}

			if (if_block) if_block.d();

			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].d();
			}

			/*div1_binding*/ ctx[20](null);
			mounted = false;
			dispose();
		}
	};
}

function instance$2($$self, $$props, $$invalidate) {
	let $highlightedDates;
	let $_today;
	let $theme;
	let $_interaction;
	let { date } = $$props;
	let { chunks } = $$props;
	let { longChunks } = $$props;
	let { iChunks = [] } = $$props;
	let { resource = undefined } = $$props;
	let { highlightedDates, theme, _interaction, _today } = getContext('state');
	component_subscribe($$self, highlightedDates, value => $$invalidate(17, $highlightedDates = value));
	component_subscribe($$self, theme, value => $$invalidate(8, $theme = value));
	component_subscribe($$self, _interaction, value => $$invalidate(9, $_interaction = value));
	component_subscribe($$self, _today, value => $$invalidate(18, $_today = value));
	let el;
	let dayChunks;
	let isToday;
	let highlight;
	let refs = [];

	function reposition() {
		runReposition(refs, dayChunks);
	}

	function event_binding($$value, i) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			refs[i] = $$value;
			$$invalidate(7, refs);
		});
	}

	function div1_binding($$value) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			el = $$value;
			$$invalidate(3, el);
		});
	}

	$$self.$$set = $$props => {
		if ('date' in $$props) $$invalidate(0, date = $$props.date);
		if ('chunks' in $$props) $$invalidate(14, chunks = $$props.chunks);
		if ('longChunks' in $$props) $$invalidate(1, longChunks = $$props.longChunks);
		if ('iChunks' in $$props) $$invalidate(2, iChunks = $$props.iChunks);
		if ('resource' in $$props) $$invalidate(15, resource = $$props.resource);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*chunks, date, dayChunks*/ 16401) {
			{
				$$invalidate(4, dayChunks = []);

				for (let chunk of chunks) {
					if (datesEqual(chunk.date, date)) {
						dayChunks.push(chunk);
					}
				}
			}
		}

		if ($$self.$$.dirty & /*date, $_today*/ 262145) {
			$$invalidate(5, isToday = datesEqual(date, $_today));
		}

		if ($$self.$$.dirty & /*$highlightedDates, date*/ 131073) {
			$$invalidate(6, highlight = $highlightedDates.some(d => datesEqual(d, date)));
		}

		if ($$self.$$.dirty & /*el, date, resource*/ 32777) {
			// dateFromPoint
			if (el) {
				setPayload(el, () => ({ allDay: true, date, resource, dayEl: el }));
			}
		}
	};

	return [
		date,
		longChunks,
		iChunks,
		el,
		dayChunks,
		isToday,
		highlight,
		refs,
		$theme,
		$_interaction,
		highlightedDates,
		theme,
		_interaction,
		_today,
		chunks,
		resource,
		reposition,
		$highlightedDates,
		$_today,
		event_binding,
		div1_binding
	];
}

class Day extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$2, create_fragment$2, safe_not_equal, {
			date: 0,
			chunks: 14,
			longChunks: 1,
			iChunks: 2,
			resource: 15,
			reposition: 16
		});
	}

	get reposition() {
		return this.$$.ctx[16];
	}
}

/* packages/time-grid/src/all-day/Week.svelte generated by Svelte v4.2.18 */

function get_each_context$1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[18] = list[i];
	child_ctx[19] = list;
	child_ctx[20] = i;
	return child_ctx;
}

// (59:0) {#each dates as date, i}
function create_each_block$1(ctx) {
	let day;
	let i = /*i*/ ctx[20];
	let current;
	const assign_day = () => /*day_binding*/ ctx[15](day, i);
	const unassign_day = () => /*day_binding*/ ctx[15](null, i);

	let day_props = {
		date: /*date*/ ctx[18],
		chunks: /*chunks*/ ctx[2],
		longChunks: /*longChunks*/ ctx[3],
		iChunks: /*iChunks*/ ctx[4],
		resource: /*resource*/ ctx[1]
	};

	day = new Day({ props: day_props });
	assign_day();

	return {
		c() {
			create_component(day.$$.fragment);
		},
		m(target, anchor) {
			mount_component(day, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (i !== /*i*/ ctx[20]) {
				unassign_day();
				i = /*i*/ ctx[20];
				assign_day();
			}

			const day_changes = {};
			if (dirty & /*dates*/ 1) day_changes.date = /*date*/ ctx[18];
			if (dirty & /*chunks*/ 4) day_changes.chunks = /*chunks*/ ctx[2];
			if (dirty & /*longChunks*/ 8) day_changes.longChunks = /*longChunks*/ ctx[3];
			if (dirty & /*iChunks*/ 16) day_changes.iChunks = /*iChunks*/ ctx[4];
			if (dirty & /*resource*/ 2) day_changes.resource = /*resource*/ ctx[1];
			day.$set(day_changes);
		},
		i(local) {
			if (current) return;
			transition_in(day.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(day.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			unassign_day();
			destroy_component(day, detaching);
		}
	};
}

function create_fragment$1(ctx) {
	let each_1_anchor;
	let current;
	let mounted;
	let dispose;
	let each_value = ensure_array_like(/*dates*/ ctx[0]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block$1(get_each_context$1(ctx, each_value, i));
	}

	const out = i => transition_out(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert(target, each_1_anchor, anchor);
			current = true;

			if (!mounted) {
				dispose = listen(window, "resize", /*reposition*/ ctx[9]);
				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			if (dirty & /*dates, chunks, longChunks, iChunks, resource, refs*/ 63) {
				each_value = ensure_array_like(/*dates*/ ctx[0]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context$1(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block$1(child_ctx);
						each_blocks[i].c();
						transition_in(each_blocks[i], 1);
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				group_outros();

				for (i = each_value.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(each_1_anchor);
			}

			destroy_each(each_blocks, detaching);
			mounted = false;
			dispose();
		}
	};
}

function instance$1($$self, $$props, $$invalidate) {
	let $hiddenDays;
	let $_iEvents;
	let $_events;
	let { dates } = $$props;
	let { resource = undefined } = $$props;
	let { _events, _iEvents, _queue2, hiddenDays } = getContext('state');
	component_subscribe($$self, _events, value => $$invalidate(14, $_events = value));
	component_subscribe($$self, _iEvents, value => $$invalidate(13, $_iEvents = value));
	component_subscribe($$self, hiddenDays, value => $$invalidate(12, $hiddenDays = value));
	let chunks, longChunks, iChunks = [];
	let start;
	let end;
	let refs = [];
	let debounceHandle = {};

	function reposition() {
		debounce(() => runReposition(refs, dates), debounceHandle, _queue2);
	}

	function day_binding($$value, i) {
		binding_callbacks[$$value ? 'unshift' : 'push'](() => {
			refs[i] = $$value;
			$$invalidate(5, refs);
		});
	}

	$$self.$$set = $$props => {
		if ('dates' in $$props) $$invalidate(0, dates = $$props.dates);
		if ('resource' in $$props) $$invalidate(1, resource = $$props.resource);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*dates*/ 1) {
			{
				$$invalidate(10, start = dates[0]);
				$$invalidate(11, end = addDay(cloneDate(dates[dates.length - 1])));
			}
		}

		if ($$self.$$.dirty & /*$_events, start, end, resource, chunks, $hiddenDays*/ 23558) {
			{
				$$invalidate(2, chunks = []);

				for (let event of $_events) {
					if (event.allDay && !bgEvent(event.display) && eventIntersects(event, start, end, resource)) {
						let chunk = createEventChunk(event, start, end);
						chunks.push(chunk);
					}
				}

				$$invalidate(3, longChunks = prepareEventChunks(chunks, $hiddenDays));

				// Run reposition only when events get changed
				reposition();
			}
		}

		if ($$self.$$.dirty & /*$_iEvents, start, end, resource, $hiddenDays*/ 15362) {
			$$invalidate(4, iChunks = $_iEvents.map(event => {
				let chunk;

				if (event && event.allDay && eventIntersects(event, start, end, resource)) {
					chunk = createEventChunk(event, start, end);
					prepareEventChunks([chunk], $hiddenDays);
				} else {
					chunk = null;
				}

				return chunk;
			}));
		}
	};

	return [
		dates,
		resource,
		chunks,
		longChunks,
		iChunks,
		refs,
		_events,
		_iEvents,
		hiddenDays,
		reposition,
		start,
		end,
		$hiddenDays,
		$_iEvents,
		$_events,
		day_binding
	];
}

class Week extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance$1, create_fragment$1, safe_not_equal, { dates: 0, resource: 1 });
	}
}

/* packages/time-grid/src/View.svelte generated by Svelte v4.2.18 */

function get_each_context(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[10] = list[i];
	return child_ctx;
}

function get_each_context_1(ctx, list, i) {
	const child_ctx = ctx.slice();
	child_ctx[10] = list[i];
	return child_ctx;
}

// (14:8) {#each $_viewDates as date}
function create_each_block_1(ctx) {
	let div;
	let time;
	let time_datetime_value;
	let time_aria_label_value;
	let setContent_action;
	let t;
	let div_class_value;
	let mounted;
	let dispose;

	return {
		c() {
			div = element("div");
			time = element("time");
			t = space();
			attr(time, "datetime", time_datetime_value = toISOString(/*date*/ ctx[10], 10));
			attr(time, "aria-label", time_aria_label_value = /*$_intlDayHeaderAL*/ ctx[2].format(/*date*/ ctx[10]));
			attr(div, "class", div_class_value = "" + (/*$theme*/ ctx[0].day + " " + /*$theme*/ ctx[0].weekdays?.[/*date*/ ctx[10].getUTCDay()]));
			attr(div, "role", "columnheader");
		},
		m(target, anchor) {
			insert(target, div, anchor);
			append(div, time);
			append(div, t);

			if (!mounted) {
				dispose = action_destroyer(setContent_action = setContent.call(null, time, /*$_intlDayHeader*/ ctx[3].format(/*date*/ ctx[10])));
				mounted = true;
			}
		},
		p(new_ctx, dirty) {
			ctx = new_ctx;

			if (dirty & /*$_viewDates*/ 2 && time_datetime_value !== (time_datetime_value = toISOString(/*date*/ ctx[10], 10))) {
				attr(time, "datetime", time_datetime_value);
			}

			if (dirty & /*$_intlDayHeaderAL, $_viewDates*/ 6 && time_aria_label_value !== (time_aria_label_value = /*$_intlDayHeaderAL*/ ctx[2].format(/*date*/ ctx[10]))) {
				attr(time, "aria-label", time_aria_label_value);
			}

			if (setContent_action && is_function(setContent_action.update) && dirty & /*$_intlDayHeader, $_viewDates*/ 10) setContent_action.update.call(null, /*$_intlDayHeader*/ ctx[3].format(/*date*/ ctx[10]));

			if (dirty & /*$theme, $_viewDates*/ 3 && div_class_value !== (div_class_value = "" + (/*$theme*/ ctx[0].day + " " + /*$theme*/ ctx[0].weekdays?.[/*date*/ ctx[10].getUTCDay()]))) {
				attr(div, "class", div_class_value);
			}
		},
		d(detaching) {
			if (detaching) {
				detach(div);
			}

			mounted = false;
			dispose();
		}
	};
}

// (13:4) <Section>
function create_default_slot_2(ctx) {
	let each_1_anchor;
	let each_value_1 = ensure_array_like(/*$_viewDates*/ ctx[1]);
	let each_blocks = [];

	for (let i = 0; i < each_value_1.length; i += 1) {
		each_blocks[i] = create_each_block_1(get_each_context_1(ctx, each_value_1, i));
	}

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert(target, each_1_anchor, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*$theme, $_viewDates, $_intlDayHeaderAL, $_intlDayHeader*/ 15) {
				each_value_1 = ensure_array_like(/*$_viewDates*/ ctx[1]);
				let i;

				for (i = 0; i < each_value_1.length; i += 1) {
					const child_ctx = get_each_context_1(ctx, each_value_1, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
					} else {
						each_blocks[i] = create_each_block_1(child_ctx);
						each_blocks[i].c();
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				for (; i < each_blocks.length; i += 1) {
					each_blocks[i].d(1);
				}

				each_blocks.length = each_value_1.length;
			}
		},
		d(detaching) {
			if (detaching) {
				detach(each_1_anchor);
			}

			destroy_each(each_blocks, detaching);
		}
	};
}

// (26:0) {#if $allDaySlot}
function create_if_block(ctx) {
	let div2;
	let div1;
	let section;
	let t;
	let div0;
	let div0_class_value;
	let div1_class_value;
	let div2_class_value;
	let current;

	section = new Section({
			props: {
				$$slots: { default: [create_default_slot_1] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			div2 = element("div");
			div1 = element("div");
			create_component(section.$$.fragment);
			t = space();
			div0 = element("div");
			attr(div0, "class", div0_class_value = /*$theme*/ ctx[0].hiddenScroll);
			attr(div1, "class", div1_class_value = /*$theme*/ ctx[0].content);
			attr(div2, "class", div2_class_value = /*$theme*/ ctx[0].allDay);
		},
		m(target, anchor) {
			insert(target, div2, anchor);
			append(div2, div1);
			mount_component(section, div1, null);
			append(div1, t);
			append(div1, div0);
			current = true;
		},
		p(ctx, dirty) {
			const section_changes = {};

			if (dirty & /*$$scope, $_viewDates*/ 32770) {
				section_changes.$$scope = { dirty, ctx };
			}

			section.$set(section_changes);

			if (!current || dirty & /*$theme*/ 1 && div0_class_value !== (div0_class_value = /*$theme*/ ctx[0].hiddenScroll)) {
				attr(div0, "class", div0_class_value);
			}

			if (!current || dirty & /*$theme*/ 1 && div1_class_value !== (div1_class_value = /*$theme*/ ctx[0].content)) {
				attr(div1, "class", div1_class_value);
			}

			if (!current || dirty & /*$theme*/ 1 && div2_class_value !== (div2_class_value = /*$theme*/ ctx[0].allDay)) {
				attr(div2, "class", div2_class_value);
			}
		},
		i(local) {
			if (current) return;
			transition_in(section.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(section.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(div2);
			}

			destroy_component(section);
		}
	};
}

// (29:12) <Section>
function create_default_slot_1(ctx) {
	let week;
	let current;
	week = new Week({ props: { dates: /*$_viewDates*/ ctx[1] } });

	return {
		c() {
			create_component(week.$$.fragment);
		},
		m(target, anchor) {
			mount_component(week, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const week_changes = {};
			if (dirty & /*$_viewDates*/ 2) week_changes.dates = /*$_viewDates*/ ctx[1];
			week.$set(week_changes);
		},
		i(local) {
			if (current) return;
			transition_in(week.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(week.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(week, detaching);
		}
	};
}

// (37:0) {#each $_viewDates as date}
function create_each_block(ctx) {
	let day;
	let current;
	day = new Day$1({ props: { date: /*date*/ ctx[10] } });

	return {
		c() {
			create_component(day.$$.fragment);
		},
		m(target, anchor) {
			mount_component(day, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const day_changes = {};
			if (dirty & /*$_viewDates*/ 2) day_changes.date = /*date*/ ctx[10];
			day.$set(day_changes);
		},
		i(local) {
			if (current) return;
			transition_in(day.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(day.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(day, detaching);
		}
	};
}

// (36:0) <Body>
function create_default_slot(ctx) {
	let each_1_anchor;
	let current;
	let each_value = ensure_array_like(/*$_viewDates*/ ctx[1]);
	let each_blocks = [];

	for (let i = 0; i < each_value.length; i += 1) {
		each_blocks[i] = create_each_block(get_each_context(ctx, each_value, i));
	}

	const out = i => transition_out(each_blocks[i], 1, 1, () => {
		each_blocks[i] = null;
	});

	return {
		c() {
			for (let i = 0; i < each_blocks.length; i += 1) {
				each_blocks[i].c();
			}

			each_1_anchor = empty();
		},
		m(target, anchor) {
			for (let i = 0; i < each_blocks.length; i += 1) {
				if (each_blocks[i]) {
					each_blocks[i].m(target, anchor);
				}
			}

			insert(target, each_1_anchor, anchor);
			current = true;
		},
		p(ctx, dirty) {
			if (dirty & /*$_viewDates*/ 2) {
				each_value = ensure_array_like(/*$_viewDates*/ ctx[1]);
				let i;

				for (i = 0; i < each_value.length; i += 1) {
					const child_ctx = get_each_context(ctx, each_value, i);

					if (each_blocks[i]) {
						each_blocks[i].p(child_ctx, dirty);
						transition_in(each_blocks[i], 1);
					} else {
						each_blocks[i] = create_each_block(child_ctx);
						each_blocks[i].c();
						transition_in(each_blocks[i], 1);
						each_blocks[i].m(each_1_anchor.parentNode, each_1_anchor);
					}
				}

				group_outros();

				for (i = each_value.length; i < each_blocks.length; i += 1) {
					out(i);
				}

				check_outros();
			}
		},
		i(local) {
			if (current) return;

			for (let i = 0; i < each_value.length; i += 1) {
				transition_in(each_blocks[i]);
			}

			current = true;
		},
		o(local) {
			each_blocks = each_blocks.filter(Boolean);

			for (let i = 0; i < each_blocks.length; i += 1) {
				transition_out(each_blocks[i]);
			}

			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(each_1_anchor);
			}

			destroy_each(each_blocks, detaching);
		}
	};
}

function create_fragment(ctx) {
	let div1;
	let section;
	let t0;
	let div0;
	let div0_class_value;
	let div1_class_value;
	let t1;
	let t2;
	let body;
	let current;

	section = new Section({
			props: {
				$$slots: { default: [create_default_slot_2] },
				$$scope: { ctx }
			}
		});

	let if_block = /*$allDaySlot*/ ctx[4] && create_if_block(ctx);

	body = new Body({
			props: {
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			div1 = element("div");
			create_component(section.$$.fragment);
			t0 = space();
			div0 = element("div");
			t1 = space();
			if (if_block) if_block.c();
			t2 = space();
			create_component(body.$$.fragment);
			attr(div0, "class", div0_class_value = /*$theme*/ ctx[0].hiddenScroll);
			attr(div1, "class", div1_class_value = /*$theme*/ ctx[0].header);
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			mount_component(section, div1, null);
			append(div1, t0);
			append(div1, div0);
			insert(target, t1, anchor);
			if (if_block) if_block.m(target, anchor);
			insert(target, t2, anchor);
			mount_component(body, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const section_changes = {};

			if (dirty & /*$$scope, $_viewDates, $theme, $_intlDayHeaderAL, $_intlDayHeader*/ 32783) {
				section_changes.$$scope = { dirty, ctx };
			}

			section.$set(section_changes);

			if (!current || dirty & /*$theme*/ 1 && div0_class_value !== (div0_class_value = /*$theme*/ ctx[0].hiddenScroll)) {
				attr(div0, "class", div0_class_value);
			}

			if (!current || dirty & /*$theme*/ 1 && div1_class_value !== (div1_class_value = /*$theme*/ ctx[0].header)) {
				attr(div1, "class", div1_class_value);
			}

			if (/*$allDaySlot*/ ctx[4]) {
				if (if_block) {
					if_block.p(ctx, dirty);

					if (dirty & /*$allDaySlot*/ 16) {
						transition_in(if_block, 1);
					}
				} else {
					if_block = create_if_block(ctx);
					if_block.c();
					transition_in(if_block, 1);
					if_block.m(t2.parentNode, t2);
				}
			} else if (if_block) {
				group_outros();

				transition_out(if_block, 1, 1, () => {
					if_block = null;
				});

				check_outros();
			}

			const body_changes = {};

			if (dirty & /*$$scope, $_viewDates*/ 32770) {
				body_changes.$$scope = { dirty, ctx };
			}

			body.$set(body_changes);
		},
		i(local) {
			if (current) return;
			transition_in(section.$$.fragment, local);
			transition_in(if_block);
			transition_in(body.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(section.$$.fragment, local);
			transition_out(if_block);
			transition_out(body.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) {
				detach(div1);
				detach(t1);
				detach(t2);
			}

			destroy_component(section);
			if (if_block) if_block.d(detaching);
			destroy_component(body, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let $theme;
	let $_viewDates;
	let $_intlDayHeaderAL;
	let $_intlDayHeader;
	let $allDaySlot;
	let { _viewDates, _intlDayHeader, _intlDayHeaderAL, allDaySlot, theme } = getContext('state');
	component_subscribe($$self, _viewDates, value => $$invalidate(1, $_viewDates = value));
	component_subscribe($$self, _intlDayHeader, value => $$invalidate(3, $_intlDayHeader = value));
	component_subscribe($$self, _intlDayHeaderAL, value => $$invalidate(2, $_intlDayHeaderAL = value));
	component_subscribe($$self, allDaySlot, value => $$invalidate(4, $allDaySlot = value));
	component_subscribe($$self, theme, value => $$invalidate(0, $theme = value));

	return [
		$theme,
		$_viewDates,
		$_intlDayHeaderAL,
		$_intlDayHeader,
		$allDaySlot,
		_viewDates,
		_intlDayHeader,
		_intlDayHeaderAL,
		allDaySlot,
		theme
	];
}

class View extends SvelteComponent {
	constructor(options) {
		super();
		init(this, options, instance, create_fragment, safe_not_equal, {});
	}
}

var index = {
	createOptions(options) {
		// Common options
		options.buttonText.timeGridDay = 'day';
		options.buttonText.timeGridWeek = 'week';
		options.view = 'timeGridWeek';
		options.views.timeGridDay = {
			buttonText: btnTextDay,
			component: View,
			dayHeaderFormat: {weekday: 'long'},
			duration: {days: 1},
			theme: themeView('ec-time-grid ec-day-view'),
			titleFormat: {year: 'numeric', month: 'long', day: 'numeric'}
		};
		options.views.timeGridWeek = {
			buttonText: btnTextWeek,
			component: View,
			duration: {weeks: 1},
			theme: themeView('ec-time-grid ec-week-view')
		};
	},

	createStores(state) {
		state._slotTimeLimits = slotTimeLimits(state);  // flexible limits
		state._times = times(state);
	}
};

export { Body, Day$1 as Day, Section, Week, index as default };
