'use strict';

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

var MemBuffer = require('./nodeMemBuffer');
var request = require('request');

function BinaryHttpTransport(serviceUrl, quiet) {
  'use strict';

  this.url = serviceUrl;
  this.quiet = quiet;
  this.additionalHeaders = {};

  this.input = new MemBuffer();
}

BinaryHttpTransport.prototype.addHeaders = function (headers) {
  'use strict';

  Object.assign(this.additionalHeaders, headers);
};

BinaryHttpTransport.prototype.open = function () {
  'use strict';
};

BinaryHttpTransport.prototype.close = function () {
  'use strict';
};

BinaryHttpTransport.prototype.read = function (len) {
  'use strict';

  throw Error('BinaryHttpTransport object does not support reads');
};

BinaryHttpTransport.prototype.write = function (bytes) {
  'use strict';

  this.input.write(bytes);
};

BinaryHttpTransport.prototype.clear = function () {
  'use strict';

  this.input.clear();
};

BinaryHttpTransport.prototype.flush = function (callback) {
  'use strict';

  var self = this;
  request.post(self.url, {
    headers: Object.assign({}, {
      'Content-Type': 'application/x-thrift',
      'Accept': 'application/x-thrift'
    }, self.additionalHeaders)
  }, function(err, res, body) {
    if (res.statusCode !== 200) {
      self.log('Error in Thrift HTTP response: ' + res.statusCode);
      if (callback) {
        callback(res);
      }
    } else {
      if (callback) {
        console.log('RES: ', res.body);
        console.log('Chunk length: ' + body.length);
        callback(null, new MemBuffer(res.body));
      }
    }
  });

  this.input.flush();
  req.write(this.input.buffer);
  req.end();
  this.clear();
};

BinaryHttpTransport.prototype.log = function (msg) {
  'use strict';

  if (this.quiet) {
    return;
  }
  console.log(msg);
};

module.exports = BinaryHttpTransport;
