/*!
 * excalibur - 0.19.1 - 2018-10-23
 * https://github.com/excaliburjs/Excalibur
 * Copyright (c) 2018 Excalibur.js <https://github.com/excaliburjs/Excalibur/graphs/contributors>
 * Licensed BSD-2-Clause
 * @preserve
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["ex"] = factory();
	else
		root["ex"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./index.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "../../node_modules/css-loader/index.js!./Loader.css":
/*!*************************************************************************************!*\
  !*** /home/travis/build/excaliburjs/Excalibur/node_modules/css-loader!./Loader.css ***!
  \*************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

exports = module.exports = __webpack_require__(/*! ../../node_modules/css-loader/lib/css-base.js */ "../../node_modules/css-loader/lib/css-base.js")(false);
// imports


// module
exports.push([module.i, "/* Buttons styles start */\n\nbutton#excalibur-play {\n  display: inline-block;\n  position: relative;\n  border-radius: 6px;\n  border: none;\n  /*border: 3px solid;\n    border-color: white;\n    box-shadow: 0 0 10px #ccc;*/\n  padding: 1rem 1.5rem 1rem 4rem;\n  margin: 0;\n  text-decoration: none;\n  background: #00b233;\n  color: #ffffff;\n  font-family: sans-serif;\n  font-size: 2rem;\n  line-height: 1;\n  cursor: pointer;\n  text-align: center;\n  transition: background 250ms ease-in-out, transform 150ms ease;\n  -webkit-appearance: none;\n  -moz-appearance: none;\n\n  -webkit-animation: excalibur-button-fadein 200ms; /* Safari, Chrome and Opera > 12.1 */\n  -moz-animation: excalibur-button-fadein 200ms; /* Firefox < 16 */\n  -ms-animation: excalibur-button-fadein 200ms; /* Internet Explorer */\n  -o-animation: excalibur-button-fadein 200ms; /* Opera < 12.1 */\n  animation: excalibur-button-fadein 200ms;\n}\n\n/*\nbutton#excalibur-play {\n  display: none;\n}*/\n\nbutton#excalibur-play:after {\n  position: absolute;\n  content: '';\n  border: 8px solid;\n  border-color: transparent transparent transparent white;\n  left: 35px;\n  top: 24px;\n  width: 0;\n  height: 0;\n}\n\nbutton#excalibur-play:before {\n  position: absolute;\n  content: '';\n  border: 3px solid;\n  left: 19px;\n  top: 14px;\n  border-radius: 20px;\n  width: 30px;\n  height: 30px;\n}\n\nbutton#excalibur-play:hover,\nbutton#excalibur-play:focus {\n  background: #00982c;\n}\n\nbutton#excalibur-play:focus {\n  outline: 1px solid #fff;\n  outline-offset: -4px;\n}\n\nbutton#excalibur-play:active {\n  transform: scale(0.99);\n}\n\n@keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n/* Firefox < 16 */\n@-moz-keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n/* Safari, Chrome and Opera > 12.1 */\n@-webkit-keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n/* Internet Explorer */\n@-ms-keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n\n/* Opera < 12.1 */\n@-o-keyframes excalibur-button-fadein {\n  from {\n    opacity: 0;\n  }\n  to {\n    opacity: 1;\n  }\n}\n", ""]);

// exports


/***/ }),

/***/ "../../node_modules/css-loader/lib/css-base.js":
/*!****************************************************************************************!*\
  !*** /home/travis/build/excaliburjs/Excalibur/node_modules/css-loader/lib/css-base.js ***!
  \****************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
module.exports = function(useSourceMap) {
	var list = [];

	// return the list of modules as css string
	list.toString = function toString() {
		return this.map(function (item) {
			var content = cssWithMappingToString(item, useSourceMap);
			if(item[2]) {
				return "@media " + item[2] + "{" + content + "}";
			} else {
				return content;
			}
		}).join("");
	};

	// import a list of modules into the list
	list.i = function(modules, mediaQuery) {
		if(typeof modules === "string")
			modules = [[null, modules, ""]];
		var alreadyImportedModules = {};
		for(var i = 0; i < this.length; i++) {
			var id = this[i][0];
			if(typeof id === "number")
				alreadyImportedModules[id] = true;
		}
		for(i = 0; i < modules.length; i++) {
			var item = modules[i];
			// skip already imported module
			// this implementation is not 100% perfect for weird media query combinations
			//  when a module is imported multiple times with different media queries.
			//  I hope this will never occur (Hey this way we have smaller bundles)
			if(typeof item[0] !== "number" || !alreadyImportedModules[item[0]]) {
				if(mediaQuery && !item[2]) {
					item[2] = mediaQuery;
				} else if(mediaQuery) {
					item[2] = "(" + item[2] + ") and (" + mediaQuery + ")";
				}
				list.push(item);
			}
		}
	};
	return list;
};

function cssWithMappingToString(item, useSourceMap) {
	var content = item[1] || '';
	var cssMapping = item[3];
	if (!cssMapping) {
		return content;
	}

	if (useSourceMap && typeof btoa === 'function') {
		var sourceMapping = toComment(cssMapping);
		var sourceURLs = cssMapping.sources.map(function (source) {
			return '/*# sourceURL=' + cssMapping.sourceRoot + source + ' */'
		});

		return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
	}

	return [content].join('\n');
}

// Adapted from convert-source-map (MIT)
function toComment(sourceMap) {
	// eslint-disable-next-line no-undef
	var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
	var data = 'sourceMappingURL=data:application/json;charset=utf-8;base64,' + base64;

	return '/*# ' + data + ' */';
}


/***/ }),

/***/ "./Actions/Action.ts":
/*!***************************!*\
  !*** ./Actions/Action.ts ***!
  \***************************/
/*! exports provided: EaseTo, MoveTo, MoveBy, Follow, Meet, RotateTo, RotateBy, ScaleTo, ScaleBy, Delay, Blink, Fade, Die, CallMethod, Repeat, RepeatForever, ActionQueue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EaseTo", function() { return EaseTo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MoveTo", function() { return MoveTo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MoveBy", function() { return MoveBy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Follow", function() { return Follow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Meet", function() { return Meet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RotateTo", function() { return RotateTo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RotateBy", function() { return RotateBy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ScaleTo", function() { return ScaleTo; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ScaleBy", function() { return ScaleBy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Delay", function() { return Delay; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Blink", function() { return Blink; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Fade", function() { return Fade; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Die", function() { return Die; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CallMethod", function() { return CallMethod; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Repeat", function() { return Repeat; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RepeatForever", function() { return RepeatForever; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActionQueue", function() { return ActionQueue; });
/* harmony import */ var _RotationType__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RotationType */ "./Actions/RotationType.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");




var EaseTo = /** @class */ (function () {
    function EaseTo(actor, x, y, duration, easingFcn) {
        this.actor = actor;
        this.easingFcn = easingFcn;
        this._currentLerpTime = 0;
        this._lerpDuration = 1 * 1000; // 1 second
        this._lerpStart = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](0, 0);
        this._lerpEnd = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](0, 0);
        this._initialized = false;
        this._stopped = false;
        this._distance = 0;
        this._lerpDuration = duration;
        this._lerpEnd = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](x, y);
    }
    EaseTo.prototype._initialize = function () {
        this._lerpStart = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](this.actor.pos.x, this.actor.pos.y);
        this._currentLerpTime = 0;
        this._distance = this._lerpStart.distance(this._lerpEnd);
    };
    EaseTo.prototype.update = function (delta) {
        if (!this._initialized) {
            this._initialize();
            this._initialized = true;
        }
        var newX = this.actor.pos.x;
        var newY = this.actor.pos.y;
        if (this._currentLerpTime < this._lerpDuration) {
            if (this._lerpEnd.x < this._lerpStart.x) {
                newX =
                    this._lerpStart.x -
                        (this.easingFcn(this._currentLerpTime, this._lerpEnd.x, this._lerpStart.x, this._lerpDuration) - this._lerpEnd.x);
            }
            else {
                newX = this.easingFcn(this._currentLerpTime, this._lerpStart.x, this._lerpEnd.x, this._lerpDuration);
            }
            if (this._lerpEnd.y < this._lerpStart.y) {
                newY =
                    this._lerpStart.y -
                        (this.easingFcn(this._currentLerpTime, this._lerpEnd.y, this._lerpStart.y, this._lerpDuration) - this._lerpEnd.y);
            }
            else {
                newY = this.easingFcn(this._currentLerpTime, this._lerpStart.y, this._lerpEnd.y, this._lerpDuration);
            }
            this.actor.pos.x = newX;
            this.actor.pos.y = newY;
            this._currentLerpTime += delta;
        }
        else {
            this.actor.pos.x = this._lerpEnd.x;
            this.actor.pos.y = this._lerpEnd.y;
            //this._lerpStart = null;
            //this._lerpEnd = null;
            //this._currentLerpTime = 0;
        }
    };
    EaseTo.prototype.isComplete = function (actor) {
        return this._stopped || new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](actor.pos.x, actor.pos.y).distance(this._lerpStart) >= this._distance;
    };
    EaseTo.prototype.reset = function () {
        this._initialized = false;
    };
    EaseTo.prototype.stop = function () {
        this._stopped = true;
    };
    return EaseTo;
}());

var MoveTo = /** @class */ (function () {
    function MoveTo(actor, destx, desty, speed) {
        this._started = false;
        this._stopped = false;
        this._actor = actor;
        this._end = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](destx, desty);
        this._speed = speed;
    }
    MoveTo.prototype.update = function (_delta) {
        if (!this._started) {
            this._started = true;
            this._start = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](this._actor.pos.x, this._actor.pos.y);
            this._distance = this._start.distance(this._end);
            this._dir = this._end.sub(this._start).normalize();
        }
        var m = this._dir.scale(this._speed);
        this._actor.vel.x = m.x;
        this._actor.vel.y = m.y;
        if (this.isComplete(this._actor)) {
            this._actor.pos.x = this._end.x;
            this._actor.pos.y = this._end.y;
            this._actor.vel.y = 0;
            this._actor.vel.x = 0;
        }
    };
    MoveTo.prototype.isComplete = function (actor) {
        return this._stopped || new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](actor.pos.x, actor.pos.y).distance(this._start) >= this._distance;
    };
    MoveTo.prototype.stop = function () {
        this._actor.vel.y = 0;
        this._actor.vel.x = 0;
        this._stopped = true;
    };
    MoveTo.prototype.reset = function () {
        this._started = false;
    };
    return MoveTo;
}());

var MoveBy = /** @class */ (function () {
    function MoveBy(actor, destx, desty, time) {
        this._started = false;
        this._stopped = false;
        this._actor = actor;
        this._end = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](destx, desty);
        if (time <= 0) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_2__["Logger"].getInstance().error('Attempted to moveBy time less than or equal to zero : ' + time);
            throw new Error('Cannot move in time <= 0');
        }
        this._time = time;
    }
    MoveBy.prototype.update = function (_delta) {
        if (!this._started) {
            this._started = true;
            this._start = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](this._actor.pos.x, this._actor.pos.y);
            this._distance = this._start.distance(this._end);
            this._dir = this._end.sub(this._start).normalize();
            this._speed = this._distance / (this._time / 1000);
        }
        var m = this._dir.scale(this._speed);
        this._actor.vel.x = m.x;
        this._actor.vel.y = m.y;
        if (this.isComplete(this._actor)) {
            this._actor.pos.x = this._end.x;
            this._actor.pos.y = this._end.y;
            this._actor.vel.y = 0;
            this._actor.vel.x = 0;
        }
    };
    MoveBy.prototype.isComplete = function (actor) {
        return this._stopped || new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](actor.pos.x, actor.pos.y).distance(this._start) >= this._distance;
    };
    MoveBy.prototype.stop = function () {
        this._actor.vel.y = 0;
        this._actor.vel.x = 0;
        this._stopped = true;
    };
    MoveBy.prototype.reset = function () {
        this._started = false;
    };
    return MoveBy;
}());

var Follow = /** @class */ (function () {
    function Follow(actor, actorToFollow, followDistance) {
        this._started = false;
        this._stopped = false;
        this._actor = actor;
        this._actorToFollow = actorToFollow;
        this._current = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](this._actor.pos.x, this._actor.pos.y);
        this._end = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](actorToFollow.pos.x, actorToFollow.pos.y);
        this._maximumDistance = followDistance !== undefined ? followDistance : this._current.distance(this._end);
        this._speed = 0;
    }
    Follow.prototype.update = function (_delta) {
        if (!this._started) {
            this._started = true;
            this._distanceBetween = this._current.distance(this._end);
            this._dir = this._end.sub(this._current).normalize();
        }
        var actorToFollowSpeed = Math.sqrt(Math.pow(this._actorToFollow.vel.x, 2) + Math.pow(this._actorToFollow.vel.y, 2));
        if (actorToFollowSpeed !== 0) {
            this._speed = actorToFollowSpeed;
        }
        this._current.x = this._actor.pos.x;
        this._current.y = this._actor.pos.y;
        this._end.x = this._actorToFollow.pos.x;
        this._end.y = this._actorToFollow.pos.y;
        this._distanceBetween = this._current.distance(this._end);
        this._dir = this._end.sub(this._current).normalize();
        if (this._distanceBetween >= this._maximumDistance) {
            var m = this._dir.scale(this._speed);
            this._actor.vel.x = m.x;
            this._actor.vel.y = m.y;
        }
        else {
            this._actor.vel.x = 0;
            this._actor.vel.y = 0;
        }
        if (this.isComplete()) {
            // TODO this should never occur
            this._actor.pos.x = this._end.x;
            this._actor.pos.y = this._end.y;
            this._actor.vel.y = 0;
            this._actor.vel.x = 0;
        }
    };
    Follow.prototype.stop = function () {
        this._actor.vel.y = 0;
        this._actor.vel.x = 0;
        this._stopped = true;
    };
    Follow.prototype.isComplete = function () {
        // the actor following should never stop unless specified to do so
        return this._stopped;
    };
    Follow.prototype.reset = function () {
        this._started = false;
    };
    return Follow;
}());

var Meet = /** @class */ (function () {
    function Meet(actor, actorToMeet, speed) {
        this._started = false;
        this._stopped = false;
        this._speedWasSpecified = false;
        this._actor = actor;
        this._actorToMeet = actorToMeet;
        this._current = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](this._actor.pos.x, this._actor.pos.y);
        this._end = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](actorToMeet.pos.x, actorToMeet.pos.y);
        this._speed = speed || 0;
        if (speed !== undefined) {
            this._speedWasSpecified = true;
        }
    }
    Meet.prototype.update = function (_delta) {
        if (!this._started) {
            this._started = true;
            this._distanceBetween = this._current.distance(this._end);
            this._dir = this._end.sub(this._current).normalize();
        }
        var actorToMeetSpeed = Math.sqrt(Math.pow(this._actorToMeet.vel.x, 2) + Math.pow(this._actorToMeet.vel.y, 2));
        if (actorToMeetSpeed !== 0 && !this._speedWasSpecified) {
            this._speed = actorToMeetSpeed;
        }
        this._current.x = this._actor.pos.x;
        this._current.y = this._actor.pos.y;
        this._end.x = this._actorToMeet.pos.x;
        this._end.y = this._actorToMeet.pos.y;
        this._distanceBetween = this._current.distance(this._end);
        this._dir = this._end.sub(this._current).normalize();
        var m = this._dir.scale(this._speed);
        this._actor.vel.x = m.x;
        this._actor.vel.y = m.y;
        if (this.isComplete()) {
            this._actor.pos.x = this._end.x;
            this._actor.pos.y = this._end.y;
            this._actor.vel.y = 0;
            this._actor.vel.x = 0;
        }
    };
    Meet.prototype.isComplete = function () {
        return this._stopped || this._distanceBetween <= 1;
    };
    Meet.prototype.stop = function () {
        this._actor.vel.y = 0;
        this._actor.vel.x = 0;
        this._stopped = true;
    };
    Meet.prototype.reset = function () {
        this._started = false;
    };
    return Meet;
}());

var RotateTo = /** @class */ (function () {
    function RotateTo(actor, angleRadians, speed, rotationType) {
        this._started = false;
        this._stopped = false;
        this._actor = actor;
        this._end = angleRadians;
        this._speed = speed;
        this._rotationType = rotationType || _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].ShortestPath;
    }
    RotateTo.prototype.update = function (_delta) {
        if (!this._started) {
            this._started = true;
            this._start = this._actor.rotation;
            var distance1 = Math.abs(this._end - this._start);
            var distance2 = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["TwoPI"] - distance1;
            if (distance1 > distance2) {
                this._shortDistance = distance2;
                this._longDistance = distance1;
            }
            else {
                this._shortDistance = distance1;
                this._longDistance = distance2;
            }
            this._shortestPathIsPositive = (this._start - this._end + _Util_Util__WEBPACK_IMPORTED_MODULE_3__["TwoPI"]) % _Util_Util__WEBPACK_IMPORTED_MODULE_3__["TwoPI"] >= Math.PI;
            switch (this._rotationType) {
                case _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].ShortestPath:
                    this._distance = this._shortDistance;
                    if (this._shortestPathIsPositive) {
                        this._direction = 1;
                    }
                    else {
                        this._direction = -1;
                    }
                    break;
                case _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].LongestPath:
                    this._distance = this._longDistance;
                    if (this._shortestPathIsPositive) {
                        this._direction = -1;
                    }
                    else {
                        this._direction = 1;
                    }
                    break;
                case _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].Clockwise:
                    this._direction = 1;
                    if (this._shortestPathIsPositive) {
                        this._distance = this._shortDistance;
                    }
                    else {
                        this._distance = this._longDistance;
                    }
                    break;
                case _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].CounterClockwise:
                    this._direction = -1;
                    if (!this._shortestPathIsPositive) {
                        this._distance = this._shortDistance;
                    }
                    else {
                        this._distance = this._longDistance;
                    }
                    break;
            }
        }
        this._actor.rx = this._direction * this._speed;
        if (this.isComplete()) {
            this._actor.rotation = this._end;
            this._actor.rx = 0;
            this._stopped = true;
        }
    };
    RotateTo.prototype.isComplete = function () {
        var distanceTravelled = Math.abs(this._actor.rotation - this._start);
        return this._stopped || distanceTravelled >= Math.abs(this._distance);
    };
    RotateTo.prototype.stop = function () {
        this._actor.rx = 0;
        this._stopped = true;
    };
    RotateTo.prototype.reset = function () {
        this._started = false;
    };
    return RotateTo;
}());

var RotateBy = /** @class */ (function () {
    function RotateBy(actor, angleRadians, time, rotationType) {
        this._started = false;
        this._stopped = false;
        this._actor = actor;
        this._end = angleRadians;
        this._time = time;
        this._rotationType = rotationType || _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].ShortestPath;
    }
    RotateBy.prototype.update = function (_delta) {
        if (!this._started) {
            this._started = true;
            this._start = this._actor.rotation;
            var distance1 = Math.abs(this._end - this._start);
            var distance2 = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["TwoPI"] - distance1;
            if (distance1 > distance2) {
                this._shortDistance = distance2;
                this._longDistance = distance1;
            }
            else {
                this._shortDistance = distance1;
                this._longDistance = distance2;
            }
            this._shortestPathIsPositive = (this._start - this._end + _Util_Util__WEBPACK_IMPORTED_MODULE_3__["TwoPI"]) % _Util_Util__WEBPACK_IMPORTED_MODULE_3__["TwoPI"] >= Math.PI;
            switch (this._rotationType) {
                case _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].ShortestPath:
                    this._distance = this._shortDistance;
                    if (this._shortestPathIsPositive) {
                        this._direction = 1;
                    }
                    else {
                        this._direction = -1;
                    }
                    break;
                case _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].LongestPath:
                    this._distance = this._longDistance;
                    if (this._shortestPathIsPositive) {
                        this._direction = -1;
                    }
                    else {
                        this._direction = 1;
                    }
                    break;
                case _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].Clockwise:
                    this._direction = 1;
                    if (this._shortDistance >= 0) {
                        this._distance = this._shortDistance;
                    }
                    else {
                        this._distance = this._longDistance;
                    }
                    break;
                case _RotationType__WEBPACK_IMPORTED_MODULE_0__["RotationType"].CounterClockwise:
                    this._direction = -1;
                    if (this._shortDistance <= 0) {
                        this._distance = this._shortDistance;
                    }
                    else {
                        this._distance = this._longDistance;
                    }
                    break;
            }
            this._speed = Math.abs((this._distance / this._time) * 1000);
        }
        this._actor.rx = this._direction * this._speed;
        if (this.isComplete()) {
            this._actor.rotation = this._end;
            this._actor.rx = 0;
            this._stopped = true;
        }
    };
    RotateBy.prototype.isComplete = function () {
        var distanceTravelled = Math.abs(this._actor.rotation - this._start);
        return this._stopped || distanceTravelled >= Math.abs(this._distance);
    };
    RotateBy.prototype.stop = function () {
        this._actor.rx = 0;
        this._stopped = true;
    };
    RotateBy.prototype.reset = function () {
        this._started = false;
    };
    return RotateBy;
}());

var ScaleTo = /** @class */ (function () {
    function ScaleTo(actor, scaleX, scaleY, speedX, speedY) {
        this._started = false;
        this._stopped = false;
        this._actor = actor;
        this._endX = scaleX;
        this._endY = scaleY;
        this._speedX = speedX;
        this._speedY = speedY;
    }
    ScaleTo.prototype.update = function (_delta) {
        if (!this._started) {
            this._started = true;
            this._startX = this._actor.scale.x;
            this._startY = this._actor.scale.y;
            this._distanceX = Math.abs(this._endX - this._startX);
            this._distanceY = Math.abs(this._endY - this._startY);
        }
        if (!(Math.abs(this._actor.scale.x - this._startX) >= this._distanceX)) {
            var directionX = this._endY < this._startY ? -1 : 1;
            this._actor.sx = this._speedX * directionX;
        }
        else {
            this._actor.sx = 0;
        }
        if (!(Math.abs(this._actor.scale.y - this._startY) >= this._distanceY)) {
            var directionY = this._endY < this._startY ? -1 : 1;
            this._actor.sy = this._speedY * directionY;
        }
        else {
            this._actor.sy = 0;
        }
        if (this.isComplete()) {
            this._actor.scale.x = this._endX;
            this._actor.scale.y = this._endY;
            this._actor.sx = 0;
            this._actor.sy = 0;
        }
    };
    ScaleTo.prototype.isComplete = function () {
        return (this._stopped ||
            (Math.abs(this._actor.scale.y - this._startX) >= this._distanceX && Math.abs(this._actor.scale.y - this._startY) >= this._distanceY));
    };
    ScaleTo.prototype.stop = function () {
        this._actor.sx = 0;
        this._actor.sy = 0;
        this._stopped = true;
    };
    ScaleTo.prototype.reset = function () {
        this._started = false;
    };
    return ScaleTo;
}());

var ScaleBy = /** @class */ (function () {
    function ScaleBy(actor, scaleX, scaleY, time) {
        this._started = false;
        this._stopped = false;
        this._actor = actor;
        this._endX = scaleX;
        this._endY = scaleY;
        this._speedX = ((this._endX - this._actor.scale.x) / time) * 1000;
        this._speedY = ((this._endY - this._actor.scale.y) / time) * 1000;
    }
    ScaleBy.prototype.update = function (_delta) {
        if (!this._started) {
            this._started = true;
            this._startX = this._actor.scale.x;
            this._startY = this._actor.scale.y;
            this._distanceX = Math.abs(this._endX - this._startX);
            this._distanceY = Math.abs(this._endY - this._startY);
        }
        var directionX = this._endX < this._startX ? -1 : 1;
        var directionY = this._endY < this._startY ? -1 : 1;
        this._actor.sx = this._speedX * directionX;
        this._actor.sy = this._speedY * directionY;
        if (this.isComplete()) {
            this._actor.scale.x = this._endX;
            this._actor.scale.y = this._endY;
            this._actor.sx = 0;
            this._actor.sy = 0;
        }
    };
    ScaleBy.prototype.isComplete = function () {
        return (this._stopped ||
            (Math.abs(this._actor.scale.x - this._startX) >= this._distanceX && Math.abs(this._actor.scale.y - this._startY) >= this._distanceY));
    };
    ScaleBy.prototype.stop = function () {
        this._actor.sx = 0;
        this._actor.sy = 0;
        this._stopped = true;
    };
    ScaleBy.prototype.reset = function () {
        this._started = false;
    };
    return ScaleBy;
}());

var Delay = /** @class */ (function () {
    function Delay(actor, delay) {
        this._elapsedTime = 0;
        this._started = false;
        this._stopped = false;
        this._actor = actor;
        this._delay = delay;
    }
    Delay.prototype.update = function (delta) {
        if (!this._started) {
            this._started = true;
        }
        this.x = this._actor.pos.x;
        this.y = this._actor.pos.y;
        this._elapsedTime += delta;
    };
    Delay.prototype.isComplete = function () {
        return this._stopped || this._elapsedTime >= this._delay;
    };
    Delay.prototype.stop = function () {
        this._stopped = true;
    };
    Delay.prototype.reset = function () {
        this._elapsedTime = 0;
        this._started = false;
    };
    return Delay;
}());

var Blink = /** @class */ (function () {
    function Blink(actor, timeVisible, timeNotVisible, numBlinks) {
        if (numBlinks === void 0) { numBlinks = 1; }
        this._timeVisible = 0;
        this._timeNotVisible = 0;
        this._elapsedTime = 0;
        this._totalTime = 0;
        this._stopped = false;
        this._started = false;
        this._actor = actor;
        this._timeVisible = timeVisible;
        this._timeNotVisible = timeNotVisible;
        this._duration = (timeVisible + timeNotVisible) * numBlinks;
    }
    Blink.prototype.update = function (delta) {
        if (!this._started) {
            this._started = true;
        }
        this._elapsedTime += delta;
        this._totalTime += delta;
        if (this._actor.visible && this._elapsedTime >= this._timeVisible) {
            this._actor.visible = false;
            this._elapsedTime = 0;
        }
        if (!this._actor.visible && this._elapsedTime >= this._timeNotVisible) {
            this._actor.visible = true;
            this._elapsedTime = 0;
        }
        if (this.isComplete()) {
            this._actor.visible = true;
        }
    };
    Blink.prototype.isComplete = function () {
        return this._stopped || this._totalTime >= this._duration;
    };
    Blink.prototype.stop = function () {
        this._actor.visible = true;
        this._stopped = true;
    };
    Blink.prototype.reset = function () {
        this._started = false;
        this._elapsedTime = 0;
        this._totalTime = 0;
    };
    return Blink;
}());

var Fade = /** @class */ (function () {
    function Fade(actor, endOpacity, speed) {
        this._multiplier = 1;
        this._started = false;
        this._stopped = false;
        this._actor = actor;
        this._endOpacity = endOpacity;
        this._speed = speed;
    }
    Fade.prototype.update = function (delta) {
        if (!this._started) {
            this._started = true;
            // determine direction when we start
            if (this._endOpacity < this._actor.opacity) {
                this._multiplier = -1;
            }
            else {
                this._multiplier = 1;
            }
        }
        if (this._speed > 0) {
            this._actor.opacity += (this._multiplier * (Math.abs(this._actor.opacity - this._endOpacity) * delta)) / this._speed;
        }
        this._speed -= delta;
        if (this.isComplete()) {
            this._actor.opacity = this._endOpacity;
        }
        _Util_Log__WEBPACK_IMPORTED_MODULE_2__["Logger"].getInstance().debug('[Action fade] Actor opacity:', this._actor.opacity);
    };
    Fade.prototype.isComplete = function () {
        return this._stopped || Math.abs(this._actor.opacity - this._endOpacity) < 0.05;
    };
    Fade.prototype.stop = function () {
        this._stopped = true;
    };
    Fade.prototype.reset = function () {
        this._started = false;
    };
    return Fade;
}());

var Die = /** @class */ (function () {
    function Die(actor) {
        this._stopped = false;
        this._actor = actor;
    }
    Die.prototype.update = function (_delta) {
        this._actor.actionQueue.clearActions();
        this._actor.kill();
        this._stopped = true;
    };
    Die.prototype.isComplete = function () {
        return this._stopped;
    };
    Die.prototype.stop = function () {
        return;
    };
    Die.prototype.reset = function () {
        return;
    };
    return Die;
}());

var CallMethod = /** @class */ (function () {
    function CallMethod(actor, method) {
        this._method = null;
        this._actor = null;
        this._hasBeenCalled = false;
        this._actor = actor;
        this._method = method;
    }
    CallMethod.prototype.update = function (_delta) {
        this._method.call(this._actor);
        this._hasBeenCalled = true;
    };
    CallMethod.prototype.isComplete = function () {
        return this._hasBeenCalled;
    };
    CallMethod.prototype.reset = function () {
        this._hasBeenCalled = false;
    };
    CallMethod.prototype.stop = function () {
        this._hasBeenCalled = true;
    };
    return CallMethod;
}());

var Repeat = /** @class */ (function () {
    function Repeat(actor, repeat, actions) {
        this._stopped = false;
        this._actor = actor;
        this._actionQueue = new ActionQueue(actor);
        this._repeat = repeat;
        this._originalRepeat = repeat;
        var i = 0, len = actions.length;
        for (i; i < len; i++) {
            actions[i].reset();
            this._actionQueue.add(actions[i]);
        }
    }
    Repeat.prototype.update = function (delta) {
        this.x = this._actor.pos.x;
        this.y = this._actor.pos.y;
        if (!this._actionQueue.hasNext()) {
            this._actionQueue.reset();
            this._repeat--;
        }
        this._actionQueue.update(delta);
    };
    Repeat.prototype.isComplete = function () {
        return this._stopped || this._repeat <= 0;
    };
    Repeat.prototype.stop = function () {
        this._stopped = true;
    };
    Repeat.prototype.reset = function () {
        this._repeat = this._originalRepeat;
    };
    return Repeat;
}());

var RepeatForever = /** @class */ (function () {
    function RepeatForever(actor, actions) {
        this._stopped = false;
        this._actor = actor;
        this._actionQueue = new ActionQueue(actor);
        var i = 0, len = actions.length;
        for (i; i < len; i++) {
            actions[i].reset();
            this._actionQueue.add(actions[i]);
        }
    }
    RepeatForever.prototype.update = function (delta) {
        this.x = this._actor.pos.x;
        this.y = this._actor.pos.y;
        if (this._stopped) {
            return;
        }
        if (!this._actionQueue.hasNext()) {
            this._actionQueue.reset();
        }
        this._actionQueue.update(delta);
    };
    RepeatForever.prototype.isComplete = function () {
        return this._stopped;
    };
    RepeatForever.prototype.stop = function () {
        this._stopped = true;
        this._actionQueue.clearActions();
    };
    RepeatForever.prototype.reset = function () {
        return;
    };
    return RepeatForever;
}());

/**
 * Action Queues
 *
 * Action queues are part of the [[ActionContext|Action API]] and
 * store the list of actions to be executed for an [[Actor]].
 *
 * Actors implement [[Actor.actions]] which can be manipulated by
 * advanced users to adjust the actions currently being executed in the
 * queue.
 */
var ActionQueue = /** @class */ (function () {
    function ActionQueue(actor) {
        this._actions = [];
        this._completedActions = [];
        this._actor = actor;
    }
    ActionQueue.prototype.add = function (action) {
        this._actions.push(action);
    };
    ActionQueue.prototype.remove = function (action) {
        var index = this._actions.indexOf(action);
        this._actions.splice(index, 1);
    };
    ActionQueue.prototype.clearActions = function () {
        this._actions.length = 0;
        this._completedActions.length = 0;
        if (this._currentAction) {
            this._currentAction.stop();
        }
    };
    ActionQueue.prototype.getActions = function () {
        return this._actions.concat(this._completedActions);
    };
    ActionQueue.prototype.hasNext = function () {
        return this._actions.length > 0;
    };
    ActionQueue.prototype.reset = function () {
        this._actions = this.getActions();
        var i = 0, len = this._actions.length;
        for (i; i < len; i++) {
            this._actions[i].reset();
        }
        this._completedActions = [];
    };
    ActionQueue.prototype.update = function (delta) {
        if (this._actions.length > 0) {
            this._currentAction = this._actions[0];
            this._currentAction.update(delta);
            if (this._currentAction.isComplete(this._actor)) {
                this._completedActions.push(this._actions.shift());
            }
        }
    };
    return ActionQueue;
}());



/***/ }),

/***/ "./Actions/ActionContext.ts":
/*!**********************************!*\
  !*** ./Actions/ActionContext.ts ***!
  \**********************************/
/*! exports provided: ActionContext */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActionContext", function() { return ActionContext; });
/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Action */ "./Actions/Action.ts");
/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Promises */ "./Promises.ts");
/* harmony import */ var _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util/EasingFunctions */ "./Util/EasingFunctions.ts");



/**
 * The fluent Action API allows you to perform "actions" on
 * [[Actor|Actors]] such as following, moving, rotating, and
 * more. You can implement your own actions by implementing
 * the [[IAction]] interface.
 *
 * [[include:Actions.md]]
 */
var ActionContext = /** @class */ (function () {
    function ActionContext() {
        this._actors = [];
        this._queues = [];
        if (arguments !== null) {
            this._actors = Array.prototype.slice.call(arguments, 0);
            this._queues = this._actors.map(function (a) {
                return a.actionQueue;
            });
        }
    }
    /**
     * Clears all queued actions from the Actor
     */
    ActionContext.prototype.clearActions = function () {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].clearActions();
        }
    };
    ActionContext.prototype.addActorToContext = function (actor) {
        this._actors.push(actor);
        // if we run into problems replace the line below with:
        this._queues.push(actor.actionQueue);
    };
    ActionContext.prototype.removeActorFromContext = function (actor) {
        var index = this._actors.indexOf(actor);
        if (index > -1) {
            this._actors.splice(index, 1);
            this._queues.splice(index, 1);
        }
    };
    /**
     * This method will move an actor to the specified `x` and `y` position over the
     * specified duration using a given [[EasingFunctions]] and return back the actor. This
     * method is part of the actor 'Action' fluent API allowing action chaining.
     * @param x         The x location to move the actor to
     * @param y         The y location to move the actor to
     * @param duration  The time it should take the actor to move to the new location in milliseconds
     * @param easingFcn Use [[EasingFunctions]] or a custom function to use to calculate position
     */
    ActionContext.prototype.easeTo = function (x, y, duration, easingFcn) {
        if (easingFcn === void 0) { easingFcn = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_2__["EasingFunctions"].Linear; }
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["EaseTo"](this._actors[i], x, y, duration, easingFcn));
        }
        return this;
    };
    /**
     * This method will move an actor to the specified x and y position at the
     * speed specified (in pixels per second) and return back the actor. This
     * method is part of the actor 'Action' fluent API allowing action chaining.
     * @param x      The x location to move the actor to
     * @param y      The y location to move the actor to
     * @param speed  The speed in pixels per second to move
     */
    ActionContext.prototype.moveTo = function (x, y, speed) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["MoveTo"](this._actors[i], x, y, speed));
        }
        return this;
    };
    /**
     * This method will move an actor to the specified x and y position by a
     * certain time (in milliseconds). This method is part of the actor
     * 'Action' fluent API allowing action chaining.
     * @param x     The x location to move the actor to
     * @param y     The y location to move the actor to
     * @param time  The time it should take the actor to move to the new location in milliseconds
     */
    ActionContext.prototype.moveBy = function (x, y, time) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["MoveBy"](this._actors[i], x, y, time));
        }
        return this;
    };
    /**
     * This method will rotate an actor to the specified angle at the speed
     * specified (in radians per second) and return back the actor. This
     * method is part of the actor 'Action' fluent API allowing action chaining.
     * @param angleRadians  The angle to rotate to in radians
     * @param speed         The angular velocity of the rotation specified in radians per second
     * @param rotationType  The [[RotationType]] to use for this rotation
     */
    ActionContext.prototype.rotateTo = function (angleRadians, speed, rotationType) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["RotateTo"](this._actors[i], angleRadians, speed, rotationType));
        }
        return this;
    };
    /**
     * This method will rotate an actor to the specified angle by a certain
     * time (in milliseconds) and return back the actor. This method is part
     * of the actor 'Action' fluent API allowing action chaining.
     * @param angleRadians  The angle to rotate to in radians
     * @param time          The time it should take the actor to complete the rotation in milliseconds
     * @param rotationType  The [[RotationType]] to use for this rotation
     */
    ActionContext.prototype.rotateBy = function (angleRadians, time, rotationType) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["RotateBy"](this._actors[i], angleRadians, time, rotationType));
        }
        return this;
    };
    /**
     * This method will scale an actor to the specified size at the speed
     * specified (in magnitude increase per second) and return back the
     * actor. This method is part of the actor 'Action' fluent API allowing
     * action chaining.
     * @param sizeX   The scaling factor to apply on X axis
     * @param sizeY   The scaling factor to apply on Y axis
     * @param speedX  The speed of scaling specified in magnitude increase per second on X axis
     * @param speedY  The speed of scaling specified in magnitude increase per second on Y axis
     */
    ActionContext.prototype.scaleTo = function (sizeX, sizeY, speedX, speedY) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["ScaleTo"](this._actors[i], sizeX, sizeY, speedX, speedY));
        }
        return this;
    };
    /**
     * This method will scale an actor to the specified size by a certain time
     * (in milliseconds) and return back the actor. This method is part of the
     * actor 'Action' fluent API allowing action chaining.
     * @param sizeX   The scaling factor to apply on X axis
     * @param sizeY   The scaling factor to apply on Y axis
     * @param time    The time it should take to complete the scaling in milliseconds
     */
    ActionContext.prototype.scaleBy = function (sizeX, sizeY, time) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["ScaleBy"](this._actors[i], sizeX, sizeY, time));
        }
        return this;
    };
    /**
     * This method will cause an actor to blink (become visible and not
     * visible). Optionally, you may specify the number of blinks. Specify the amount of time
     * the actor should be visible per blink, and the amount of time not visible.
     * This method is part of the actor 'Action' fluent API allowing action chaining.
     * @param timeVisible     The amount of time to stay visible per blink in milliseconds
     * @param timeNotVisible  The amount of time to stay not visible per blink in milliseconds
     * @param numBlinks       The number of times to blink
     */
    ActionContext.prototype.blink = function (timeVisible, timeNotVisible, numBlinks) {
        if (numBlinks === void 0) { numBlinks = 1; }
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["Blink"](this._actors[i], timeVisible, timeNotVisible, numBlinks));
        }
        return this;
    };
    /**
     * This method will cause an actor's opacity to change from its current value
     * to the provided value by a specified time (in milliseconds). This method is
     * part of the actor 'Action' fluent API allowing action chaining.
     * @param opacity  The ending opacity
     * @param time     The time it should take to fade the actor (in milliseconds)
     */
    ActionContext.prototype.fade = function (opacity, time) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["Fade"](this._actors[i], opacity, time));
        }
        return this;
    };
    /**
     * This method will delay the next action from executing for a certain
     * amount of time (in milliseconds). This method is part of the actor
     * 'Action' fluent API allowing action chaining.
     * @param time  The amount of time to delay the next action in the queue from executing in milliseconds
     */
    ActionContext.prototype.delay = function (time) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["Delay"](this._actors[i], time));
        }
        return this;
    };
    /**
     * This method will add an action to the queue that will remove the actor from the
     * scene once it has completed its previous actions. Any actions on the
     * action queue after this action will not be executed.
     */
    ActionContext.prototype.die = function () {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["Die"](this._actors[i]));
        }
        return this;
    };
    /**
     * This method allows you to call an arbitrary method as the next action in the
     * action queue. This is useful if you want to execute code in after a specific
     * action, i.e An actor arrives at a destination after traversing a path
     */
    ActionContext.prototype.callMethod = function (method) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["CallMethod"](this._actors[i], method));
        }
        return this;
    };
    /**
     * This method will cause the actor to repeat all of the previously
     * called actions a certain number of times. If the number of repeats
     * is not specified it will repeat forever. This method is part of
     * the actor 'Action' fluent API allowing action chaining
     * @param times  The number of times to repeat all the previous actions in the action queue. If nothing is specified the actions
     * will repeat forever
     */
    ActionContext.prototype.repeat = function (times) {
        if (!times) {
            this.repeatForever();
            return this;
        }
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["Repeat"](this._actors[i], times, this._actors[i].actionQueue.getActions()));
        }
        return this;
    };
    /**
     * This method will cause the actor to repeat all of the previously
     * called actions forever. This method is part of the actor 'Action'
     * fluent API allowing action chaining.
     */
    ActionContext.prototype.repeatForever = function () {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["RepeatForever"](this._actors[i], this._actors[i].actionQueue.getActions()));
        }
        return this;
    };
    /**
     * This method will cause the actor to follow another at a specified distance
     * @param actor           The actor to follow
     * @param followDistance  The distance to maintain when following, if not specified the actor will follow at the current distance.
     */
    ActionContext.prototype.follow = function (actor, followDistance) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            if (followDistance === undefined) {
                this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["Follow"](this._actors[i], actor));
            }
            else {
                this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["Follow"](this._actors[i], actor, followDistance));
            }
        }
        return this;
    };
    /**
     * This method will cause the actor to move towards another until they
     * collide "meet" at a specified speed.
     * @param actor  The actor to meet
     * @param speed  The speed in pixels per second to move, if not specified it will match the speed of the other actor
     */
    ActionContext.prototype.meet = function (actor, speed) {
        var i = 0, len = this._queues.length;
        for (i; i < len; i++) {
            if (speed === undefined) {
                this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["Meet"](this._actors[i], actor));
            }
            else {
                this._queues[i].add(new _Action__WEBPACK_IMPORTED_MODULE_0__["Meet"](this._actors[i], actor, speed));
            }
        }
        return this;
    };
    /**
     * Returns a promise that resolves when the current action queue up to now
     * is finished.
     */
    ActionContext.prototype.asPromise = function () {
        var _this = this;
        var promises = this._queues.map(function (q, i) {
            var temp = new _Promises__WEBPACK_IMPORTED_MODULE_1__["Promise"]();
            q.add(new _Action__WEBPACK_IMPORTED_MODULE_0__["CallMethod"](_this._actors[i], function () {
                temp.resolve();
            }));
            return temp;
        });
        return _Promises__WEBPACK_IMPORTED_MODULE_1__["Promise"].join.apply(this, promises);
    };
    return ActionContext;
}());



/***/ }),

/***/ "./Actions/Index.ts":
/*!**************************!*\
  !*** ./Actions/Index.ts ***!
  \**************************/
/*! exports provided: Actions, Internal, ActionContext, RotationType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Internal", function() { return Internal; });
/* harmony import */ var _ActionContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ActionContext */ "./Actions/ActionContext.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionContext", function() { return _ActionContext__WEBPACK_IMPORTED_MODULE_0__["ActionContext"]; });

/* harmony import */ var _RotationType__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./RotationType */ "./Actions/RotationType.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RotationType", function() { return _RotationType__WEBPACK_IMPORTED_MODULE_1__["RotationType"]; });

/* harmony import */ var _Action__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Action */ "./Actions/Action.ts");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "Actions", function() { return _Action__WEBPACK_IMPORTED_MODULE_2__; });




// legacy Internal.Actions namespace support
var Internal = { Actions: _Action__WEBPACK_IMPORTED_MODULE_2__ };


/***/ }),

/***/ "./Actions/RotationType.ts":
/*!*********************************!*\
  !*** ./Actions/RotationType.ts ***!
  \*********************************/
/*! exports provided: RotationType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RotationType", function() { return RotationType; });
/**
 * An enum that describes the strategies that rotation actions can use
 */
var RotationType;
(function (RotationType) {
    /**
     * Rotation via `ShortestPath` will use the smallest angle
     * between the starting and ending points. This strategy is the default behavior.
     */
    RotationType[RotationType["ShortestPath"] = 0] = "ShortestPath";
    /**
     * Rotation via `LongestPath` will use the largest angle
     * between the starting and ending points.
     */
    RotationType[RotationType["LongestPath"] = 1] = "LongestPath";
    /**
     * Rotation via `Clockwise` will travel in a clockwise direction,
     * regardless of the starting and ending points.
     */
    RotationType[RotationType["Clockwise"] = 2] = "Clockwise";
    /**
     * Rotation via `CounterClockwise` will travel in a counterclockwise direction,
     * regardless of the starting and ending points.
     */
    RotationType[RotationType["CounterClockwise"] = 3] = "CounterClockwise";
})(RotationType || (RotationType = {}));


/***/ }),

/***/ "./Actor.ts":
/*!******************!*\
  !*** ./Actor.ts ***!
  \******************/
/*! exports provided: ActorImpl, Actor, CollisionType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActorImpl", function() { return ActorImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Actor", function() { return Actor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CollisionType", function() { return CollisionType; });
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Physics */ "./Physics.ts");
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Class */ "./Class.ts");
/* harmony import */ var _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Collision/BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Resources_Texture__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Resources/Texture */ "./Resources/Texture.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Drawing_Sprite__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Drawing/Sprite */ "./Drawing/Sprite.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Actions_ActionContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Actions/ActionContext */ "./Actions/ActionContext.ts");
/* harmony import */ var _Actions_Action__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Actions/Action */ "./Actions/Action.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");
/* harmony import */ var _Collision_Body__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Collision/Body */ "./Collision/Body.ts");
/* harmony import */ var _Collision_Side__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Collision/Side */ "./Collision/Side.ts");
/* harmony import */ var _Configurable__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Configurable */ "./Configurable.ts");
/* harmony import */ var _Traits_Index__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Traits/Index */ "./Traits/Index.ts");
/* harmony import */ var _Drawing_SpriteEffects__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Drawing/SpriteEffects */ "./Drawing/SpriteEffects.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Util/Util */ "./Util/Util.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

















/**
 * @hidden
 */
var ActorImpl = /** @class */ (function (_super) {
    __extends(ActorImpl, _super);
    // #endregion
    /**
     * @param x       The starting x coordinate of the actor
     * @param y       The starting y coordinate of the actor
     * @param width   The starting width of the actor
     * @param height  The starting height of the actor
     * @param color   The starting color of the actor. Leave null to draw a transparent actor. The opacity of the color will be used as the
     * initial [[opacity]].
     */
    function ActorImpl(xOrConfig, y, width, height, color) {
        var _this = _super.call(this) || this;
        /**
         * The unique identifier for the actor
         */
        _this.id = ActorImpl.maxId++;
        /**
         * The physics body the is associated with this actor. The body is the container for all physical properties, like position, velocity,
         * acceleration, mass, inertia, etc.
         */
        _this.body = new _Collision_Body__WEBPACK_IMPORTED_MODULE_11__["Body"](_this);
        /**
         * Gets/sets the acceleration of the actor from the last frame. This does not include the global acc [[Physics.acc]].
         */
        _this.oldAcc = _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"].Zero.clone();
        _this._height = 0;
        _this._width = 0;
        /**
         * The scale vector of the actor
         */
        _this.scale = _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"].One.clone();
        /**
         * The scale of the actor last frame
         */
        _this.oldScale = _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"].One.clone();
        /**
         * The x scalar velocity of the actor in scale/second
         */
        _this.sx = 0; //scale/sec
        /**
         * The y scalar velocity of the actor in scale/second
         */
        _this.sy = 0; //scale/sec
        /**
         * Indicates whether the actor is physically in the viewport
         */
        _this.isOffScreen = false;
        /**
         * The visibility of an actor
         */
        _this.visible = true;
        /**
         * The opacity of an actor. Passing in a color in the [[constructor]] will use the
         * color's opacity.
         */
        _this.opacity = 1;
        _this.previousOpacity = 1;
        /**
         * Convenience reference to the global logger
         */
        _this.logger = _Util_Log__WEBPACK_IMPORTED_MODULE_7__["Logger"].getInstance();
        /**
         * The scene that the actor is in
         */
        _this.scene = null;
        /**
         * The parent of this actor
         */
        _this.parent = null;
        // TODO: Replace this with the new actor collection once z-indexing is built
        /**
         * The children of this actor
         */
        _this.children = [];
        /**
         * Gets or sets the current collision type of this actor. By
         * default it is ([[CollisionType.PreventCollision]]).
         */
        _this.collisionType = CollisionType.PreventCollision;
        _this.collisionGroups = [];
        /**
         * Flag to be set when any property change would result in a geometry recalculation
         * @internal
         */
        _this._geometryDirty = false;
        _this._collisionHandlers = {};
        _this._isInitialized = false;
        _this.frames = {};
        _this._effectsDirty = false;
        /**
         * Access to the current drawing for the actor, this can be
         * an [[Animation]], [[Sprite]], or [[Polygon]].
         * Set drawings with [[setDrawing]].
         */
        _this.currentDrawing = null;
        /**
         * Modify the current actor update pipeline.
         */
        _this.traits = [];
        /**
         * Whether or not to enable the [[CapturePointer]] trait that propagates
         * pointer events to this actor
         */
        _this.enableCapturePointer = false;
        /**
         * Configuration for [[CapturePointer]] trait
         */
        _this.capturePointer = {
            captureMoveEvents: false,
            captureDragEvents: false
        };
        _this._zIndex = 0;
        _this._isKilled = false;
        _this._opacityFx = new _Drawing_SpriteEffects__WEBPACK_IMPORTED_MODULE_15__["Opacity"](_this.opacity);
        // #region Events
        _this._capturePointerEvents = [
            'pointerup',
            'pointerdown',
            'pointermove',
            'pointerenter',
            'pointerleave',
            'pointerdragstart',
            'pointerdragend',
            'pointerdragmove',
            'pointerdragenter',
            'pointerdragleave'
        ];
        _this._captureMoveEvents = [
            'pointermove',
            'pointerenter',
            'pointerleave',
            'pointerdragmove',
            'pointerdragenter',
            'pointerdragleave'
        ];
        _this._captureDragEvents = [
            'pointerdragstart',
            'pointerdragend',
            'pointerdragmove',
            'pointerdragenter',
            'pointerdragleave'
        ];
        if (xOrConfig && typeof xOrConfig === 'object') {
            var config = xOrConfig;
            xOrConfig = config.pos ? config.pos.x : config.x;
            y = config.pos ? config.pos.y : config.y;
            width = config.width;
            height = config.height;
        }
        _this.pos.x = xOrConfig || 0;
        _this.pos.y = y || 0;
        _this._width = width || 0;
        _this._height = height || 0;
        if (color) {
            _this.color = color;
            // set default opacity of an actor to the color
            _this.opacity = color.a;
        }
        // Build default pipeline
        //this.traits.push(new ex.Traits.EulerMovement());
        // TODO: TileMaps should be converted to a collision area
        _this.traits.push(new _Traits_Index__WEBPACK_IMPORTED_MODULE_14__["TileMapCollisionDetection"]());
        _this.traits.push(new _Traits_Index__WEBPACK_IMPORTED_MODULE_14__["OffscreenCulling"]());
        _this.traits.push(new _Traits_Index__WEBPACK_IMPORTED_MODULE_14__["CapturePointer"]());
        // Build the action queue
        _this.actionQueue = new _Actions_Action__WEBPACK_IMPORTED_MODULE_9__["ActionQueue"](_this);
        _this.actions = new _Actions_ActionContext__WEBPACK_IMPORTED_MODULE_8__["ActionContext"](_this);
        // initialize default options
        _this._initDefaults();
        // Initialize default collision area to be box
        _this.body.useBoxCollision();
        return _this;
    }
    Object.defineProperty(ActorImpl.prototype, "collisionArea", {
        /**
         * Gets the collision area shape to use for collision possible options are [CircleArea|circles], [PolygonArea|polygons], and
         * [EdgeArea|edges].
         */
        get: function () {
            return this.body.collisionArea;
        },
        /**
         * Gets the collision area shape to use for collision possible options are [CircleArea|circles], [PolygonArea|polygons], and
         * [EdgeArea|edges].
         */
        set: function (area) {
            this.body.collisionArea = area;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "x", {
        /**
         * Gets the x position of the actor relative to it's parent (if any)
         */
        get: function () {
            return this.body.pos.x;
        },
        /**
         * Sets the x position of the actor relative to it's parent (if any)
         */
        set: function (theX) {
            this.body.pos.x = theX;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "y", {
        /**
         * Gets the y position of the actor relative to it's parent (if any)
         */
        get: function () {
            return this.body.pos.y;
        },
        /**
         * Sets the y position of the actor relative to it's parent (if any)
         */
        set: function (theY) {
            this.body.pos.y = theY;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "pos", {
        /**
         * Gets the position vector of the actor in pixels
         */
        get: function () {
            return this.body.pos;
        },
        /**
         * Sets the position vector of the actor in pixels
         */
        set: function (thePos) {
            this.body.pos.setTo(thePos.x, thePos.y);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "oldPos", {
        /**
         * Gets the position vector of the actor from the last frame
         */
        get: function () {
            return this.body.oldPos;
        },
        /**
         * Sets the position vector of the actor in the last frame
         */
        set: function (thePos) {
            this.body.oldPos.setTo(thePos.x, thePos.y);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "vel", {
        /**
         * Gets the velocity vector of the actor in pixels/sec
         */
        get: function () {
            return this.body.vel;
        },
        /**
         * Sets the velocity vector of the actor in pixels/sec
         */
        set: function (theVel) {
            this.body.vel.setTo(theVel.x, theVel.y);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "oldVel", {
        /**
         * Gets the velocity vector of the actor from the last frame
         */
        get: function () {
            return this.body.oldVel;
        },
        /**
         * Sets the velocity vector of the actor from the last frame
         */
        set: function (theVel) {
            this.body.oldVel.setTo(theVel.x, theVel.y);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "acc", {
        /**
         * Gets the acceleration vector of the actor in pixels/second/second. An acceleration pointing down such as (0, 100) may be
         * useful to simulate a gravitational effect.
         */
        get: function () {
            return this.body.acc;
        },
        /**
         * Sets the acceleration vector of teh actor in pixels/second/second
         */
        set: function (theAcc) {
            this.body.acc.setTo(theAcc.x, theAcc.y);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "rotation", {
        /**
         * Gets the rotation of the actor in radians. 1 radian = 180/PI Degrees.
         */
        get: function () {
            return this.body.rotation;
        },
        /**
         * Sets the rotation of the actor in radians. 1 radian = 180/PI Degrees.
         */
        set: function (theAngle) {
            this.body.rotation = theAngle;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "rx", {
        /**
         * Gets the rotational velocity of the actor in radians/second
         */
        get: function () {
            return this.body.rx;
        },
        /**
         * Sets the rotational velocity of the actor in radians/sec
         */
        set: function (angularVelocity) {
            this.body.rx = angularVelocity;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "torque", {
        /**
         * Gets the current torque applied to the actor. Torque can be thought of as rotational force
         */
        get: function () {
            return this.body.torque;
        },
        /**
         * Sets the current torque applied to the actor. Torque can be thought of as rotational force
         */
        set: function (theTorque) {
            this.body.torque = theTorque;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "mass", {
        /**
         * Get the current mass of the actor, mass can be thought of as the resistance to acceleration.
         */
        get: function () {
            return this.body.mass;
        },
        /**
         * Sets the mass of the actor, mass can be thought of as the resistance to acceleration.
         */
        set: function (theMass) {
            this.body.mass = theMass;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "moi", {
        /**
         * Gets the current moment of inertia, moi can be thought of as the resistance to rotation.
         */
        get: function () {
            return this.body.moi;
        },
        /**
         * Sets the current moment of inertia, moi can be thought of as the resistance to rotation.
         */
        set: function (theMoi) {
            this.body.moi = theMoi;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "friction", {
        /**
         * Gets the coefficient of friction on this actor, this can be thought of as how sticky or slippery an object is.
         */
        get: function () {
            return this.body.friction;
        },
        /**
         * Sets the coefficient of friction of this actor, this can ve thought of as how stick or slippery an object is.
         */
        set: function (theFriction) {
            this.body.friction = theFriction;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "restitution", {
        /**
         * Gets the coefficient of restitution of this actor, represents the amount of energy preserved after collision. Think of this
         * as bounciness.
         */
        get: function () {
            return this.body.restitution;
        },
        /**
         * Sets the coefficient of restitution of this actor, represents the amount of energy preserved after collision. Think of this
         * as bounciness.
         */
        set: function (theRestitution) {
            this.body.restitution = theRestitution;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(ActorImpl.prototype, "color", {
        /**
         * Sets the color of the actor. A rectangle of this color will be
         * drawn if no [[IDrawable]] is specified as the actors drawing.
         *
         * The default is `null` which prevents a rectangle from being drawn.
         */
        get: function () {
            return this._color;
        },
        set: function (v) {
            this._color = v.clone();
        },
        enumerable: true,
        configurable: true
    });
    /**
     * `onInitialize` is called before the first update of the actor. This method is meant to be
     * overridden. This is where initialization of child actors should take place.
     *
     * Synonymous with the event handler `.on('initialize', (evt) => {...})`
     */
    ActorImpl.prototype.onInitialize = function (_engine) {
        // Override me
    };
    Object.defineProperty(ActorImpl.prototype, "isInitialized", {
        /**
         * Gets whether the actor is Initialized
         */
        get: function () {
            return this._isInitialized;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Initializes this actor and all it's child actors, meant to be called by the Scene before first update not by users of Excalibur.
     *
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * @internal
     */
    ActorImpl.prototype._initialize = function (engine) {
        if (!this.isInitialized) {
            this.onInitialize(engine);
            _super.prototype.emit.call(this, 'initialize', new _Events__WEBPACK_IMPORTED_MODULE_4__["InitializeEvent"](engine, this));
            this._isInitialized = true;
        }
        for (var _i = 0, _a = this.children; _i < _a.length; _i++) {
            var child = _a[_i];
            child._initialize(engine);
        }
    };
    ActorImpl.prototype._initDefaults = function () {
        this.anchor = Actor.defaults.anchor.clone();
    };
    ActorImpl.prototype._checkForPointerOptIn = function (eventName) {
        if (eventName) {
            var normalized = eventName.toLowerCase();
            if (this._capturePointerEvents.indexOf(normalized) !== -1) {
                this.enableCapturePointer = true;
                if (this._captureMoveEvents.indexOf(normalized) !== -1) {
                    this.capturePointer.captureMoveEvents = true;
                }
                if (this._captureDragEvents.indexOf(normalized) !== -1) {
                    this.capturePointer.captureDragEvents = true;
                }
            }
        }
    };
    ActorImpl.prototype.on = function (eventName, handler) {
        this._checkForPointerOptIn(eventName);
        _super.prototype.on.call(this, eventName, handler);
    };
    ActorImpl.prototype.once = function (eventName, handler) {
        this._checkForPointerOptIn(eventName);
        _super.prototype.once.call(this, eventName, handler);
    };
    ActorImpl.prototype.off = function (eventName, handler) {
        _super.prototype.off.call(this, eventName, handler);
    };
    // #endregion
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _prekill handler for [[onPreKill]] lifecycle event
     * @internal
     */
    ActorImpl.prototype._prekill = function (_scene) {
        _super.prototype.emit.call(this, 'prekill', new _Events__WEBPACK_IMPORTED_MODULE_4__["PreKillEvent"](this));
        this.onPreKill(_scene);
    };
    /**
     * Safe to override onPreKill lifecycle event handler. Synonymous with `.on('prekill', (evt) =>{...})`
     *
     * `onPreKill` is called directly before an actor is killed and removed from its current [[Scene]].
     */
    ActorImpl.prototype.onPreKill = function (_scene) {
        // Override me
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _prekill handler for [[onPostKill]] lifecycle event
     * @internal
     */
    ActorImpl.prototype._postkill = function (_scene) {
        _super.prototype.emit.call(this, 'postkill', new _Events__WEBPACK_IMPORTED_MODULE_4__["PostKillEvent"](this));
        this.onPostKill(_scene);
    };
    /**
     * Safe to override onPostKill lifecycle event handler. Synonymous with `.on('postkill', (evt) => {...})`
     *
     * `onPostKill` is called directly after an actor is killed and remove from its current [[Scene]].
     */
    ActorImpl.prototype.onPostKill = function (_scene) {
        // Override me
    };
    /**
     * If the current actor is a member of the scene, this will remove
     * it from the scene graph. It will no longer be drawn or updated.
     */
    ActorImpl.prototype.kill = function () {
        if (this.scene) {
            this._prekill(this.scene);
            this.emit('kill', new _Events__WEBPACK_IMPORTED_MODULE_4__["KillEvent"](this));
            this._isKilled = true;
            this.scene.remove(this);
            this._postkill(this.scene);
        }
        else {
            this.logger.warn('Cannot kill actor, it was never added to the Scene');
        }
    };
    /**
     * If the current actor is killed, it will now not be killed.
     */
    ActorImpl.prototype.unkill = function () {
        this._isKilled = false;
    };
    /**
     * Indicates wether the actor has been killed.
     */
    ActorImpl.prototype.isKilled = function () {
        return this._isKilled;
    };
    /**
     * Adds a child actor to this actor. All movement of the child actor will be
     * relative to the parent actor. Meaning if the parent moves the child will
     * move with it.
     * @param actor The child actor to add
     */
    ActorImpl.prototype.add = function (actor) {
        actor.collisionType = CollisionType.PreventCollision;
        if (_Util_Util__WEBPACK_IMPORTED_MODULE_16__["addItemToArray"](actor, this.children)) {
            actor.parent = this;
        }
    };
    /**
     * Removes a child actor from this actor.
     * @param actor The child actor to remove
     */
    ActorImpl.prototype.remove = function (actor) {
        if (_Util_Util__WEBPACK_IMPORTED_MODULE_16__["removeItemFromArray"](actor, this.children)) {
            actor.parent = null;
        }
    };
    ActorImpl.prototype.setDrawing = function (key) {
        key = key.toString();
        if (this.currentDrawing !== this.frames[key]) {
            if (this.frames[key] != null) {
                this.frames[key].reset();
                this.currentDrawing = this.frames[key];
            }
            else {
                _Util_Log__WEBPACK_IMPORTED_MODULE_7__["Logger"].getInstance().error("the specified drawing key " + key + " does not exist");
            }
        }
    };
    ActorImpl.prototype.addDrawing = function () {
        if (arguments.length === 2) {
            this.frames[arguments[0]] = arguments[1];
            if (!this.currentDrawing) {
                this.currentDrawing = arguments[1];
            }
            this._effectsDirty = true;
        }
        else {
            if (arguments[0] instanceof _Drawing_Sprite__WEBPACK_IMPORTED_MODULE_6__["Sprite"]) {
                this.addDrawing('default', arguments[0]);
            }
            if (arguments[0] instanceof _Resources_Texture__WEBPACK_IMPORTED_MODULE_3__["Texture"]) {
                this.addDrawing('default', arguments[0].asSprite());
            }
        }
    };
    Object.defineProperty(ActorImpl.prototype, "z", {
        get: function () {
            return this.getZIndex();
        },
        set: function (newZ) {
            this.setZIndex(newZ);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Gets the z-index of an actor. The z-index determines the relative order an actor is drawn in.
     * Actors with a higher z-index are drawn on top of actors with a lower z-index
     */
    ActorImpl.prototype.getZIndex = function () {
        return this._zIndex;
    };
    /**
     * Sets the z-index of an actor and updates it in the drawing list for the scene.
     * The z-index determines the relative order an actor is drawn in.
     * Actors with a higher z-index are drawn on top of actors with a lower z-index
     * @param newIndex new z-index to assign
     */
    ActorImpl.prototype.setZIndex = function (newIndex) {
        this.scene.cleanupDrawTree(this);
        this._zIndex = newIndex;
        this.scene.updateDrawTree(this);
    };
    /**
     * Adds an actor to a collision group. Actors with no named collision groups are
     * considered to be in every collision group.
     *
     * Once in a collision group(s) actors will only collide with other actors in
     * that group.
     *
     * @param name The name of the collision group
     */
    ActorImpl.prototype.addCollisionGroup = function (name) {
        this.collisionGroups.push(name);
    };
    /**
     * Removes an actor from a collision group.
     * @param name The name of the collision group
     */
    ActorImpl.prototype.removeCollisionGroup = function (name) {
        var index = this.collisionGroups.indexOf(name);
        if (index !== -1) {
            this.collisionGroups.splice(index, 1);
        }
    };
    /**
     * Get the center point of an actor
     */
    ActorImpl.prototype.getCenter = function () {
        return new _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"](this.pos.x + this.getWidth() / 2 - this.anchor.x * this.getWidth(), this.pos.y + this.getHeight() / 2 - this.anchor.y * this.getHeight());
    };
    /**
     * Gets the calculated width of an actor, factoring in scale
     */
    ActorImpl.prototype.getWidth = function () {
        return this._width * this.getGlobalScale().x;
    };
    /**
     * Sets the width of an actor, factoring in the current scale
     */
    ActorImpl.prototype.setWidth = function (width) {
        this._width = width / this.scale.x;
        this._geometryDirty = true;
    };
    /**
     * Gets the calculated height of an actor, factoring in scale
     */
    ActorImpl.prototype.getHeight = function () {
        return this._height * this.getGlobalScale().y;
    };
    /**
     * Sets the height of an actor, factoring in the current scale
     */
    ActorImpl.prototype.setHeight = function (height) {
        this._height = height / this.scale.y;
        this._geometryDirty = true;
    };
    /**
     * Gets the left edge of the actor
     */
    ActorImpl.prototype.getLeft = function () {
        return this.getBounds().left;
    };
    /**
     * Gets the right edge of the actor
     */
    ActorImpl.prototype.getRight = function () {
        return this.getBounds().right;
    };
    /**
     * Gets the top edge of the actor
     */
    ActorImpl.prototype.getTop = function () {
        return this.getBounds().top;
    };
    /**
     * Gets the bottom edge of the actor
     */
    ActorImpl.prototype.getBottom = function () {
        return this.getBounds().bottom;
    };
    /**
     * Gets this actor's rotation taking into account any parent relationships
     *
     * @returns Rotation angle in radians
     */
    ActorImpl.prototype.getWorldRotation = function () {
        if (!this.parent) {
            return this.rotation;
        }
        return this.rotation + this.parent.getWorldRotation();
    };
    /**
     * Gets an actor's world position taking into account parent relationships, scaling, rotation, and translation
     *
     * @returns Position in world coordinates
     */
    ActorImpl.prototype.getWorldPos = function () {
        if (!this.parent) {
            return this.pos.clone();
        }
        // collect parents
        var parents = [];
        var root = this;
        parents.push(this);
        // find parents
        while (root.parent) {
            root = root.parent;
            parents.push(root);
        }
        // calculate position
        var x = parents.reduceRight(function (px, p) {
            if (p.parent) {
                return px + p.pos.x * p.getGlobalScale().x;
            }
            return px + p.pos.x;
        }, 0);
        var y = parents.reduceRight(function (py, p) {
            if (p.parent) {
                return py + p.pos.y * p.getGlobalScale().y;
            }
            return py + p.pos.y;
        }, 0);
        // rotate around root anchor
        var ra = root.getWorldPos(); // 10, 10
        var r = this.getWorldRotation();
        return new _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"](x, y).rotate(r, ra);
    };
    /**
     * Gets the global scale of the Actor
     */
    ActorImpl.prototype.getGlobalScale = function () {
        if (!this.parent) {
            return new _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"](this.scale.x, this.scale.y);
        }
        var parentScale = this.parent.getGlobalScale();
        return new _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"](this.scale.x * parentScale.x, this.scale.y * parentScale.y);
    };
    // #region Collision
    /**
     * Returns the actor's [[BoundingBox]] calculated for this instant in world space.
     */
    ActorImpl.prototype.getBounds = function (rotated) {
        if (rotated === void 0) { rotated = true; }
        // todo cache bounding box
        var anchor = this._getCalculatedAnchor();
        var pos = this.getWorldPos();
        var bb = new _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_2__["BoundingBox"](pos.x - anchor.x, pos.y - anchor.y, pos.x + this.getWidth() - anchor.x, pos.y + this.getHeight() - anchor.y);
        return rotated ? bb.rotate(this.rotation, pos) : bb;
    };
    /**
     * Returns the actor's [[BoundingBox]] relative to the actor's position.
     */
    ActorImpl.prototype.getRelativeBounds = function (rotated) {
        if (rotated === void 0) { rotated = true; }
        // todo cache bounding box
        var anchor = this._getCalculatedAnchor();
        var bb = new _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_2__["BoundingBox"](-anchor.x, -anchor.y, this.getWidth() - anchor.x, this.getHeight() - anchor.y);
        return rotated ? bb.rotate(this.rotation) : bb;
    };
    /**
     * Returns the actors unrotated geometry in world coordinates
     */
    ActorImpl.prototype.getGeometry = function () {
        return this.getBounds(false).getPoints();
    };
    /**
     * Return the actor's unrotated geometry relative to the actor's position
     */
    ActorImpl.prototype.getRelativeGeometry = function () {
        return this.getRelativeBounds(false).getPoints();
    };
    Object.defineProperty(ActorImpl.prototype, "isGeometryDirty", {
        /**
         * Indicates that the actor's collision geometry needs to be recalculated for accurate collisions
         */
        get: function () {
            return this._geometryDirty;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Tests whether the x/y specified are contained in the actor
     * @param x  X coordinate to test (in world coordinates)
     * @param y  Y coordinate to test (in world coordinates)
     * @param recurse checks whether the x/y are contained in any child actors (if they exist).
     */
    ActorImpl.prototype.contains = function (x, y, recurse) {
        if (recurse === void 0) { recurse = false; }
        var containment = this.getBounds().contains(new _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"](x, y));
        if (recurse) {
            return (containment ||
                this.children.some(function (child) {
                    return child.contains(x, y, true);
                }));
        }
        return containment;
    };
    /**
     * Returns the side of the collision based on the intersection
     * @param intersect The displacement vector returned by a collision
     */
    ActorImpl.prototype.getSideFromIntersect = function (intersect) {
        if (intersect) {
            if (Math.abs(intersect.x) > Math.abs(intersect.y)) {
                if (intersect.x < 0) {
                    return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].Right;
                }
                return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].Left;
            }
            else {
                if (intersect.y < 0) {
                    return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].Bottom;
                }
                return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].Top;
            }
        }
        return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].None;
    };
    /**
     * Test whether the actor has collided with another actor, returns the side of the current actor that collided.
     * @param actor The other actor to test
     */
    ActorImpl.prototype.collidesWithSide = function (actor) {
        var separationVector = this.collides(actor);
        if (!separationVector) {
            return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].None;
        }
        if (Math.abs(separationVector.x) > Math.abs(separationVector.y)) {
            if (this.pos.x < actor.pos.x) {
                return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].Right;
            }
            else {
                return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].Left;
            }
        }
        else {
            if (this.pos.y < actor.pos.y) {
                return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].Bottom;
            }
            else {
                return _Collision_Side__WEBPACK_IMPORTED_MODULE_12__["Side"].Top;
            }
        }
    };
    /**
     * Test whether the actor has collided with another actor, returns the intersection vector on collision. Returns
     * `null` when there is no collision;
     * @param actor The other actor to test
     */
    ActorImpl.prototype.collides = function (actor) {
        var bounds = this.getBounds();
        var otherBounds = actor.getBounds();
        var intersect = bounds.collides(otherBounds);
        return intersect;
    };
    /**
     * Register a handler to fire when this actor collides with another in a specified group
     * @param group The group name to listen for
     * @param func The callback to fire on collision with another actor from the group. The callback is passed the other actor.
     */
    ActorImpl.prototype.onCollidesWith = function (group, func) {
        if (!this._collisionHandlers[group]) {
            this._collisionHandlers[group] = [];
        }
        this._collisionHandlers[group].push(func);
    };
    ActorImpl.prototype.getCollisionHandlers = function () {
        return this._collisionHandlers;
    };
    /**
     * Removes all collision handlers for this group on this actor
     * @param group Group to remove all handlers for on this actor.
     */
    ActorImpl.prototype.removeCollidesWith = function (group) {
        this._collisionHandlers[group] = [];
    };
    /**
     * Returns true if the two actors are less than or equal to the distance specified from each other
     * @param actor     Actor to test
     * @param distance  Distance in pixels to test
     */
    ActorImpl.prototype.within = function (actor, distance) {
        return Math.sqrt(Math.pow(this.pos.x - actor.pos.x, 2) + Math.pow(this.pos.y - actor.pos.y, 2)) <= distance;
    };
    // #endregion
    ActorImpl.prototype._getCalculatedAnchor = function () {
        return new _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"](this.getWidth() * this.anchor.x, this.getHeight() * this.anchor.y);
    };
    ActorImpl.prototype._reapplyEffects = function (drawing) {
        drawing.removeEffect(this._opacityFx);
        drawing.addEffect(this._opacityFx);
    };
    // #region Update
    /**
     * Perform euler integration at the specified time step
     */
    ActorImpl.prototype.integrate = function (delta) {
        // Update placements based on linear algebra
        var seconds = delta / 1000;
        var totalAcc = this.acc.clone();
        // Only active vanilla actors are affected by global acceleration
        if (this.collisionType === CollisionType.Active) {
            totalAcc.addEqual(_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].acc);
        }
        this.vel.addEqual(totalAcc.scale(seconds));
        this.pos.addEqual(this.vel.scale(seconds)).addEqual(totalAcc.scale(0.5 * seconds * seconds));
        this.rx += this.torque * (1.0 / this.moi) * seconds;
        this.rotation += this.rx * seconds;
        this.scale.x += (this.sx * delta) / 1000;
        this.scale.y += (this.sy * delta) / 1000;
        if (!this.scale.equals(this.oldScale)) {
            // change in scale effects the geometry
            this._geometryDirty = true;
        }
        // Update physics body
        this.body.update();
        this._geometryDirty = false;
    };
    /**
     * Called by the Engine, updates the state of the actor
     * @param engine The reference to the current game engine
     * @param delta  The time elapsed since the last update in milliseconds
     */
    ActorImpl.prototype.update = function (engine, delta) {
        this._initialize(engine);
        this._preupdate(engine, delta);
        // Update action queue
        this.actionQueue.update(delta);
        // Update color only opacity
        if (this.color) {
            this.color.a = this.opacity;
        }
        // calculate changing opacity
        if (this.previousOpacity !== this.opacity) {
            this.previousOpacity = this.opacity;
            this._opacityFx.opacity = this.opacity;
            this._effectsDirty = true;
        }
        // Capture old values before integration step updates them
        this.oldVel.setTo(this.vel.x, this.vel.y);
        this.oldPos.setTo(this.pos.x, this.pos.y);
        this.oldAcc.setTo(this.acc.x, this.acc.y);
        this.oldScale.setTo(this.scale.x, this.scale.y);
        // Run Euler integration
        this.integrate(delta);
        // Update actor pipeline (movement, collision detection, event propagation, offscreen culling)
        for (var _i = 0, _a = this.traits; _i < _a.length; _i++) {
            var trait = _a[_i];
            trait.update(this, engine, delta);
        }
        // Update child actors
        for (var i = 0; i < this.children.length; i++) {
            this.children[i].update(engine, delta);
        }
        this._postupdate(engine, delta);
    };
    /**
     * Safe to override onPreUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPreUpdate` is called directly before an actor is updated.
     */
    ActorImpl.prototype.onPreUpdate = function (_engine, _delta) {
        // Override me
    };
    /**
     * Safe to override onPostUpdate lifecycle event handler. Synonymous with `.on('postupdate', (evt) =>{...})`
     *
     * `onPostUpdate` is called directly after an actor is updated.
     */
    ActorImpl.prototype.onPostUpdate = function (_engine, _delta) {
        // Override me
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _preupdate handler for [[onPreUpdate]] lifecycle event
     * @internal
     */
    ActorImpl.prototype._preupdate = function (engine, delta) {
        this.emit('preupdate', new _Events__WEBPACK_IMPORTED_MODULE_4__["PreUpdateEvent"](engine, delta, this));
        this.onPreUpdate(engine, delta);
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _preupdate handler for [[onPostUpdate]] lifecycle event
     * @internal
     */
    ActorImpl.prototype._postupdate = function (engine, delta) {
        this.emit('postupdate', new _Events__WEBPACK_IMPORTED_MODULE_4__["PreUpdateEvent"](engine, delta, this));
        this.onPostUpdate(engine, delta);
    };
    // endregion
    // #region Drawing
    /**
     * Called by the Engine, draws the actor to the screen
     * @param ctx   The rendering context
     * @param delta The time since the last draw in milliseconds
     */
    ActorImpl.prototype.draw = function (ctx, delta) {
        ctx.save();
        ctx.translate(this.pos.x, this.pos.y);
        ctx.rotate(this.rotation);
        ctx.scale(this.scale.x, this.scale.y);
        // translate canvas by anchor offset
        ctx.save();
        ctx.translate(-(this._width * this.anchor.x), -(this._height * this.anchor.y));
        this._predraw(ctx, delta);
        if (this.currentDrawing) {
            var drawing = this.currentDrawing;
            // See https://github.com/excaliburjs/Excalibur/pull/619 for discussion on this formula
            var offsetX = (this._width - drawing.width * drawing.scale.x) * this.anchor.x;
            var offsetY = (this._height - drawing.height * drawing.scale.y) * this.anchor.y;
            if (this._effectsDirty) {
                this._reapplyEffects(this.currentDrawing);
                this._effectsDirty = false;
            }
            this.currentDrawing.draw(ctx, offsetX, offsetY);
        }
        else {
            if (this.color) {
                ctx.fillStyle = this.color.toString();
                ctx.fillRect(0, 0, this._width, this._height);
            }
        }
        ctx.restore();
        // Draw child actors
        for (var i = 0; i < this.children.length; i++) {
            if (this.children[i].visible) {
                this.children[i].draw(ctx, delta);
            }
        }
        this._postdraw(ctx, delta);
        ctx.restore();
    };
    /**
     * Safe to override onPreDraw lifecycle event handler. Synonymous with `.on('predraw', (evt) =>{...})`
     *
     * `onPreDraw` is called directly before an actor is drawn, but after local transforms are made.
     */
    ActorImpl.prototype.onPreDraw = function (_ctx, _delta) {
        // Override me
    };
    /**
     * Safe to override onPostDraw lifecycle event handler. Synonymous with `.on('postdraw', (evt) =>{...})`
     *
     * `onPostDraw` is called directly after an actor is drawn, and before local transforms are removed.
     */
    ActorImpl.prototype.onPostDraw = function (_ctx, _delta) {
        // Override me
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _predraw handler for [[onPreDraw]] lifecycle event
     * @internal
     */
    ActorImpl.prototype._predraw = function (ctx, delta) {
        this.emit('predraw', new _Events__WEBPACK_IMPORTED_MODULE_4__["PreDrawEvent"](ctx, delta, this));
        this.onPreDraw(ctx, delta);
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _postdraw handler for [[onPostDraw]] lifecycle event
     * @internal
     */
    ActorImpl.prototype._postdraw = function (ctx, delta) {
        this.emit('postdraw', new _Events__WEBPACK_IMPORTED_MODULE_4__["PreDrawEvent"](ctx, delta, this));
        this.onPostDraw(ctx, delta);
    };
    /**
     * Called by the Engine, draws the actors debugging to the screen
     * @param ctx The rendering context
     */
    /* istanbul ignore next */
    ActorImpl.prototype.debugDraw = function (ctx) {
        this.emit('predebugdraw', new _Events__WEBPACK_IMPORTED_MODULE_4__["PreDebugDrawEvent"](ctx, this));
        this.body.debugDraw(ctx);
        // Draw actor bounding box
        var bb = this.getBounds();
        bb.debugDraw(ctx);
        // Draw actor Id
        ctx.fillText('id: ' + this.id, bb.left + 3, bb.top + 10);
        // Draw actor anchor Vector
        ctx.fillStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_5__["Color"].Yellow.toString();
        ctx.beginPath();
        ctx.arc(this.getWorldPos().x, this.getWorldPos().y, 3, 0, Math.PI * 2);
        ctx.closePath();
        ctx.fill();
        // Culling Box debug draw
        for (var j = 0; j < this.traits.length; j++) {
            if (this.traits[j] instanceof _Traits_Index__WEBPACK_IMPORTED_MODULE_14__["OffscreenCulling"]) {
                this.traits[j].cullingBox.debugDraw(ctx);
            }
        }
        // Unit Circle debug draw
        ctx.strokeStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_5__["Color"].Yellow.toString();
        ctx.beginPath();
        var radius = Math.min(this.getWidth(), this.getHeight());
        ctx.arc(this.getWorldPos().x, this.getWorldPos().y, radius, 0, Math.PI * 2);
        ctx.closePath();
        ctx.stroke();
        var ticks = {
            '0 Pi': 0,
            'Pi/2': Math.PI / 2,
            Pi: Math.PI,
            '3/2 Pi': (3 * Math.PI) / 2
        };
        var oldFont = ctx.font;
        for (var tick in ticks) {
            ctx.fillStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_5__["Color"].Yellow.toString();
            ctx.font = '14px';
            ctx.textAlign = 'center';
            ctx.fillText(tick, this.getWorldPos().x + Math.cos(ticks[tick]) * (radius + 10), this.getWorldPos().y + Math.sin(ticks[tick]) * (radius + 10));
        }
        ctx.font = oldFont;
        // Draw child actors
        for (var i = 0; i < this.children.length; i++) {
            this.children[i].debugDraw(ctx);
        }
        this.emit('postdebugdraw', new _Events__WEBPACK_IMPORTED_MODULE_4__["PostDebugDrawEvent"](ctx, this));
    };
    /**
     * Returns the full array of ancestors
     */
    ActorImpl.prototype.getAncestors = function () {
        var path = [this];
        var currentActor = this;
        var parent;
        while ((parent = currentActor.parent)) {
            currentActor = parent;
            path.push(currentActor);
        }
        return path.reverse();
    };
    // #region Properties
    /**
     * Indicates the next id to be set
     */
    ActorImpl.defaults = {
        anchor: _Algebra__WEBPACK_IMPORTED_MODULE_10__["Vector"].Half.clone()
    };
    /**
     * Indicates the next id to be set
     */
    ActorImpl.maxId = 0;
    return ActorImpl;
}(_Class__WEBPACK_IMPORTED_MODULE_1__["Class"]));

/**
 * The most important primitive in Excalibur is an `Actor`. Anything that
 * can move on the screen, collide with another `Actor`, respond to events,
 * or interact with the current scene, must be an actor. An `Actor` **must**
 * be part of a [[Scene]] for it to be drawn to the screen.
 *
 * [[include:Actors.md]]
 *
 *
 * [[include:Constructors.md]]
 *
 */
var Actor = /** @class */ (function (_super) {
    __extends(Actor, _super);
    function Actor(xOrConfig, y, width, height, color) {
        return _super.call(this, xOrConfig, y, width, height, color) || this;
    }
    return Actor;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_13__["Configurable"])(ActorImpl)));

/**
 * An enum that describes the types of collisions actors can participate in
 */
var CollisionType;
(function (CollisionType) {
    /**
     * Actors with the `PreventCollision` setting do not participate in any
     * collisions and do not raise collision events.
     */
    CollisionType[CollisionType["PreventCollision"] = 0] = "PreventCollision";
    /**
     * Actors with the `Passive` setting only raise collision events, but are not
     * influenced or moved by other actors and do not influence or move other actors.
     */
    CollisionType[CollisionType["Passive"] = 1] = "Passive";
    /**
     * Actors with the `Active` setting raise collision events and participate
     * in collisions with other actors and will be push or moved by actors sharing
     * the `Active` or `Fixed` setting.
     */
    CollisionType[CollisionType["Active"] = 2] = "Active";
    /**
     * Actors with the `Fixed` setting raise collision events and participate in
     * collisions with other actors. Actors with the `Fixed` setting will not be
     * pushed or moved by other actors sharing the `Fixed`. Think of Fixed
     * actors as "immovable/onstoppable" objects. If two `Fixed` actors meet they will
     * not be pushed or moved by each other, they will not interact except to throw
     * collision events.
     */
    CollisionType[CollisionType["Fixed"] = 3] = "Fixed";
})(CollisionType || (CollisionType = {}));


/***/ }),

/***/ "./Algebra.ts":
/*!********************!*\
  !*** ./Algebra.ts ***!
  \********************/
/*! exports provided: Vector, Ray, Line, Projection, GlobalCoordinates */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Vector", function() { return Vector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Ray", function() { return Ray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Line", function() { return Line; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Projection", function() { return Projection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GlobalCoordinates", function() { return GlobalCoordinates; });
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Util/Util */ "./Util/Util.ts");

/**
 * A 2D vector on a plane.
 */
var Vector = /** @class */ (function () {
    /**
     * @param x  X component of the Vector
     * @param y  Y component of the Vector
     */
    function Vector(x, y) {
        this.x = x;
        this.y = y;
    }
    /**
     * Returns a vector of unit length in the direction of the specified angle in Radians.
     * @param angle The angle to generate the vector
     */
    Vector.fromAngle = function (angle) {
        return new Vector(Math.cos(angle), Math.sin(angle));
    };
    /**
     * Checks if vector is not null, undefined, or if any of its components are NaN or Infinity.
     */
    Vector.isValid = function (vec) {
        if (vec === null || vec === undefined) {
            return false;
        }
        if (isNaN(vec.x) || isNaN(vec.y)) {
            return false;
        }
        if (vec.x === Infinity || vec.y === Infinity || vec.x === -Infinity || vec.y === -Infinity) {
            return false;
        }
        return true;
    };
    /**
     * Calculates distance between two Vectors
     * @param vec1
     * @param vec2
     */
    Vector.distance = function (vec1, vec2) {
        return Math.sqrt(Math.pow(vec1.x - vec2.x, 2) + Math.pow(vec1.y - vec2.y, 2));
    };
    /**
     * Sets the x and y components at once
     */
    Vector.prototype.setTo = function (x, y) {
        this.x = x;
        this.y = y;
    };
    /**
     * Compares this point against another and tests for equality
     * @param point  The other point to compare to
     */
    Vector.prototype.equals = function (vector, tolerance) {
        if (tolerance === void 0) { tolerance = 0.001; }
        return Math.abs(this.x - vector.x) <= tolerance && Math.abs(this.y - vector.y) <= tolerance;
    };
    /**
     * The distance to another vector. If no other Vector is specified, this will return the [[magnitude]].
     * @param v  The other vector. Leave blank to use origin vector.
     */
    Vector.prototype.distance = function (v) {
        if (!v) {
            v = Vector.Zero;
        }
        return Math.sqrt(Math.pow(this.x - v.x, 2) + Math.pow(this.y - v.y, 2));
    };
    /**
     * The magnitude (size) of the Vector
     */
    Vector.prototype.magnitude = function () {
        return this.distance();
    };
    /**
     * Normalizes a vector to have a magnitude of 1.
     */
    Vector.prototype.normalize = function () {
        var d = this.distance();
        if (d > 0) {
            return new Vector(this.x / d, this.y / d);
        }
        else {
            return new Vector(0, 1);
        }
    };
    /**
     * Returns the average (midpoint) between the current point and the specified
     */
    Vector.prototype.average = function (vec) {
        return this.add(vec).scale(0.5);
    };
    /**
     * Scales a vector's by a factor of size
     * @param size  The factor to scale the magnitude by
     */
    Vector.prototype.scale = function (size) {
        return new Vector(this.x * size, this.y * size);
    };
    /**
     * Adds one vector to another
     * @param v The vector to add
     */
    Vector.prototype.add = function (v) {
        return new Vector(this.x + v.x, this.y + v.y);
    };
    /**
     * Subtracts a vector from another, if you subract vector `B.sub(A)` the resulting vector points from A -> B
     * @param v The vector to subtract
     */
    Vector.prototype.sub = function (v) {
        return new Vector(this.x - v.x, this.y - v.y);
    };
    /**
     * Adds one vector to this one modifying the original
     * @param v The vector to add
     */
    Vector.prototype.addEqual = function (v) {
        this.x += v.x;
        this.y += v.y;
        return this;
    };
    /**
     * Subtracts a vector from this one modifying the original
     * @parallel v The vector to subtract
     */
    Vector.prototype.subEqual = function (v) {
        this.x -= v.x;
        this.y -= v.y;
        return this;
    };
    /**
     * Scales this vector by a factor of size and modifies the original
     */
    Vector.prototype.scaleEqual = function (size) {
        this.x *= size;
        this.y *= size;
        return this;
    };
    /**
     * Performs a dot product with another vector
     * @param v  The vector to dot
     */
    Vector.prototype.dot = function (v) {
        return this.x * v.x + this.y * v.y;
    };
    Vector.prototype.cross = function (v) {
        if (v instanceof Vector) {
            return this.x * v.y - this.y * v.x;
        }
        else if (typeof v === 'number') {
            return new Vector(v * this.y, -v * this.x);
        }
    };
    /**
     * Returns the perpendicular vector to this one
     */
    Vector.prototype.perpendicular = function () {
        return new Vector(this.y, -this.x);
    };
    /**
     * Returns the normal vector to this one, same as the perpendicular of length 1
     */
    Vector.prototype.normal = function () {
        return this.perpendicular().normalize();
    };
    /**
     * Negate the current vector
     */
    Vector.prototype.negate = function () {
        return this.scale(-1);
    };
    /**
     * Returns the angle of this vector.
     */
    Vector.prototype.toAngle = function () {
        return Math.atan2(this.y, this.x);
    };
    /**
     * Rotates the current vector around a point by a certain number of
     * degrees in radians
     */
    Vector.prototype.rotate = function (angle, anchor) {
        if (!anchor) {
            anchor = new Vector(0, 0);
        }
        var sinAngle = Math.sin(angle);
        var cosAngle = Math.cos(angle);
        var x = cosAngle * (this.x - anchor.x) - sinAngle * (this.y - anchor.y) + anchor.x;
        var y = sinAngle * (this.x - anchor.x) + cosAngle * (this.y - anchor.y) + anchor.y;
        return new Vector(x, y);
    };
    /**
     * Creates new vector that has the same values as the previous.
     */
    Vector.prototype.clone = function () {
        return new Vector(this.x, this.y);
    };
    /**
     * Returns a string repesentation of the vector.
     */
    Vector.prototype.toString = function () {
        return "(" + this.x + ", " + this.y + ")";
    };
    /**
     * A (0, 0) vector
     */
    Vector.Zero = new Vector(0, 0);
    /**
     * A (1, 1) vector
     */
    Vector.One = new Vector(1, 1);
    /**
     * A (0.5, 0.5) vector
     */
    Vector.Half = new Vector(0.5, 0.5);
    /**
     * A unit vector pointing up (0, -1)
     */
    Vector.Up = new Vector(0, -1);
    /**
     * A unit vector pointing down (0, 1)
     */
    Vector.Down = new Vector(0, 1);
    /**
     * A unit vector pointing left (-1, 0)
     */
    Vector.Left = new Vector(-1, 0);
    /**
     * A unit vector pointing right (1, 0)
     */
    Vector.Right = new Vector(1, 0);
    return Vector;
}());

/**
 * A 2D ray that can be cast into the scene to do collision detection
 */
var Ray = /** @class */ (function () {
    /**
     * @param pos The starting position for the ray
     * @param dir The vector indicating the direction of the ray
     */
    function Ray(pos, dir) {
        this.pos = pos;
        this.dir = dir.normalize();
    }
    /**
     * Tests a whether this ray intersects with a line segment. Returns a number greater than or equal to 0 on success.
     * This number indicates the mathematical intersection time.
     * @param line  The line to test
     */
    Ray.prototype.intersect = function (line) {
        var numerator = line.begin.sub(this.pos);
        // Test is line and ray are parallel and non intersecting
        if (this.dir.cross(line.getSlope()) === 0 && numerator.cross(this.dir) !== 0) {
            return -1;
        }
        // Lines are parallel
        var divisor = this.dir.cross(line.getSlope());
        if (divisor === 0) {
            return -1;
        }
        var t = numerator.cross(line.getSlope()) / divisor;
        if (t >= 0) {
            var u = numerator.cross(this.dir) / divisor / line.getLength();
            if (u >= 0 && u <= 1) {
                return t;
            }
        }
        return -1;
    };
    /**
     * Returns the point of intersection given the intersection time
     */
    Ray.prototype.getPoint = function (time) {
        return this.pos.add(this.dir.scale(time));
    };
    return Ray;
}());

/**
 * A 2D line segment
 */
var Line = /** @class */ (function () {
    /**
     * @param begin  The starting point of the line segment
     * @param end  The ending point of the line segment
     */
    function Line(begin, end) {
        this.begin = begin;
        this.end = end;
    }
    Object.defineProperty(Line.prototype, "slope", {
        /**
         * Gets the raw slope (m) of the line. Will return (+/-)Infinity for vertical lines.
         */
        get: function () {
            return (this.end.y - this.begin.y) / (this.end.x - this.begin.x);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Line.prototype, "intercept", {
        /**
         * Gets the Y-intercept (b) of the line. Will return (+/-)Infinity if there is no intercept.
         */
        get: function () {
            return this.begin.y - this.slope * this.begin.x;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Gets the normal of the line
     */
    Line.prototype.normal = function () {
        return this.end.sub(this.begin).normal();
    };
    /**
     * Returns the slope of the line in the form of a vector
     */
    Line.prototype.getSlope = function () {
        var begin = this.begin;
        var end = this.end;
        var distance = begin.distance(end);
        return end.sub(begin).scale(1 / distance);
    };
    /**
     * Returns the length of the line segment in pixels
     */
    Line.prototype.getLength = function () {
        var begin = this.begin;
        var end = this.end;
        var distance = begin.distance(end);
        return distance;
    };
    /**
     * Find the perpendicular distance from the line to a point
     * https://en.wikipedia.org/wiki/Distance_from_a_point_to_a_line
     * @param point
     */
    Line.prototype.distanceToPoint = function (point) {
        var x0 = point.x;
        var y0 = point.y;
        var l = this.getLength();
        var dy = this.end.y - this.begin.y;
        var dx = this.end.x - this.begin.x;
        var distance = Math.abs(dy * x0 - dx * y0 + this.end.x * this.begin.y - this.end.y * this.begin.x) / l;
        return distance;
    };
    /**
     * Finds a point on the line given only an X or a Y value. Given an X value, the function returns
     * a new point with the calculated Y value and vice-versa.
     *
     * @param x The known X value of the target point
     * @param y The known Y value of the target point
     * @returns A new point with the other calculated axis value
     */
    Line.prototype.findPoint = function (x, y) {
        if (x === void 0) { x = null; }
        if (y === void 0) { y = null; }
        var m = this.slope;
        var b = this.intercept;
        if (x !== null) {
            return new Vector(x, m * x + b);
        }
        else if (y !== null) {
            return new Vector((y - b) / m, y);
        }
        else {
            throw new Error('You must provide an X or a Y value');
        }
    };
    /**
     * @see http://stackoverflow.com/a/11908158/109458
     */
    Line.prototype.hasPoint = function () {
        var currPoint;
        var threshold = 0;
        if (typeof arguments[0] === 'number' && typeof arguments[1] === 'number') {
            currPoint = new Vector(arguments[0], arguments[1]);
            threshold = arguments[2] || 0;
        }
        else if (arguments[0] instanceof Vector) {
            currPoint = arguments[0];
            threshold = arguments[1] || 0;
        }
        else {
            throw 'Could not determine the arguments for Vector.hasPoint';
        }
        var dxc = currPoint.x - this.begin.x;
        var dyc = currPoint.y - this.begin.y;
        var dx1 = this.end.x - this.begin.x;
        var dy1 = this.end.y - this.begin.y;
        var cross = dxc * dy1 - dyc * dx1;
        // check whether point lines on the line
        if (Math.abs(cross) > threshold) {
            return false;
        }
        // check whether point lies in-between start and end
        if (Math.abs(dx1) >= Math.abs(dy1)) {
            return dx1 > 0 ? this.begin.x <= currPoint.x && currPoint.x <= this.end.x : this.end.x <= currPoint.x && currPoint.x <= this.begin.x;
        }
        else {
            return dy1 > 0 ? this.begin.y <= currPoint.y && currPoint.y <= this.end.y : this.end.y <= currPoint.y && currPoint.y <= this.begin.y;
        }
    };
    return Line;
}());

/**
 * A 1 dimensional projection on an axis, used to test overlaps
 */
var Projection = /** @class */ (function () {
    function Projection(min, max) {
        this.min = min;
        this.max = max;
    }
    Projection.prototype.overlaps = function (projection) {
        return this.max > projection.min && projection.max > this.min;
    };
    Projection.prototype.getOverlap = function (projection) {
        if (this.overlaps(projection)) {
            if (this.max > projection.max) {
                return projection.max - this.min;
            }
            else {
                return this.max - projection.min;
            }
        }
        return 0;
    };
    return Projection;
}());

var GlobalCoordinates = /** @class */ (function () {
    function GlobalCoordinates(worldPos, pagePos, screenPos) {
        this.worldPos = worldPos;
        this.pagePos = pagePos;
        this.screenPos = screenPos;
    }
    GlobalCoordinates.fromPagePosition = function (xOrPos, yOrEngine, engineOrUndefined) {
        var pageX;
        var pageY;
        var pagePos;
        var engine;
        if (arguments.length === 3) {
            pageX = xOrPos;
            pageY = yOrEngine;
            pagePos = new Vector(pageX, pageY);
            engine = engineOrUndefined;
        }
        else {
            pagePos = xOrPos;
            pageX = pagePos.x;
            pageY = pagePos.y;
            engine = yOrEngine;
        }
        var screenX = pageX - _Util_Util__WEBPACK_IMPORTED_MODULE_0__["getPosition"](engine.canvas).x;
        var screenY = pageY - _Util_Util__WEBPACK_IMPORTED_MODULE_0__["getPosition"](engine.canvas).y;
        var screenPos = new Vector(screenX, screenY);
        var worldPos = engine.screenToWorldCoordinates(screenPos);
        return new GlobalCoordinates(worldPos, pagePos, screenPos);
    };
    return GlobalCoordinates;
}());



/***/ }),

/***/ "./Camera.ts":
/*!*******************!*\
  !*** ./Camera.ts ***!
  \*******************/
/*! exports provided: StrategyContainer, Axis, LockCameraToActorStrategy, LockCameraToActorAxisStrategy, ElasticToActorStrategy, RadiusAroundActorStrategy, BaseCamera */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "StrategyContainer", function() { return StrategyContainer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Axis", function() { return Axis; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LockCameraToActorStrategy", function() { return LockCameraToActorStrategy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LockCameraToActorAxisStrategy", function() { return LockCameraToActorAxisStrategy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ElasticToActorStrategy", function() { return ElasticToActorStrategy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RadiusAroundActorStrategy", function() { return RadiusAroundActorStrategy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BaseCamera", function() { return BaseCamera; });
/* harmony import */ var _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Util/EasingFunctions */ "./Util/EasingFunctions.ts");
/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Promises */ "./Promises.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Util/Util */ "./Util/Util.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Class */ "./Class.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();






/**
 * Container to house convenience strategy methods
 * @internal
 */
var StrategyContainer = /** @class */ (function () {
    function StrategyContainer(camera) {
        this.camera = camera;
    }
    /**
     * Creates and adds the [[LockCameraToActorStrategy]] on the current camera.
     * @param actor The actor to lock the camera to
     */
    StrategyContainer.prototype.lockToActor = function (actor) {
        this.camera.addStrategy(new LockCameraToActorStrategy(actor));
    };
    /**
     * Creates and adds the [[LockCameraToActorAxisStrategy]] on the current camera
     * @param actor The actor to lock the camera to
     * @param axis The axis to follow the actor on
     */
    StrategyContainer.prototype.lockToActorAxis = function (actor, axis) {
        this.camera.addStrategy(new LockCameraToActorAxisStrategy(actor, axis));
    };
    /**
     * Creates and adds the [[ElasticToActorStrategy]] on the current camera
     * If cameraElasticity < cameraFriction < 1.0, the behavior will be a dampened spring that will slowly end at the target without bouncing
     * If cameraFriction < cameraElasticity < 1.0, the behavior will be an oscillationg spring that will over
     * correct and bounce around the target
     *
     * @param target Target actor to elastically follow
     * @param cameraElasticity [0 - 1.0] The higher the elasticity the more force that will drive the camera towards the target
     * @param cameraFriction [0 - 1.0] The higher the friction the more that the camera will resist motion towards the target
     */
    StrategyContainer.prototype.elasticToActor = function (actor, cameraElasticity, cameraFriction) {
        this.camera.addStrategy(new ElasticToActorStrategy(actor, cameraElasticity, cameraFriction));
    };
    /**
     * Creates and adds the [[RadiusAroundActorStrategy]] on the current camera
     * @param target Target actor to follow when it is "radius" pixels away
     * @param radius Number of pixels away before the camera will follow
     */
    StrategyContainer.prototype.radiusAroundActor = function (actor, radius) {
        this.camera.addStrategy(new RadiusAroundActorStrategy(actor, radius));
    };
    return StrategyContainer;
}());

/**
 * Camera axis enum
 */
var Axis;
(function (Axis) {
    Axis[Axis["X"] = 0] = "X";
    Axis[Axis["Y"] = 1] = "Y";
})(Axis || (Axis = {}));
/**
 * Lock a camera to the exact x/y postition of an actor.
 */
var LockCameraToActorStrategy = /** @class */ (function () {
    function LockCameraToActorStrategy(target) {
        this.target = target;
        this.action = function (target, _cam, _eng, _delta) {
            var center = target.getCenter();
            return center;
        };
    }
    return LockCameraToActorStrategy;
}());

/**
 * Lock a camera to a specific axis around an actor.
 */
var LockCameraToActorAxisStrategy = /** @class */ (function () {
    function LockCameraToActorAxisStrategy(target, axis) {
        var _this = this;
        this.target = target;
        this.axis = axis;
        this.action = function (target, cam, _eng, _delta) {
            var center = target.getCenter();
            var currentFocus = cam.getFocus();
            if (_this.axis === Axis.X) {
                return new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](center.x, currentFocus.y);
            }
            else {
                return new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](currentFocus.x, center.y);
            }
        };
    }
    return LockCameraToActorAxisStrategy;
}());

/**
 * Using [Hook's law](https://en.wikipedia.org/wiki/Hooke's_law), elastically move the camera towards the target actor.
 */
var ElasticToActorStrategy = /** @class */ (function () {
    /**
     * If cameraElasticity < cameraFriction < 1.0, the behavior will be a dampened spring that will slowly end at the target without bouncing
     * If cameraFriction < cameraElasticity < 1.0, the behavior will be an oscillationg spring that will over
     * correct and bounce around the target
     *
     * @param target Target actor to elastically follow
     * @param cameraElasticity [0 - 1.0] The higher the elasticity the more force that will drive the camera towards the target
     * @param cameraFriction [0 - 1.0] The higher the friction the more that the camera will resist motion towards the target
     */
    function ElasticToActorStrategy(target, cameraElasticity, cameraFriction) {
        var _this = this;
        this.target = target;
        this.cameraElasticity = cameraElasticity;
        this.cameraFriction = cameraFriction;
        this.action = function (target, cam, _eng, _delta) {
            var position = target.getCenter();
            var focus = cam.getFocus();
            var cameraVel = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](cam.dx, cam.dy);
            // Calculate the strech vector, using the spring equation
            // F = kX
            // https://en.wikipedia.org/wiki/Hooke's_law
            // Apply to the current camera velocity
            var stretch = position.sub(focus).scale(_this.cameraElasticity); // stretch is X
            cameraVel = cameraVel.add(stretch);
            // Calculate the friction (-1 to apply a force in the opposition of motion)
            // Apply to the current camera velocity
            var friction = cameraVel.scale(-1).scale(_this.cameraFriction);
            cameraVel = cameraVel.add(friction);
            // Update position by velocity deltas
            focus = focus.add(cameraVel);
            return focus;
        };
    }
    return ElasticToActorStrategy;
}());

var RadiusAroundActorStrategy = /** @class */ (function () {
    /**
     *
     * @param target Target actor to follow when it is "radius" pixels away
     * @param radius Number of pixels away before the camera will follow
     */
    function RadiusAroundActorStrategy(target, radius) {
        var _this = this;
        this.target = target;
        this.radius = radius;
        this.action = function (target, cam, _eng, _delta) {
            var position = target.getCenter();
            var focus = cam.getFocus();
            var direction = position.sub(focus);
            var distance = direction.magnitude();
            if (distance >= _this.radius) {
                var offset = distance - _this.radius;
                return focus.add(direction.normalize().scale(offset));
            }
            return focus;
        };
    }
    return RadiusAroundActorStrategy;
}());

/**
 * Cameras
 *
 * [[BaseCamera]] is the base class for all Excalibur cameras. Cameras are used
 * to move around your game and set focus. They are used to determine
 * what is "off screen" and can be used to scale the game.
 *
 * [[include:Cameras.md]]
 */
var BaseCamera = /** @class */ (function (_super) {
    __extends(BaseCamera, _super);
    function BaseCamera() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._cameraStrategies = [];
        _this.strategy = new StrategyContainer(_this);
        // camera physical quantities
        _this.z = 1;
        _this.dx = 0;
        _this.dy = 0;
        _this.dz = 0;
        _this.ax = 0;
        _this.ay = 0;
        _this.az = 0;
        _this.rotation = 0;
        _this.rx = 0;
        _this._x = 0;
        _this._y = 0;
        _this._cameraMoving = false;
        _this._currentLerpTime = 0;
        _this._lerpDuration = 1000; // 1 second
        _this._lerpStart = null;
        _this._lerpEnd = null;
        //camera effects
        _this._isShaking = false;
        _this._shakeMagnitudeX = 0;
        _this._shakeMagnitudeY = 0;
        _this._shakeDuration = 0;
        _this._elapsedShakeTime = 0;
        _this._xShake = 0;
        _this._yShake = 0;
        _this._isZooming = false;
        _this._zoomStart = 1;
        _this._zoomEnd = 1;
        _this._currentZoomTime = 0;
        _this._zoomDuration = 0;
        _this._zoomEasing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_0__["EasingFunctions"].EaseInOutCubic;
        _this._easing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_0__["EasingFunctions"].EaseInOutCubic;
        _this._isInitialized = false;
        return _this;
    }
    Object.defineProperty(BaseCamera.prototype, "x", {
        /**
         * Get the camera's x position
         */
        get: function () {
            return this._x;
        },
        /**
         * Set the camera's x position (cannot be set when following an [[Actor]] or when moving)
         */
        set: function (value) {
            if (!this._follow && !this._cameraMoving) {
                this._x = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BaseCamera.prototype, "y", {
        /**
         * Get the camera's y position
         */
        get: function () {
            return this._y;
        },
        /**
         * Set the camera's y position (cannot be set when following an [[Actor]] or when moving)
         */
        set: function (value) {
            if (!this._follow && !this._cameraMoving) {
                this._y = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BaseCamera.prototype, "pos", {
        /**
         * Get the camera's position as a vector
         */
        get: function () {
            return new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](this.x, this.y);
        },
        /**
         * Set the cameras position
         */
        set: function (value) {
            this.x = value.x;
            this.y = value.y;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(BaseCamera.prototype, "vel", {
        /**
         * Get the camera's velocity as a vector
         */
        get: function () {
            return new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](this.dx, this.dy);
        },
        /**
         * Set the camera's velocity
         */
        set: function (value) {
            this.dx = value.x;
            this.dy = value.y;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Returns the focal point of the camera, a new point giving the x and y position of the camera
     */
    BaseCamera.prototype.getFocus = function () {
        return new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](this.x, this.y);
    };
    /**
     * This moves the camera focal point to the specified position using specified easing function. Cannot move when following an Actor.
     *
     * @param pos The target position to move to
     * @param duration The duration in milliseconds the move should last
     * @param [easingFn] An optional easing function ([[ex.EasingFunctions.EaseInOutCubic]] by default)
     * @returns A [[Promise]] that resolves when movement is finished, including if it's interrupted.
     *          The [[Promise]] value is the [[Vector]] of the target position. It will be rejected if a move cannot be made.
     */
    BaseCamera.prototype.move = function (pos, duration, easingFn) {
        if (easingFn === void 0) { easingFn = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_0__["EasingFunctions"].EaseInOutCubic; }
        if (typeof easingFn !== 'function') {
            throw 'Please specify an EasingFunction';
        }
        // cannot move when following an actor
        if (this._follow) {
            return new _Promises__WEBPACK_IMPORTED_MODULE_1__["Promise"]().reject(pos);
        }
        // resolve existing promise, if any
        if (this._lerpPromise && this._lerpPromise.state() === _Promises__WEBPACK_IMPORTED_MODULE_1__["PromiseState"].Pending) {
            this._lerpPromise.resolve(pos);
        }
        this._lerpPromise = new _Promises__WEBPACK_IMPORTED_MODULE_1__["Promise"]();
        this._lerpStart = this.getFocus().clone();
        this._lerpDuration = duration;
        this._lerpEnd = pos;
        this._currentLerpTime = 0;
        this._cameraMoving = true;
        this._easing = easingFn;
        return this._lerpPromise;
    };
    /**
     * Sets the camera to shake at the specified magnitudes for the specified duration
     * @param magnitudeX  The x magnitude of the shake
     * @param magnitudeY  The y magnitude of the shake
     * @param duration    The duration of the shake in milliseconds
     */
    BaseCamera.prototype.shake = function (magnitudeX, magnitudeY, duration) {
        this._isShaking = true;
        this._shakeMagnitudeX = magnitudeX;
        this._shakeMagnitudeY = magnitudeY;
        this._shakeDuration = duration;
    };
    /**
     * Zooms the camera in or out by the specified scale over the specified duration.
     * If no duration is specified, it take effect immediately.
     * @param scale    The scale of the zoom
     * @param duration The duration of the zoom in milliseconds
     */
    BaseCamera.prototype.zoom = function (scale, duration, easingFn) {
        if (duration === void 0) { duration = 0; }
        if (easingFn === void 0) { easingFn = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_0__["EasingFunctions"].EaseInOutCubic; }
        this._zoomPromise = new _Promises__WEBPACK_IMPORTED_MODULE_1__["Promise"]();
        if (duration) {
            this._isZooming = true;
            this._zoomEasing = easingFn;
            this._currentZoomTime = 0;
            this._zoomDuration = duration;
            this._zoomStart = this.z;
            this._zoomEnd = scale;
        }
        else {
            this._isZooming = false;
            this.z = scale;
            this._zoomPromise.resolve(true);
        }
        return this._zoomPromise;
    };
    /**
     * Gets the current zoom scale
     */
    BaseCamera.prototype.getZoom = function () {
        return this.z;
    };
    /**
     * Adds a new camera strategy to this camera
     * @param cameraStrategy Instance of an [[ICameraStrategy]]
     */
    BaseCamera.prototype.addStrategy = function (cameraStrategy) {
        this._cameraStrategies.push(cameraStrategy);
    };
    /**
     * Removes a camera strategy by reference
     * @param cameraStrategy Instance of an [[ICameraStrategy]]
     */
    BaseCamera.prototype.removeStrategy = function (cameraStrategy) {
        Object(_Util_Util__WEBPACK_IMPORTED_MODULE_3__["removeItemFromArray"])(cameraStrategy, this._cameraStrategies);
    };
    /**
     * Clears all camera strategies from the camera
     */
    BaseCamera.prototype.clearAllStrategies = function () {
        this._cameraStrategies.length = 0;
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _preupdate handler for [[onPreUpdate]] lifecycle event
     * @internal
     */
    BaseCamera.prototype._preupdate = function (engine, delta) {
        this.emit('preupdate', new _Events__WEBPACK_IMPORTED_MODULE_4__["PreUpdateEvent"](engine, delta, this));
        this.onPreUpdate(engine, delta);
    };
    /**
     * Safe to override onPreUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPreUpdate` is called directly before a scene is updated.
     */
    BaseCamera.prototype.onPreUpdate = function (_engine, _delta) {
        // Overridable
    };
    /**
     *  It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _preupdate handler for [[onPostUpdate]] lifecycle event
     * @internal
     */
    BaseCamera.prototype._postupdate = function (engine, delta) {
        this.emit('postupdate', new _Events__WEBPACK_IMPORTED_MODULE_4__["PostUpdateEvent"](engine, delta, this));
        this.onPostUpdate(engine, delta);
    };
    /**
     * Safe to override onPostUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPostUpdate` is called directly after a scene is updated.
     */
    BaseCamera.prototype.onPostUpdate = function (_engine, _delta) {
        // Overridable
    };
    Object.defineProperty(BaseCamera.prototype, "isInitialized", {
        get: function () {
            return this._isInitialized;
        },
        enumerable: true,
        configurable: true
    });
    BaseCamera.prototype._initialize = function (_engine) {
        if (!this.isInitialized) {
            this.onInitialize(_engine);
            _super.prototype.emit.call(this, 'initialize', new _Events__WEBPACK_IMPORTED_MODULE_4__["InitializeEvent"](_engine, this));
            this._isInitialized = true;
        }
    };
    /**
     * Safe to override onPostUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPostUpdate` is called directly after a scene is updated.
     */
    BaseCamera.prototype.onInitialize = function (_engine) {
        // Overridable
    };
    BaseCamera.prototype.on = function (eventName, handler) {
        _super.prototype.on.call(this, eventName, handler);
    };
    BaseCamera.prototype.off = function (eventName, handler) {
        _super.prototype.off.call(this, eventName, handler);
    };
    BaseCamera.prototype.once = function (eventName, handler) {
        _super.prototype.once.call(this, eventName, handler);
    };
    BaseCamera.prototype.update = function (_engine, delta) {
        this._initialize(_engine);
        this._preupdate(_engine, delta);
        // Update placements based on linear algebra
        this._x += (this.dx * delta) / 1000;
        this._y += (this.dy * delta) / 1000;
        this.z += (this.dz * delta) / 1000;
        this.dx += (this.ax * delta) / 1000;
        this.dy += (this.ay * delta) / 1000;
        this.dz += (this.az * delta) / 1000;
        this.rotation += (this.rx * delta) / 1000;
        if (this._isZooming) {
            if (this._currentZoomTime < this._zoomDuration) {
                var zoomEasing = this._zoomEasing;
                var newZoom = zoomEasing(this._currentZoomTime, this._zoomStart, this._zoomEnd, this._zoomDuration);
                this.z = newZoom;
                this._currentZoomTime += delta;
            }
            else {
                this._isZooming = false;
                this.z = this._zoomEnd;
                this._currentZoomTime = 0;
                this._zoomPromise.resolve(true);
            }
        }
        if (this._cameraMoving) {
            if (this._currentLerpTime < this._lerpDuration) {
                var moveEasing = _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_0__["EasingFunctions"].CreateVectorEasingFunction(this._easing);
                var lerpPoint = moveEasing(this._currentLerpTime, this._lerpStart, this._lerpEnd, this._lerpDuration);
                this._x = lerpPoint.x;
                this._y = lerpPoint.y;
                this._currentLerpTime += delta;
            }
            else {
                this._x = this._lerpEnd.x;
                this._y = this._lerpEnd.y;
                var end = this._lerpEnd.clone();
                this._lerpStart = null;
                this._lerpEnd = null;
                this._currentLerpTime = 0;
                this._cameraMoving = false;
                // Order matters here, resolve should be last so any chain promises have a clean slate
                this._lerpPromise.resolve(end);
            }
        }
        if (this._isDoneShaking()) {
            this._isShaking = false;
            this._elapsedShakeTime = 0;
            this._shakeMagnitudeX = 0;
            this._shakeMagnitudeY = 0;
            this._shakeDuration = 0;
            this._xShake = 0;
            this._yShake = 0;
        }
        else {
            this._elapsedShakeTime += delta;
            this._xShake = ((Math.random() * this._shakeMagnitudeX) | 0) + 1;
            this._yShake = ((Math.random() * this._shakeMagnitudeY) | 0) + 1;
        }
        for (var _i = 0, _a = this._cameraStrategies; _i < _a.length; _i++) {
            var s = _a[_i];
            this.pos = s.action.call(s, s.target, this, _engine, delta);
        }
        this._postupdate(_engine, delta);
    };
    /**
     * Applies the relevant transformations to the game canvas to "move" or apply effects to the Camera
     * @param ctx    Canvas context to apply transformations
     * @param delta  The number of milliseconds since the last update
     */
    BaseCamera.prototype.draw = function (ctx) {
        var focus = this.getFocus();
        var canvasWidth = ctx.canvas.width;
        var canvasHeight = ctx.canvas.height;
        var pixelRatio = window.devicePixelRatio;
        var zoom = this.getZoom();
        var newCanvasWidth = canvasWidth / zoom / pixelRatio;
        var newCanvasHeight = canvasHeight / zoom / pixelRatio;
        ctx.scale(zoom, zoom);
        ctx.translate(-focus.x + newCanvasWidth / 2 + this._xShake, -focus.y + newCanvasHeight / 2 + this._yShake);
    };
    BaseCamera.prototype.debugDraw = function (ctx) {
        var focus = this.getFocus();
        ctx.fillStyle = 'red';
        ctx.strokeStyle = 'white';
        ctx.lineWidth = 3;
        ctx.beginPath();
        ctx.arc(focus.x, focus.y, 15, 0, Math.PI * 2);
        ctx.closePath();
        ctx.stroke();
        ctx.beginPath();
        ctx.arc(focus.x, focus.y, 5, 0, Math.PI * 2);
        ctx.closePath();
        ctx.stroke();
    };
    BaseCamera.prototype._isDoneShaking = function () {
        return !this._isShaking || this._elapsedShakeTime >= this._shakeDuration;
    };
    return BaseCamera;
}(_Class__WEBPACK_IMPORTED_MODULE_5__["Class"]));



/***/ }),

/***/ "./Class.ts":
/*!******************!*\
  !*** ./Class.ts ***!
  \******************/
/*! exports provided: Class */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Class", function() { return Class; });
/* harmony import */ var _EventDispatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EventDispatcher */ "./EventDispatcher.ts");

/**
 * Excalibur base class that provides basic functionality such as [[EventDispatcher]]
 * and extending abilities for vanilla Javascript projects
 */
var Class = /** @class */ (function () {
    function Class() {
        this.eventDispatcher = new _EventDispatcher__WEBPACK_IMPORTED_MODULE_0__["EventDispatcher"](this);
    }
    /**
     * Alias for `addEventListener`. You can listen for a variety of
     * events off of the engine; see the events section below for a complete list.
     * @param eventName  Name of the event to listen for
     * @param handler    Event handler for the thrown event
     */
    Class.prototype.on = function (eventName, handler) {
        this.eventDispatcher.on(eventName, handler);
    };
    /**
     * Alias for `removeEventListener`. If only the eventName is specified
     * it will remove all handlers registered for that specific event. If the eventName
     * and the handler instance are specified only that handler will be removed.
     *
     * @param eventName  Name of the event to listen for
     * @param handler    Event handler for the thrown event
     */
    Class.prototype.off = function (eventName, handler) {
        this.eventDispatcher.off(eventName, handler);
    };
    /**
     * Emits a new event
     * @param eventName   Name of the event to emit
     * @param eventObject Data associated with this event
     */
    Class.prototype.emit = function (eventName, eventObject) {
        this.eventDispatcher.emit(eventName, eventObject);
    };
    /**
     * Once listens to an event one time, then unsubscribes from that event
     *
     * @param eventName The name of the event to subscribe to once
     * @param handler   The handler of the event that will be auto unsubscribed
     */
    Class.prototype.once = function (eventName, handler) {
        this.eventDispatcher.once(eventName, handler);
    };
    /**
     * You may wish to extend native Excalibur functionality in vanilla Javascript.
     * Any method on a class inheriting [[Class]] may be extended to support
     * additional functionality. In the example below we create a new type called `MyActor`.
     *
     *
     * ```js
     * var MyActor = Actor.extend({
     *
     *    constructor: function() {
     *       this.newprop = 'something';
     *       Actor.apply(this, arguments);
     *    },
     *
     *    update: function(engine, delta) {
     *       // Implement custom update
     *       // Call super constructor update
     *       Actor.prototype.update.call(this, engine, delta);
     *
     *       console.log("Something cool!");
     *    }
     * });
     *
     * var myActor = new MyActor(100, 100, 100, 100, Color.Azure);
     * ```
     *
     * In TypeScript, you only need to use the `extends` syntax, you do not need
     * to use this method of extension.
     *
     * @param methods A JSON object contain any methods/properties you want to extend
     */
    Class.extend = function (methods) {
        var parent = this;
        var child;
        if (methods && methods.hasOwnProperty('constructor')) {
            child = methods.constructor;
        }
        else {
            child = function () {
                return parent.apply(this, arguments);
            };
        }
        // Using constructor allows JS to lazily instantiate super classes
        var Super = function () {
            this.constructor = child;
        };
        Super.prototype = parent.prototype;
        child.prototype = new Super();
        if (methods) {
            for (var prop in methods) {
                if (methods.hasOwnProperty(prop)) {
                    child.prototype[prop] = methods[prop];
                }
            }
        }
        // Make subclasses extendable
        child.extend = Class.extend;
        return child;
    };
    return Class;
}());



/***/ }),

/***/ "./Collision/Body.ts":
/*!***************************!*\
  !*** ./Collision/Body.ts ***!
  \***************************/
/*! exports provided: Body */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Body", function() { return Body; });
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Physics */ "./Physics.ts");
/* harmony import */ var _EdgeArea__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./EdgeArea */ "./Collision/EdgeArea.ts");
/* harmony import */ var _CircleArea__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CircleArea */ "./Collision/CircleArea.ts");
/* harmony import */ var _PolygonArea__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./PolygonArea */ "./Collision/PolygonArea.ts");
/* harmony import */ var _Pair__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Pair */ "./Collision/Pair.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Util/DrawUtil */ "./Util/DrawUtil.ts");








var Body = /** @class */ (function () {
    /**
     * Constructs a new physics body associated with an actor
     */
    function Body(actor) {
        this.actor = actor;
        /**
         * [[ICollisionArea|Collision area]] of this physics body, defines the shape for rigid body collision
         */
        this.collisionArea = null;
        /**
         * The (x, y) position of the actor this will be in the middle of the actor if the
         * [[Actor.anchor]] is set to (0.5, 0.5) which is default.
         * If you want the (x, y) position to be the top left of the actor specify an anchor of (0, 0).
         */
        this.pos = new _Algebra__WEBPACK_IMPORTED_MODULE_5__["Vector"](0, 0);
        /**
         * The position of the actor last frame (x, y) in pixels
         */
        this.oldPos = new _Algebra__WEBPACK_IMPORTED_MODULE_5__["Vector"](0, 0);
        /**
         * The current velocity vector (vx, vy) of the actor in pixels/second
         */
        this.vel = new _Algebra__WEBPACK_IMPORTED_MODULE_5__["Vector"](0, 0);
        /**
         * The velocity of the actor last frame (vx, vy) in pixels/second
         */
        this.oldVel = new _Algebra__WEBPACK_IMPORTED_MODULE_5__["Vector"](0, 0);
        /**
         * The curret acceleration vector (ax, ay) of the actor in pixels/second/second. An acceleration pointing down such as (0, 100) may
         * be useful to simulate a gravitational effect.
         */
        this.acc = new _Algebra__WEBPACK_IMPORTED_MODULE_5__["Vector"](0, 0);
        /**
         * The current torque applied to the actor
         */
        this.torque = 0;
        /**
         * The current mass of the actor, mass can be thought of as the resistance to acceleration.
         */
        this.mass = 1.0;
        /**
         * The current moment of inertia, moi can be thought of as the resistance to rotation.
         */
        this.moi = 1000;
        /**
         * The current "motion" of the actor, used to calculated sleep in the physics simulation
         */
        this.motion = 10;
        /**
         * The coefficient of friction on this actor
         */
        this.friction = 0.99;
        /**
         * The coefficient of restitution of this actor, represents the amount of energy preserved after collision
         */
        this.restitution = 0.2;
        /**
         * The rotation of the actor in radians
         */
        this.rotation = 0; // radians
        /**
         * The rotational velocity of the actor in radians/second
         */
        this.rx = 0; //radians/sec
        this._totalMtv = _Algebra__WEBPACK_IMPORTED_MODULE_5__["Vector"].Zero.clone();
    }
    /**
     * Add minimum translation vectors accumulated during the current frame to resolve collisions.
     */
    Body.prototype.addMtv = function (mtv) {
        this._totalMtv.addEqual(mtv);
    };
    /**
     * Applies the accumulated translation vectors to the actors position
     */
    Body.prototype.applyMtv = function () {
        this.pos.addEqual(this._totalMtv);
        this._totalMtv.setTo(0, 0);
    };
    /**
     * Returns the body's [[BoundingBox]] calculated for this instant in world space.
     */
    Body.prototype.getBounds = function () {
        if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].collisionResolutionStrategy === _Physics__WEBPACK_IMPORTED_MODULE_0__["CollisionResolutionStrategy"].Box) {
            return this.actor.getBounds();
        }
        else {
            return this.collisionArea.getBounds();
        }
    };
    /**
     * Returns the actor's [[BoundingBox]] relative to the actors position.
     */
    Body.prototype.getRelativeBounds = function () {
        if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].collisionResolutionStrategy === _Physics__WEBPACK_IMPORTED_MODULE_0__["CollisionResolutionStrategy"].Box) {
            return this.actor.getRelativeBounds();
        }
        else {
            return this.actor.getRelativeBounds();
        }
    };
    /**
     * Updates the collision area geometry and internal caches
     */
    Body.prototype.update = function () {
        if (this.collisionArea) {
            // Update the geometry if needed
            if (this.actor && this.actor.isGeometryDirty && this.collisionArea instanceof _PolygonArea__WEBPACK_IMPORTED_MODULE_3__["PolygonArea"]) {
                this.collisionArea.points = this.actor.getRelativeGeometry();
            }
            this.collisionArea.recalc();
        }
    };
    /**
     * Sets up a box collision area based on the current bounds of the associated actor of this physics body.
     *
     * By default, the box is center is at (0, 0) which means it is centered around the actors anchor.
     */
    Body.prototype.useBoxCollision = function (center) {
        if (center === void 0) { center = _Algebra__WEBPACK_IMPORTED_MODULE_5__["Vector"].Zero.clone(); }
        this.collisionArea = new _PolygonArea__WEBPACK_IMPORTED_MODULE_3__["PolygonArea"]({
            body: this,
            points: this.actor.getRelativeGeometry(),
            pos: center // position relative to actor
        });
        // in case of a nan moi, coalesce to a safe default
        this.moi = this.collisionArea.getMomentOfInertia() || this.moi;
    };
    /**
     * Sets up a polygon collision area based on a list of of points relative to the anchor of the associated actor of this physics body.
     *
     * Only [convex polygon](https://en.wikipedia.org/wiki/Convex_polygon) definitions are supported.
     *
     * By default, the box is center is at (0, 0) which means it is centered around the actors anchor.
     */
    Body.prototype.usePolygonCollision = function (points, center) {
        if (center === void 0) { center = _Algebra__WEBPACK_IMPORTED_MODULE_5__["Vector"].Zero.clone(); }
        this.collisionArea = new _PolygonArea__WEBPACK_IMPORTED_MODULE_3__["PolygonArea"]({
            body: this,
            points: points,
            pos: center // position relative to actor
        });
        // in case of a nan moi, collesce to a safe default
        this.moi = this.collisionArea.getMomentOfInertia() || this.moi;
    };
    /**
     * Sets up a [[CircleArea|circle collision area]] with a specified radius in pixels.
     *
     * By default, the box is center is at (0, 0) which means it is centered around the actors anchor.
     */
    Body.prototype.useCircleCollision = function (radius, center) {
        if (center === void 0) { center = _Algebra__WEBPACK_IMPORTED_MODULE_5__["Vector"].Zero.clone(); }
        if (!radius) {
            radius = this.actor.getWidth() / 2;
        }
        this.collisionArea = new _CircleArea__WEBPACK_IMPORTED_MODULE_2__["CircleArea"]({
            body: this,
            radius: radius,
            pos: center
        });
        this.moi = this.collisionArea.getMomentOfInertia() || this.moi;
    };
    /**
     * Sets up an [[EdgeArea|edge collision]] with a start point and an end point relative to the anchor of the associated actor
     * of this physics body.
     *
     * By default, the box is center is at (0, 0) which means it is centered around the actors anchor.
     */
    Body.prototype.useEdgeCollision = function (begin, end) {
        this.collisionArea = new _EdgeArea__WEBPACK_IMPORTED_MODULE_1__["EdgeArea"]({
            begin: begin,
            end: end,
            body: this
        });
        this.moi = this.collisionArea.getMomentOfInertia() || this.moi;
    };
    /* istanbul ignore next */
    Body.prototype.debugDraw = function (ctx) {
        // Draw motion vectors
        if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].showMotionVectors) {
            _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_7__["vector"](ctx, _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__["Color"].Yellow, this.pos, this.acc.add(_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].acc));
            _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_7__["vector"](ctx, _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__["Color"].Red, this.pos, this.vel);
            _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_7__["point"](ctx, _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__["Color"].Red, this.pos);
        }
        if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].showBounds) {
            this.getBounds().debugDraw(ctx, _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__["Color"].Yellow);
        }
        if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].showArea) {
            this.collisionArea.debugDraw(ctx, _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__["Color"].Green);
        }
    };
    /**
     * Returns a boolean indicating whether this body collided with
     * or was in stationary contact with
     * the body of the other [[Actor]]
     */
    Body.prototype.touching = function (other) {
        var pair = new _Pair__WEBPACK_IMPORTED_MODULE_4__["Pair"](this, other.body);
        pair.collide();
        if (pair.collision) {
            return true;
        }
        return false;
    };
    return Body;
}());



/***/ }),

/***/ "./Collision/BoundingBox.ts":
/*!**********************************!*\
  !*** ./Collision/BoundingBox.ts ***!
  \**********************************/
/*! exports provided: BoundingBox */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BoundingBox", function() { return BoundingBox; });
/* harmony import */ var _PolygonArea__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PolygonArea */ "./Collision/PolygonArea.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Drawing/Color */ "./Drawing/Color.ts");



/**
 * Axis Aligned collision primitive for Excalibur.
 */
var BoundingBox = /** @class */ (function () {
    /**
     * @param left    x coordinate of the left edge
     * @param top     y coordinate of the top edge
     * @param right   x coordinate of the right edge
     * @param bottom  y coordinate of the bottom edge
     */
    function BoundingBox(left, top, right, bottom) {
        if (left === void 0) { left = 0; }
        if (top === void 0) { top = 0; }
        if (right === void 0) { right = 0; }
        if (bottom === void 0) { bottom = 0; }
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
    }
    BoundingBox.fromPoints = function (points) {
        var minX = Infinity;
        var minY = Infinity;
        var maxX = -Infinity;
        var maxY = -Infinity;
        for (var i = 0; i < points.length; i++) {
            if (points[i].x < minX) {
                minX = points[i].x;
            }
            if (points[i].x > maxX) {
                maxX = points[i].x;
            }
            if (points[i].y < minY) {
                minY = points[i].y;
            }
            if (points[i].y > maxY) {
                maxY = points[i].y;
            }
        }
        return new BoundingBox(minX, minY, maxX, maxY);
    };
    /**
     * Returns the calculated width of the bounding box
     */
    BoundingBox.prototype.getWidth = function () {
        return this.right - this.left;
    };
    /**
     * Returns the calculated height of the bounding box
     */
    BoundingBox.prototype.getHeight = function () {
        return this.bottom - this.top;
    };
    /**
     * Rotates a bounding box by and angle and around a point, if no point is specified (0, 0) is used by default. The resulting bounding
     * box is also axis-align. This is useful when a new axis-aligned bounding box is needed for rotated geometry.
     */
    BoundingBox.prototype.rotate = function (angle, point) {
        if (point === void 0) { point = _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"].Zero.clone(); }
        var points = this.getPoints().map(function (p) { return p.rotate(angle, point); });
        return BoundingBox.fromPoints(points);
    };
    /**
     * Returns the perimeter of the bounding box
     */
    BoundingBox.prototype.getPerimeter = function () {
        var wx = this.getWidth();
        var wy = this.getHeight();
        return 2 * (wx + wy);
    };
    BoundingBox.prototype.getPoints = function () {
        var results = [];
        results.push(new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](this.left, this.top));
        results.push(new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](this.right, this.top));
        results.push(new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](this.right, this.bottom));
        results.push(new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](this.left, this.bottom));
        return results;
    };
    /**
     * Creates a Polygon collision area from the points of the bounding box
     */
    BoundingBox.prototype.toPolygon = function (actor) {
        return new _PolygonArea__WEBPACK_IMPORTED_MODULE_0__["PolygonArea"]({
            body: actor ? actor.body : null,
            points: this.getPoints(),
            pos: _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"].Zero.clone()
        });
    };
    /**
     * Determines whether a ray intersects with a bounding box
     */
    BoundingBox.prototype.rayCast = function (ray, farClipDistance) {
        if (farClipDistance === void 0) { farClipDistance = Infinity; }
        // algorithm from https://tavianator.com/fast-branchless-raybounding-box-intersections/
        var tmin = -Infinity;
        var tmax = +Infinity;
        var xinv = ray.dir.x === 0 ? Number.MAX_VALUE : 1 / ray.dir.x;
        var yinv = ray.dir.y === 0 ? Number.MAX_VALUE : 1 / ray.dir.y;
        var tx1 = (this.left - ray.pos.x) * xinv;
        var tx2 = (this.right - ray.pos.x) * xinv;
        tmin = Math.min(tx1, tx2);
        tmax = Math.max(tx1, tx2);
        var ty1 = (this.top - ray.pos.y) * yinv;
        var ty2 = (this.bottom - ray.pos.y) * yinv;
        tmin = Math.max(tmin, Math.min(ty1, ty2));
        tmax = Math.min(tmax, Math.max(ty1, ty2));
        return tmax >= Math.max(0, tmin) && tmin < farClipDistance;
    };
    BoundingBox.prototype.rayCastTime = function (ray, farClipDistance) {
        if (farClipDistance === void 0) { farClipDistance = Infinity; }
        // algorithm from https://tavianator.com/fast-branchless-raybounding-box-intersections/
        var tmin = -Infinity;
        var tmax = +Infinity;
        var xinv = ray.dir.x === 0 ? Number.MAX_VALUE : 1 / ray.dir.x;
        var yinv = ray.dir.y === 0 ? Number.MAX_VALUE : 1 / ray.dir.y;
        var tx1 = (this.left - ray.pos.x) * xinv;
        var tx2 = (this.right - ray.pos.x) * xinv;
        tmin = Math.min(tx1, tx2);
        tmax = Math.max(tx1, tx2);
        var ty1 = (this.top - ray.pos.y) * yinv;
        var ty2 = (this.bottom - ray.pos.y) * yinv;
        tmin = Math.max(tmin, Math.min(ty1, ty2));
        tmax = Math.min(tmax, Math.max(ty1, ty2));
        if (tmax >= Math.max(0, tmin) && tmin < farClipDistance) {
            return tmin;
        }
        return -1;
    };
    BoundingBox.prototype.contains = function (val) {
        if (val instanceof _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"]) {
            return this.left <= val.x && this.top <= val.y && this.bottom >= val.y && this.right >= val.x;
        }
        else if (val instanceof BoundingBox) {
            if (this.left < val.left && this.top < val.top && val.bottom < this.bottom && val.right < this.right) {
                return true;
            }
            return false;
        }
        return false;
    };
    /**
     * Combines this bounding box and another together returning a new bounding box
     * @param other  The bounding box to combine
     */
    BoundingBox.prototype.combine = function (other) {
        var compositeBB = new BoundingBox(Math.min(this.left, other.left), Math.min(this.top, other.top), Math.max(this.right, other.right), Math.max(this.bottom, other.bottom));
        return compositeBB;
    };
    /**
     * Test wether this bounding box collides with another returning,
     * the intersection vector that can be used to resolve the collision. If there
     * is no collision null is returned.
     * @param collidable  Other collidable to test
     */
    BoundingBox.prototype.collides = function (collidable) {
        if (collidable instanceof BoundingBox) {
            var other = collidable;
            var totalBoundingBox = this.combine(other);
            // If the total bounding box is less than the sum of the 2 bounds then there is collision
            if (totalBoundingBox.getWidth() < other.getWidth() + this.getWidth() &&
                totalBoundingBox.getHeight() < other.getHeight() + this.getHeight()) {
                // collision
                var overlapX = 0;
                if (this.right >= other.left && this.right <= other.right) {
                    overlapX = other.left - this.right;
                }
                else {
                    overlapX = other.right - this.left;
                }
                var overlapY = 0;
                if (this.top <= other.bottom && this.top >= other.top) {
                    overlapY = other.bottom - this.top;
                }
                else {
                    overlapY = other.top - this.bottom;
                }
                if (Math.abs(overlapX) < Math.abs(overlapY)) {
                    return new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](overlapX, 0);
                }
                else {
                    return new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](0, overlapY);
                }
            }
            else {
                return null;
            }
        }
        return null;
    };
    /* istanbul ignore next */
    BoundingBox.prototype.debugDraw = function (ctx, color) {
        if (color === void 0) { color = _Drawing_Color__WEBPACK_IMPORTED_MODULE_2__["Color"].Yellow; }
        ctx.strokeStyle = color.toString();
        ctx.strokeRect(this.left, this.top, this.getWidth(), this.getHeight());
    };
    return BoundingBox;
}());



/***/ }),

/***/ "./Collision/CircleArea.ts":
/*!*********************************!*\
  !*** ./Collision/CircleArea.ts ***!
  \*********************************/
/*! exports provided: CircleArea */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CircleArea", function() { return CircleArea; });
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _PolygonArea__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PolygonArea */ "./Collision/PolygonArea.ts");
/* harmony import */ var _EdgeArea__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./EdgeArea */ "./Collision/EdgeArea.ts");
/* harmony import */ var _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CollisionJumpTable */ "./Collision/CollisionJumpTable.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Physics */ "./Physics.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Drawing/Color */ "./Drawing/Color.ts");







/**
 * This is a circle collision area for the excalibur rigid body physics simulation
 */
var CircleArea = /** @class */ (function () {
    function CircleArea(options) {
        /**
         * This is the center position of the circle, relative to the body position
         */
        this.pos = _Algebra__WEBPACK_IMPORTED_MODULE_4__["Vector"].Zero.clone();
        this.pos = options.pos || _Algebra__WEBPACK_IMPORTED_MODULE_4__["Vector"].Zero.clone();
        this.radius = options.radius || 0;
        this.body = options.body || null;
    }
    /**
     * Get the center of the collision area in world coordinates
     */
    CircleArea.prototype.getCenter = function () {
        if (this.body) {
            return this.pos.add(this.body.pos);
        }
        return this.pos;
    };
    /**
     * Tests if a point is contained in this collision area
     */
    CircleArea.prototype.contains = function (point) {
        var distance = this.body.pos.distance(point);
        if (distance <= this.radius) {
            return true;
        }
        return false;
    };
    /**
     * Casts a ray at the CircleArea and returns the nearest point of collision
     * @param ray
     */
    CircleArea.prototype.rayCast = function (ray, max) {
        if (max === void 0) { max = Infinity; }
        //https://en.wikipedia.org/wiki/Line%E2%80%93sphere_intersection
        var c = this.getCenter();
        var dir = ray.dir;
        var orig = ray.pos;
        var discriminant = Math.sqrt(Math.pow(dir.dot(orig.sub(c)), 2) - Math.pow(orig.sub(c).distance(), 2) + Math.pow(this.radius, 2));
        if (discriminant < 0) {
            // no intersection
            return null;
        }
        else {
            var toi = 0;
            if (discriminant === 0) {
                toi = -dir.dot(orig.sub(c));
                if (toi > 0 && toi < max) {
                    return ray.getPoint(toi);
                }
                return null;
            }
            else {
                var toi1 = -dir.dot(orig.sub(c)) + discriminant;
                var toi2 = -dir.dot(orig.sub(c)) - discriminant;
                var mintoi = Math.min(toi1, toi2);
                if (mintoi <= max) {
                    return ray.getPoint(mintoi);
                }
                return null;
            }
        }
    };
    /**
     * @inheritdoc
     */
    CircleArea.prototype.collide = function (area) {
        if (area instanceof CircleArea) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_3__["CollisionJumpTable"].CollideCircleCircle(this, area);
        }
        else if (area instanceof _PolygonArea__WEBPACK_IMPORTED_MODULE_1__["PolygonArea"]) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_3__["CollisionJumpTable"].CollideCirclePolygon(this, area);
        }
        else if (area instanceof _EdgeArea__WEBPACK_IMPORTED_MODULE_2__["EdgeArea"]) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_3__["CollisionJumpTable"].CollideCircleEdge(this, area);
        }
        else {
            throw new Error("Circle could not collide with unknown ICollisionArea " + typeof area);
        }
    };
    /**
     * Find the point on the shape furthest in the direction specified
     */
    CircleArea.prototype.getFurthestPoint = function (direction) {
        return this.getCenter().add(direction.normalize().scale(this.radius));
    };
    /**
     * Get the axis aligned bounding box for the circle area
     */
    CircleArea.prototype.getBounds = function () {
        return new _BoundingBox__WEBPACK_IMPORTED_MODULE_0__["BoundingBox"](this.pos.x + this.body.pos.x - this.radius, this.pos.y + this.body.pos.y - this.radius, this.pos.x + this.body.pos.x + this.radius, this.pos.y + this.body.pos.y + this.radius);
    };
    /**
     * Get axis not implemented on circles, since there are infinite axis in a circle
     */
    CircleArea.prototype.getAxes = function () {
        return null;
    };
    /**
     * Returns the moment of inertia of a circle given it's mass
     * https://en.wikipedia.org/wiki/List_of_moments_of_inertia
     */
    CircleArea.prototype.getMomentOfInertia = function () {
        var mass = this.body ? this.body.mass : _Physics__WEBPACK_IMPORTED_MODULE_5__["Physics"].defaultMass;
        return (mass * this.radius * this.radius) / 2;
    };
    /**
     * Tests the separating axis theorem for circles against polygons
     */
    CircleArea.prototype.testSeparatingAxisTheorem = function (polygon) {
        var axes = polygon.getAxes();
        var pc = polygon.getCenter();
        // Special SAT with circles
        var closestPointOnPoly = polygon.getFurthestPoint(this.pos.sub(pc));
        axes.push(this.pos.sub(closestPointOnPoly).normalize());
        var minOverlap = Number.MAX_VALUE;
        var minAxis = null;
        var minIndex = -1;
        for (var i = 0; i < axes.length; i++) {
            var proj1 = polygon.project(axes[i]);
            var proj2 = this.project(axes[i]);
            var overlap = proj1.getOverlap(proj2);
            if (overlap <= 0) {
                return null;
            }
            else {
                if (overlap < minOverlap) {
                    minOverlap = overlap;
                    minAxis = axes[i];
                    minIndex = i;
                }
            }
        }
        if (minIndex < 0) {
            return null;
        }
        return minAxis.normalize().scale(minOverlap);
    };
    /* istanbul ignore next */
    CircleArea.prototype.recalc = function () {
        // circles don't cache
    };
    /**
     * Project the circle along a specified axis
     */
    CircleArea.prototype.project = function (axis) {
        var scalars = [];
        var point = this.getCenter();
        var dotProduct = point.dot(axis);
        scalars.push(dotProduct);
        scalars.push(dotProduct + this.radius);
        scalars.push(dotProduct - this.radius);
        return new _Algebra__WEBPACK_IMPORTED_MODULE_4__["Projection"](Math.min.apply(Math, scalars), Math.max.apply(Math, scalars));
    };
    /* istanbul ignore next */
    CircleArea.prototype.debugDraw = function (ctx, color) {
        if (color === void 0) { color = _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__["Color"].Green.clone(); }
        var pos = this.body ? this.body.pos.add(this.pos) : this.pos;
        var rotation = this.body ? this.body.rotation : 0;
        ctx.beginPath();
        ctx.strokeStyle = color.toString();
        ctx.arc(pos.x, pos.y, this.radius, 0, Math.PI * 2);
        ctx.closePath();
        ctx.stroke();
        ctx.beginPath();
        ctx.moveTo(pos.x, pos.y);
        ctx.lineTo(Math.cos(rotation) * this.radius + pos.x, Math.sin(rotation) * this.radius + pos.y);
        ctx.closePath();
        ctx.stroke();
    };
    return CircleArea;
}());



/***/ }),

/***/ "./Collision/CollisionContact.ts":
/*!***************************************!*\
  !*** ./Collision/CollisionContact.ts ***!
  \***************************************/
/*! exports provided: CollisionContact */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CollisionContact", function() { return CollisionContact; });
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Actor */ "./Actor.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Physics */ "./Physics.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Events */ "./Events.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");





/**
 * Collision contacts are used internally by Excalibur to resolve collision between actors. This
 * Pair prevents collisions from being evaluated more than one time
 */
var CollisionContact = /** @class */ (function () {
    function CollisionContact(bodyA, bodyB, mtv, point, normal) {
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.mtv = mtv;
        this.point = point;
        this.normal = normal;
    }
    CollisionContact.prototype.resolve = function (strategy) {
        if (strategy === _Physics__WEBPACK_IMPORTED_MODULE_2__["CollisionResolutionStrategy"].RigidBody) {
            this._resolveRigidBodyCollision();
        }
        else if (strategy === _Physics__WEBPACK_IMPORTED_MODULE_2__["CollisionResolutionStrategy"].Box) {
            this._resolveBoxCollision();
        }
        else {
            throw new Error('Unknown collision resolution strategy');
        }
    };
    CollisionContact.prototype._applyBoxImpulse = function (bodyA, bodyB, mtv) {
        if (bodyA.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Active && bodyB.collisionType !== _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Passive) {
            // Resolve overlaps
            if (bodyA.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Active && bodyB.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Active) {
                // split overlaps if both are Active
                mtv = mtv.scale(0.5);
            }
            // Apply mtv
            bodyA.pos.y += mtv.y;
            bodyA.pos.x += mtv.x;
            var mtvDir = mtv.normalize();
            // only adjust if velocity is opposite
            if (mtvDir.dot(bodyA.vel) < 0) {
                // Cancel out velocity in direction of mtv
                var velAdj = mtvDir.scale(mtvDir.dot(bodyA.vel.negate()));
                bodyA.vel = bodyA.vel.add(velAdj);
            }
            bodyA.emit('postcollision', new _Events__WEBPACK_IMPORTED_MODULE_3__["PostCollisionEvent"](bodyA, bodyB, _Util_Util__WEBPACK_IMPORTED_MODULE_4__["getSideFromVector"](mtv), mtv));
        }
    };
    CollisionContact.prototype._resolveBoxCollision = function () {
        var bodyA = this.bodyA.body.actor;
        var bodyB = this.bodyB.body.actor;
        var side = _Util_Util__WEBPACK_IMPORTED_MODULE_4__["getSideFromVector"](this.mtv);
        var mtv = this.mtv.negate();
        // Publish collision events on both participants
        bodyA.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_3__["PreCollisionEvent"](bodyA, bodyB, side, mtv));
        bodyB.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_3__["PreCollisionEvent"](bodyB, bodyA, _Util_Util__WEBPACK_IMPORTED_MODULE_4__["getOppositeSide"](side), mtv.negate()));
        this._applyBoxImpulse(bodyA, bodyB, mtv);
        this._applyBoxImpulse(bodyB, bodyA, mtv.negate());
    };
    CollisionContact.prototype._resolveRigidBodyCollision = function () {
        // perform collison on bounding areas
        var bodyA = this.bodyA.body;
        var bodyB = this.bodyB.body;
        var mtv = this.mtv; // normal pointing away from bodyA
        var normal = this.normal; // normal pointing away from bodyA
        if (bodyA.actor === bodyB.actor) {
            // sanity check for existing pairs
            return;
        }
        // Publish collision events on both participants
        var side = _Util_Util__WEBPACK_IMPORTED_MODULE_4__["getSideFromVector"](this.mtv);
        bodyA.actor.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_3__["PreCollisionEvent"](this.bodyA.body.actor, this.bodyB.body.actor, side, this.mtv));
        bodyB.actor.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_3__["PreCollisionEvent"](this.bodyB.body.actor, this.bodyA.body.actor, _Util_Util__WEBPACK_IMPORTED_MODULE_4__["getOppositeSide"](side), this.mtv.negate()));
        // If any of the participants are passive then short circuit
        if (bodyA.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Passive || bodyB.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Passive) {
            return;
        }
        var invMassA = bodyA.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Fixed ? 0 : 1 / bodyA.mass;
        var invMassB = bodyB.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Fixed ? 0 : 1 / bodyB.mass;
        var invMoiA = bodyA.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Fixed ? 0 : 1 / bodyA.moi;
        var invMoiB = bodyB.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Fixed ? 0 : 1 / bodyB.moi;
        // average restitution more relistic
        var coefRestitution = Math.min(bodyA.restitution, bodyB.restitution);
        var coefFriction = Math.min(bodyA.friction, bodyB.friction);
        normal = normal.normalize();
        var tangent = normal.normal().normalize();
        var ra = this.point.sub(this.bodyA.getCenter()); // point relative to bodyA position
        var rb = this.point.sub(this.bodyB.getCenter()); /// point relative to bodyB
        // Relative velocity in linear terms
        // Angular to linear velocity formula -> omega = v/r
        var rv = bodyB.vel.add(rb.cross(-bodyB.rx)).sub(bodyA.vel.sub(ra.cross(bodyA.rx)));
        var rvNormal = rv.dot(normal);
        var rvTangent = rv.dot(tangent);
        var raTangent = ra.dot(tangent);
        var raNormal = ra.dot(normal);
        var rbTangent = rb.dot(tangent);
        var rbNormal = rb.dot(normal);
        // If objects are moving away ignore
        if (rvNormal > 0) {
            return;
        }
        // Collision impulse formula from Chris Hecker
        // https://en.wikipedia.org/wiki/Collision_response
        var impulse = -((1 + coefRestitution) * rvNormal) / (invMassA + invMassB + invMoiA * raTangent * raTangent + invMoiB * rbTangent * rbTangent);
        if (bodyA.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Fixed) {
            bodyB.vel = bodyB.vel.add(normal.scale(impulse * invMassB));
            if (_Physics__WEBPACK_IMPORTED_MODULE_2__["Physics"].allowRigidBodyRotation) {
                bodyB.rx -= impulse * invMoiB * -rb.cross(normal);
            }
            bodyB.addMtv(mtv);
        }
        else if (bodyB.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Fixed) {
            bodyA.vel = bodyA.vel.sub(normal.scale(impulse * invMassA));
            if (_Physics__WEBPACK_IMPORTED_MODULE_2__["Physics"].allowRigidBodyRotation) {
                bodyA.rx += impulse * invMoiA * -ra.cross(normal);
            }
            bodyA.addMtv(mtv.negate());
        }
        else {
            bodyB.vel = bodyB.vel.add(normal.scale(impulse * invMassB));
            bodyA.vel = bodyA.vel.sub(normal.scale(impulse * invMassA));
            if (_Physics__WEBPACK_IMPORTED_MODULE_2__["Physics"].allowRigidBodyRotation) {
                bodyB.rx -= impulse * invMoiB * -rb.cross(normal);
                bodyA.rx += impulse * invMoiA * -ra.cross(normal);
            }
            // Split the mtv in half for the two bodies, potentially we could do something smarter here
            bodyB.addMtv(mtv.scale(0.5));
            bodyA.addMtv(mtv.scale(-0.5));
        }
        // Friction portion of impulse
        if (coefFriction && rvTangent) {
            // Columb model of friction, formula for impulse due to friction from
            // https://en.wikipedia.org/wiki/Collision_response
            // tangent force exerted by body on another in contact
            var t = rv.sub(normal.scale(rv.dot(normal))).normalize();
            // impulse in the direction of tangent force
            var jt = rv.dot(t) / (invMassA + invMassB + raNormal * raNormal * invMoiA + rbNormal * rbNormal * invMoiB);
            var frictionImpulse = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](0, 0);
            if (Math.abs(jt) <= impulse * coefFriction) {
                frictionImpulse = t.scale(jt).negate();
            }
            else {
                frictionImpulse = t.scale(-impulse * coefFriction);
            }
            if (bodyA.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Fixed) {
                // apply frictional impulse
                bodyB.vel = bodyB.vel.add(frictionImpulse.scale(invMassB));
                if (_Physics__WEBPACK_IMPORTED_MODULE_2__["Physics"].allowRigidBodyRotation) {
                    bodyB.rx += frictionImpulse.dot(t) * invMoiB * rb.cross(t);
                }
            }
            else if (bodyB.actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Fixed) {
                // apply frictional impulse
                bodyA.vel = bodyA.vel.sub(frictionImpulse.scale(invMassA));
                if (_Physics__WEBPACK_IMPORTED_MODULE_2__["Physics"].allowRigidBodyRotation) {
                    bodyA.rx -= frictionImpulse.dot(t) * invMoiA * ra.cross(t);
                }
            }
            else {
                // apply frictional impulse
                bodyB.vel = bodyB.vel.add(frictionImpulse.scale(invMassB));
                bodyA.vel = bodyA.vel.sub(frictionImpulse.scale(invMassA));
                // apply frictional impulse
                if (_Physics__WEBPACK_IMPORTED_MODULE_2__["Physics"].allowRigidBodyRotation) {
                    bodyB.rx += frictionImpulse.dot(t) * invMoiB * rb.cross(t);
                    bodyA.rx -= frictionImpulse.dot(t) * invMoiA * ra.cross(t);
                }
            }
        }
        bodyA.actor.emit('postcollision', new _Events__WEBPACK_IMPORTED_MODULE_3__["PostCollisionEvent"](this.bodyA.body.actor, this.bodyB.body.actor, side, this.mtv));
        bodyB.actor.emit('postcollision', new _Events__WEBPACK_IMPORTED_MODULE_3__["PostCollisionEvent"](this.bodyB.body.actor, this.bodyA.body.actor, _Util_Util__WEBPACK_IMPORTED_MODULE_4__["getOppositeSide"](side), this.mtv.negate()));
    };
    return CollisionContact;
}());



/***/ }),

/***/ "./Collision/CollisionJumpTable.ts":
/*!*****************************************!*\
  !*** ./Collision/CollisionJumpTable.ts ***!
  \*****************************************/
/*! exports provided: CollisionJumpTable */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CollisionJumpTable", function() { return CollisionJumpTable; });
/* harmony import */ var _CollisionContact__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CollisionContact */ "./Collision/CollisionContact.ts");
/* harmony import */ var _PolygonArea__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./PolygonArea */ "./Collision/PolygonArea.ts");


var CollisionJumpTable = {
    CollideCircleCircle: function (circleA, circleB) {
        var radius = circleA.radius + circleB.radius;
        var circleAPos = circleA.body.pos.add(circleA.pos);
        var circleBPos = circleB.body.pos.add(circleB.pos);
        if (circleAPos.distance(circleBPos) > radius) {
            return null;
        }
        var axisOfCollision = circleBPos.sub(circleAPos).normalize();
        var mvt = axisOfCollision.scale(radius - circleBPos.distance(circleAPos));
        var pointOfCollision = circleA.getFurthestPoint(axisOfCollision);
        return new _CollisionContact__WEBPACK_IMPORTED_MODULE_0__["CollisionContact"](circleA, circleB, mvt, pointOfCollision, axisOfCollision);
    },
    CollideCirclePolygon: function (circle, polygon) {
        var minAxis = circle.testSeparatingAxisTheorem(polygon);
        if (!minAxis) {
            return null;
        }
        // make sure that the minAxis is pointing away from circle
        var samedir = minAxis.dot(polygon.getCenter().sub(circle.getCenter()));
        minAxis = samedir < 0 ? minAxis.negate() : minAxis;
        var verts = [];
        var point1 = polygon.getFurthestPoint(minAxis.negate());
        var point2 = circle.getFurthestPoint(minAxis); //.add(cc);
        if (circle.contains(point1)) {
            verts.push(point1);
        }
        if (polygon.contains(point2)) {
            verts.push(point2);
        }
        if (verts.length === 0) {
            return null;
        }
        return new _CollisionContact__WEBPACK_IMPORTED_MODULE_0__["CollisionContact"](circle, polygon, minAxis, verts.length === 2 ? verts[0].average(verts[1]) : verts[0], minAxis.normalize());
    },
    CollideCircleEdge: function (circle, edge) {
        // center of the circle
        var cc = circle.getCenter();
        // vector in the direction of the edge
        var e = edge.end.sub(edge.begin);
        // amount of overlap with the circle's center along the edge direction
        var u = e.dot(edge.end.sub(cc));
        var v = e.dot(cc.sub(edge.begin));
        // Potential region A collision (circle is on the left side of the edge, before the beginning)
        if (v <= 0) {
            var da = edge.begin.sub(cc);
            var dda = da.dot(da); // quick and dirty way of calc'n distance in r^2 terms saves some sqrts
            // save some sqrts
            if (dda > circle.radius * circle.radius) {
                return null; // no collision
            }
            return new _CollisionContact__WEBPACK_IMPORTED_MODULE_0__["CollisionContact"](circle, edge, da.normalize().scale(circle.radius - Math.sqrt(dda)), edge.begin, da.normalize());
        }
        // Potential region B collision (circle is on the right side of the edge, after the end)
        if (u <= 0) {
            var db = edge.end.sub(cc);
            var ddb = db.dot(db);
            if (ddb > circle.radius * circle.radius) {
                return null;
            }
            return new _CollisionContact__WEBPACK_IMPORTED_MODULE_0__["CollisionContact"](circle, edge, db.normalize().scale(circle.radius - Math.sqrt(ddb)), edge.end, db.normalize());
        }
        // Otherwise potential region AB collision (circle is in the middle of the edge between the beginning and end)
        var den = e.dot(e);
        var pointOnEdge = edge.begin
            .scale(u)
            .add(edge.end.scale(v))
            .scale(1 / den);
        var d = cc.sub(pointOnEdge);
        var dd = d.dot(d);
        if (dd > circle.radius * circle.radius) {
            return null; // no collision
        }
        var n = e.perpendicular();
        // flip correct direction
        if (n.dot(cc.sub(edge.begin)) < 0) {
            n.x = -n.x;
            n.y = -n.y;
        }
        n = n.normalize();
        var mvt = n.scale(Math.abs(circle.radius - Math.sqrt(dd)));
        return new _CollisionContact__WEBPACK_IMPORTED_MODULE_0__["CollisionContact"](circle, edge, mvt.negate(), pointOnEdge, n.negate());
    },
    CollideEdgeEdge: function () {
        // Edge-edge collision doesn't make sense
        return null;
    },
    CollidePolygonEdge: function (polygon, edge) {
        // 3 cases:
        // (1) Polygon lands on the full face
        // (2) Polygon lands on the right point
        // (3) Polygon lands on the left point
        var e = edge.end.sub(edge.begin);
        var edgeNormal = e.normal();
        if (polygon.contains(edge.begin)) {
            var _a = polygon.getClosestFace(edge.begin), mtv = _a.distance, face = _a.face;
            if (mtv) {
                return new _CollisionContact__WEBPACK_IMPORTED_MODULE_0__["CollisionContact"](polygon, edge, mtv.negate(), edge.begin.add(mtv.negate()), face.normal().negate());
            }
        }
        if (polygon.contains(edge.end)) {
            var _b = polygon.getClosestFace(edge.end), mtv = _b.distance, face = _b.face;
            if (mtv) {
                return new _CollisionContact__WEBPACK_IMPORTED_MODULE_0__["CollisionContact"](polygon, edge, mtv.negate(), edge.end.add(mtv.negate()), face.normal().negate());
            }
        }
        var pc = polygon.getCenter();
        var ec = edge.getCenter();
        var dir = ec.sub(pc).normalize();
        // build a temporary polygon from the edge to use SAT
        var linePoly = new _PolygonArea__WEBPACK_IMPORTED_MODULE_1__["PolygonArea"]({
            points: [edge.begin, edge.end, edge.end.add(dir.scale(30)), edge.begin.add(dir.scale(30))]
        });
        var minAxis = polygon.testSeparatingAxisTheorem(linePoly);
        // no minAxis, no overlap, no collision
        if (!minAxis) {
            return null;
        }
        // flip the normal and axis to always have positive collisions
        edgeNormal = edgeNormal.dot(dir) < 0 ? edgeNormal.negate() : edgeNormal;
        minAxis = minAxis.dot(dir) < 0 ? minAxis.negate() : minAxis;
        return new _CollisionContact__WEBPACK_IMPORTED_MODULE_0__["CollisionContact"](polygon, edge, minAxis, polygon.getFurthestPoint(edgeNormal), edgeNormal);
    },
    CollidePolygonPolygon: function (polyA, polyB) {
        // do a SAT test to find a min axis if it exists
        var minAxis = polyA.testSeparatingAxisTheorem(polyB);
        // no overlap, no collision return null
        if (!minAxis) {
            return null;
        }
        // make sure that minAxis is pointing from A -> B
        var sameDir = minAxis.dot(polyB.getCenter().sub(polyA.getCenter()));
        minAxis = sameDir < 0 ? minAxis.negate() : minAxis;
        // find rough point of collision
        // todo this could be better
        var verts = [];
        var pointA = polyA.getFurthestPoint(minAxis);
        var pointB = polyB.getFurthestPoint(minAxis.negate());
        if (polyB.contains(pointA)) {
            verts.push(pointA);
        }
        if (polyA.contains(pointB)) {
            verts.push(pointB);
        }
        // no candidates, pick something
        if (verts.length === 0) {
            verts.push(pointB);
        }
        var contact = verts.length === 2 ? verts[0].add(verts[1]).scale(0.5) : verts[0];
        return new _CollisionContact__WEBPACK_IMPORTED_MODULE_0__["CollisionContact"](polyA, polyB, minAxis, contact, minAxis.normalize());
    }
};


/***/ }),

/***/ "./Collision/DynamicTree.ts":
/*!**********************************!*\
  !*** ./Collision/DynamicTree.ts ***!
  \**********************************/
/*! exports provided: TreeNode, DynamicTree */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TreeNode", function() { return TreeNode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DynamicTree", function() { return DynamicTree; });
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Physics */ "./Physics.ts");
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");



/**
 * Dynamic Tree Node used for tracking bounds within the tree
 */
var TreeNode = /** @class */ (function () {
    function TreeNode(parent) {
        this.parent = parent;
        this.parent = parent || null;
        this.body = null;
        this.bounds = new _BoundingBox__WEBPACK_IMPORTED_MODULE_1__["BoundingBox"]();
        this.left = null;
        this.right = null;
        this.height = 0;
    }
    TreeNode.prototype.isLeaf = function () {
        return !this.left && !this.right;
    };
    return TreeNode;
}());

/**
 * The DynamicTrees provides a spatial partiioning data structure for quickly querying for overlapping bounding boxes for
 * all tracked bodies. The worst case performance of this is O(n*log(n)) where n is the number of bodies in the tree.
 *
 * Internally the bounding boxes are organized as a balanced binary tree of bounding boxes, where the leaf nodes are tracked bodies.
 * Every non-leaf node is a bounding box that contains child bounding boxes.
 */
var DynamicTree = /** @class */ (function () {
    function DynamicTree(worldBounds) {
        if (worldBounds === void 0) { worldBounds = new _BoundingBox__WEBPACK_IMPORTED_MODULE_1__["BoundingBox"](-Number.MAX_VALUE, -Number.MAX_VALUE, Number.MAX_VALUE, Number.MAX_VALUE); }
        this.worldBounds = worldBounds;
        this.root = null;
        this.nodes = {};
    }
    /**
     * Inserts a node into the dynamic tree
     */
    DynamicTree.prototype._insert = function (leaf) {
        // If there are no nodes in the tree, make this the root leaf
        if (this.root === null) {
            this.root = leaf;
            this.root.parent = null;
            return;
        }
        // Search the tree for a node that is not a leaf and find the best place to insert
        var leafAABB = leaf.bounds;
        var currentRoot = this.root;
        while (!currentRoot.isLeaf()) {
            var left = currentRoot.left;
            var right = currentRoot.right;
            var area = currentRoot.bounds.getPerimeter();
            var combinedAABB = currentRoot.bounds.combine(leafAABB);
            var combinedArea = combinedAABB.getPerimeter();
            // Calculate cost heuristic for creating a new parent and leaf
            var cost = 2 * combinedArea;
            // Minimum cost of pushing the leaf down the tree
            var inheritanceCost = 2 * (combinedArea - area);
            // Cost of descending
            var leftCost = 0;
            var leftCombined = leafAABB.combine(left.bounds);
            var newArea;
            var oldArea;
            if (left.isLeaf()) {
                leftCost = leftCombined.getPerimeter() + inheritanceCost;
            }
            else {
                oldArea = left.bounds.getPerimeter();
                newArea = leftCombined.getPerimeter();
                leftCost = newArea - oldArea + inheritanceCost;
            }
            var rightCost = 0;
            var rightCombined = leafAABB.combine(right.bounds);
            if (right.isLeaf()) {
                rightCost = rightCombined.getPerimeter() + inheritanceCost;
            }
            else {
                oldArea = right.bounds.getPerimeter();
                newArea = rightCombined.getPerimeter();
                rightCost = newArea - oldArea + inheritanceCost;
            }
            // cost is acceptable
            if (cost < leftCost && cost < rightCost) {
                break;
            }
            // Descend to the depths
            if (leftCost < rightCost) {
                currentRoot = left;
            }
            else {
                currentRoot = right;
            }
        }
        // Create the new parent node and insert into the tree
        var oldParent = currentRoot.parent;
        var newParent = new TreeNode(oldParent);
        newParent.bounds = leafAABB.combine(currentRoot.bounds);
        newParent.height = currentRoot.height + 1;
        if (oldParent !== null) {
            // The sibling node was not the root
            if (oldParent.left === currentRoot) {
                oldParent.left = newParent;
            }
            else {
                oldParent.right = newParent;
            }
            newParent.left = currentRoot;
            newParent.right = leaf;
            currentRoot.parent = newParent;
            leaf.parent = newParent;
        }
        else {
            // The sibling node was the root
            newParent.left = currentRoot;
            newParent.right = leaf;
            currentRoot.parent = newParent;
            leaf.parent = newParent;
            this.root = newParent;
        }
        // Walk up the tree fixing heights and AABBs
        var currentNode = leaf.parent;
        while (currentNode) {
            currentNode = this._balance(currentNode);
            if (!currentNode.left) {
                throw new Error('Parent of current leaf cannot have a null left child' + currentNode);
            }
            if (!currentNode.right) {
                throw new Error('Parent of current leaf cannot have a null right child' + currentNode);
            }
            currentNode.height = 1 + Math.max(currentNode.left.height, currentNode.right.height);
            currentNode.bounds = currentNode.left.bounds.combine(currentNode.right.bounds);
            currentNode = currentNode.parent;
        }
    };
    /**
     * Removes a node from the dynamic tree
     */
    DynamicTree.prototype._remove = function (leaf) {
        if (leaf === this.root) {
            this.root = null;
            return;
        }
        var parent = leaf.parent;
        var grandParent = parent.parent;
        var sibling;
        if (parent.left === leaf) {
            sibling = parent.right;
        }
        else {
            sibling = parent.left;
        }
        if (grandParent) {
            if (grandParent.left === parent) {
                grandParent.left = sibling;
            }
            else {
                grandParent.right = sibling;
            }
            sibling.parent = grandParent;
            var currentNode = grandParent;
            while (currentNode) {
                currentNode = this._balance(currentNode);
                currentNode.bounds = currentNode.left.bounds.combine(currentNode.right.bounds);
                currentNode.height = 1 + Math.max(currentNode.left.height, currentNode.right.height);
                currentNode = currentNode.parent;
            }
        }
        else {
            this.root = sibling;
            sibling.parent = null;
        }
    };
    /**
     * Tracks a body in the dynamic tree
     */
    DynamicTree.prototype.trackBody = function (body) {
        var node = new TreeNode();
        node.body = body;
        node.bounds = body.getBounds();
        node.bounds.left -= 2;
        node.bounds.top -= 2;
        node.bounds.right += 2;
        node.bounds.bottom += 2;
        this.nodes[body.actor.id] = node;
        this._insert(node);
    };
    /**
     * Updates the dynamic tree given the current bounds of each body being tracked
     */
    DynamicTree.prototype.updateBody = function (body) {
        var node = this.nodes[body.actor.id];
        if (!node) {
            return false;
        }
        var b = body.getBounds();
        // if the body is outside the world no longer update it
        if (!this.worldBounds.contains(b)) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_2__["Logger"].getInstance().warn('Actor with id ' + body.actor.id + ' is outside the world bounds and will no longer be tracked for physics');
            this.untrackBody(body);
            return false;
        }
        if (node.bounds.contains(b)) {
            return false;
        }
        this._remove(node);
        b.left -= _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].boundsPadding;
        b.top -= _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].boundsPadding;
        b.right += _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].boundsPadding;
        b.bottom += _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].boundsPadding;
        var multdx = body.vel.x * _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].dynamicTreeVelocityMultiplyer;
        var multdy = body.vel.y * _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].dynamicTreeVelocityMultiplyer;
        if (multdx < 0) {
            b.left += multdx;
        }
        else {
            b.right += multdx;
        }
        if (multdy < 0) {
            b.top += multdy;
        }
        else {
            b.bottom += multdy;
        }
        node.bounds = b;
        this._insert(node);
        return true;
    };
    /**
     * Untracks a body from the dynamic tree
     */
    DynamicTree.prototype.untrackBody = function (body) {
        var node = this.nodes[body.actor.id];
        if (!node) {
            return;
        }
        this._remove(node);
        this.nodes[body.actor.id] = null;
        delete this.nodes[body.actor.id];
    };
    /**
     * Balances the tree about a node
     */
    DynamicTree.prototype._balance = function (node) {
        if (node === null) {
            throw new Error('Cannot balance at null node');
        }
        if (node.isLeaf() || node.height < 2) {
            return node;
        }
        var left = node.left;
        var right = node.right;
        var a = node;
        var b = left;
        var c = right;
        var d = left.left;
        var e = left.right;
        var f = right.left;
        var g = right.right;
        var balance = c.height - b.height;
        // Rotate c node up
        if (balance > 1) {
            // Swap the right node with it's parent
            c.left = a;
            c.parent = a.parent;
            a.parent = c;
            // The original node's old parent should point to the right node
            // this is mega confusing
            if (c.parent) {
                if (c.parent.left === a) {
                    c.parent.left = c;
                }
                else {
                    c.parent.right = c;
                }
            }
            else {
                this.root = c;
            }
            // Rotate
            if (f.height > g.height) {
                c.right = f;
                a.right = g;
                g.parent = a;
                a.bounds = b.bounds.combine(g.bounds);
                c.bounds = a.bounds.combine(f.bounds);
                a.height = 1 + Math.max(b.height, g.height);
                c.height = 1 + Math.max(a.height, f.height);
            }
            else {
                c.right = g;
                a.right = f;
                f.parent = a;
                a.bounds = b.bounds.combine(f.bounds);
                c.bounds = a.bounds.combine(g.bounds);
                a.height = 1 + Math.max(b.height, f.height);
                c.height = 1 + Math.max(a.height, g.height);
            }
            return c;
        }
        // Rotate left node up
        if (balance < -1) {
            // swap
            b.left = a;
            b.parent = a.parent;
            a.parent = b;
            // node's old parent should point to b
            if (b.parent) {
                if (b.parent.left === a) {
                    b.parent.left = b;
                }
                else {
                    if (b.parent.right !== a) {
                        throw 'Error rotating Dynamic Tree';
                    }
                    b.parent.right = b;
                }
            }
            else {
                this.root = b;
            }
            // rotate
            if (d.height > e.height) {
                b.right = d;
                a.left = e;
                e.parent = a;
                a.bounds = c.bounds.combine(e.bounds);
                b.bounds = a.bounds.combine(d.bounds);
                a.height = 1 + Math.max(c.height, e.height);
                b.height = 1 + Math.max(a.height, d.height);
            }
            else {
                b.right = e;
                a.left = d;
                d.parent = a;
                a.bounds = c.bounds.combine(d.bounds);
                b.bounds = a.bounds.combine(e.bounds);
                a.height = 1 + Math.max(c.height, d.height);
                b.height = 1 + Math.max(a.height, e.height);
            }
            return b;
        }
        return node;
    };
    /**
     * Returns the internal height of the tree, shorter trees are better. Performance drops as the tree grows
     */
    DynamicTree.prototype.getHeight = function () {
        if (this.root === null) {
            return 0;
        }
        return this.root.height;
    };
    /**
     * Queries the Dynamic Axis Aligned Tree for bodies that could be colliding with the provided body.
     *
     * In the query callback, it will be passed a potential collider. Returning true from this callback indicates
     * that you are complete with your query and you do not want to continue. Returning false will continue searching
     * the tree until all possible colliders have been returned.
     */
    DynamicTree.prototype.query = function (body, callback) {
        var bounds = body.getBounds();
        var helper = function (currentNode) {
            if (currentNode && currentNode.bounds.collides(bounds)) {
                if (currentNode.isLeaf() && currentNode.body !== body) {
                    if (callback.call(body, currentNode.body)) {
                        return true;
                    }
                }
                else {
                    return helper(currentNode.left) || helper(currentNode.right);
                }
            }
            return false;
        };
        helper(this.root);
    };
    /**
     * Queries the Dynamic Axis Aligned Tree for bodies that could be intersecting. By default the raycast query uses an infinitely
     * long ray to test the tree specified by `max`.
     *
     * In the query callback, it will be passed a potential body that intersects with the racast. Returning true from this
     * callback indicates that your are complete with your query and do not want to continue. Return false will continue searching
     * the tree until all possible bodies that would intersect with the ray have been returned.
     */
    DynamicTree.prototype.rayCastQuery = function (ray, max, callback) {
        if (max === void 0) { max = Infinity; }
        var helper = function (currentNode) {
            if (currentNode && currentNode.bounds.rayCast(ray, max)) {
                if (currentNode.isLeaf()) {
                    if (callback.call(ray, currentNode.body)) {
                        // ray hit a leaf! return the body
                        return true;
                    }
                }
                else {
                    // ray hit but not at a leaf, recurse deeper
                    return helper(currentNode.left) || helper(currentNode.right);
                }
            }
            return false; // ray missed
        };
        helper(this.root);
    };
    DynamicTree.prototype.getNodes = function () {
        var helper = function (currentNode) {
            if (currentNode) {
                return [currentNode].concat(helper(currentNode.left), helper(currentNode.right));
            }
            else {
                return [];
            }
        };
        return helper(this.root);
    };
    DynamicTree.prototype.debugDraw = function (ctx) {
        // draw all the nodes in the Dynamic Tree
        var helper = function (currentNode) {
            if (currentNode) {
                if (currentNode.isLeaf()) {
                    ctx.lineWidth = 1;
                    ctx.strokeStyle = 'green';
                }
                else {
                    ctx.lineWidth = 1;
                    ctx.strokeStyle = 'white';
                }
                currentNode.bounds.debugDraw(ctx);
                if (currentNode.left) {
                    helper(currentNode.left);
                }
                if (currentNode.right) {
                    helper(currentNode.right);
                }
            }
        };
        helper(this.root);
    };
    return DynamicTree;
}());



/***/ }),

/***/ "./Collision/DynamicTreeCollisionBroadphase.ts":
/*!*****************************************************!*\
  !*** ./Collision/DynamicTreeCollisionBroadphase.ts ***!
  \*****************************************************/
/*! exports provided: DynamicTreeCollisionBroadphase */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DynamicTreeCollisionBroadphase", function() { return DynamicTreeCollisionBroadphase; });
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Physics */ "./Physics.ts");
/* harmony import */ var _DynamicTree__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DynamicTree */ "./Collision/DynamicTree.ts");
/* harmony import */ var _Pair__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Pair */ "./Collision/Pair.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Actor */ "./Actor.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Events */ "./Events.ts");







var DynamicTreeCollisionBroadphase = /** @class */ (function () {
    function DynamicTreeCollisionBroadphase() {
        this._dynamicCollisionTree = new _DynamicTree__WEBPACK_IMPORTED_MODULE_1__["DynamicTree"]();
        this._collisionHash = {};
        this._collisionPairCache = [];
        this._lastFramePairs = [];
        this._lastFramePairsHash = {};
    }
    /**
     * Tracks a physics body for collisions
     */
    DynamicTreeCollisionBroadphase.prototype.track = function (target) {
        if (!target) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_5__["Logger"].getInstance().warn('Cannot track null physics body');
            return;
        }
        this._dynamicCollisionTree.trackBody(target);
    };
    /**
     * Untracks a physics body
     */
    DynamicTreeCollisionBroadphase.prototype.untrack = function (target) {
        if (!target) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_5__["Logger"].getInstance().warn('Cannot untrack a null physics body');
            return;
        }
        this._dynamicCollisionTree.untrackBody(target);
    };
    DynamicTreeCollisionBroadphase.prototype._shouldGenerateCollisionPair = function (actorA, actorB) {
        // if the collision pair has been calculated already short circuit
        var hash = _Pair__WEBPACK_IMPORTED_MODULE_2__["Pair"].calculatePairHash(actorA.body, actorB.body);
        if (this._collisionHash[hash]) {
            return false; // pair exists easy exit return false
        }
        return _Pair__WEBPACK_IMPORTED_MODULE_2__["Pair"].canCollide(actorA, actorB);
    };
    /**
     * Detects potential collision pairs in a broadphase approach with the dynamic aabb tree strategy
     */
    DynamicTreeCollisionBroadphase.prototype.broadphase = function (targets, delta, stats) {
        var _this = this;
        var seconds = delta / 1000;
        // TODO optimization use only the actors that are moving to start
        // Retrieve the list of potential colliders, exclude killed, prevented, and self
        var potentialColliders = targets.filter(function (other) {
            return !other.isKilled() && other.collisionType !== _Actor__WEBPACK_IMPORTED_MODULE_4__["CollisionType"].PreventCollision;
        });
        // clear old list of collision pairs
        this._collisionPairCache = [];
        this._collisionHash = {};
        // check for normal collision pairs
        var actor;
        for (var j = 0, l = potentialColliders.length; j < l; j++) {
            actor = potentialColliders[j];
            // Query the collision tree for potential colliders
            this._dynamicCollisionTree.query(actor.body, function (other) {
                if (_this._shouldGenerateCollisionPair(actor, other.actor)) {
                    var pair = new _Pair__WEBPACK_IMPORTED_MODULE_2__["Pair"](actor.body, other);
                    _this._collisionHash[pair.id] = true;
                    _this._collisionPairCache.push(pair);
                }
                // Always return false, to query whole tree. Returning true in the query method stops searching
                return false;
            });
        }
        if (stats) {
            stats.physics.pairs = this._collisionPairCache.length;
        }
        // Check dynamic tree for fast moving objects
        // Fast moving objects are those moving at least there smallest bound per frame
        if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].checkForFastBodies) {
            for (var _i = 0, potentialColliders_1 = potentialColliders; _i < potentialColliders_1.length; _i++) {
                var actor = potentialColliders_1[_i];
                // Skip non-active objects. Does not make sense on other collison types
                if (actor.collisionType !== _Actor__WEBPACK_IMPORTED_MODULE_4__["CollisionType"].Active) {
                    continue;
                }
                // Maximum travel distance next frame
                var updateDistance = actor.vel.magnitude() * seconds + // velocity term
                    actor.acc.magnitude() * 0.5 * seconds * seconds; // acc term
                // Find the minimum dimension
                var minDimension = Math.min(actor.body.getBounds().getHeight(), actor.body.getBounds().getWidth());
                if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].disableMinimumSpeedForFastBody || updateDistance > minDimension / 2) {
                    if (stats) {
                        stats.physics.fastBodies++;
                    }
                    // start with the oldPos because the integration for actors has already happened
                    // objects resting on a surface may be slightly penatrating in the current position
                    var updateVec = actor.pos.sub(actor.oldPos);
                    var centerPoint = actor.body.collisionArea.getCenter();
                    var furthestPoint = actor.body.collisionArea.getFurthestPoint(actor.vel);
                    var origin = furthestPoint.sub(updateVec);
                    var ray = new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Ray"](origin, actor.vel);
                    // back the ray up by -2x surfaceEpsilon to account for fast moving objects starting on the surface
                    ray.pos = ray.pos.add(ray.dir.scale(-2 * _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].surfaceEpsilon));
                    var minBody;
                    var minTranslate = new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"](Infinity, Infinity);
                    this._dynamicCollisionTree.rayCastQuery(ray, updateDistance + _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].surfaceEpsilon * 2, function (other) {
                        if (actor.body !== other && other.collisionArea) {
                            var hitPoint = other.collisionArea.rayCast(ray, updateDistance + _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].surfaceEpsilon * 10);
                            if (hitPoint) {
                                var translate = hitPoint.sub(origin);
                                if (translate.magnitude() < minTranslate.magnitude()) {
                                    minTranslate = translate;
                                    minBody = other;
                                }
                            }
                        }
                        return false;
                    });
                    if (minBody && _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"].isValid(minTranslate)) {
                        var pair = new _Pair__WEBPACK_IMPORTED_MODULE_2__["Pair"](actor.body, minBody);
                        if (!this._collisionHash[pair.id]) {
                            this._collisionHash[pair.id] = true;
                            this._collisionPairCache.push(pair);
                        }
                        // move the fast moving object to the other body
                        // need to push into the surface by ex.Physics.surfaceEpsilon
                        var shift = centerPoint.sub(furthestPoint);
                        actor.pos = origin
                            .add(shift)
                            .add(minTranslate)
                            .add(ray.dir.scale(2 * _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].surfaceEpsilon));
                        actor.body.collisionArea.recalc();
                        if (stats) {
                            stats.physics.fastBodyCollisions++;
                        }
                    }
                }
            }
        }
        // return cache
        return this._collisionPairCache;
    };
    /**
     * Applies narrow phase on collision pairs to find actual area intersections
     * Adds actual colliding pairs to stats' Frame data
     */
    DynamicTreeCollisionBroadphase.prototype.narrowphase = function (pairs, stats) {
        for (var i = 0; i < pairs.length; i++) {
            pairs[i].collide();
            if (stats && pairs[i].collision) {
                stats.physics.collisions++;
                stats.physics.collidersHash[pairs[i].id] = pairs[i];
            }
        }
        return pairs.filter(function (p) { return p.collision; });
    };
    /**
     * Perform collision resolution given a strategy (rigid body or box) and move objects out of intersect.
     */
    DynamicTreeCollisionBroadphase.prototype.resolve = function (pairs, delta, strategy) {
        for (var _i = 0, pairs_1 = pairs; _i < pairs_1.length; _i++) {
            var pair = pairs_1[_i];
            pair.resolve(strategy);
            if (pair.collision) {
                pair.bodyA.applyMtv();
                pair.bodyB.applyMtv();
                // todo still don't like this, this is a small integration step to resolve narrowphase collisions
                pair.bodyA.actor.integrate(delta * _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].collisionShift);
                pair.bodyB.actor.integrate(delta * _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].collisionShift);
            }
        }
        return pairs.filter(function (p) { return p.canCollide; });
    };
    DynamicTreeCollisionBroadphase.prototype.runCollisionStartEnd = function (pairs) {
        var currentFrameHash = {};
        for (var _i = 0, pairs_2 = pairs; _i < pairs_2.length; _i++) {
            var p = pairs_2[_i];
            // load currentFrameHash
            currentFrameHash[p.id] = p;
            // find all new collisions
            if (!this._lastFramePairsHash[p.id]) {
                var actor1 = p.bodyA.actor;
                var actor2 = p.bodyB.actor;
                actor1.emit('collisionstart', new _Events__WEBPACK_IMPORTED_MODULE_6__["CollisionStartEvent"](actor1, actor2, p));
                actor2.emit('collisionstart', new _Events__WEBPACK_IMPORTED_MODULE_6__["CollisionStartEvent"](actor2, actor1, p));
            }
        }
        // find all old collisions
        for (var _a = 0, _b = this._lastFramePairs; _a < _b.length; _a++) {
            var p = _b[_a];
            if (!currentFrameHash[p.id]) {
                var actor1 = p.bodyA.actor;
                var actor2 = p.bodyB.actor;
                actor1.emit('collisionend', new _Events__WEBPACK_IMPORTED_MODULE_6__["CollisionEndEvent"](actor1, actor2));
                actor2.emit('collisionend', new _Events__WEBPACK_IMPORTED_MODULE_6__["CollisionEndEvent"](actor2, actor1));
            }
        }
        // reset the last frame cache
        this._lastFramePairs = pairs;
        this._lastFramePairsHash = currentFrameHash;
    };
    /**
     * Update the dynamic tree positions
     */
    DynamicTreeCollisionBroadphase.prototype.update = function (targets) {
        var updated = 0, i = 0, len = targets.length;
        for (i; i < len; i++) {
            if (this._dynamicCollisionTree.updateBody(targets[i].body)) {
                updated++;
            }
        }
        return updated;
    };
    /* istanbul ignore next */
    DynamicTreeCollisionBroadphase.prototype.debugDraw = function (ctx) {
        if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].broadphaseDebug) {
            this._dynamicCollisionTree.debugDraw(ctx);
        }
        if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].showContacts || _Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].showCollisionNormals) {
            for (var _i = 0, _a = this._collisionPairCache; _i < _a.length; _i++) {
                var pair = _a[_i];
                pair.debugDraw(ctx);
            }
        }
    };
    return DynamicTreeCollisionBroadphase;
}());



/***/ }),

/***/ "./Collision/EdgeArea.ts":
/*!*******************************!*\
  !*** ./Collision/EdgeArea.ts ***!
  \*******************************/
/*! exports provided: EdgeArea */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EdgeArea", function() { return EdgeArea; });
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CollisionJumpTable */ "./Collision/CollisionJumpTable.ts");
/* harmony import */ var _CircleArea__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CircleArea */ "./Collision/CircleArea.ts");
/* harmony import */ var _PolygonArea__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./PolygonArea */ "./Collision/PolygonArea.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Physics */ "./Physics.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Drawing/Color */ "./Drawing/Color.ts");







var EdgeArea = /** @class */ (function () {
    function EdgeArea(options) {
        this.begin = options.begin || _Algebra__WEBPACK_IMPORTED_MODULE_4__["Vector"].Zero.clone();
        this.end = options.end || _Algebra__WEBPACK_IMPORTED_MODULE_4__["Vector"].Zero.clone();
        this.body = options.body || null;
        this.pos = this.getCenter();
    }
    /**
     * Get the center of the collision area in world coordinates
     */
    EdgeArea.prototype.getCenter = function () {
        var pos = this.begin.average(this.end).add(this._getBodyPos());
        return pos;
    };
    EdgeArea.prototype._getBodyPos = function () {
        var bodyPos = _Algebra__WEBPACK_IMPORTED_MODULE_4__["Vector"].Zero.clone();
        if (this.body.pos) {
            bodyPos = this.body.pos;
        }
        return bodyPos;
    };
    EdgeArea.prototype._getTransformedBegin = function () {
        var angle = this.body ? this.body.rotation : 0;
        return this.begin.rotate(angle).add(this._getBodyPos());
    };
    EdgeArea.prototype._getTransformedEnd = function () {
        var angle = this.body ? this.body.rotation : 0;
        return this.end.rotate(angle).add(this._getBodyPos());
    };
    /**
     * Returns the slope of the line in the form of a vector
     */
    EdgeArea.prototype.getSlope = function () {
        var begin = this._getTransformedBegin();
        var end = this._getTransformedEnd();
        var distance = begin.distance(end);
        return end.sub(begin).scale(1 / distance);
    };
    /**
     * Returns the length of the line segment in pixels
     */
    EdgeArea.prototype.getLength = function () {
        var begin = this._getTransformedBegin();
        var end = this._getTransformedEnd();
        var distance = begin.distance(end);
        return distance;
    };
    /**
     * Tests if a point is contained in this collision area
     */
    EdgeArea.prototype.contains = function () {
        return false;
    };
    /**
     * @inheritdoc
     */
    EdgeArea.prototype.rayCast = function (ray, max) {
        if (max === void 0) { max = Infinity; }
        var numerator = this._getTransformedBegin().sub(ray.pos);
        // Test is line and ray are parallel and non intersecting
        if (ray.dir.cross(this.getSlope()) === 0 && numerator.cross(ray.dir) !== 0) {
            return null;
        }
        // Lines are parallel
        var divisor = ray.dir.cross(this.getSlope());
        if (divisor === 0) {
            return null;
        }
        var t = numerator.cross(this.getSlope()) / divisor;
        if (t >= 0 && t <= max) {
            var u = numerator.cross(ray.dir) / divisor / this.getLength();
            if (u >= 0 && u <= 1) {
                return ray.getPoint(t);
            }
        }
        return null;
    };
    /**
     * @inheritdoc
     */
    EdgeArea.prototype.collide = function (area) {
        if (area instanceof _CircleArea__WEBPACK_IMPORTED_MODULE_2__["CircleArea"]) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_1__["CollisionJumpTable"].CollideCircleEdge(area, this);
        }
        else if (area instanceof _PolygonArea__WEBPACK_IMPORTED_MODULE_3__["PolygonArea"]) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_1__["CollisionJumpTable"].CollidePolygonEdge(area, this);
        }
        else if (area instanceof EdgeArea) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_1__["CollisionJumpTable"].CollideEdgeEdge();
        }
        else {
            throw new Error("Edge could not collide with unknown ICollisionArea " + typeof area);
        }
    };
    /**
     * Find the point on the shape furthest in the direction specified
     */
    EdgeArea.prototype.getFurthestPoint = function (direction) {
        var transformedBegin = this._getTransformedBegin();
        var transformedEnd = this._getTransformedEnd();
        if (direction.dot(transformedBegin) > 0) {
            return transformedBegin;
        }
        else {
            return transformedEnd;
        }
    };
    /**
     * Get the axis aligned bounding box for the circle area
     */
    EdgeArea.prototype.getBounds = function () {
        var transformedBegin = this._getTransformedBegin();
        var transformedEnd = this._getTransformedEnd();
        return new _BoundingBox__WEBPACK_IMPORTED_MODULE_0__["BoundingBox"](Math.min(transformedBegin.x, transformedEnd.x), Math.min(transformedBegin.y, transformedEnd.y), Math.max(transformedBegin.x, transformedEnd.x), Math.max(transformedBegin.y, transformedEnd.y));
    };
    /**
     * Get the axis associated with the edge
     */
    EdgeArea.prototype.getAxes = function () {
        var e = this._getTransformedEnd().sub(this._getTransformedBegin());
        var edgeNormal = e.normal();
        var axes = [];
        axes.push(edgeNormal);
        axes.push(edgeNormal.negate());
        axes.push(edgeNormal.normal());
        axes.push(edgeNormal.normal().negate());
        return axes;
    };
    /**
     * Get the moment of inertia for an edge
     * https://en.wikipedia.org/wiki/List_of_moments_of_inertia
     */
    EdgeArea.prototype.getMomentOfInertia = function () {
        var mass = this.body ? this.body.mass : _Physics__WEBPACK_IMPORTED_MODULE_5__["Physics"].defaultMass;
        var length = this.end.sub(this.begin).distance() / 2;
        return mass * length * length;
    };
    /**
     * @inheritdoc
     */
    EdgeArea.prototype.recalc = function () {
        // edges don't have any cached data
    };
    /**
     * Project the edge along a specified axis
     */
    EdgeArea.prototype.project = function (axis) {
        var scalars = [];
        var points = [this._getTransformedBegin(), this._getTransformedEnd()];
        var len = points.length;
        for (var i = 0; i < len; i++) {
            scalars.push(points[i].dot(axis));
        }
        return new _Algebra__WEBPACK_IMPORTED_MODULE_4__["Projection"](Math.min.apply(Math, scalars), Math.max.apply(Math, scalars));
    };
    /* istanbul ignore next */
    EdgeArea.prototype.debugDraw = function (ctx, color) {
        if (color === void 0) { color = _Drawing_Color__WEBPACK_IMPORTED_MODULE_6__["Color"].Red.clone(); }
        ctx.strokeStyle = color.toString();
        ctx.beginPath();
        ctx.moveTo(this.begin.x, this.begin.y);
        ctx.lineTo(this.end.x, this.end.y);
        ctx.closePath();
        ctx.stroke();
    };
    return EdgeArea;
}());



/***/ }),

/***/ "./Collision/Index.ts":
/*!****************************!*\
  !*** ./Collision/Index.ts ***!
  \****************************/
/*! exports provided: Body, BoundingBox, CircleArea, CollisionContact, CollisionJumpTable, TreeNode, DynamicTree, DynamicTreeCollisionBroadphase, EdgeArea, NaiveCollisionBroadphase, Pair, PolygonArea, Side */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Body__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Body */ "./Collision/Body.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Body", function() { return _Body__WEBPACK_IMPORTED_MODULE_0__["Body"]; });

/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BoundingBox", function() { return _BoundingBox__WEBPACK_IMPORTED_MODULE_1__["BoundingBox"]; });

/* harmony import */ var _CircleArea__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./CircleArea */ "./Collision/CircleArea.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CircleArea", function() { return _CircleArea__WEBPACK_IMPORTED_MODULE_2__["CircleArea"]; });

/* harmony import */ var _CollisionContact__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./CollisionContact */ "./Collision/CollisionContact.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CollisionContact", function() { return _CollisionContact__WEBPACK_IMPORTED_MODULE_3__["CollisionContact"]; });

/* harmony import */ var _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CollisionJumpTable */ "./Collision/CollisionJumpTable.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CollisionJumpTable", function() { return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_4__["CollisionJumpTable"]; });

/* harmony import */ var _DynamicTree__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./DynamicTree */ "./Collision/DynamicTree.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TreeNode", function() { return _DynamicTree__WEBPACK_IMPORTED_MODULE_5__["TreeNode"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DynamicTree", function() { return _DynamicTree__WEBPACK_IMPORTED_MODULE_5__["DynamicTree"]; });

/* harmony import */ var _DynamicTreeCollisionBroadphase__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./DynamicTreeCollisionBroadphase */ "./Collision/DynamicTreeCollisionBroadphase.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DynamicTreeCollisionBroadphase", function() { return _DynamicTreeCollisionBroadphase__WEBPACK_IMPORTED_MODULE_6__["DynamicTreeCollisionBroadphase"]; });

/* harmony import */ var _EdgeArea__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./EdgeArea */ "./Collision/EdgeArea.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EdgeArea", function() { return _EdgeArea__WEBPACK_IMPORTED_MODULE_7__["EdgeArea"]; });

/* harmony import */ var _NaiveCollisionBroadphase__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./NaiveCollisionBroadphase */ "./Collision/NaiveCollisionBroadphase.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NaiveCollisionBroadphase", function() { return _NaiveCollisionBroadphase__WEBPACK_IMPORTED_MODULE_8__["NaiveCollisionBroadphase"]; });

/* harmony import */ var _Pair__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Pair */ "./Collision/Pair.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Pair", function() { return _Pair__WEBPACK_IMPORTED_MODULE_9__["Pair"]; });

/* harmony import */ var _PolygonArea__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./PolygonArea */ "./Collision/PolygonArea.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PolygonArea", function() { return _PolygonArea__WEBPACK_IMPORTED_MODULE_10__["PolygonArea"]; });

/* harmony import */ var _Side__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Side */ "./Collision/Side.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Side", function() { return _Side__WEBPACK_IMPORTED_MODULE_11__["Side"]; });















/***/ }),

/***/ "./Collision/NaiveCollisionBroadphase.ts":
/*!***********************************************!*\
  !*** ./Collision/NaiveCollisionBroadphase.ts ***!
  \***********************************************/
/*! exports provided: NaiveCollisionBroadphase */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NaiveCollisionBroadphase", function() { return NaiveCollisionBroadphase; });
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Physics */ "./Physics.ts");
/* harmony import */ var _CollisionContact__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./CollisionContact */ "./Collision/CollisionContact.ts");
/* harmony import */ var _Pair__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Pair */ "./Collision/Pair.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./../Actor */ "./Actor.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Events */ "./Events.ts");





var NaiveCollisionBroadphase = /** @class */ (function () {
    function NaiveCollisionBroadphase() {
        this._lastFramePairs = [];
        this._lastFramePairsHash = {};
    }
    NaiveCollisionBroadphase.prototype.track = function () {
        // pass
    };
    NaiveCollisionBroadphase.prototype.untrack = function () {
        // pass
    };
    /**
     * Detects potential collision pairs in a broadphase approach with the dynamic aabb tree strategy
     */
    NaiveCollisionBroadphase.prototype.broadphase = function (targets) {
        // Retrieve the list of potential colliders, exclude killed, prevented, and self
        var potentialColliders = targets.filter(function (other) {
            return !other.isKilled() && other.collisionType !== _Actor__WEBPACK_IMPORTED_MODULE_3__["CollisionType"].PreventCollision;
        });
        var actor1;
        var actor2;
        var collisionPairs = [];
        for (var j = 0, l = potentialColliders.length; j < l; j++) {
            actor1 = potentialColliders[j];
            for (var i = j + 1; i < l; i++) {
                actor2 = potentialColliders[i];
                var minimumTranslationVector;
                if ((minimumTranslationVector = actor1.collides(actor2))) {
                    var pair = new _Pair__WEBPACK_IMPORTED_MODULE_2__["Pair"](actor1.body, actor2.body);
                    pair.collision = new _CollisionContact__WEBPACK_IMPORTED_MODULE_1__["CollisionContact"](actor1.collisionArea, actor2.collisionArea, minimumTranslationVector, actor1.pos, minimumTranslationVector);
                    if (!collisionPairs.some(function (cp) {
                        return cp.id === pair.id;
                    })) {
                        collisionPairs.push(pair);
                    }
                }
            }
        }
        return collisionPairs;
    };
    /**
     * Identify actual collisions from those pairs, and calculate collision impulse
     */
    NaiveCollisionBroadphase.prototype.narrowphase = function (pairs) {
        return pairs;
    };
    NaiveCollisionBroadphase.prototype.runCollisionStartEnd = function (pairs) {
        var currentFrameHash = {};
        for (var _i = 0, pairs_1 = pairs; _i < pairs_1.length; _i++) {
            var p = pairs_1[_i];
            // load currentFrameHash
            currentFrameHash[p.id] = p;
            // find all new collisions
            if (!this._lastFramePairsHash[p.id]) {
                var actor1 = p.bodyA.actor;
                var actor2 = p.bodyB.actor;
                actor1.emit('collisionstart', new _Events__WEBPACK_IMPORTED_MODULE_4__["CollisionStartEvent"](actor1, actor2, p));
                actor2.emit('collisionstart', new _Events__WEBPACK_IMPORTED_MODULE_4__["CollisionStartEvent"](actor2, actor1, p));
            }
        }
        // find all old collisions
        for (var _a = 0, _b = this._lastFramePairs; _a < _b.length; _a++) {
            var p = _b[_a];
            if (!currentFrameHash[p.id]) {
                var actor1 = p.bodyA.actor;
                var actor2 = p.bodyB.actor;
                actor1.emit('collisionend', new _Events__WEBPACK_IMPORTED_MODULE_4__["CollisionEndEvent"](actor1, actor2));
                actor2.emit('collisionend', new _Events__WEBPACK_IMPORTED_MODULE_4__["CollisionEndEvent"](actor2, actor1));
            }
        }
        // reset the last frame cache
        this._lastFramePairs = pairs;
        this._lastFramePairsHash = currentFrameHash;
    };
    /**
     * Resolve the position and velocity of the physics bodies
     */
    NaiveCollisionBroadphase.prototype.resolve = function (pairs) {
        for (var _i = 0, pairs_2 = pairs; _i < pairs_2.length; _i++) {
            var pair = pairs_2[_i];
            pair.resolve(_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].collisionResolutionStrategy);
        }
        return pairs.filter(function (p) { return p.canCollide; });
    };
    NaiveCollisionBroadphase.prototype.update = function () {
        return 0;
    };
    NaiveCollisionBroadphase.prototype.debugDraw = function () {
        return;
    };
    return NaiveCollisionBroadphase;
}());



/***/ }),

/***/ "./Collision/Pair.ts":
/*!***************************!*\
  !*** ./Collision/Pair.ts ***!
  \***************************/
/*! exports provided: Pair */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Pair", function() { return Pair; });
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Physics */ "./Physics.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Actor */ "./Actor.ts");
/* harmony import */ var _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Util/DrawUtil */ "./Util/DrawUtil.ts");




/**
 * Models a potential collision between 2 bodies
 */
var Pair = /** @class */ (function () {
    function Pair(bodyA, bodyB) {
        this.bodyA = bodyA;
        this.bodyB = bodyB;
        this.id = null;
        this.collision = null;
        this.id = Pair.calculatePairHash(bodyA, bodyB);
    }
    Pair.canCollide = function (actorA, actorB) {
        // if both are fixed short circuit
        if (actorA.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_2__["CollisionType"].Fixed && actorB.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_2__["CollisionType"].Fixed) {
            return false;
        }
        // if the either is prevent collision short circuit
        if (actorB.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_2__["CollisionType"].PreventCollision || actorA.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_2__["CollisionType"].PreventCollision) {
            return false;
        }
        // if either is dead short circuit
        if (actorA.isKilled() || actorB.isKilled()) {
            return false;
        }
        return true;
    };
    Object.defineProperty(Pair.prototype, "canCollide", {
        /**
         * Returns whether or not it is possible for the pairs to collide
         */
        get: function () {
            var actorA = this.bodyA.actor;
            var actorB = this.bodyB.actor;
            return Pair.canCollide(actorA, actorB);
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Runs the collison intersection logic on the members of this pair
     */
    Pair.prototype.collide = function () {
        this.collision = this.bodyA.collisionArea.collide(this.bodyB.collisionArea);
    };
    /**
     * Resovles the collision body position and velocity if a collision occured
     */
    Pair.prototype.resolve = function (strategy) {
        if (this.collision) {
            this.collision.resolve(strategy);
        }
    };
    /**
     * Calculates the unique pair hash id for this collision pair
     */
    Pair.calculatePairHash = function (bodyA, bodyB) {
        if (bodyA.actor.id < bodyB.actor.id) {
            return "#" + bodyA.actor.id + "+" + bodyB.actor.id;
        }
        else {
            return "#" + bodyB.actor.id + "+" + bodyA.actor.id;
        }
    };
    /* istanbul ignore next */
    Pair.prototype.debugDraw = function (ctx) {
        if (this.collision) {
            if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].showContacts) {
                _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_3__["point"](ctx, _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Red, this.collision.point);
            }
            if (_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].showCollisionNormals) {
                _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_3__["vector"](ctx, _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Cyan, this.collision.point, this.collision.normal, 30);
            }
        }
    };
    return Pair;
}());



/***/ }),

/***/ "./Collision/PolygonArea.ts":
/*!**********************************!*\
  !*** ./Collision/PolygonArea.ts ***!
  \**********************************/
/*! exports provided: PolygonArea */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PolygonArea", function() { return PolygonArea; });
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./../Physics */ "./Physics.ts");
/* harmony import */ var _BoundingBox__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _EdgeArea__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./EdgeArea */ "./Collision/EdgeArea.ts");
/* harmony import */ var _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./CollisionJumpTable */ "./Collision/CollisionJumpTable.ts");
/* harmony import */ var _CircleArea__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./CircleArea */ "./Collision/CircleArea.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./../Algebra */ "./Algebra.ts");







/**
 * Polygon collision area for detecting collisions for actors, or independently
 */
var PolygonArea = /** @class */ (function () {
    function PolygonArea(options) {
        this._transformedPoints = [];
        this._axes = [];
        this._sides = [];
        this.pos = options.pos || _Algebra__WEBPACK_IMPORTED_MODULE_6__["Vector"].Zero.clone();
        var winding = !!options.clockwiseWinding;
        this.points = (winding ? options.points.reverse() : options.points) || [];
        this.body = options.body || null;
        // calculate initial transformation
        this._calculateTransformation();
    }
    /**
     * Get the center of the collision area in world coordinates
     */
    PolygonArea.prototype.getCenter = function () {
        if (this.body) {
            return this.body.pos.add(this.pos);
        }
        return this.pos;
    };
    /**
     * Calculates the underlying transformation from the body relative space to world space
     */
    PolygonArea.prototype._calculateTransformation = function () {
        var pos = this.body ? this.body.pos.add(this.pos) : this.pos;
        var angle = this.body ? this.body.rotation : 0;
        var len = this.points.length;
        this._transformedPoints.length = 0; // clear out old transform
        for (var i = 0; i < len; i++) {
            this._transformedPoints[i] = this.points[i].rotate(angle).add(pos);
        }
    };
    /**
     * Gets the points that make up the polygon in world space, from actor relative space (if specified)
     */
    PolygonArea.prototype.getTransformedPoints = function () {
        if (!this._transformedPoints.length) {
            this._calculateTransformation();
        }
        return this._transformedPoints;
    };
    /**
     * Gets the sides of the polygon in world space
     */
    PolygonArea.prototype.getSides = function () {
        if (this._sides.length) {
            return this._sides;
        }
        var lines = [];
        var points = this.getTransformedPoints();
        var len = points.length;
        for (var i = 0; i < len; i++) {
            lines.push(new _Algebra__WEBPACK_IMPORTED_MODULE_6__["Line"](points[i], points[(i - 1 + len) % len]));
        }
        this._sides = lines;
        return this._sides;
    };
    PolygonArea.prototype.recalc = function () {
        this._sides.length = 0;
        this._axes.length = 0;
        this._transformedPoints.length = 0;
        this.getTransformedPoints();
        this.getAxes();
        this.getSides();
    };
    /**
     * Tests if a point is contained in this collision area in world space
     */
    PolygonArea.prototype.contains = function (point) {
        // Always cast to the right, as long as we cast in a consitent fixed direction we
        // will be fine
        var testRay = new _Algebra__WEBPACK_IMPORTED_MODULE_6__["Ray"](point, new _Algebra__WEBPACK_IMPORTED_MODULE_6__["Vector"](1, 0));
        var intersectCount = this.getSides().reduce(function (accum, side) {
            if (testRay.intersect(side) >= 0) {
                return accum + 1;
            }
            return accum;
        }, 0);
        if (intersectCount % 2 === 0) {
            return false;
        }
        return true;
    };
    /**
     * Returns a collision contact if the 2 collision areas collide, otherwise collide will
     * return null.
     * @param area
     */
    PolygonArea.prototype.collide = function (area) {
        if (area instanceof _CircleArea__WEBPACK_IMPORTED_MODULE_5__["CircleArea"]) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_4__["CollisionJumpTable"].CollideCirclePolygon(area, this);
        }
        else if (area instanceof PolygonArea) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_4__["CollisionJumpTable"].CollidePolygonPolygon(this, area);
        }
        else if (area instanceof _EdgeArea__WEBPACK_IMPORTED_MODULE_3__["EdgeArea"]) {
            return _CollisionJumpTable__WEBPACK_IMPORTED_MODULE_4__["CollisionJumpTable"].CollidePolygonEdge(this, area);
        }
        else {
            throw new Error("Polygon could not collide with unknown ICollisionArea " + typeof area);
        }
    };
    /**
     * Find the point on the shape furthest in the direction specified
     */
    PolygonArea.prototype.getFurthestPoint = function (direction) {
        var pts = this.getTransformedPoints();
        var furthestPoint = null;
        var maxDistance = -Number.MAX_VALUE;
        for (var i = 0; i < pts.length; i++) {
            var distance = direction.dot(pts[i]);
            if (distance > maxDistance) {
                maxDistance = distance;
                furthestPoint = pts[i];
            }
        }
        return furthestPoint;
    };
    /**
     * Finds the closes face to the point using perpendicular distance
     * @param point point to test against polygon
     */
    PolygonArea.prototype.getClosestFace = function (point) {
        var sides = this.getSides();
        var min = Number.POSITIVE_INFINITY;
        var faceIndex = -1;
        var distance = -1;
        for (var i = 0; i < sides.length; i++) {
            var dist = sides[i].distanceToPoint(point);
            if (dist < min) {
                min = dist;
                faceIndex = i;
                distance = dist;
            }
        }
        if (faceIndex !== -1) {
            return {
                distance: sides[faceIndex].normal().scale(distance),
                face: sides[faceIndex]
            };
        }
        return null;
    };
    /**
     * Get the axis aligned bounding box for the polygon area
     */
    PolygonArea.prototype.getBounds = function () {
        // todo there is a faster way to do this
        var points = this.getTransformedPoints();
        var minX = points.reduce(function (prev, curr) {
            return Math.min(prev, curr.x);
        }, 999999999);
        var maxX = points.reduce(function (prev, curr) {
            return Math.max(prev, curr.x);
        }, -99999999);
        var minY = points.reduce(function (prev, curr) {
            return Math.min(prev, curr.y);
        }, 9999999999);
        var maxY = points.reduce(function (prev, curr) {
            return Math.max(prev, curr.y);
        }, -9999999999);
        return new _BoundingBox__WEBPACK_IMPORTED_MODULE_2__["BoundingBox"](minX, minY, maxX, maxY);
    };
    /**
     * Get the moment of inertia for an arbitrary polygon
     * https://en.wikipedia.org/wiki/List_of_moments_of_inertia
     */
    PolygonArea.prototype.getMomentOfInertia = function () {
        var mass = this.body ? this.body.mass : _Physics__WEBPACK_IMPORTED_MODULE_1__["Physics"].defaultMass;
        var numerator = 0;
        var denominator = 0;
        for (var i = 0; i < this.points.length; i++) {
            var iplusone = (i + 1) % this.points.length;
            var crossTerm = this.points[iplusone].cross(this.points[i]);
            numerator +=
                crossTerm *
                    (this.points[i].dot(this.points[i]) + this.points[i].dot(this.points[iplusone]) + this.points[iplusone].dot(this.points[iplusone]));
            denominator += crossTerm;
        }
        return (mass / 6) * (numerator / denominator);
    };
    /**
     * Casts a ray into the polygon and returns a vector representing the point of contact (in world space) or null if no collision.
     */
    PolygonArea.prototype.rayCast = function (ray, max) {
        if (max === void 0) { max = Infinity; }
        // find the minimum contact time greater than 0
        // contact times less than 0 are behind the ray and we don't want those
        var sides = this.getSides();
        var len = sides.length;
        var minContactTime = Number.MAX_VALUE;
        var contactIndex = -1;
        for (var i = 0; i < len; i++) {
            var contactTime = ray.intersect(sides[i]);
            if (contactTime >= 0 && contactTime < minContactTime && contactTime <= max) {
                minContactTime = contactTime;
                contactIndex = i;
            }
        }
        // contact was found
        if (contactIndex >= 0) {
            return ray.getPoint(minContactTime);
        }
        // no contact found
        return null;
    };
    /**
     * Get the axis associated with the edge
     */
    PolygonArea.prototype.getAxes = function () {
        if (this._axes.length) {
            return this._axes;
        }
        var axes = [];
        var points = this.getTransformedPoints();
        var len = points.length;
        for (var i = 0; i < len; i++) {
            axes.push(points[i].sub(points[(i + 1) % len]).normal());
        }
        this._axes = axes;
        return this._axes;
    };
    /**
     * Perform Separating Axis test against another polygon, returns null if no overlap in polys
     * Reference http://www.dyn4j.org/2010/01/sat/
     */
    PolygonArea.prototype.testSeparatingAxisTheorem = function (other) {
        var poly1 = this;
        var poly2 = other;
        var axes = poly1.getAxes().concat(poly2.getAxes());
        var minOverlap = Number.MAX_VALUE;
        var minAxis = null;
        var minIndex = -1;
        for (var i = 0; i < axes.length; i++) {
            var proj1 = poly1.project(axes[i]);
            var proj2 = poly2.project(axes[i]);
            var overlap = proj1.getOverlap(proj2);
            if (overlap <= 0) {
                return null;
            }
            else {
                if (overlap < minOverlap) {
                    minOverlap = overlap;
                    minAxis = axes[i];
                    minIndex = i;
                }
            }
        }
        // Sanity check
        if (minIndex === -1) {
            return null;
        }
        return minAxis.normalize().scale(minOverlap);
    };
    /**
     * Project the edges of the polygon along a specified axis
     */
    PolygonArea.prototype.project = function (axis) {
        var points = this.getTransformedPoints();
        var len = points.length;
        var min = Number.MAX_VALUE;
        var max = -Number.MAX_VALUE;
        for (var i = 0; i < len; i++) {
            var scalar = points[i].dot(axis);
            min = Math.min(min, scalar);
            max = Math.max(max, scalar);
        }
        return new _Algebra__WEBPACK_IMPORTED_MODULE_6__["Projection"](min, max);
    };
    /* istanbul ignore next */
    PolygonArea.prototype.debugDraw = function (ctx, color) {
        if (color === void 0) { color = _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__["Color"].Red.clone(); }
        ctx.beginPath();
        ctx.strokeStyle = color.toString();
        // Iterate through the supplied points and construct a 'polygon'
        var firstPoint = this.getTransformedPoints()[0];
        ctx.moveTo(firstPoint.x, firstPoint.y);
        this.getTransformedPoints().forEach(function (point) {
            ctx.lineTo(point.x, point.y);
        });
        ctx.lineTo(firstPoint.x, firstPoint.y);
        ctx.closePath();
        ctx.stroke();
    };
    return PolygonArea;
}());



/***/ }),

/***/ "./Collision/Side.ts":
/*!***************************!*\
  !*** ./Collision/Side.ts ***!
  \***************************/
/*! exports provided: Side */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Side", function() { return Side; });
/**
 * An enum that describes the sides of an Actor for collision
 */
var Side;
(function (Side) {
    Side[Side["None"] = 0] = "None";
    Side[Side["Top"] = 1] = "Top";
    Side[Side["Bottom"] = 2] = "Bottom";
    Side[Side["Left"] = 3] = "Left";
    Side[Side["Right"] = 4] = "Right";
})(Side || (Side = {}));


/***/ }),

/***/ "./Configurable.ts":
/*!*************************!*\
  !*** ./Configurable.ts ***!
  \*************************/
/*! exports provided: Configurable */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Configurable", function() { return Configurable; });
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
function Configurable(base) {
    return /** @class */ (function (_super) {
        __extends(class_1, _super);
        function class_1() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var _this = _super.apply(this, args) || this;
            //get the number of arguments that aren't undefined. TS passes a value to all parameters
            //of whatever ctor is the implementation, so args.length doesn't work here.
            var size = args.filter(function (value) {
                return value !== undefined;
            }).length;
            if (size === 1 && args[0] && typeof args[0] === 'object' && !(args[0] instanceof Array)) {
                _this.assign(args[0]);
            }
            return _this;
        }
        class_1.prototype.assign = function (props) {
            //set the value of every property that was passed in,
            //if the constructor previously set this value, it will be overridden here
            for (var k in props) {
                if (typeof this[k] !== 'function') {
                    this[k] = props[k];
                }
            }
        };
        return class_1;
    }(base));
}


/***/ }),

/***/ "./Debug.ts":
/*!******************!*\
  !*** ./Debug.ts ***!
  \******************/
/*! exports provided: Debug, FrameStats, PhysicsStats */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Debug", function() { return Debug; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FrameStats", function() { return FrameStats; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PhysicsStats", function() { return PhysicsStats; });
/**
 * Debug statistics and flags for Excalibur. If polling these values, it would be
 * best to do so on the `postupdate` event for [[Engine]], after all values have been
 * updated during a frame.
 */
var Debug = /** @class */ (function () {
    function Debug() {
        /**
         * Performance statistics
         */
        this.stats = {
            /**
             * Current frame statistics. Engine reuses this instance, use [[FrameStats.clone]] to copy frame stats.
             * Best accessed on [[postframe]] event. See [[IFrameStats]]
             */
            currFrame: new FrameStats(),
            /**
             * Previous frame statistics. Engine reuses this instance, use [[FrameStats.clone]] to copy frame stats.
             * Best accessed on [[preframe]] event. Best inspected on engine event `preframe`. See [[IFrameStats]]
             */
            prevFrame: new FrameStats()
        };
    }
    return Debug;
}());

/**
 * Implementation of a frame's stats. Meant to have values copied via [[FrameStats.reset]], avoid
 * creating instances of this every frame.
 */
var FrameStats = /** @class */ (function () {
    function FrameStats() {
        this._id = 0;
        this._delta = 0;
        this._fps = 0;
        this._actorStats = {
            alive: 0,
            killed: 0,
            ui: 0,
            get remaining() {
                return this.alive - this.killed;
            },
            get total() {
                return this.remaining + this.ui;
            }
        };
        this._durationStats = {
            update: 0,
            draw: 0,
            get total() {
                return this.update + this.draw;
            }
        };
        this._physicsStats = new PhysicsStats();
    }
    /**
     * Zero out values or clone other IFrameStat stats. Allows instance reuse.
     *
     * @param [otherStats] Optional stats to clone
     */
    FrameStats.prototype.reset = function (otherStats) {
        if (otherStats) {
            this.id = otherStats.id;
            this.delta = otherStats.delta;
            this.fps = otherStats.fps;
            this.actors.alive = otherStats.actors.alive;
            this.actors.killed = otherStats.actors.killed;
            this.actors.ui = otherStats.actors.ui;
            this.duration.update = otherStats.duration.update;
            this.duration.draw = otherStats.duration.draw;
            this._physicsStats.reset(otherStats.physics);
        }
        else {
            this.id = this.delta = this.fps = 0;
            this.actors.alive = this.actors.killed = this.actors.ui = 0;
            this.duration.update = this.duration.draw = 0;
            this._physicsStats.reset();
        }
    };
    /**
     * Provides a clone of this instance.
     */
    FrameStats.prototype.clone = function () {
        var fs = new FrameStats();
        fs.reset(this);
        return fs;
    };
    Object.defineProperty(FrameStats.prototype, "id", {
        /**
         * Gets the frame's id
         */
        get: function () {
            return this._id;
        },
        /**
         * Sets the frame's id
         */
        set: function (value) {
            this._id = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FrameStats.prototype, "delta", {
        /**
         * Gets the frame's delta (time since last frame)
         */
        get: function () {
            return this._delta;
        },
        /**
         * Sets the frame's delta (time since last frame). Internal use only.
         * @internal
         */
        set: function (value) {
            this._delta = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FrameStats.prototype, "fps", {
        /**
         * Gets the frame's frames-per-second (FPS)
         */
        get: function () {
            return this._fps;
        },
        /**
         * Sets the frame's frames-per-second (FPS). Internal use only.
         * @internal
         */
        set: function (value) {
            this._fps = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FrameStats.prototype, "actors", {
        /**
         * Gets the frame's actor statistics
         */
        get: function () {
            return this._actorStats;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FrameStats.prototype, "duration", {
        /**
         * Gets the frame's duration statistics
         */
        get: function () {
            return this._durationStats;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FrameStats.prototype, "physics", {
        /**
         * Gets the frame's physics statistics
         */
        get: function () {
            return this._physicsStats;
        },
        enumerable: true,
        configurable: true
    });
    return FrameStats;
}());

var PhysicsStats = /** @class */ (function () {
    function PhysicsStats() {
        this._pairs = 0;
        this._collisions = 0;
        this._collidersHash = {};
        this._fastBodies = 0;
        this._fastBodyCollisions = 0;
        this._broadphase = 0;
        this._narrowphase = 0;
    }
    /**
     * Zero out values or clone other IPhysicsStats stats. Allows instance reuse.
     *
     * @param [otherStats] Optional stats to clone
     */
    PhysicsStats.prototype.reset = function (otherStats) {
        if (otherStats) {
            this.pairs = otherStats.pairs;
            this.collisions = otherStats.collisions;
            this.collidersHash = otherStats.collidersHash;
            this.fastBodies = otherStats.fastBodies;
            this.fastBodyCollisions = otherStats.fastBodyCollisions;
            this.broadphase = otherStats.broadphase;
            this.narrowphase = otherStats.narrowphase;
        }
        else {
            this.pairs = this.collisions = this.fastBodies = 0;
            this.fastBodyCollisions = this.broadphase = this.narrowphase = 0;
            this.collidersHash = {};
        }
    };
    /**
     * Provides a clone of this instance.
     */
    PhysicsStats.prototype.clone = function () {
        var ps = new PhysicsStats();
        ps.reset(this);
        return ps;
    };
    Object.defineProperty(PhysicsStats.prototype, "pairs", {
        get: function () {
            return this._pairs;
        },
        set: function (value) {
            this._pairs = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PhysicsStats.prototype, "collisions", {
        get: function () {
            return this._collisions;
        },
        set: function (value) {
            this._collisions = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PhysicsStats.prototype, "collidersHash", {
        get: function () {
            return this._collidersHash;
        },
        set: function (colliders) {
            this._collidersHash = colliders;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PhysicsStats.prototype, "fastBodies", {
        get: function () {
            return this._fastBodies;
        },
        set: function (value) {
            this._fastBodies = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PhysicsStats.prototype, "fastBodyCollisions", {
        get: function () {
            return this._fastBodyCollisions;
        },
        set: function (value) {
            this._fastBodyCollisions = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PhysicsStats.prototype, "broadphase", {
        get: function () {
            return this._broadphase;
        },
        set: function (value) {
            this._broadphase = value;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PhysicsStats.prototype, "narrowphase", {
        get: function () {
            return this._narrowphase;
        },
        set: function (value) {
            this._narrowphase = value;
        },
        enumerable: true,
        configurable: true
    });
    return PhysicsStats;
}());



/***/ }),

/***/ "./Drawing/Animation.ts":
/*!******************************!*\
  !*** ./Drawing/Animation.ts ***!
  \******************************/
/*! exports provided: AnimationImpl, Animation */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AnimationImpl", function() { return AnimationImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Animation", function() { return Animation; });
/* harmony import */ var _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpriteEffects */ "./Drawing/SpriteEffects.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Engine__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Engine */ "./Engine.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");
/* harmony import */ var _Configurable__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Configurable */ "./Configurable.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





/**
 * @hidden
 */
var AnimationImpl = /** @class */ (function () {
    /**
     * Typically you will use a [[SpriteSheet]] to generate an [[Animation]].
     *
     * @param engine  Reference to the current game engine
     * @param images  An array of sprites to create the frames for the animation
     * @param speed   The number in milliseconds to display each frame in the animation
     * @param loop    Indicates whether the animation should loop after it is completed
     */
    function AnimationImpl(engineOrConfig, sprites, speed, loop) {
        /**
         * The sprite frames to play, in order. See [[SpriteSheet.getAnimationForAll]] to quickly
         * generate an [[Animation]].
         */
        this.sprites = [];
        /**
         * Current frame index being shown
         */
        this.currentFrame = 0;
        this._oldTime = Date.now();
        this.anchor = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](0.0, 0.0);
        this.rotation = 0.0;
        this.scale = new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](1, 1);
        /**
         * Indicates whether the animation should loop after it is completed
         */
        this.loop = true;
        /**
         * Indicates the frame index the animation should freeze on for a non-looping
         * animation. By default it is the last frame.
         */
        this.freezeFrame = -1;
        /**
         * Flip each frame vertically. Sets [[Sprite.flipVertical]].
         */
        this.flipVertical = false;
        /**
         * Flip each frame horizontally. Sets [[Sprite.flipHorizontal]].
         */
        this.flipHorizontal = false;
        this.drawWidth = 0;
        this.drawHeight = 0;
        this.width = 0;
        this.height = 0;
        var engine = engineOrConfig;
        if (engineOrConfig && !(engineOrConfig instanceof _Engine__WEBPACK_IMPORTED_MODULE_2__["Engine"])) {
            var config = engineOrConfig;
            engine = config.engine;
            sprites = config.sprites;
            speed = config.speed;
            loop = config.loop;
        }
        this.sprites = sprites;
        this.speed = speed;
        this._engine = engine;
        if (loop != null) {
            this.loop = loop;
        }
        if (sprites && sprites[0]) {
            this.drawHeight = sprites[0] ? sprites[0].drawHeight : 0;
            this.drawWidth = sprites[0] ? sprites[0].drawWidth : 0;
            this.width = sprites[0] ? sprites[0].width : 0;
            this.height = sprites[0] ? sprites[0].height : 0;
            this.freezeFrame = sprites.length - 1;
        }
    }
    /**
     * Applies the opacity effect to a sprite, setting the alpha of all pixels to a given value
     */
    AnimationImpl.prototype.opacity = function (value) {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Opacity"](value));
    };
    /**
     * Applies the grayscale effect to a sprite, removing color information.
     */
    AnimationImpl.prototype.grayscale = function () {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Grayscale"]());
    };
    /**
     * Applies the invert effect to a sprite, inverting the pixel colors.
     */
    AnimationImpl.prototype.invert = function () {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Invert"]());
    };
    /**
     * Applies the fill effect to a sprite, changing the color channels of all non-transparent pixels to match a given color
     */
    AnimationImpl.prototype.fill = function (color) {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Fill"](color));
    };
    /**
     * Applies the colorize effect to a sprite, changing the color channels of all pixels to be the average of the original color and the
     * provided color.
     */
    AnimationImpl.prototype.colorize = function (color) {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Colorize"](color));
    };
    /**
     * Applies the lighten effect to a sprite, changes the lightness of the color according to hsl
     */
    AnimationImpl.prototype.lighten = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Lighten"](factor));
    };
    /**
     * Applies the darken effect to a sprite, changes the darkness of the color according to hsl
     */
    AnimationImpl.prototype.darken = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Darken"](factor));
    };
    /**
     * Applies the saturate effect to a sprite, saturates the color according to hsl
     */
    AnimationImpl.prototype.saturate = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Saturate"](factor));
    };
    /**
     * Applies the desaturate effect to a sprite, desaturates the color according to hsl
     */
    AnimationImpl.prototype.desaturate = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Desaturate"](factor));
    };
    /**
     * Add a [[ISpriteEffect]] manually
     */
    AnimationImpl.prototype.addEffect = function (effect) {
        for (var i in this.sprites) {
            this.sprites[i].addEffect(effect);
        }
    };
    AnimationImpl.prototype.removeEffect = function (param) {
        for (var i in this.sprites) {
            this.sprites[i].removeEffect(param);
        }
    };
    /**
     * Clear all sprite effects
     */
    AnimationImpl.prototype.clearEffects = function () {
        for (var i in this.sprites) {
            this.sprites[i].clearEffects();
        }
    };
    AnimationImpl.prototype._setAnchor = function (point) {
        //if (!this.anchor.equals(point)) {
        for (var i in this.sprites) {
            this.sprites[i].anchor.setTo(point.x, point.y);
        }
        //}
    };
    AnimationImpl.prototype._setRotation = function (radians) {
        //if (this.rotation !== radians) {
        for (var i in this.sprites) {
            this.sprites[i].rotation = radians;
        }
        //}
    };
    AnimationImpl.prototype._setScale = function (scale) {
        //if (!this.scale.equals(scale)) {
        for (var i in this.sprites) {
            this.sprites[i].scale = scale;
        }
        //}
    };
    /**
     * Resets the animation to first frame.
     */
    AnimationImpl.prototype.reset = function () {
        this.currentFrame = 0;
    };
    /**
     * Indicates whether the animation is complete, animations that loop are never complete.
     */
    AnimationImpl.prototype.isDone = function () {
        return !this.loop && this.currentFrame >= this.sprites.length;
    };
    /**
     * Not meant to be called by game developers. Ticks the animation forward internally and
     * calculates whether to change to the frame.
     * @internal
     */
    AnimationImpl.prototype.tick = function () {
        var time = Date.now();
        if (time - this._oldTime > this.speed) {
            this.currentFrame = this.loop ? (this.currentFrame + 1) % this.sprites.length : this.currentFrame + 1;
            this._oldTime = time;
        }
    };
    AnimationImpl.prototype._updateValues = function () {
        this._setAnchor(this.anchor);
        this._setRotation(this.rotation);
        this._setScale(this.scale);
    };
    /**
     * Skips ahead a specified number of frames in the animation
     * @param frames  Frames to skip ahead
     */
    AnimationImpl.prototype.skip = function (frames) {
        this.currentFrame = (this.currentFrame + frames) % this.sprites.length;
    };
    AnimationImpl.prototype.draw = function (ctx, x, y) {
        this.tick();
        this._updateValues();
        var currSprite;
        if (this.currentFrame < this.sprites.length) {
            currSprite = this.sprites[this.currentFrame];
            if (this.flipVertical) {
                currSprite.flipVertical = this.flipVertical;
            }
            if (this.flipHorizontal) {
                currSprite.flipHorizontal = this.flipHorizontal;
            }
            currSprite.draw(ctx, x, y);
        }
        if (this.freezeFrame !== -1 && this.currentFrame >= this.sprites.length) {
            currSprite = this.sprites[_Util_Util__WEBPACK_IMPORTED_MODULE_3__["clamp"](this.freezeFrame, 0, this.sprites.length - 1)];
            currSprite.draw(ctx, x, y);
        }
        // add the calculated width
        if (currSprite) {
            this.drawWidth = currSprite.drawWidth;
            this.drawHeight = currSprite.drawHeight;
        }
    };
    /**
     * Plays an animation at an arbitrary location in the game.
     * @param x  The x position in the game to play
     * @param y  The y position in the game to play
     */
    AnimationImpl.prototype.play = function (x, y) {
        this.reset();
        this._engine.playAnimation(this, x, y);
    };
    return AnimationImpl;
}());

/**
 * Animations allow you to display a series of images one after another,
 * creating the illusion of change. Generally these images will come from a [[SpriteSheet]] source.
 *
 * [[include:Animations.md]]
 */
var Animation = /** @class */ (function (_super) {
    __extends(Animation, _super);
    function Animation(engineOrConfig, images, speed, loop) {
        return _super.call(this, engineOrConfig, images, speed, loop) || this;
    }
    return Animation;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_4__["Configurable"])(AnimationImpl)));



/***/ }),

/***/ "./Drawing/Color.ts":
/*!**************************!*\
  !*** ./Drawing/Color.ts ***!
  \**************************/
/*! exports provided: Color */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Color", function() { return Color; });
/**
 * Provides standard colors (e.g. [[Color.Black]])
 * but you can also create custom colors using RGB, HSL, or Hex. Also provides
 * useful color operations like [[Color.lighten]], [[Color.darken]], and more.
 *
 * [[include:Colors.md]]
 */
var Color = /** @class */ (function () {
    /**
     * Creates a new instance of Color from an r, g, b, a
     *
     * @param r  The red component of color (0-255)
     * @param g  The green component of color (0-255)
     * @param b  The blue component of color (0-255)
     * @param a  The alpha component of color (0-1.0)
     */
    function Color(r, g, b, a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a != null ? a : 1;
    }
    /**
     * Creates a new instance of Color from an r, g, b, a
     *
     * @param r  The red component of color (0-255)
     * @param g  The green component of color (0-255)
     * @param b  The blue component of color (0-255)
     * @param a  The alpha component of color (0-1.0)
     */
    Color.fromRGB = function (r, g, b, a) {
        return new Color(r, g, b, a);
    };
    /**
     * Creates a new inscance of Color from a hex string
     *
     * @param hex  CSS color string of the form #ffffff, the alpha component is optional
     */
    Color.fromHex = function (hex) {
        var hexRegEx = /^#?([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})([0-9a-f]{2})?$/i;
        var match = null;
        if ((match = hex.match(hexRegEx))) {
            var r = parseInt(match[1], 16);
            var g = parseInt(match[2], 16);
            var b = parseInt(match[3], 16);
            var a = 1;
            if (match[4]) {
                a = parseInt(match[4], 16) / 255;
            }
            return new Color(r, g, b, a);
        }
        else {
            throw new Error('Invalid hex string: ' + hex);
        }
    };
    /**
     * Creats a new instance of Color from hsla values
     *
     * @param h  Hue is represented [0-1]
     * @param s  Saturation is represented [0-1]
     * @param l  Luminance is represented [0-1]
     * @param a  Alpha is represented [0-1]
     */
    Color.fromHSL = function (h, s, l, a) {
        if (a === void 0) { a = 1.0; }
        var temp = new HSLColor(h, s, l, a);
        return temp.toRGBA();
    };
    /**
     * Lightens the current color by a specified amount
     *
     * @param factor  The amount to lighten by [0-1]
     */
    Color.prototype.lighten = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        var temp = HSLColor.fromRGBA(this.r, this.g, this.b, this.a);
        temp.l += temp.l * factor;
        return temp.toRGBA();
    };
    /**
     * Darkens the current color by a specified amount
     *
     * @param factor  The amount to darken by [0-1]
     */
    Color.prototype.darken = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        var temp = HSLColor.fromRGBA(this.r, this.g, this.b, this.a);
        temp.l -= temp.l * factor;
        return temp.toRGBA();
    };
    /**
     * Saturates the current color by a specified amount
     *
     * @param factor  The amount to saturate by [0-1]
     */
    Color.prototype.saturate = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        var temp = HSLColor.fromRGBA(this.r, this.g, this.b, this.a);
        temp.s += temp.s * factor;
        return temp.toRGBA();
    };
    /**
     * Desaturates the current color by a specified amount
     *
     * @param factor  The amount to desaturate by [0-1]
     */
    Color.prototype.desaturate = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        var temp = HSLColor.fromRGBA(this.r, this.g, this.b, this.a);
        temp.s -= temp.s * factor;
        return temp.toRGBA();
    };
    /**
     * Multiplies a color by another, results in a darker color
     *
     * @param color  The other color
     */
    Color.prototype.mulitiply = function (color) {
        var newR = (((color.r / 255) * this.r) / 255) * 255;
        var newG = (((color.g / 255) * this.g) / 255) * 255;
        var newB = (((color.b / 255) * this.b) / 255) * 255;
        var newA = color.a * this.a;
        return new Color(newR, newG, newB, newA);
    };
    /**
     * Screens a color by another, results in a lighter color
     *
     * @param color  The other color
     */
    Color.prototype.screen = function (color) {
        var color1 = color.invert();
        var color2 = color.invert();
        return color1.mulitiply(color2).invert();
    };
    /**
     * Inverts the current color
     */
    Color.prototype.invert = function () {
        return new Color(255 - this.r, 255 - this.g, 255 - this.b, 1.0 - this.a);
    };
    /**
     * Averages the current color with another
     *
     * @param color  The other color
     */
    Color.prototype.average = function (color) {
        var newR = (color.r + this.r) / 2;
        var newG = (color.g + this.g) / 2;
        var newB = (color.b + this.b) / 2;
        var newA = (color.a + this.a) / 2;
        return new Color(newR, newG, newB, newA);
    };
    /**
     * Returns a CSS string representation of a color.
     *
     * @param format Color representation, accepts: rgb, hsl, or hex
     */
    Color.prototype.toString = function (format) {
        if (format === void 0) { format = 'rgb'; }
        switch (format) {
            case 'rgb':
                return this.toRGBA();
            case 'hsl':
                return this.toHSLA();
            case 'hex':
                return this.toHex();
            default:
                throw new Error('Invalid Color format');
        }
    };
    /**
     * Returns Hex Value of a color component
     * @param c color component
     * @see https://stackoverflow.com/questions/5623838/rgb-to-hex-and-hex-to-rgb
     */
    Color.prototype._componentToHex = function (c) {
        var hex = c.toString(16);
        return hex.length === 1 ? '0' + hex : hex;
    };
    /**
     * Return Hex representation of a color.
     */
    Color.prototype.toHex = function () {
        return '#' + this._componentToHex(this.r) + this._componentToHex(this.g) + this._componentToHex(this.b);
    };
    /**
     * Return RGBA representation of a color.
     */
    Color.prototype.toRGBA = function () {
        var result = String(this.r.toFixed(0)) + ', ' + String(this.g.toFixed(0)) + ', ' + String(this.b.toFixed(0));
        if (this.a !== undefined || this.a !== null) {
            return 'rgba(' + result + ', ' + String(this.a) + ')';
        }
        return 'rgb(' + result + ')';
    };
    /**
     * Return HSLA representation of a color.
     */
    Color.prototype.toHSLA = function () {
        return HSLColor.fromRGBA(this.r, this.g, this.b, this.a).toString();
    };
    /**
     * Returns a CSS string representation of a color.
     */
    Color.prototype.fillStyle = function () {
        return this.toString();
    };
    /**
     * Returns a clone of the current color.
     */
    Color.prototype.clone = function () {
        return new Color(this.r, this.g, this.b, this.a);
    };
    /**
     * Black (#000000)
     */
    Color.Black = Color.fromHex('#000000');
    /**
     * White (#FFFFFF)
     */
    Color.White = Color.fromHex('#FFFFFF');
    /**
     * Gray (#808080)
     */
    Color.Gray = Color.fromHex('#808080');
    /**
     * Light gray (#D3D3D3)
     */
    Color.LightGray = Color.fromHex('#D3D3D3');
    /**
     * Dark gray (#A9A9A9)
     */
    Color.DarkGray = Color.fromHex('#A9A9A9');
    /**
     * Yellow (#FFFF00)
     */
    Color.Yellow = Color.fromHex('#FFFF00');
    /**
     * Orange (#FFA500)
     */
    Color.Orange = Color.fromHex('#FFA500');
    /**
     * Red (#FF0000)
     */
    Color.Red = Color.fromHex('#FF0000');
    /**
     * Vermillion (#FF5B31)
     */
    Color.Vermillion = Color.fromHex('#FF5B31');
    /**
     * Rose (#FF007F)
     */
    Color.Rose = Color.fromHex('#FF007F');
    /**
     * Magenta (#FF00FF)
     */
    Color.Magenta = Color.fromHex('#FF00FF');
    /**
     * Violet (#7F00FF)
     */
    Color.Violet = Color.fromHex('#7F00FF');
    /**
     * Blue (#0000FF)
     */
    Color.Blue = Color.fromHex('#0000FF');
    /**
     * Azure (#007FFF)
     */
    Color.Azure = Color.fromHex('#007FFF');
    /**
     * Cyan (#00FFFF)
     */
    Color.Cyan = Color.fromHex('#00FFFF');
    /**
     * Viridian (#59978F)
     */
    Color.Viridian = Color.fromHex('#59978F');
    /**
     * Green (#00FF00)
     */
    Color.Green = Color.fromHex('#00FF00');
    /**
     * Chartreuse (#7FFF00)
     */
    Color.Chartreuse = Color.fromHex('#7FFF00');
    /**
     * Transparent (#FFFFFF00)
     */
    Color.Transparent = Color.fromHex('#FFFFFF00');
    return Color;
}());

/**
 * Internal HSL Color representation
 *
 * http://en.wikipedia.org/wiki/HSL_and_HSV
 * http://axonflux.com/handy-rgb-to-hsl-and-rgb-to-hsv-color-model-c
 */
var HSLColor = /** @class */ (function () {
    function HSLColor(h, s, l, a) {
        this.h = h;
        this.s = s;
        this.l = l;
        this.a = a;
    }
    HSLColor.hue2rgb = function (p, q, t) {
        if (t < 0) {
            t += 1;
        }
        if (t > 1) {
            t -= 1;
        }
        if (t < 1 / 6) {
            return p + (q - p) * 6 * t;
        }
        if (t < 1 / 2) {
            return q;
        }
        if (t < 2 / 3) {
            return p + (q - p) * (2 / 3 - t) * 6;
        }
        return p;
    };
    HSLColor.fromRGBA = function (r, g, b, a) {
        r /= 255;
        g /= 255;
        b /= 255;
        var max = Math.max(r, g, b), min = Math.min(r, g, b);
        var h, s, l = (max + min) / 2;
        if (max === min) {
            h = s = 0; // achromatic
        }
        else {
            var d = max - min;
            s = l > 0.5 ? d / (2 - max - min) : d / (max + min);
            switch (max) {
                case r:
                    h = (g - b) / d + (g < b ? 6 : 0);
                    break;
                case g:
                    h = (b - r) / d + 2;
                    break;
                case b:
                    h = (r - g) / d + 4;
                    break;
            }
            h /= 6;
        }
        return new HSLColor(h, s, l, a);
    };
    HSLColor.prototype.toRGBA = function () {
        var r, g, b;
        if (this.s === 0) {
            r = g = b = this.l; // achromatic
        }
        else {
            var q = this.l < 0.5 ? this.l * (1 + this.s) : this.l + this.s - this.l * this.s;
            var p = 2 * this.l - q;
            r = HSLColor.hue2rgb(p, q, this.h + 1 / 3);
            g = HSLColor.hue2rgb(p, q, this.h);
            b = HSLColor.hue2rgb(p, q, this.h - 1 / 3);
        }
        return new Color(r * 255, g * 255, b * 255, this.a);
    };
    HSLColor.prototype.toString = function () {
        var h = this.h.toFixed(0), s = this.s.toFixed(0), l = this.l.toFixed(0), a = this.a.toFixed(0);
        return "hsla(" + h + ", " + s + ", " + l + ", " + a + ")";
    };
    return HSLColor;
}());


/***/ }),

/***/ "./Drawing/Index.ts":
/*!**************************!*\
  !*** ./Drawing/Index.ts ***!
  \**************************/
/*! exports provided: Animation, Sprite, SpriteSheet, SpriteFont, Effects, Color, Polygon */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Animation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Animation */ "./Drawing/Animation.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Animation", function() { return _Animation__WEBPACK_IMPORTED_MODULE_0__["Animation"]; });

/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Color */ "./Drawing/Color.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Color", function() { return _Color__WEBPACK_IMPORTED_MODULE_1__["Color"]; });

/* harmony import */ var _Polygon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Polygon */ "./Drawing/Polygon.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Polygon", function() { return _Polygon__WEBPACK_IMPORTED_MODULE_2__["Polygon"]; });

/* harmony import */ var _Sprite__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Sprite */ "./Drawing/Sprite.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Sprite", function() { return _Sprite__WEBPACK_IMPORTED_MODULE_3__["Sprite"]; });

/* harmony import */ var _SpriteSheet__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./SpriteSheet */ "./Drawing/SpriteSheet.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SpriteSheet", function() { return _SpriteSheet__WEBPACK_IMPORTED_MODULE_4__["SpriteSheet"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SpriteFont", function() { return _SpriteSheet__WEBPACK_IMPORTED_MODULE_4__["SpriteFont"]; });

/* harmony import */ var _SpriteEffects__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./SpriteEffects */ "./Drawing/SpriteEffects.ts");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "Effects", function() { return _SpriteEffects__WEBPACK_IMPORTED_MODULE_5__; });









/***/ }),

/***/ "./Drawing/Polygon.ts":
/*!****************************!*\
  !*** ./Drawing/Polygon.ts ***!
  \****************************/
/*! exports provided: Polygon */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Polygon", function() { return Polygon; });
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");

/**
 * Creates a closed polygon drawing given a list of [[Vector]]s.
 *
 * @warning Use sparingly as Polygons are performance intensive
 */
var Polygon = /** @class */ (function () {
    /**
     * @param points  The vectors to use to build the polygon in order
     */
    function Polygon(points) {
        /**
         * The width of the lines of the polygon
         */
        this.lineWidth = 5;
        /**
         * Indicates whether the polygon is filled or not.
         */
        this.filled = false;
        this._points = [];
        this.anchor = new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](0, 0);
        this.rotation = 0;
        this.scale = new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](1, 1);
        this._points = points;
        var minX = this._points.reduce(function (prev, curr) {
            return Math.min(prev, curr.x);
        }, 0);
        var maxX = this._points.reduce(function (prev, curr) {
            return Math.max(prev, curr.x);
        }, 0);
        this.drawWidth = maxX - minX;
        var minY = this._points.reduce(function (prev, curr) {
            return Math.min(prev, curr.y);
        }, 0);
        var maxY = this._points.reduce(function (prev, curr) {
            return Math.max(prev, curr.y);
        }, 0);
        this.drawHeight = maxY - minY;
        this.height = this.drawHeight;
        this.width = this.drawWidth;
    }
    /**
     * @notimplemented Effects are not supported on `Polygon`
     */
    Polygon.prototype.addEffect = function () {
        // not supported on polygons
    };
    /**
     * @notimplemented Effects are not supported on `Polygon`
     */
    Polygon.prototype.removeEffect = function () {
        // not supported on polygons
    };
    /**
     * @notimplemented Effects are not supported on `Polygon`
     */
    Polygon.prototype.clearEffects = function () {
        // not supported on polygons
    };
    Polygon.prototype.reset = function () {
        //pass
    };
    Polygon.prototype.draw = function (ctx, x, y) {
        ctx.save();
        ctx.translate(x + this.anchor.x, y + this.anchor.y);
        ctx.scale(this.scale.x, this.scale.y);
        ctx.rotate(this.rotation);
        ctx.beginPath();
        ctx.lineWidth = this.lineWidth;
        // Iterate through the supplied points and construct a 'polygon'
        var firstPoint = this._points[0];
        ctx.moveTo(firstPoint.x, firstPoint.y);
        var i = 0, len = this._points.length;
        for (i; i < len; i++) {
            ctx.lineTo(this._points[i].x, this._points[i].y);
        }
        ctx.lineTo(firstPoint.x, firstPoint.y);
        ctx.closePath();
        if (this.filled) {
            ctx.fillStyle = this.fillColor.toString();
            ctx.fill();
        }
        ctx.strokeStyle = this.lineColor.toString();
        if (this.flipHorizontal) {
            ctx.translate(this.drawWidth, 0);
            ctx.scale(-1, 1);
        }
        if (this.flipVertical) {
            ctx.translate(0, this.drawHeight);
            ctx.scale(1, -1);
        }
        ctx.stroke();
        ctx.restore();
    };
    return Polygon;
}());



/***/ }),

/***/ "./Drawing/Sprite.ts":
/*!***************************!*\
  !*** ./Drawing/Sprite.ts ***!
  \***************************/
/*! exports provided: SpriteImpl, Sprite */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpriteImpl", function() { return SpriteImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Sprite", function() { return Sprite; });
/* harmony import */ var _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SpriteEffects */ "./Drawing/SpriteEffects.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Color */ "./Drawing/Color.ts");
/* harmony import */ var _Resources_Texture__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Resources/Texture */ "./Resources/Texture.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");
/* harmony import */ var _Configurable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Configurable */ "./Configurable.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();







/**
 * @hidden
 */
var SpriteImpl = /** @class */ (function () {
    /**
     * @param image   The backing image texture to build the Sprite
     * @param x      The x position of the sprite
     * @param y      The y position of the sprite
     * @param width  The width of the sprite in pixels
     * @param height The height of the sprite in pixels
     */
    function SpriteImpl(imageOrConfig, x, y, width, height) {
        var _this = this;
        this.x = 0;
        this.y = 0;
        this.rotation = 0.0;
        this.anchor = new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"](0.0, 0.0);
        this.scale = new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"](1, 1);
        this.logger = _Util_Log__WEBPACK_IMPORTED_MODULE_4__["Logger"].getInstance();
        /**
         * Draws the sprite flipped vertically
         */
        this.flipVertical = false;
        /**
         * Draws the sprite flipped horizontally
         */
        this.flipHorizontal = false;
        this.effects = [];
        this.width = 0;
        this.height = 0;
        this._spriteCanvas = null;
        this._spriteCtx = null;
        this._pixelData = null;
        this._pixelsLoaded = false;
        this._dirtyEffect = false;
        var image = imageOrConfig;
        if (imageOrConfig && !(imageOrConfig instanceof _Resources_Texture__WEBPACK_IMPORTED_MODULE_2__["Texture"])) {
            x = imageOrConfig.x | 0;
            y = imageOrConfig.y | 0;
            width = imageOrConfig.width | 0;
            height = imageOrConfig.height | 0;
            image = imageOrConfig.image;
            if (!image) {
                var message = 'An image texture is required to contsruct a sprite';
                throw new Error(message);
            }
        }
        this.x = x || 0;
        this.y = y || 0;
        this._texture = image;
        this._spriteCanvas = document.createElement('canvas');
        this._spriteCanvas.width = width;
        this._spriteCanvas.height = height;
        this._spriteCtx = this._spriteCanvas.getContext('2d');
        this._texture.loaded
            .then(function () {
            _this.width = _this.width || _this._texture.image.naturalWidth;
            _this.height = _this.height || _this._texture.image.naturalHeight;
            _this._spriteCanvas.width = _this._spriteCanvas.width || _this._texture.image.naturalWidth;
            _this._spriteCanvas.height = _this._spriteCanvas.height || _this._texture.image.naturalHeight;
            _this._loadPixels();
            _this._dirtyEffect = true;
        })
            .error(function (e) {
            _this.logger.error('Error loading texture ', _this._texture.path, e);
        });
        this.width = width;
        this.height = height;
    }
    Object.defineProperty(SpriteImpl.prototype, "drawWidth", {
        get: function () {
            return this.width * this.scale.x;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(SpriteImpl.prototype, "drawHeight", {
        get: function () {
            return this.height * this.scale.y;
        },
        enumerable: true,
        configurable: true
    });
    SpriteImpl.prototype._loadPixels = function () {
        if (this._texture.isLoaded() && !this._pixelsLoaded) {
            var naturalWidth = this._texture.image.naturalWidth || 0;
            var naturalHeight = this._texture.image.naturalHeight || 0;
            if (this.width > naturalWidth) {
                this.logger.warn("The sprite width " + this.width + " exceeds the width \n                              " + naturalWidth + " of the backing texture " + this._texture.path);
            }
            if (this.width <= 0 || naturalWidth <= 0) {
                throw new Error("The width of a sprite cannot be 0 or negative, sprite width: " + this.width + ", original width: " + naturalWidth);
            }
            if (this.height > naturalHeight) {
                this.logger.warn("The sprite height " + this.height + " exceeds the height \n                              " + naturalHeight + " of the backing texture " + this._texture.path);
            }
            if (this.height <= 0 || naturalHeight <= 0) {
                throw new Error("The height of a sprite cannot be 0 or negative, sprite height: " + this.height + ", original height: " + naturalHeight);
            }
            this._spriteCtx.drawImage(this._texture.image, Object(_Util_Util__WEBPACK_IMPORTED_MODULE_5__["clamp"])(this.x, 0, naturalWidth), Object(_Util_Util__WEBPACK_IMPORTED_MODULE_5__["clamp"])(this.y, 0, naturalHeight), Object(_Util_Util__WEBPACK_IMPORTED_MODULE_5__["clamp"])(this.width, 0, naturalWidth), Object(_Util_Util__WEBPACK_IMPORTED_MODULE_5__["clamp"])(this.height, 0, naturalHeight), 0, 0, this.width, this.height);
            this._pixelsLoaded = true;
        }
    };
    /**
     * Applies the [[Opacity]] effect to a sprite, setting the alpha of all pixels to a given value
     */
    SpriteImpl.prototype.opacity = function (value) {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Opacity"](value));
    };
    /**
     * Applies the [[Grayscale]] effect to a sprite, removing color information.
     */
    SpriteImpl.prototype.grayscale = function () {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Grayscale"]());
    };
    /**
     * Applies the [[Invert]] effect to a sprite, inverting the pixel colors.
     */
    SpriteImpl.prototype.invert = function () {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Invert"]());
    };
    /**
     * Applies the [[Fill]] effect to a sprite, changing the color channels of all non-transparent pixels to match a given color
     */
    SpriteImpl.prototype.fill = function (color) {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Fill"](color));
    };
    /**
     * Applies the [[Colorize]] effect to a sprite, changing the color channels of all pixels to be the average of the original color
     * and the provided color.
     */
    SpriteImpl.prototype.colorize = function (color) {
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Colorize"](color));
    };
    /**
     * Applies the [[Lighten]] effect to a sprite, changes the lightness of the color according to HSL
     */
    SpriteImpl.prototype.lighten = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Lighten"](factor));
    };
    /**
     * Applies the [[Darken]] effect to a sprite, changes the darkness of the color according to HSL
     */
    SpriteImpl.prototype.darken = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Darken"](factor));
    };
    /**
     * Applies the [[Saturate]] effect to a sprite, saturates the color according to HSL
     */
    SpriteImpl.prototype.saturate = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Saturate"](factor));
    };
    /**
     * Applies the [[Desaturate]] effect to a sprite, desaturates the color according to HSL
     */
    SpriteImpl.prototype.desaturate = function (factor) {
        if (factor === void 0) { factor = 0.1; }
        this.addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_0__["Desaturate"](factor));
    };
    /**
     * Adds a new [[ISpriteEffect]] to this drawing.
     * @param effect  Effect to add to the this drawing
     */
    SpriteImpl.prototype.addEffect = function (effect) {
        this.effects.push(effect);
        // We must check if the texture and the backing sprite pixels are loaded as well before
        // an effect can be applied
        if (!this._texture.isLoaded() || !this._pixelsLoaded) {
            this._dirtyEffect = true;
        }
        else {
            this._applyEffects();
        }
    };
    SpriteImpl.prototype.removeEffect = function (param) {
        var indexToRemove = -1;
        if (typeof param === 'number') {
            indexToRemove = param;
        }
        else {
            indexToRemove = this.effects.indexOf(param);
        }
        // bounds check
        if (indexToRemove < 0 || indexToRemove >= this.effects.length) {
            return;
        }
        this.effects.splice(indexToRemove, 1);
        // We must check if the texture and the backing sprite pixels are loaded as well before
        // an effect can be applied
        if (!this._texture.isLoaded() || !this._pixelsLoaded) {
            this._dirtyEffect = true;
        }
        else {
            this._applyEffects();
        }
    };
    SpriteImpl.prototype._applyEffects = function () {
        var naturalWidth = this._texture.image.naturalWidth || 0;
        var naturalHeight = this._texture.image.naturalHeight || 0;
        this._spriteCtx.clearRect(0, 0, this.width, this.height);
        this._spriteCtx.drawImage(this._texture.image, Object(_Util_Util__WEBPACK_IMPORTED_MODULE_5__["clamp"])(this.x, 0, naturalWidth), Object(_Util_Util__WEBPACK_IMPORTED_MODULE_5__["clamp"])(this.y, 0, naturalHeight), Object(_Util_Util__WEBPACK_IMPORTED_MODULE_5__["clamp"])(this.width, 0, naturalWidth), Object(_Util_Util__WEBPACK_IMPORTED_MODULE_5__["clamp"])(this.height, 0, naturalHeight), 0, 0, this.width, this.height);
        this._pixelData = this._spriteCtx.getImageData(0, 0, this.width, this.height);
        var i = 0, x = 0, y = 0, len = this.effects.length;
        for (i; i < len; i++) {
            y = 0;
            for (y; y < this.height; y++) {
                x = 0;
                for (x; x < this.width; x++) {
                    this.effects[i].updatePixel(x, y, this._pixelData);
                }
            }
        }
        this._spriteCtx.clearRect(0, 0, this.width, this.height);
        this._spriteCtx.putImageData(this._pixelData, 0, 0);
        this._dirtyEffect = false;
    };
    /**
     * Clears all effects from the drawing and return it to its original state.
     */
    SpriteImpl.prototype.clearEffects = function () {
        this.effects.length = 0;
        this._applyEffects();
    };
    /**
     * Resets the internal state of the drawing (if any)
     */
    SpriteImpl.prototype.reset = function () {
        // do nothing
    };
    SpriteImpl.prototype.debugDraw = function (ctx, x, y) {
        ctx.save();
        ctx.translate(x, y);
        ctx.rotate(this.rotation);
        var xpoint = this.drawWidth * this.anchor.x;
        var ypoint = this.drawHeight * this.anchor.y;
        ctx.strokeStyle = _Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Black.toString();
        ctx.strokeRect(-xpoint, -ypoint, this.drawWidth, this.drawHeight);
        ctx.restore();
    };
    /**
     * Draws the sprite appropriately to the 2D rendering context, at an x and y coordinate.
     * @param ctx  The 2D rendering context
     * @param x    The x coordinate of where to draw
     * @param y    The y coordinate of where to draw
     */
    SpriteImpl.prototype.draw = function (ctx, x, y) {
        if (this._dirtyEffect) {
            this._applyEffects();
        }
        // calculating current dimensions
        ctx.save();
        var xpoint = this.drawWidth * this.anchor.x;
        var ypoint = this.drawHeight * this.anchor.y;
        ctx.translate(x, y);
        ctx.rotate(this.rotation);
        // todo cache flipped sprites
        if (this.flipHorizontal) {
            ctx.translate(this.drawWidth, 0);
            ctx.scale(-1, 1);
        }
        if (this.flipVertical) {
            ctx.translate(0, this.drawHeight);
            ctx.scale(1, -1);
        }
        ctx.drawImage(this._spriteCanvas, 0, 0, this.width, this.height, -xpoint, -ypoint, this.drawWidth, this.drawHeight);
        ctx.restore();
    };
    /**
     * Produces a copy of the current sprite
     */
    SpriteImpl.prototype.clone = function () {
        var result = new Sprite(this._texture, this.x, this.y, this.width, this.height);
        result.scale = this.scale.clone();
        result.rotation = this.rotation;
        result.flipHorizontal = this.flipHorizontal;
        result.flipVertical = this.flipVertical;
        var i = 0, len = this.effects.length;
        for (i; i < len; i++) {
            result.addEffect(this.effects[i]);
        }
        return result;
    };
    return SpriteImpl;
}());

/**
 * A [[Sprite]] is one of the main drawing primitives. It is responsible for drawing
 * images or parts of images from a [[Texture]] resource to the screen.
 *
 * [[include:Sprites.md]]
 */
var Sprite = /** @class */ (function (_super) {
    __extends(Sprite, _super);
    function Sprite(imageOrConfig, x, y, width, height) {
        return _super.call(this, imageOrConfig, x, y, width, height) || this;
    }
    return Sprite;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_6__["Configurable"])(SpriteImpl)));



/***/ }),

/***/ "./Drawing/SpriteEffects.ts":
/*!**********************************!*\
  !*** ./Drawing/SpriteEffects.ts ***!
  \**********************************/
/*! exports provided: Grayscale, Invert, Opacity, Colorize, Lighten, Darken, Saturate, Desaturate, Fill */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Grayscale", function() { return Grayscale; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Invert", function() { return Invert; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Opacity", function() { return Opacity; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Colorize", function() { return Colorize; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Lighten", function() { return Lighten; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Darken", function() { return Darken; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Saturate", function() { return Saturate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Desaturate", function() { return Desaturate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Fill", function() { return Fill; });
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Color */ "./Drawing/Color.ts");
/**
 * These effects can be applied to any bitmap image but are mainly used
 * for [[Sprite]] effects or [[Animation]] effects.
 *
 * [[include:SpriteEffects.md]]
 */
/**
 * @typedoc
 */

/**
 * Applies the "Grayscale" effect to a sprite, removing color information.
 */
var Grayscale = /** @class */ (function () {
    function Grayscale() {
    }
    Grayscale.prototype.updatePixel = function (x, y, imageData) {
        var firstPixel = (x + y * imageData.width) * 4;
        var pixel = imageData.data;
        var avg = (pixel[firstPixel + 0] + pixel[firstPixel + 1] + pixel[firstPixel + 2]) / 3;
        pixel[firstPixel + 0] = avg;
        pixel[firstPixel + 1] = avg;
        pixel[firstPixel + 2] = avg;
    };
    return Grayscale;
}());

/**
 * Applies the "Invert" effect to a sprite, inverting the pixel colors.
 */
var Invert = /** @class */ (function () {
    function Invert() {
    }
    Invert.prototype.updatePixel = function (x, y, imageData) {
        var firstPixel = (x + y * imageData.width) * 4;
        var pixel = imageData.data;
        pixel[firstPixel + 0] = 255 - pixel[firstPixel + 0];
        pixel[firstPixel + 1] = 255 - pixel[firstPixel + 1];
        pixel[firstPixel + 2] = 255 - pixel[firstPixel + 2];
    };
    return Invert;
}());

/**
 * Applies the "Opacity" effect to a sprite, setting the alpha of all pixels to a given value.
 */
var Opacity = /** @class */ (function () {
    /**
     * @param opacity  The new opacity of the sprite from 0-1.0
     */
    function Opacity(opacity) {
        this.opacity = opacity;
    }
    Opacity.prototype.updatePixel = function (x, y, imageData) {
        var firstPixel = (x + y * imageData.width) * 4;
        var pixel = imageData.data;
        if (pixel[firstPixel + 3] !== 0) {
            pixel[firstPixel + 3] = Math.round(this.opacity * pixel[firstPixel + 3]);
        }
    };
    return Opacity;
}());

/**
 * Applies the "Colorize" effect to a sprite, changing the color channels of all the pixels to an
 * average of the original color and the provided color
 */
var Colorize = /** @class */ (function () {
    /**
     * @param color  The color to apply to the sprite
     */
    function Colorize(color) {
        this.color = color;
    }
    Colorize.prototype.updatePixel = function (x, y, imageData) {
        var firstPixel = (x + y * imageData.width) * 4;
        var pixel = imageData.data;
        if (pixel[firstPixel + 3] !== 0) {
            pixel[firstPixel + 0] = (pixel[firstPixel + 0] + this.color.r) / 2;
            pixel[firstPixel + 1] = (pixel[firstPixel + 1] + this.color.g) / 2;
            pixel[firstPixel + 2] = (pixel[firstPixel + 2] + this.color.b) / 2;
        }
    };
    return Colorize;
}());

/**
 * Applies the "Lighten" effect to a sprite, changes the lightness of the color according to HSL
 */
var Lighten = /** @class */ (function () {
    /**
     * @param factor  The factor of the effect between 0-1
     */
    function Lighten(factor) {
        if (factor === void 0) { factor = 0.1; }
        this.factor = factor;
    }
    Lighten.prototype.updatePixel = function (x, y, imageData) {
        var firstPixel = (x + y * imageData.width) * 4;
        var pixel = imageData.data;
        var color = _Color__WEBPACK_IMPORTED_MODULE_0__["Color"].fromRGB(pixel[firstPixel + 0], pixel[firstPixel + 1], pixel[firstPixel + 2], pixel[firstPixel + 3]).lighten(this.factor);
        pixel[firstPixel + 0] = color.r;
        pixel[firstPixel + 1] = color.g;
        pixel[firstPixel + 2] = color.b;
        pixel[firstPixel + 3] = color.a;
    };
    return Lighten;
}());

/**
 * Applies the "Darken" effect to a sprite, changes the darkness of the color according to HSL
 */
var Darken = /** @class */ (function () {
    /**
     * @param factor  The factor of the effect between 0-1
     */
    function Darken(factor) {
        if (factor === void 0) { factor = 0.1; }
        this.factor = factor;
    }
    Darken.prototype.updatePixel = function (x, y, imageData) {
        var firstPixel = (x + y * imageData.width) * 4;
        var pixel = imageData.data;
        var color = _Color__WEBPACK_IMPORTED_MODULE_0__["Color"].fromRGB(pixel[firstPixel + 0], pixel[firstPixel + 1], pixel[firstPixel + 2], pixel[firstPixel + 3]).darken(this.factor);
        pixel[firstPixel + 0] = color.r;
        pixel[firstPixel + 1] = color.g;
        pixel[firstPixel + 2] = color.b;
        pixel[firstPixel + 3] = color.a;
    };
    return Darken;
}());

/**
 * Applies the "Saturate" effect to a sprite, saturates the color according to HSL
 */
var Saturate = /** @class */ (function () {
    /**
     * @param factor  The factor of the effect between 0-1
     */
    function Saturate(factor) {
        if (factor === void 0) { factor = 0.1; }
        this.factor = factor;
    }
    Saturate.prototype.updatePixel = function (x, y, imageData) {
        var firstPixel = (x + y * imageData.width) * 4;
        var pixel = imageData.data;
        var color = _Color__WEBPACK_IMPORTED_MODULE_0__["Color"].fromRGB(pixel[firstPixel + 0], pixel[firstPixel + 1], pixel[firstPixel + 2], pixel[firstPixel + 3]).saturate(this.factor);
        pixel[firstPixel + 0] = color.r;
        pixel[firstPixel + 1] = color.g;
        pixel[firstPixel + 2] = color.b;
        pixel[firstPixel + 3] = color.a;
    };
    return Saturate;
}());

/**
 * Applies the "Desaturate" effect to a sprite, desaturates the color according to HSL
 */
var Desaturate = /** @class */ (function () {
    /**
     * @param factor  The factor of the effect between 0-1
     */
    function Desaturate(factor) {
        if (factor === void 0) { factor = 0.1; }
        this.factor = factor;
    }
    Desaturate.prototype.updatePixel = function (x, y, imageData) {
        var firstPixel = (x + y * imageData.width) * 4;
        var pixel = imageData.data;
        var color = _Color__WEBPACK_IMPORTED_MODULE_0__["Color"].fromRGB(pixel[firstPixel + 0], pixel[firstPixel + 1], pixel[firstPixel + 2], pixel[firstPixel + 3]).desaturate(this.factor);
        pixel[firstPixel + 0] = color.r;
        pixel[firstPixel + 1] = color.g;
        pixel[firstPixel + 2] = color.b;
        pixel[firstPixel + 3] = color.a;
    };
    return Desaturate;
}());

/**
 * Applies the "Fill" effect to a sprite, changing the color channels of all non-transparent pixels to match
 * a given color
 */
var Fill = /** @class */ (function () {
    /**
     * @param color  The color to apply to the sprite
     */
    function Fill(color) {
        this.color = color;
    }
    Fill.prototype.updatePixel = function (x, y, imageData) {
        var firstPixel = (x + y * imageData.width) * 4;
        var pixel = imageData.data;
        if (pixel[firstPixel + 3] !== 0) {
            pixel[firstPixel + 0] = this.color.r;
            pixel[firstPixel + 1] = this.color.g;
            pixel[firstPixel + 2] = this.color.b;
        }
    };
    return Fill;
}());



/***/ }),

/***/ "./Drawing/SpriteSheet.ts":
/*!********************************!*\
  !*** ./Drawing/SpriteSheet.ts ***!
  \********************************/
/*! exports provided: SpriteSheetImpl, SpriteSheet, SpriteFontImpl, SpriteFont */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpriteSheetImpl", function() { return SpriteSheetImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpriteSheet", function() { return SpriteSheet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpriteFontImpl", function() { return SpriteFontImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SpriteFont", function() { return SpriteFont; });
/* harmony import */ var _Sprite__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Sprite */ "./Drawing/Sprite.ts");
/* harmony import */ var _Animation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Animation */ "./Drawing/Animation.ts");
/* harmony import */ var _Color__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Color */ "./Drawing/Color.ts");
/* harmony import */ var _SpriteEffects__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./SpriteEffects */ "./Drawing/SpriteEffects.ts");
/* harmony import */ var _Resources_Texture__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Resources/Texture */ "./Resources/Texture.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../Label */ "./Label.ts");
/* harmony import */ var _Configurable__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../Configurable */ "./Configurable.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();








/**
 * @hidden
 */
var SpriteSheetImpl = /** @class */ (function () {
    /**
     * @param image     The backing image texture to build the SpriteSheet
     * @param columns   The number of columns in the image texture
     * @param rows      The number of rows in the image texture
     * @param spWidth   The width of each individual sprite in pixels
     * @param spHeight  The height of each individual sprite in pixels
     */
    function SpriteSheetImpl(imageOrConfigOrSprites, columns, rows, spWidth, spHeight) {
        this.sprites = [];
        this.image = null;
        this.columns = 0;
        this.rows = 0;
        this.spWidth = 0;
        this.spHeight = 0;
        var loadFromImage = false;
        if (imageOrConfigOrSprites instanceof Array) {
            this.sprites = imageOrConfigOrSprites;
        }
        else {
            if (imageOrConfigOrSprites && !(imageOrConfigOrSprites instanceof _Resources_Texture__WEBPACK_IMPORTED_MODULE_4__["Texture"])) {
                this.columns = imageOrConfigOrSprites.columns;
                this.rows = imageOrConfigOrSprites.rows;
                this.spWidth = imageOrConfigOrSprites.spWidth;
                this.spHeight = imageOrConfigOrSprites.spHeight;
                this.image = imageOrConfigOrSprites.image;
            }
            else {
                this.image = imageOrConfigOrSprites;
                this.columns = columns;
                this.rows = rows;
                this.spWidth = spWidth;
                this.spHeight = spHeight;
            }
            this.sprites = new Array(this.columns * this.rows);
            loadFromImage = true;
        }
        // TODO: Inspect actual image dimensions with preloading
        /*if(spWidth * columns > this.internalImage.naturalWidth){
             throw new Error("SpriteSheet specified is wider than image width");
          }
    
          if(spHeight * rows > this.internalImage.naturalHeight){
             throw new Error("SpriteSheet specified is higher than image height");
          }*/
        if (loadFromImage) {
            var i = 0;
            var j = 0;
            for (i = 0; i < this.rows; i++) {
                for (j = 0; j < this.columns; j++) {
                    this.sprites[j + i * this.columns] = new _Sprite__WEBPACK_IMPORTED_MODULE_0__["Sprite"](this.image, j * this.spWidth, i * this.spHeight, this.spWidth, this.spHeight);
                }
            }
        }
    }
    /**
     * Create an animation from the this SpriteSheet by listing out the
     * sprite indices. Sprites are organized in row major order in the SpriteSheet.
     * @param engine   Reference to the current game [[Engine]]
     * @param indices  An array of sprite indices to use in the animation
     * @param speed    The number in milliseconds to display each frame in the animation
     */
    SpriteSheetImpl.prototype.getAnimationByIndices = function (engine, indices, speed) {
        var _this = this;
        var images = indices.map(function (index) {
            return _this.sprites[index];
        });
        images = images.map(function (i) {
            return i.clone();
        });
        return new _Animation__WEBPACK_IMPORTED_MODULE_1__["Animation"](engine, images, speed);
    };
    /**
     * Create an animation from the this SpriteSheet by specifing the range of
     * images with the beginning (inclusive) and ending (exclusive) index
     * For example `getAnimationBetween(engine, 0, 5, 200)` returns an animation with 5 frames.
     * @param engine      Reference to the current game Engine
     * @param beginIndex  The index to start taking frames (inclusive)
     * @param endIndex    The index to stop taking frames (exclusive)
     * @param speed       The number in milliseconds to display each frame in the animation
     */
    SpriteSheetImpl.prototype.getAnimationBetween = function (engine, beginIndex, endIndex, speed) {
        var images = this.sprites.slice(beginIndex, endIndex);
        images = images.map(function (i) {
            return i.clone();
        });
        return new _Animation__WEBPACK_IMPORTED_MODULE_1__["Animation"](engine, images, speed);
    };
    /**
     * Treat the entire SpriteSheet as one animation, organizing the frames in
     * row major order.
     * @param engine  Reference to the current game [[Engine]]
     * @param speed   The number in milliseconds to display each frame the animation
     */
    SpriteSheetImpl.prototype.getAnimationForAll = function (engine, speed) {
        var sprites = this.sprites.map(function (i) {
            return i.clone();
        });
        return new _Animation__WEBPACK_IMPORTED_MODULE_1__["Animation"](engine, sprites, speed);
    };
    /**
     * Retreive a specific sprite from the SpriteSheet by its index. Sprites are organized
     * in row major order in the SpriteSheet.
     * @param index  The index of the sprite
     */
    SpriteSheetImpl.prototype.getSprite = function (index) {
        if (index >= 0 && index < this.sprites.length) {
            return this.sprites[index];
        }
        else {
            throw new Error('Invalid index: ' + index);
        }
    };
    /**
     * Get an animation with bespoke sprite coordinates. This is useful if the SpriteSheet is
     * packed and not a uniform width or height. The resulting [[Animation]] will have the height and width of the
     * largest dimension (width, height) from among the sprite coordinates
     * @param engine
     * @param spriteCoordinates
     * @param speed
     */
    SpriteSheetImpl.prototype.getAnimationByCoords = function (engine, spriteCoordinates, speed) {
        var maxWidth = 0;
        var maxHeight = 0;
        var sprites = new Array(spriteCoordinates.length);
        for (var i = 0; i < spriteCoordinates.length; i++) {
            var coord = spriteCoordinates[i];
            // no need to pass image again if using a spritesheet
            coord.image = coord.image || this.image;
            maxWidth = Math.max(maxWidth, coord.drawWidth);
            maxHeight = Math.max(maxHeight, coord.drawHeight);
            sprites[i] = new _Sprite__WEBPACK_IMPORTED_MODULE_0__["Sprite"](coord);
        }
        var anim = new _Animation__WEBPACK_IMPORTED_MODULE_1__["Animation"](engine, sprites, speed);
        anim.drawWidth = maxWidth;
        anim.drawHeight = maxHeight;
        return anim;
    };
    return SpriteSheetImpl;
}());

/**
 * Sprite sheets are a useful mechanism for slicing up image resources into
 * separate sprites or for generating in game animations. [[Sprite|Sprites]] are organized
 * in row major order in the [[SpriteSheet]].
 *
 * [[include:SpriteSheets.md]]
 */
var SpriteSheet = /** @class */ (function (_super) {
    __extends(SpriteSheet, _super);
    function SpriteSheet(imageOrConfigOrSprites, columns, rows, spWidth, spHeight) {
        return _super.call(this, imageOrConfigOrSprites, columns, rows, spWidth, spHeight) || this;
    }
    return SpriteSheet;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_7__["Configurable"])(SpriteSheetImpl)));

var SpriteFontImpl = /** @class */ (function (_super) {
    __extends(SpriteFontImpl, _super);
    /**
     * @param image           The backing image texture to build the SpriteFont
     * @param alphabet        A string representing all the characters in the image, in row major order.
     * @param caseInsensitive  Indicate whether this font takes case into account
     * @param columns         The number of columns of characters in the image
     * @param rows            The number of rows of characters in the image
     * @param spWidth         The width of each character in pixels
     * @param spHeight        The height of each character in pixels
     */
    function SpriteFontImpl(imageOrConfig, alphabet, caseInsensitive, columns, rows, spWidth, spHeight) {
        var _this = _super.call(this, imageOrConfig instanceof _Resources_Texture__WEBPACK_IMPORTED_MODULE_4__["Texture"]
            ? {
                image: imageOrConfig,
                spWidth: spWidth,
                spHeight: spHeight,
                rows: rows,
                columns: columns
            }
            : imageOrConfig) || this;
        _this._currentColor = _Color__WEBPACK_IMPORTED_MODULE_2__["Color"].Black.clone();
        _this._currentOpacity = 1.0;
        _this._sprites = {};
        // text shadow
        _this._textShadowOn = false;
        _this._textShadowDirty = true;
        _this._textShadowColor = _Color__WEBPACK_IMPORTED_MODULE_2__["Color"].Black.clone();
        _this._textShadowSprites = {};
        _this._shadowOffsetX = 5;
        _this._shadowOffsetY = 5;
        if (imageOrConfig && !(imageOrConfig instanceof _Resources_Texture__WEBPACK_IMPORTED_MODULE_4__["Texture"])) {
            alphabet = imageOrConfig.alphabet;
            caseInsensitive = imageOrConfig.caseInsensitive;
        }
        _this._alphabet = alphabet;
        _this._caseInsensitive = caseInsensitive;
        _this._sprites = _this.getTextSprites();
        return _this;
    }
    /**
     * Returns a dictionary that maps each character in the alphabet to the appropriate [[Sprite]].
     */
    SpriteFontImpl.prototype.getTextSprites = function () {
        var lookup = {};
        for (var i = 0; i < this._alphabet.length; i++) {
            var char = this._alphabet[i];
            if (this._caseInsensitive) {
                char = char.toLowerCase();
            }
            lookup[char] = this.sprites[i].clone();
        }
        return lookup;
    };
    /**
     * Sets the text shadow for sprite fonts
     * @param offsetX      The x offset in pixels to place the shadow
     * @param offsetY      The y offset in pixels to place the shadow
     * @param shadowColor  The color of the text shadow
     */
    SpriteFontImpl.prototype.setTextShadow = function (offsetX, offsetY, shadowColor) {
        this._textShadowOn = true;
        this._shadowOffsetX = offsetX;
        this._shadowOffsetY = offsetY;
        this._textShadowColor = shadowColor.clone();
        this._textShadowDirty = true;
        for (var character in this._sprites) {
            this._textShadowSprites[character] = this._sprites[character].clone();
        }
    };
    /**
     * Toggles text shadows on or off
     */
    SpriteFontImpl.prototype.useTextShadow = function (on) {
        this._textShadowOn = on;
        if (on) {
            this.setTextShadow(5, 5, this._textShadowColor);
        }
    };
    /**
     * Draws the current sprite font
     */
    SpriteFontImpl.prototype.draw = function (ctx, text, x, y, options) {
        options = this._parseOptions(options);
        if (this._currentColor.toString() !== options.color.toString() || this._currentOpacity !== options.opacity) {
            this._currentOpacity = options.opacity;
            this._currentColor = options.color;
            for (var char in this._sprites) {
                this._sprites[char].clearEffects();
                this._sprites[char].fill(options.color);
                this._sprites[char].opacity(options.opacity);
            }
        }
        if (this._textShadowOn && this._textShadowDirty && this._textShadowColor) {
            for (var characterShadow in this._textShadowSprites) {
                this._textShadowSprites[characterShadow].clearEffects();
                this._textShadowSprites[characterShadow].addEffect(new _SpriteEffects__WEBPACK_IMPORTED_MODULE_3__["Fill"](this._textShadowColor.clone()));
            }
            this._textShadowDirty = false;
        }
        // find the current length of text in pixels
        var sprite = this.sprites[0];
        // find the current height fo the text in pixels
        var height = sprite.drawHeight;
        // calculate appropriate scale for font size
        var scale = options.fontSize / height;
        var length = text.length * sprite.drawWidth * scale + text.length * options.letterSpacing;
        var currX = x;
        if (options.textAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["TextAlign"].Left || options.textAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["TextAlign"].Start) {
            currX = x;
        }
        else if (options.textAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["TextAlign"].Right || options.textAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["TextAlign"].End) {
            currX = x - length;
        }
        else if (options.textAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["TextAlign"].Center) {
            currX = x - length / 2;
        }
        var currY = y - height * scale;
        if (options.baseAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["BaseAlign"].Top || options.baseAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["BaseAlign"].Hanging) {
            currY = y;
        }
        else if (options.baseAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["BaseAlign"].Ideographic ||
            options.baseAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["BaseAlign"].Bottom ||
            options.baseAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["BaseAlign"].Alphabetic) {
            currY = y - height * scale;
        }
        else if (options.baseAlign === _Label__WEBPACK_IMPORTED_MODULE_6__["BaseAlign"].Middle) {
            currY = y - (height * scale) / 2;
        }
        for (var i = 0; i < text.length; i++) {
            var character = text[i];
            if (this._caseInsensitive) {
                character = character.toLowerCase();
            }
            try {
                // if text shadow
                if (this._textShadowOn) {
                    this._textShadowSprites[character].scale.x = scale;
                    this._textShadowSprites[character].scale.y = scale;
                    this._textShadowSprites[character].draw(ctx, currX + this._shadowOffsetX, currY + this._shadowOffsetY);
                }
                var charSprite = this._sprites[character];
                charSprite.scale.x = scale;
                charSprite.scale.y = scale;
                charSprite.draw(ctx, currX, currY);
                currX += charSprite.drawWidth + options.letterSpacing;
            }
            catch (e) {
                _Util_Log__WEBPACK_IMPORTED_MODULE_5__["Logger"].getInstance().error("SpriteFont Error drawing char " + character);
            }
        }
    };
    SpriteFontImpl.prototype._parseOptions = function (options) {
        return {
            fontSize: options.fontSize || 10,
            letterSpacing: options.letterSpacing || 0,
            color: options.color || _Color__WEBPACK_IMPORTED_MODULE_2__["Color"].Black.clone(),
            textAlign: typeof options.textAlign === undefined ? _Label__WEBPACK_IMPORTED_MODULE_6__["TextAlign"].Left : options.textAlign,
            baseAlign: typeof options.baseAlign === undefined ? _Label__WEBPACK_IMPORTED_MODULE_6__["BaseAlign"].Bottom : options.baseAlign,
            maxWidth: options.maxWidth || -1,
            opacity: options.opacity || 0
        };
    };
    return SpriteFontImpl;
}(SpriteSheet));

/**
 * Sprite fonts are a used in conjunction with a [[Label]] to specify
 * a particular bitmap as a font. Note that some font features are not
 * supported by Sprite fonts.
 *
 * [[include:SpriteFonts.md]]
 */
var SpriteFont = /** @class */ (function (_super) {
    __extends(SpriteFont, _super);
    function SpriteFont(imageOrConfig, alphabet, caseInsensitive, columns, rows, spWidth, spHeight) {
        return _super.call(this, imageOrConfig, alphabet, caseInsensitive, columns, rows, spWidth, spHeight) || this;
    }
    return SpriteFont;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_7__["Configurable"])(SpriteFontImpl)));



/***/ }),

/***/ "./Engine.ts":
/*!*******************!*\
  !*** ./Engine.ts ***!
  \*******************/
/*! exports provided: DisplayMode, ScrollPreventionMode, Engine */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DisplayMode", function() { return DisplayMode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ScrollPreventionMode", function() { return ScrollPreventionMode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Engine", function() { return Engine; });
/* harmony import */ var ___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ */ "./index.ts");
/* harmony import */ var _Polyfill__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Polyfill */ "./Polyfill.ts");
/* harmony import */ var _Polyfill__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_Polyfill__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Promises */ "./Promises.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");
/* harmony import */ var _UIActor__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./UIActor */ "./UIActor.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Actor */ "./Actor.ts");
/* harmony import */ var _Timer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Timer */ "./Timer.ts");
/* harmony import */ var _TileMap__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./TileMap */ "./TileMap.ts");
/* harmony import */ var _Loader__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Loader */ "./Loader.ts");
/* harmony import */ var _Util_Detector__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Util/Detector */ "./Util/Detector.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Scene__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Scene */ "./Scene.ts");
/* harmony import */ var _Debug__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Debug */ "./Debug.ts");
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Class */ "./Class.ts");
/* harmony import */ var _Input_Index__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Input/Index */ "./Input/Index.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./Util/Util */ "./Util/Util.ts");
/* harmony import */ var _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Collision/BoundingBox */ "./Collision/BoundingBox.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



















/**
 * Enum representing the different display modes available to Excalibur
 */
var DisplayMode;
(function (DisplayMode) {
    /**
     * Show the game as full screen
     */
    DisplayMode[DisplayMode["FullScreen"] = 0] = "FullScreen";
    /**
     * Scale the game to the parent DOM container
     */
    DisplayMode[DisplayMode["Container"] = 1] = "Container";
    /**
     * Show the game as a fixed size
     */
    DisplayMode[DisplayMode["Fixed"] = 2] = "Fixed";
    /**
     * Allow the game to be positioned with the [[IEngineOptions.position]] option
     */
    DisplayMode[DisplayMode["Position"] = 3] = "Position";
})(DisplayMode || (DisplayMode = {}));
/**
 * Enum representing the different mousewheel event bubble prevention
 */
var ScrollPreventionMode;
(function (ScrollPreventionMode) {
    /**
     * Do not prevent any page scrolling
     */
    ScrollPreventionMode[ScrollPreventionMode["None"] = 0] = "None";
    /**
     * Prevent page scroll if mouse is over the game canvas
     */
    ScrollPreventionMode[ScrollPreventionMode["Canvas"] = 1] = "Canvas";
    /**
     * Prevent all page scrolling via mouse wheel
     */
    ScrollPreventionMode[ScrollPreventionMode["All"] = 2] = "All";
})(ScrollPreventionMode || (ScrollPreventionMode = {}));
/**
 * The Excalibur Engine
 *
 * The [[Engine]] is the main driver for a game. It is responsible for
 * starting/stopping the game, maintaining state, transmitting events,
 * loading resources, and managing the scene.
 *
 * [[include:Engine.md]]
 */
var Engine = /** @class */ (function (_super) {
    __extends(Engine, _super);
    /**
     * Creates a new game using the given [[IEngineOptions]]. By default, if no options are provided,
     * the game will be rendered full screen (taking up all available browser window space).
     * You can customize the game rendering through [[IEngineOptions]].
     *
     * Example:
     *
     * ```js
     * var game = new ex.Engine({
     *   width: 0, // the width of the canvas
     *   height: 0, // the height of the canvas
     *   canvasElementId: '', // the DOM canvas element ID, if you are providing your own
     *   displayMode: ex.DisplayMode.FullScreen, // the display mode
     *   pointerScope: ex.Input.PointerScope.Document, // the scope of capturing pointer (mouse/touch) events
     *   backgroundColor: ex.Color.fromHex('#2185d0') // background color of the engine
     * });
     *
     * // call game.start, which is a Promise
     * game.start().then(function () {
     *   // ready, set, go!
     * });
     * ```
     */
    function Engine(options) {
        var _this = _super.call(this) || this;
        _this._hasStarted = false;
        /**
         * Access Excalibur debugging functionality.
         */
        _this.debug = new _Debug__WEBPACK_IMPORTED_MODULE_14__["Debug"]();
        /**
         * Gets or sets the list of post processors to apply at the end of drawing a frame (such as [[ColorBlindCorrector]])
         */
        _this.postProcessors = [];
        /**
         * Contains all the scenes currently registered with Excalibur
         */
        _this.scenes = {};
        _this._animations = [];
        /**
         * Indicates whether the engine is set to fullscreen or not
         */
        _this.isFullscreen = false;
        /**
         * Indicates the current [[DisplayMode]] of the engine.
         */
        _this.displayMode = DisplayMode.FullScreen;
        _this._suppressHiDPIScaling = false;
        _this._suppressPlayButton = false;
        /**
         * Indicates whether audio should be paused when the game is no longer visible.
         */
        _this.pauseAudioWhenHidden = true;
        /**
         * Indicates whether the engine should draw with debug information
         */
        _this.isDebug = false;
        _this.debugColor = new _Drawing_Color__WEBPACK_IMPORTED_MODULE_12__["Color"](255, 255, 255);
        /**
         * The action to take when a fatal exception is thrown
         */
        _this.onFatalException = function (e) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_11__["Logger"].getInstance().fatal(e);
        };
        _this._isSmoothingEnabled = true;
        _this._timescale = 1.0;
        _this._isLoading = false;
        _this._isInitialized = false;
        options = _Util_Util__WEBPACK_IMPORTED_MODULE_17__["extend"]({}, Engine._DefaultEngineOptions, options);
        // Check compatibility
        var detector = new _Util_Detector__WEBPACK_IMPORTED_MODULE_9__["Detector"]();
        if (!options.suppressMinimumBrowserFeatureDetection && !(_this._compatible = detector.test())) {
            var message = document.createElement('div');
            message.innerText = 'Sorry, your browser does not support all the features needed for Excalibur';
            document.body.appendChild(message);
            detector.failedTests.forEach(function (test) {
                var testMessage = document.createElement('div');
                testMessage.innerText = 'Browser feature missing ' + test;
                document.body.appendChild(testMessage);
            });
            if (options.canvasElementId) {
                var canvas = document.getElementById(options.canvasElementId);
                if (canvas) {
                    canvas.parentElement.removeChild(canvas);
                }
            }
            return _this;
        }
        else {
            _this._compatible = true;
        }
        // Use native console API for color fun
        if (console.log && !options.suppressConsoleBootMessage) {
            console.log("%cPowered by Excalibur.js (v" + ___WEBPACK_IMPORTED_MODULE_0__["EX_VERSION"] + ")", 'background: #176BAA; color: white; border-radius: 5px; padding: 15px; font-size: 1.5em; line-height: 80px;');
            console.log('\n\
      /| ________________\n\
O|===|* >________________>\n\
      \\|');
            console.log('Visit', 'http://excaliburjs.com', 'for more information');
        }
        // Suppress play button
        if (options.suppressPlayButton) {
            _this._suppressPlayButton = true;
        }
        _this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_11__["Logger"].getInstance();
        // If debug is enabled, let's log browser features to the console.
        if (_this._logger.defaultLevel === _Util_Log__WEBPACK_IMPORTED_MODULE_11__["LogLevel"].Debug) {
            detector.logBrowserFeatures();
        }
        _this._logger.debug('Building engine...');
        _this.canvasElementId = options.canvasElementId;
        if (options.canvasElementId) {
            _this._logger.debug('Using Canvas element specified: ' + options.canvasElementId);
            _this.canvas = document.getElementById(options.canvasElementId);
        }
        else {
            _this._logger.debug('Using generated canvas element');
            _this.canvas = document.createElement('canvas');
        }
        if (options.width && options.height) {
            if (options.displayMode === undefined) {
                _this.displayMode = DisplayMode.Fixed;
            }
            _this._logger.debug('Engine viewport is size ' + options.width + ' x ' + options.height);
            _this.canvas.width = options.width;
            _this.canvas.height = options.height;
        }
        else if (!options.displayMode) {
            _this._logger.debug('Engine viewport is fullscreen');
            _this.displayMode = DisplayMode.FullScreen;
        }
        if (options.backgroundColor) {
            _this.backgroundColor = options.backgroundColor.clone();
        }
        _this._loader = new _Loader__WEBPACK_IMPORTED_MODULE_8__["Loader"]();
        _this._initialize(options);
        _this.rootScene = _this.currentScene = new _Scene__WEBPACK_IMPORTED_MODULE_13__["Scene"](_this);
        _this.addScene('root', _this.rootScene);
        _this.goToScene('root');
        return _this;
    }
    Object.defineProperty(Engine.prototype, "canvasWidth", {
        /**
         * The width of the game canvas in pixels (physical width component of the
         * resolution of the canvas element)
         */
        get: function () {
            return this.canvas.width;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "halfCanvasWidth", {
        /**
         * Returns half width of the game canvas in pixels (half physical width component)
         */
        get: function () {
            return this.canvas.width / 2;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "canvasHeight", {
        /**
         * The height of the game canvas in pixels, (physical height component of
         * the resolution of the canvas element)
         */
        get: function () {
            return this.canvas.height;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "halfCanvasHeight", {
        /**
         * Returns half height of the game canvas in pixels (half physical height component)
         */
        get: function () {
            return this.canvas.height / 2;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "drawWidth", {
        /**
         * Returns the width of the engine's visible drawing surface in pixels including zoom and device pixel ratio.
         */
        get: function () {
            if (this.currentScene && this.currentScene.camera) {
                return this.canvasWidth / this.currentScene.camera.getZoom() / this.pixelRatio;
            }
            return this.canvasWidth / this.pixelRatio;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "halfDrawWidth", {
        /**
         * Returns half the width of the engine's visible drawing surface in pixels including zoom and device pixel ratio.
         */
        get: function () {
            return this.drawWidth / 2;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "drawHeight", {
        /**
         * Returns the height of the engine's visible drawing surface in pixels including zoom and device pixel ratio.
         */
        get: function () {
            if (this.currentScene && this.currentScene.camera) {
                return this.canvasHeight / this.currentScene.camera.getZoom() / this.pixelRatio;
            }
            return this.canvasHeight / this.pixelRatio;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "halfDrawHeight", {
        /**
         * Returns half the height of the engine's visible drawing surface in pixels including zoom and device pixel ratio.
         */
        get: function () {
            return this.drawHeight / 2;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "isHiDpi", {
        /**
         * Returns whether excalibur detects the current screen to be HiDPI
         */
        get: function () {
            return this.pixelRatio !== 1;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "stats", {
        /**
         * Access [[stats]] that holds frame statistics.
         */
        get: function () {
            return this.debug.stats;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Engine.prototype, "pixelRatio", {
        /**
         * Returns the calculated pixel ration for use in rendering
         */
        get: function () {
            if (this._suppressHiDPIScaling) {
                return 1;
            }
            if (window.devicePixelRatio < 1) {
                return 1;
            }
            var devicePixelRatio = window.devicePixelRatio || 1;
            var pixelRatio = devicePixelRatio;
            return pixelRatio;
        },
        enumerable: true,
        configurable: true
    });
    Engine.prototype.on = function (eventName, handler) {
        _super.prototype.on.call(this, eventName, handler);
    };
    Engine.prototype.once = function (eventName, handler) {
        _super.prototype.once.call(this, eventName, handler);
    };
    Engine.prototype.off = function (eventName, handler) {
        _super.prototype.off.call(this, eventName, handler);
    };
    /**
     * Returns a BoundingBox of the top left corner of the screen
     * and the bottom right corner of the screen.
     */
    Engine.prototype.getWorldBounds = function () {
        var left = this.screenToWorldCoordinates(_Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"].Zero).x;
        var top = this.screenToWorldCoordinates(_Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"].Zero).y;
        var right = left + this.drawWidth;
        var bottom = top + this.drawHeight;
        return new _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_18__["BoundingBox"](left, top, right, bottom);
    };
    Object.defineProperty(Engine.prototype, "timescale", {
        /**
         * Gets the current engine timescale factor (default is 1.0 which is 1:1 time)
         */
        get: function () {
            return this._timescale;
        },
        /**
         * Sets the current engine timescale factor. Useful for creating slow-motion effects or fast-forward effects
         * when using time-based movement.
         */
        set: function (value) {
            if (value <= 0) {
                _Util_Log__WEBPACK_IMPORTED_MODULE_11__["Logger"].getInstance().error('Cannot set engine.timescale to a value of 0 or less than 0.');
                return;
            }
            this._timescale = value;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Plays a sprite animation on the screen at the specified `x` and `y`
     * (in game coordinates, not screen pixels). These animations play
     * independent of actors, and will be cleaned up internally as soon
     * as they are complete. Note animations that loop will never be
     * cleaned up.
     *
     * @param animation  Animation to play
     * @param x          x game coordinate to play the animation
     * @param y          y game coordinate to play the animation
     */
    Engine.prototype.playAnimation = function (animation, x, y) {
        this._animations.push(new AnimationNode(animation, x, y));
    };
    /**
     * Adds a [[TileMap]] to the [[currentScene]], once this is done the TileMap
     * will be drawn and updated.
     */
    Engine.prototype.addTileMap = function (tileMap) {
        this.currentScene.addTileMap(tileMap);
    };
    /**
     * Removes a [[TileMap]] from the [[currentScene]], it will no longer be drawn or updated.
     */
    Engine.prototype.removeTileMap = function (tileMap) {
        this.currentScene.removeTileMap(tileMap);
    };
    /**
     * Adds a [[Timer]] to the [[currentScene]].
     * @param timer  The timer to add to the [[currentScene]].
     */
    Engine.prototype.addTimer = function (timer) {
        return this.currentScene.addTimer(timer);
    };
    /**
     * Removes a [[Timer]] from the [[currentScene]].
     * @param timer  The timer to remove to the [[currentScene]].
     */
    Engine.prototype.removeTimer = function (timer) {
        return this.currentScene.removeTimer(timer);
    };
    /**
     * Adds a [[Scene]] to the engine, think of scenes in Excalibur as you
     * would levels or menus.
     *
     * @param key  The name of the scene, must be unique
     * @param scene The scene to add to the engine
     */
    Engine.prototype.addScene = function (key, scene) {
        if (this.scenes[key]) {
            this._logger.warn('Scene', key, 'already exists overwriting');
        }
        this.scenes[key] = scene;
        scene.engine = this;
    };
    /**
     * @internal
     */
    Engine.prototype.removeScene = function (entity) {
        if (entity instanceof _Scene__WEBPACK_IMPORTED_MODULE_13__["Scene"]) {
            // remove scene
            for (var key in this.scenes) {
                if (this.scenes.hasOwnProperty(key)) {
                    if (this.scenes[key] === entity) {
                        delete this.scenes[key];
                    }
                }
            }
        }
        if (typeof entity === 'string') {
            // remove scene
            delete this.scenes[entity];
        }
    };
    Engine.prototype.add = function (entity) {
        if (entity instanceof _UIActor__WEBPACK_IMPORTED_MODULE_4__["UIActor"]) {
            this.currentScene.addUIActor(entity);
            return;
        }
        if (entity instanceof _Actor__WEBPACK_IMPORTED_MODULE_5__["Actor"]) {
            this._addChild(entity);
        }
        if (entity instanceof _Timer__WEBPACK_IMPORTED_MODULE_6__["Timer"]) {
            this.addTimer(entity);
        }
        if (entity instanceof _TileMap__WEBPACK_IMPORTED_MODULE_7__["TileMap"]) {
            this.addTileMap(entity);
        }
        if (arguments.length === 2) {
            this.addScene(arguments[0], arguments[1]);
        }
    };
    Engine.prototype.remove = function (entity) {
        if (entity instanceof _UIActor__WEBPACK_IMPORTED_MODULE_4__["UIActor"]) {
            this.currentScene.removeUIActor(entity);
            return;
        }
        if (entity instanceof _Actor__WEBPACK_IMPORTED_MODULE_5__["Actor"]) {
            this._removeChild(entity);
        }
        if (entity instanceof _Timer__WEBPACK_IMPORTED_MODULE_6__["Timer"]) {
            this.removeTimer(entity);
        }
        if (entity instanceof _TileMap__WEBPACK_IMPORTED_MODULE_7__["TileMap"]) {
            this.removeTileMap(entity);
        }
        if (entity instanceof _Scene__WEBPACK_IMPORTED_MODULE_13__["Scene"]) {
            this.removeScene(entity);
        }
        if (typeof entity === 'string') {
            this.removeScene(entity);
        }
    };
    /**
     * Adds an actor to the [[currentScene]] of the game. This is synonymous
     * to calling `engine.currentScene.add(actor)`.
     *
     * Actors can only be drawn if they are a member of a scene, and only
     * the [[currentScene]] may be drawn or updated.
     *
     * @param actor  The actor to add to the [[currentScene]]
     */
    Engine.prototype._addChild = function (actor) {
        this.currentScene.add(actor);
    };
    /**
     * Removes an actor from the [[currentScene]] of the game. This is synonymous
     * to calling `engine.currentScene.remove(actor)`.
     * Actors that are removed from a scene will no longer be drawn or updated.
     *
     * @param actor  The actor to remove from the [[currentScene]].
     */
    Engine.prototype._removeChild = function (actor) {
        this.currentScene.remove(actor);
    };
    /**
     * Changes the currently updating and drawing scene to a different,
     * named scene. Calls the [[Scene]] lifecycle events.
     * @param key  The key of the scene to transition to.
     */
    Engine.prototype.goToScene = function (key) {
        if (this.scenes[key]) {
            var oldScene = this.currentScene;
            var newScene = this.scenes[key];
            this._logger.debug('Going to scene:', key);
            // only deactivate when initialized
            if (this.currentScene.isInitialized) {
                this.currentScene._deactivate.call(this.currentScene, [oldScene, newScene]);
                this.currentScene.eventDispatcher.emit('deactivate', new _Events__WEBPACK_IMPORTED_MODULE_10__["DeactivateEvent"](newScene, this.currentScene));
            }
            // set current scene to new one
            this.currentScene = newScene;
            // initialize the current scene if has not been already
            this.currentScene._initialize(this);
            this.currentScene._activate.call(this.currentScene, [oldScene, newScene]);
            this.currentScene.eventDispatcher.emit('activate', new _Events__WEBPACK_IMPORTED_MODULE_10__["ActivateEvent"](oldScene, this.currentScene));
        }
        else {
            this._logger.error('Scene', key, 'does not exist!');
        }
    };
    /**
     * Transforms the current x, y from screen coordinates to world coordinates
     * @param point  Screen coordinate to convert
     */
    Engine.prototype.screenToWorldCoordinates = function (point) {
        var newX = point.x;
        var newY = point.y;
        // transform back to world space
        newX = (newX / this.canvas.clientWidth) * this.drawWidth;
        newY = (newY / this.canvas.clientHeight) * this.drawHeight;
        // transform based on zoom
        newX = newX - this.halfDrawWidth;
        newY = newY - this.halfDrawHeight;
        // shift by focus
        if (this.currentScene && this.currentScene.camera) {
            var focus = this.currentScene.camera.getFocus();
            newX += focus.x;
            newY += focus.y;
        }
        return new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"](Math.floor(newX), Math.floor(newY));
    };
    /**
     * Transforms a world coordinate, to a screen coordinate
     * @param point  World coordinate to convert
     */
    Engine.prototype.worldToScreenCoordinates = function (point) {
        var screenX = point.x;
        var screenY = point.y;
        // shift by focus
        if (this.currentScene && this.currentScene.camera) {
            var focus = this.currentScene.camera.getFocus();
            screenX -= focus.x;
            screenY -= focus.y;
        }
        // transform back on zoom
        screenX = screenX + this.halfDrawWidth;
        screenY = screenY + this.halfDrawHeight;
        // transform back to screen space
        screenX = (screenX * this.canvas.clientWidth) / this.drawWidth;
        screenY = (screenY * this.canvas.clientHeight) / this.drawHeight;
        return new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"](Math.floor(screenX), Math.floor(screenY));
    };
    /**
     * Sets the internal canvas height based on the selected display mode.
     */
    Engine.prototype._setHeightByDisplayMode = function (parent) {
        if (this.displayMode === DisplayMode.Container) {
            this.canvas.width = parent.clientWidth;
            this.canvas.height = parent.clientHeight;
        }
        if (this.displayMode === DisplayMode.FullScreen) {
            document.body.style.margin = '0px';
            document.body.style.overflow = 'hidden';
            this.canvas.width = parent.innerWidth;
            this.canvas.height = parent.innerHeight;
        }
    };
    /**
     * Initializes the internal canvas, rendering context, displaymode, and native event listeners
     */
    Engine.prototype._initialize = function (options) {
        var _this = this;
        if (options.displayMode) {
            this.displayMode = options.displayMode;
        }
        if (this.displayMode === DisplayMode.FullScreen || this.displayMode === DisplayMode.Container) {
            var parent = (this.displayMode === DisplayMode.Container ? (this.canvas.parentElement || document.body) : window);
            this._setHeightByDisplayMode(parent);
            window.addEventListener('resize', function () {
                _this._logger.debug('View port resized');
                _this._setHeightByDisplayMode(parent);
                _this._logger.info('parent.clientHeight ' + parent.clientHeight);
                _this.setAntialiasing(_this._isSmoothingEnabled);
            });
        }
        else if (this.displayMode === DisplayMode.Position) {
            this._intializeDisplayModePosition(options);
        }
        // initialize inputs
        this.input = {
            keyboard: new _Input_Index__WEBPACK_IMPORTED_MODULE_16__["Keyboard"](),
            pointers: new _Input_Index__WEBPACK_IMPORTED_MODULE_16__["Pointers"](this),
            gamepads: new _Input_Index__WEBPACK_IMPORTED_MODULE_16__["Gamepads"]()
        };
        this.input.keyboard.init();
        this.input.pointers.init(options && options.pointerScope === _Input_Index__WEBPACK_IMPORTED_MODULE_16__["PointerScope"].Document ? document : this.canvas);
        this.input.gamepads.init();
        this.pageScrollPreventionMode = options.scrollPreventionMode;
        // Issue #385 make use of the visibility api
        // https://developer.mozilla.org/en-US/docs/Web/Guide/User_experience/Using_the_Page_Visibility_API
        var hidden, visibilityChange;
        if (typeof document.hidden !== 'undefined') {
            // Opera 12.10 and Firefox 18 and later support
            hidden = 'hidden';
            visibilityChange = 'visibilitychange';
        }
        else if ('msHidden' in document) {
            hidden = 'msHidden';
            visibilityChange = 'msvisibilitychange';
        }
        else if ('webkitHidden' in document) {
            hidden = 'webkitHidden';
            visibilityChange = 'webkitvisibilitychange';
        }
        document.addEventListener(visibilityChange, function () {
            if (document[hidden]) {
                _this.eventDispatcher.emit('hidden', new _Events__WEBPACK_IMPORTED_MODULE_10__["HiddenEvent"](_this));
                _this._logger.debug('Window hidden');
            }
            else {
                _this.eventDispatcher.emit('visible', new _Events__WEBPACK_IMPORTED_MODULE_10__["VisibleEvent"](_this));
                _this._logger.debug('Window visible');
            }
        });
        this.ctx = this.canvas.getContext('2d');
        this._suppressHiDPIScaling = !!options.suppressHiDPIScaling;
        if (!options.suppressHiDPIScaling) {
            this._initializeHiDpi();
        }
        if (!this.canvasElementId) {
            document.body.appendChild(this.canvas);
        }
    };
    Engine.prototype.onInitialize = function (_engine) {
        // Override me
    };
    Engine.prototype._intializeDisplayModePosition = function (options) {
        if (!options.position) {
            throw new Error('DisplayMode of Position was selected but no position option was given');
        }
        else {
            this.canvas.style.display = 'block';
            this.canvas.style.position = 'absolute';
            if (typeof options.position === 'string') {
                var specifiedPosition = options.position.split(' ');
                switch (specifiedPosition[0]) {
                    case 'top':
                        this.canvas.style.top = '0px';
                        break;
                    case 'bottom':
                        this.canvas.style.bottom = '0px';
                        break;
                    case 'middle':
                        this.canvas.style.top = '50%';
                        var offsetY = -this.halfDrawHeight;
                        this.canvas.style.marginTop = offsetY.toString();
                        break;
                    default:
                        throw new Error('Invalid Position Given');
                }
                if (specifiedPosition[1]) {
                    switch (specifiedPosition[1]) {
                        case 'left':
                            this.canvas.style.left = '0px';
                            break;
                        case 'right':
                            this.canvas.style.right = '0px';
                            break;
                        case 'center':
                            this.canvas.style.left = '50%';
                            var offsetX = -this.halfDrawWidth;
                            this.canvas.style.marginLeft = offsetX.toString();
                            break;
                        default:
                            throw new Error('Invalid Position Given');
                    }
                }
            }
            else {
                if (options.position.top) {
                    typeof options.position.top === 'number'
                        ? (this.canvas.style.top = options.position.top.toString() + 'px')
                        : (this.canvas.style.top = options.position.top);
                }
                if (options.position.right) {
                    typeof options.position.right === 'number'
                        ? (this.canvas.style.right = options.position.right.toString() + 'px')
                        : (this.canvas.style.right = options.position.right);
                }
                if (options.position.bottom) {
                    typeof options.position.bottom === 'number'
                        ? (this.canvas.style.bottom = options.position.bottom.toString() + 'px')
                        : (this.canvas.style.bottom = options.position.bottom);
                }
                if (options.position.left) {
                    typeof options.position.left === 'number'
                        ? (this.canvas.style.left = options.position.left.toString() + 'px')
                        : (this.canvas.style.left = options.position.left);
                }
            }
        }
    };
    Engine.prototype._initializeHiDpi = function () {
        // Scale the canvas if needed
        if (this.isHiDpi) {
            var oldWidth = this.canvas.width;
            var oldHeight = this.canvas.height;
            this.canvas.width = oldWidth * this.pixelRatio;
            this.canvas.height = oldHeight * this.pixelRatio;
            this.canvas.style.width = oldWidth + 'px';
            this.canvas.style.height = oldHeight + 'px';
            this._logger.warn("Hi DPI screen detected, resetting canvas resolution from \n                           " + oldWidth + "x" + oldHeight + " to " + this.canvas.width + "x" + this.canvas.height + " \n                           css size will remain " + oldWidth + "x" + oldHeight);
            this.ctx.scale(this.pixelRatio, this.pixelRatio);
            this._logger.warn("Canvas drawing context was scaled by " + this.pixelRatio);
        }
    };
    /**
     * If supported by the browser, this will set the antialiasing flag on the
     * canvas. Set this to `false` if you want a 'jagged' pixel art look to your
     * image resources.
     * @param isSmooth  Set smoothing to true or false
     */
    Engine.prototype.setAntialiasing = function (isSmooth) {
        this._isSmoothingEnabled = isSmooth;
        var ctx = this.ctx;
        ctx.imageSmoothingEnabled = isSmooth;
        for (var _i = 0, _a = ['webkitImageSmoothingEnabled', 'mozImageSmoothingEnabled', 'msImageSmoothingEnabled']; _i < _a.length; _i++) {
            var smoothing = _a[_i];
            if (smoothing in ctx) {
                ctx[smoothing] = isSmooth;
            }
        }
    };
    /**
     * Return the current smoothing status of the canvas
     */
    Engine.prototype.getAntialiasing = function () {
        return (this.ctx.imageSmoothingEnabled ||
            this.ctx.webkitImageSmoothingEnabled ||
            this.ctx.mozImageSmoothingEnabled ||
            this.ctx.msImageSmoothingEnabled);
    };
    Object.defineProperty(Engine.prototype, "isInitialized", {
        /**
         * Gets whether the actor is Initialized
         */
        get: function () {
            return this._isInitialized;
        },
        enumerable: true,
        configurable: true
    });
    Engine.prototype._overrideInitialize = function (engine) {
        if (!this.isInitialized) {
            this.onInitialize(engine);
            _super.prototype.emit.call(this, 'initialize', new _Events__WEBPACK_IMPORTED_MODULE_10__["InitializeEvent"](engine, this));
            this._isInitialized = true;
        }
    };
    /**
     * Updates the entire state of the game
     * @param delta  Number of milliseconds elapsed since the last update.
     */
    Engine.prototype._update = function (delta) {
        if (this._isLoading) {
            // suspend updates untill loading is finished
            this._loader.update(this, delta);
            // Update input listeners
            this.input.keyboard.update();
            this.input.pointers.update();
            this.input.gamepads.update();
            return;
        }
        this._overrideInitialize(this);
        // Publish preupdate events
        this._preupdate(delta);
        // process engine level events
        this.currentScene.update(this, delta);
        // update animations
        this._animations = this._animations.filter(function (a) {
            return !a.animation.isDone();
        });
        // Update input listeners
        this.input.keyboard.update();
        this.input.pointers.update();
        this.input.gamepads.update();
        // Publish update event
        this._postupdate(delta);
    };
    /**
     * @internal
     */
    Engine.prototype._preupdate = function (delta) {
        this.emit('preupdate', new _Events__WEBPACK_IMPORTED_MODULE_10__["PreUpdateEvent"](this, delta, this));
        this.onPreUpdate(this, delta);
    };
    Engine.prototype.onPreUpdate = function (_engine, _delta) {
        // Override me
    };
    /**
     * @internal
     */
    Engine.prototype._postupdate = function (delta) {
        this.emit('postupdate', new _Events__WEBPACK_IMPORTED_MODULE_10__["PostUpdateEvent"](this, delta, this));
        this.onPostUpdate(this, delta);
    };
    Engine.prototype.onPostUpdate = function (_engine, _delta) {
        // Override me
    };
    /**
     * Draws the entire game
     * @param delta  Number of milliseconds elapsed since the last draw.
     */
    Engine.prototype._draw = function (delta) {
        var ctx = this.ctx;
        this._predraw(ctx, delta);
        if (this._isLoading) {
            this._loader.draw(ctx, delta);
            // Drawing nothing else while loading
            return;
        }
        ctx.clearRect(0, 0, this.canvasWidth, this.canvasHeight);
        ctx.fillStyle = this.backgroundColor.toString();
        ctx.fillRect(0, 0, this.canvasWidth, this.canvasHeight);
        this.currentScene.draw(this.ctx, delta);
        // todo needs to be a better way of doing this
        var a = 0, len = this._animations.length;
        for (a; a < len; a++) {
            this._animations[a].animation.draw(ctx, this._animations[a].x, this._animations[a].y);
        }
        // Draw debug information
        if (this.isDebug) {
            this.ctx.font = 'Consolas';
            this.ctx.fillStyle = this.debugColor.toString();
            var keys = this.input.keyboard.getKeys();
            for (var j = 0; j < keys.length; j++) {
                this.ctx.fillText(keys[j].toString() + ' : ' + (_Input_Index__WEBPACK_IMPORTED_MODULE_16__["Keys"][keys[j]] ? _Input_Index__WEBPACK_IMPORTED_MODULE_16__["Keys"][keys[j]] : 'Not Mapped'), 100, 10 * j + 10);
            }
            this.ctx.fillText('FPS:' + this.stats.currFrame.fps.toFixed(2).toString(), 10, 10);
        }
        // Post processing
        for (var i = 0; i < this.postProcessors.length; i++) {
            this.postProcessors[i].process(this.ctx.getImageData(0, 0, this.canvasWidth, this.canvasHeight), this.ctx);
        }
        this._postdraw(ctx, delta);
    };
    /**
     * @internal
     */
    Engine.prototype._predraw = function (_ctx, delta) {
        this.emit('predraw', new _Events__WEBPACK_IMPORTED_MODULE_10__["PreDrawEvent"](_ctx, delta, this));
        this.onPreDraw(_ctx, delta);
    };
    Engine.prototype.onPreDraw = function (_ctx, _delta) {
        // Override me
    };
    /**
     * @internal
     */
    Engine.prototype._postdraw = function (_ctx, delta) {
        this.emit('postdraw', new _Events__WEBPACK_IMPORTED_MODULE_10__["PostDrawEvent"](_ctx, delta, this));
        this.onPostDraw(_ctx, delta);
    };
    Engine.prototype.onPostDraw = function (_ctx, _delta) {
        // Override me
    };
    /**
     * Starts the internal game loop for Excalibur after loading
     * any provided assets.
     * @param loader  Optional [[ILoader]] to use to load resources. The default loader is [[Loader]], override to provide your own
     * custom loader.
     */
    Engine.prototype.start = function (loader) {
        var _this = this;
        if (!this._compatible) {
            var promise = new _Promises__WEBPACK_IMPORTED_MODULE_2__["Promise"]();
            return promise.reject('Excalibur is incompatible with your browser');
        }
        var loadingComplete;
        if (loader) {
            this._loader = loader;
            this._loader.suppressPlayButton = this._suppressPlayButton;
            this._loader.wireEngine(this);
            loadingComplete = this.load(this._loader);
        }
        else {
            loadingComplete = _Promises__WEBPACK_IMPORTED_MODULE_2__["Promise"].resolve();
        }
        loadingComplete.then(function () {
            _this.emit('start', new _Events__WEBPACK_IMPORTED_MODULE_10__["GameStartEvent"](_this));
        });
        if (!this._hasStarted) {
            this._hasStarted = true;
            this._logger.debug('Starting game...');
            Engine.createMainLoop(this, window.requestAnimationFrame, Date.now)();
            this._logger.debug('Game started');
        }
        else {
            // Game already started;
        }
        return loadingComplete;
    };
    Engine.createMainLoop = function (game, raf, nowFn) {
        var lastTime = nowFn();
        return function mainloop() {
            if (!game._hasStarted) {
                return;
            }
            try {
                game._requestId = raf(mainloop);
                game.emit('preframe', new _Events__WEBPACK_IMPORTED_MODULE_10__["PreFrameEvent"](game, game.stats.prevFrame));
                // Get the time to calculate time-elapsed
                var now = nowFn();
                var elapsed = Math.floor(now - lastTime) || 1;
                // Resolves issue #138 if the game has been paused, or blurred for
                // more than a 200 milliseconds, reset elapsed time to 1. This improves reliability
                // and provides more expected behavior when the engine comes back
                // into focus
                if (elapsed > 200) {
                    elapsed = 1;
                }
                var delta = elapsed * game.timescale;
                // reset frame stats (reuse existing instances)
                var frameId = game.stats.prevFrame.id + 1;
                game.stats.prevFrame.reset(game.stats.currFrame);
                game.stats.currFrame.reset();
                game.stats.currFrame.id = frameId;
                game.stats.currFrame.delta = delta;
                game.stats.currFrame.fps = 1.0 / (delta / 1000);
                var beforeUpdate = nowFn();
                game._update(delta);
                var afterUpdate = nowFn();
                game._draw(delta);
                var afterDraw = nowFn();
                game.stats.currFrame.duration.update = afterUpdate - beforeUpdate;
                game.stats.currFrame.duration.draw = afterDraw - afterUpdate;
                lastTime = now;
                game.emit('postframe', new _Events__WEBPACK_IMPORTED_MODULE_10__["PostFrameEvent"](game, game.stats.currFrame));
            }
            catch (e) {
                window.cancelAnimationFrame(game._requestId);
                game.stop();
                game.onFatalException(e);
            }
        };
    };
    /**
     * Stops Excalibur's main loop, useful for pausing the game.
     */
    Engine.prototype.stop = function () {
        if (this._hasStarted) {
            this.emit('stop', new _Events__WEBPACK_IMPORTED_MODULE_10__["GameStopEvent"](this));
            this._hasStarted = false;
            this._logger.debug('Game stopped');
        }
    };
    /**
     * Returns the Engine's Running status, Useful for checking whether engine is running or paused.
     */
    Engine.prototype.isPaused = function () {
        return !this._hasStarted;
    };
    /**
     * Takes a screen shot of the current viewport and returns it as an
     * HTML Image Element.
     */
    Engine.prototype.screenshot = function () {
        var result = new Image();
        var raw = this.canvas.toDataURL('image/png');
        result.src = raw;
        return result;
    };
    /**
     * Another option available to you to load resources into the game.
     * Immediately after calling this the game will pause and the loading screen
     * will appear.
     * @param loader  Some [[ILoadable]] such as a [[Loader]] collection, [[Sound]], or [[Texture]].
     */
    Engine.prototype.load = function (loader) {
        var _this = this;
        var complete = new _Promises__WEBPACK_IMPORTED_MODULE_2__["Promise"]();
        this._isLoading = true;
        loader.load().then(function () {
            if (_this._suppressPlayButton) {
                setTimeout(function () {
                    _this._isLoading = false;
                    complete.resolve();
                    // Delay is to give the logo a chance to show, otherwise don't delay
                }, 500);
            }
            else {
                _this._isLoading = false;
                complete.resolve();
            }
        });
        return complete;
    };
    /**
     * Default [[IEngineOptions]]
     */
    Engine._DefaultEngineOptions = {
        width: 0,
        height: 0,
        canvasElementId: '',
        pointerScope: _Input_Index__WEBPACK_IMPORTED_MODULE_16__["PointerScope"].Document,
        suppressConsoleBootMessage: null,
        suppressMinimumBrowserFeatureDetection: null,
        suppressHiDPIScaling: null,
        suppressPlayButton: null,
        scrollPreventionMode: ScrollPreventionMode.Canvas,
        backgroundColor: _Drawing_Color__WEBPACK_IMPORTED_MODULE_12__["Color"].fromHex('#2185d0') // Excalibur blue
    };
    return Engine;
}(_Class__WEBPACK_IMPORTED_MODULE_15__["Class"]));

/**
 * @internal
 */
var AnimationNode = /** @class */ (function () {
    function AnimationNode(animation, x, y) {
        this.animation = animation;
        this.x = x;
        this.y = y;
    }
    return AnimationNode;
}());


/***/ }),

/***/ "./EventDispatcher.ts":
/*!****************************!*\
  !*** ./EventDispatcher.ts ***!
  \****************************/
/*! exports provided: EventDispatcher */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EventDispatcher", function() { return EventDispatcher; });
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Events */ "./Events.ts");

/**
 * Excalibur's internal event dispatcher implementation.
 * Callbacks are fired immediately after an event is published.
 * Typically you will use [[Class.eventDispatcher]] since most classes in
 * Excalibur inherit from [[Class]]. You will rarely create an `EventDispatcher`
 * yourself.
 *
 * [[include:Events.md]]
 */
var EventDispatcher = /** @class */ (function () {
    /**
     * @param target  The object that will be the recipient of events from this event dispatcher
     */
    function EventDispatcher(target) {
        this._handlers = {};
        this._wiredEventDispatchers = [];
        this._target = target;
    }
    /**
     * Emits an event for target
     * @param eventName  The name of the event to publish
     * @param event      Optionally pass an event data object to the handler
     */
    EventDispatcher.prototype.emit = function (eventName, event) {
        if (!eventName) {
            // key not mapped
            return;
        }
        eventName = eventName.toLowerCase();
        var target = this._target;
        if (!event) {
            event = new _Events__WEBPACK_IMPORTED_MODULE_0__["GameEvent"]();
        }
        event.target = target;
        var i, len;
        if (this._handlers[eventName]) {
            i = 0;
            len = this._handlers[eventName].length;
            for (i; i < len; i++) {
                this._handlers[eventName][i].call(target, event);
            }
        }
        i = 0;
        len = this._wiredEventDispatchers.length;
        for (i; i < len; i++) {
            this._wiredEventDispatchers[i].emit(eventName, event);
        }
    };
    /**
     * Subscribe an event handler to a particular event name, multiple handlers per event name are allowed.
     * @param eventName  The name of the event to subscribe to
     * @param handler    The handler callback to fire on this event
     */
    EventDispatcher.prototype.on = function (eventName, handler) {
        eventName = eventName.toLowerCase();
        if (!this._handlers[eventName]) {
            this._handlers[eventName] = [];
        }
        this._handlers[eventName].push(handler);
        // meta event handlers
        if (eventName !== 'unsubscribe' && eventName !== 'subscribe') {
            this.emit('subscribe', new _Events__WEBPACK_IMPORTED_MODULE_0__["SubscribeEvent"](eventName, handler));
        }
    };
    /**
     * Unsubscribe an event handler(s) from an event. If a specific handler
     * is specified for an event, only that handler will be unsubscribed.
     * Otherwise all handlers will be unsubscribed for that event.
     *
     * @param eventName  The name of the event to unsubscribe
     * @param handler    Optionally the specific handler to unsubscribe
     *
     */
    EventDispatcher.prototype.off = function (eventName, handler) {
        eventName = eventName.toLowerCase();
        var eventHandlers = this._handlers[eventName];
        if (eventHandlers) {
            // if no explicit handler is give with the event name clear all handlers
            if (!handler) {
                this._handlers[eventName].length = 0;
            }
            else {
                var index = eventHandlers.indexOf(handler);
                this._handlers[eventName].splice(index, 1);
            }
        }
        // meta event handlers
        if (eventName !== 'unsubscribe' && eventName !== 'subscribe') {
            this.emit('unsubscribe', new _Events__WEBPACK_IMPORTED_MODULE_0__["UnsubscribeEvent"](eventName, handler));
        }
    };
    /**
     * Once listens to an event one time, then unsubscribes from that event
     *
     * @param eventName The name of the event to subscribe to once
     * @param handler   The handler of the event that will be auto unsubscribed
     */
    EventDispatcher.prototype.once = function (eventName, handler) {
        var _this = this;
        var metaHandler = function (event) {
            var ev = event || new _Events__WEBPACK_IMPORTED_MODULE_0__["GameEvent"]();
            ev.target = ev.target || _this._target;
            _this.off(eventName, handler);
            handler.call(ev.target, ev);
        };
        this.on(eventName, metaHandler);
    };
    /**
     * Wires this event dispatcher to also recieve events from another
     */
    EventDispatcher.prototype.wire = function (eventDispatcher) {
        eventDispatcher._wiredEventDispatchers.push(this);
    };
    /**
     * Unwires this event dispatcher from another
     */
    EventDispatcher.prototype.unwire = function (eventDispatcher) {
        var index = eventDispatcher._wiredEventDispatchers.indexOf(this);
        if (index > -1) {
            eventDispatcher._wiredEventDispatchers.splice(index, 1);
        }
    };
    return EventDispatcher;
}());



/***/ }),

/***/ "./Events.ts":
/*!*******************!*\
  !*** ./Events.ts ***!
  \*******************/
/*! exports provided: GameEvent, KillEvent, PreKillEvent, PostKillEvent, GameStartEvent, GameStopEvent, PreDrawEvent, PostDrawEvent, PreDebugDrawEvent, PostDebugDrawEvent, PreUpdateEvent, PostUpdateEvent, PreFrameEvent, PostFrameEvent, GamepadConnectEvent, GamepadDisconnectEvent, GamepadButtonEvent, GamepadAxisEvent, SubscribeEvent, UnsubscribeEvent, VisibleEvent, HiddenEvent, PreCollisionEvent, PostCollisionEvent, CollisionStartEvent, CollisionEndEvent, InitializeEvent, ActivateEvent, DeactivateEvent, ExitViewPortEvent, EnterViewPortEvent, EnterTriggerEvent, ExitTriggerEvent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GameEvent", function() { return GameEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "KillEvent", function() { return KillEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PreKillEvent", function() { return PreKillEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PostKillEvent", function() { return PostKillEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GameStartEvent", function() { return GameStartEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GameStopEvent", function() { return GameStopEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PreDrawEvent", function() { return PreDrawEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PostDrawEvent", function() { return PostDrawEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PreDebugDrawEvent", function() { return PreDebugDrawEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PostDebugDrawEvent", function() { return PostDebugDrawEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PreUpdateEvent", function() { return PreUpdateEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PostUpdateEvent", function() { return PostUpdateEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PreFrameEvent", function() { return PreFrameEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PostFrameEvent", function() { return PostFrameEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GamepadConnectEvent", function() { return GamepadConnectEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GamepadDisconnectEvent", function() { return GamepadDisconnectEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GamepadButtonEvent", function() { return GamepadButtonEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "GamepadAxisEvent", function() { return GamepadAxisEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SubscribeEvent", function() { return SubscribeEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UnsubscribeEvent", function() { return UnsubscribeEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "VisibleEvent", function() { return VisibleEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HiddenEvent", function() { return HiddenEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PreCollisionEvent", function() { return PreCollisionEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PostCollisionEvent", function() { return PostCollisionEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CollisionStartEvent", function() { return CollisionStartEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CollisionEndEvent", function() { return CollisionEndEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "InitializeEvent", function() { return InitializeEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActivateEvent", function() { return ActivateEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DeactivateEvent", function() { return DeactivateEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExitViewPortEvent", function() { return ExitViewPortEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EnterViewPortEvent", function() { return EnterViewPortEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EnterTriggerEvent", function() { return EnterTriggerEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExitTriggerEvent", function() { return ExitTriggerEvent; });
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/**
 * Base event type in Excalibur that all other event types derive from. Not all event types are thrown on all Excalibur game objects,
 * some events are unique to a type, others are not.
 *
 */
var GameEvent = /** @class */ (function () {
    function GameEvent() {
        /**
         * determines, if event bubbles to the target's ancestors
         */
        this.bubbles = true;
        /**
         * Holds the whole path from the Root to the event target
         */
        this._path = [];
        this._name = '';
    }
    Object.defineProperty(GameEvent.prototype, "eventPath", {
        /**
         * Returns Event path from root to active actor.
         */
        get: function () {
            return this._path;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(GameEvent.prototype, "name", {
        /**
         * Returns name of the event
         */
        get: function () {
            return this._name;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Prevents event from bubbling
     */
    GameEvent.prototype.stopPropagation = function () {
        this.bubbles = false;
    };
    /**
     * Action, that calls when event happens
     */
    GameEvent.prototype.action = function () {
        var actor = this.eventPath.pop();
        if (actor) {
            this._onActionStart(actor);
            actor.eventDispatcher.emit(this._name, this);
            this._onActionEnd(actor);
        }
    };
    /**
     * Propagate event further through event path
     */
    GameEvent.prototype.propagate = function () {
        if (!this.eventPath.length) {
            return;
        }
        this.action();
        if (this.bubbles) {
            this.propagate();
        }
    };
    GameEvent.prototype.layPath = function (actor) {
        var actorPath = actor.getAncestors();
        this._path = actorPath.length > this._path.length ? actorPath : this._path;
    };
    GameEvent.prototype._onActionStart = function (_actor) {
        // to be rewritten
    };
    GameEvent.prototype._onActionEnd = function (_actor) {
        // to be rewritten
    };
    return GameEvent;
}());

/**
 * The 'kill' event is emitted on actors when it is killed. The target is the actor that was killed.
 */
var KillEvent = /** @class */ (function (_super) {
    __extends(KillEvent, _super);
    function KillEvent(target) {
        var _this = _super.call(this) || this;
        _this.target = target;
        return _this;
    }
    return KillEvent;
}(GameEvent));

/**
 * The 'prekill' event is emitted directly before an actor is killed.
 */
var PreKillEvent = /** @class */ (function (_super) {
    __extends(PreKillEvent, _super);
    function PreKillEvent(target) {
        var _this = _super.call(this) || this;
        _this.target = target;
        return _this;
    }
    return PreKillEvent;
}(GameEvent));

/**
 * The 'postkill' event is emitted directly after the actor is killed.
 */
var PostKillEvent = /** @class */ (function (_super) {
    __extends(PostKillEvent, _super);
    function PostKillEvent(target) {
        var _this = _super.call(this) || this;
        _this.target = target;
        return _this;
    }
    return PostKillEvent;
}(GameEvent));

/**
 * The 'start' event is emitted on engine when has started and is ready for interaction.
 */
var GameStartEvent = /** @class */ (function (_super) {
    __extends(GameStartEvent, _super);
    function GameStartEvent(target) {
        var _this = _super.call(this) || this;
        _this.target = target;
        return _this;
    }
    return GameStartEvent;
}(GameEvent));

/**
 * The 'stop' event is emitted on engine when has been stopped and will no longer take input, update or draw.
 */
var GameStopEvent = /** @class */ (function (_super) {
    __extends(GameStopEvent, _super);
    function GameStopEvent(target) {
        var _this = _super.call(this) || this;
        _this.target = target;
        return _this;
    }
    return GameStopEvent;
}(GameEvent));

/**
 * The 'predraw' event is emitted on actors, scenes, and engine before drawing starts. Actors' predraw happens inside their graphics
 * transform so that all drawing takes place with the actor as the origin.
 *
 */
var PreDrawEvent = /** @class */ (function (_super) {
    __extends(PreDrawEvent, _super);
    function PreDrawEvent(ctx, delta, target) {
        var _this = _super.call(this) || this;
        _this.ctx = ctx;
        _this.delta = delta;
        _this.target = target;
        return _this;
    }
    return PreDrawEvent;
}(GameEvent));

/**
 * The 'postdraw' event is emitted on actors, scenes, and engine after drawing finishes. Actors' postdraw happens inside their graphics
 * transform so that all drawing takes place with the actor as the origin.
 *
 */
var PostDrawEvent = /** @class */ (function (_super) {
    __extends(PostDrawEvent, _super);
    function PostDrawEvent(ctx, delta, target) {
        var _this = _super.call(this) || this;
        _this.ctx = ctx;
        _this.delta = delta;
        _this.target = target;
        return _this;
    }
    return PostDrawEvent;
}(GameEvent));

/**
 * The 'predebugdraw' event is emitted on actors, scenes, and engine before debug drawing starts.
 */
var PreDebugDrawEvent = /** @class */ (function (_super) {
    __extends(PreDebugDrawEvent, _super);
    function PreDebugDrawEvent(ctx, target) {
        var _this = _super.call(this) || this;
        _this.ctx = ctx;
        _this.target = target;
        return _this;
    }
    return PreDebugDrawEvent;
}(GameEvent));

/**
 * The 'postdebugdraw' event is emitted on actors, scenes, and engine after debug drawing starts.
 */
var PostDebugDrawEvent = /** @class */ (function (_super) {
    __extends(PostDebugDrawEvent, _super);
    function PostDebugDrawEvent(ctx, target) {
        var _this = _super.call(this) || this;
        _this.ctx = ctx;
        _this.target = target;
        return _this;
    }
    return PostDebugDrawEvent;
}(GameEvent));

/**
 * The 'preupdate' event is emitted on actors, scenes, camera, and engine before the update starts.
 */
var PreUpdateEvent = /** @class */ (function (_super) {
    __extends(PreUpdateEvent, _super);
    function PreUpdateEvent(engine, delta, target) {
        var _this = _super.call(this) || this;
        _this.engine = engine;
        _this.delta = delta;
        _this.target = target;
        return _this;
    }
    return PreUpdateEvent;
}(GameEvent));

/**
 * The 'postupdate' event is emitted on actors, scenes, camera, and engine after the update ends.
 */
var PostUpdateEvent = /** @class */ (function (_super) {
    __extends(PostUpdateEvent, _super);
    function PostUpdateEvent(engine, delta, target) {
        var _this = _super.call(this) || this;
        _this.engine = engine;
        _this.delta = delta;
        _this.target = target;
        return _this;
    }
    return PostUpdateEvent;
}(GameEvent));

/**
 * The 'preframe' event is emitted on the engine, before the frame begins.
 */
var PreFrameEvent = /** @class */ (function (_super) {
    __extends(PreFrameEvent, _super);
    function PreFrameEvent(engine, prevStats) {
        var _this = _super.call(this) || this;
        _this.engine = engine;
        _this.prevStats = prevStats;
        _this.target = engine;
        return _this;
    }
    return PreFrameEvent;
}(GameEvent));

/**
 * The 'postframe' event is emitted on the engine, after a frame ends.
 */
var PostFrameEvent = /** @class */ (function (_super) {
    __extends(PostFrameEvent, _super);
    function PostFrameEvent(engine, stats) {
        var _this = _super.call(this) || this;
        _this.engine = engine;
        _this.stats = stats;
        _this.target = engine;
        return _this;
    }
    return PostFrameEvent;
}(GameEvent));

/**
 * Event received when a gamepad is connected to Excalibur. [[Gamepads]] receives this event.
 */
var GamepadConnectEvent = /** @class */ (function (_super) {
    __extends(GamepadConnectEvent, _super);
    function GamepadConnectEvent(index, gamepad) {
        var _this = _super.call(this) || this;
        _this.index = index;
        _this.gamepad = gamepad;
        _this.target = gamepad;
        return _this;
    }
    return GamepadConnectEvent;
}(GameEvent));

/**
 * Event received when a gamepad is disconnected from Excalibur. [[Gamepads]] receives this event.
 */
var GamepadDisconnectEvent = /** @class */ (function (_super) {
    __extends(GamepadDisconnectEvent, _super);
    function GamepadDisconnectEvent(index, gamepad) {
        var _this = _super.call(this) || this;
        _this.index = index;
        _this.gamepad = gamepad;
        _this.target = gamepad;
        return _this;
    }
    return GamepadDisconnectEvent;
}(GameEvent));

/**
 * Gamepad button event. See [[Gamepads]] for information on responding to controller input. [[Gamepad]] instances receive this event;
 */
var GamepadButtonEvent = /** @class */ (function (_super) {
    __extends(GamepadButtonEvent, _super);
    /**
     * @param button  The Gamepad button
     * @param value   A numeric value between 0 and 1
     */
    function GamepadButtonEvent(button, value, target) {
        var _this = _super.call(this) || this;
        _this.button = button;
        _this.value = value;
        _this.target = target;
        return _this;
    }
    return GamepadButtonEvent;
}(GameEvent));

/**
 * Gamepad axis event. See [[Gamepads]] for information on responding to controller input. [[Gamepad]] instances receive this event;
 */
var GamepadAxisEvent = /** @class */ (function (_super) {
    __extends(GamepadAxisEvent, _super);
    /**
     * @param axis  The Gamepad axis
     * @param value A numeric value between -1 and 1
     */
    function GamepadAxisEvent(axis, value, target) {
        var _this = _super.call(this) || this;
        _this.axis = axis;
        _this.value = value;
        _this.target = target;
        return _this;
    }
    return GamepadAxisEvent;
}(GameEvent));

/**
 * Subscribe event thrown when handlers for events other than subscribe are added. Meta event that is received by
 * [[EventDispatcher|event dispatchers]].
 */
var SubscribeEvent = /** @class */ (function (_super) {
    __extends(SubscribeEvent, _super);
    function SubscribeEvent(topic, handler) {
        var _this = _super.call(this) || this;
        _this.topic = topic;
        _this.handler = handler;
        return _this;
    }
    return SubscribeEvent;
}(GameEvent));

/**
 * Unsubscribe event thrown when handlers for events other than unsubscribe are removed. Meta event that is received by
 * [[EventDispatcher|event dispatchers]].
 */
var UnsubscribeEvent = /** @class */ (function (_super) {
    __extends(UnsubscribeEvent, _super);
    function UnsubscribeEvent(topic, handler) {
        var _this = _super.call(this) || this;
        _this.topic = topic;
        _this.handler = handler;
        return _this;
    }
    return UnsubscribeEvent;
}(GameEvent));

/**
 * Event received by the [[Engine]] when the browser window is visible on a screen.
 */
var VisibleEvent = /** @class */ (function (_super) {
    __extends(VisibleEvent, _super);
    function VisibleEvent(target) {
        var _this = _super.call(this) || this;
        _this.target = target;
        return _this;
    }
    return VisibleEvent;
}(GameEvent));

/**
 * Event received by the [[Engine]] when the browser window is hidden from all screens.
 */
var HiddenEvent = /** @class */ (function (_super) {
    __extends(HiddenEvent, _super);
    function HiddenEvent(target) {
        var _this = _super.call(this) || this;
        _this.target = target;
        return _this;
    }
    return HiddenEvent;
}(GameEvent));

/**
 * Event thrown on an [[Actor|actor]] when a collision will occur this frame if it resolves
 */
var PreCollisionEvent = /** @class */ (function (_super) {
    __extends(PreCollisionEvent, _super);
    /**
     * @param actor         The actor the event was thrown on
     * @param other         The actor that will collided with the current actor
     * @param side          The side that will be collided with the current actor
     * @param intersection  Intersection vector
     */
    function PreCollisionEvent(actor, other, side, intersection) {
        var _this = _super.call(this) || this;
        _this.actor = actor;
        _this.other = other;
        _this.side = side;
        _this.intersection = intersection;
        _this.target = actor;
        return _this;
    }
    return PreCollisionEvent;
}(GameEvent));

/**
 * Event thrown on an [[Actor|actor]] when a collision has been resolved (body reacted) this frame
 */
var PostCollisionEvent = /** @class */ (function (_super) {
    __extends(PostCollisionEvent, _super);
    /**
     * @param actor         The actor the event was thrown on
     * @param other         The actor that did collide with the current actor
     * @param side          The side that did collide with the current actor
     * @param intersection  Intersection vector
     */
    function PostCollisionEvent(actor, other, side, intersection) {
        var _this = _super.call(this) || this;
        _this.actor = actor;
        _this.other = other;
        _this.side = side;
        _this.intersection = intersection;
        _this.target = actor;
        return _this;
    }
    return PostCollisionEvent;
}(GameEvent));

/**
 * Event thrown the first time an [[Actor|actor]] collides with another, after an actor is in contact normal collision events are fired.
 */
var CollisionStartEvent = /** @class */ (function (_super) {
    __extends(CollisionStartEvent, _super);
    /**
     *
     */
    function CollisionStartEvent(actor, other, pair) {
        var _this = _super.call(this) || this;
        _this.actor = actor;
        _this.other = other;
        _this.pair = pair;
        _this.target = actor;
        return _this;
    }
    return CollisionStartEvent;
}(GameEvent));

/**
 * Event thrown when the [[Actor|actor]] is no longer colliding with another
 */
var CollisionEndEvent = /** @class */ (function (_super) {
    __extends(CollisionEndEvent, _super);
    /**
     *
     */
    function CollisionEndEvent(actor, other) {
        var _this = _super.call(this) || this;
        _this.actor = actor;
        _this.other = other;
        _this.target = actor;
        return _this;
    }
    return CollisionEndEvent;
}(GameEvent));

/**
 * Event thrown on an [[Actor]] and a [[Scene]] only once before the first update call
 */
var InitializeEvent = /** @class */ (function (_super) {
    __extends(InitializeEvent, _super);
    /**
     * @param engine  The reference to the current engine
     */
    function InitializeEvent(engine, target) {
        var _this = _super.call(this) || this;
        _this.engine = engine;
        _this.target = target;
        return _this;
    }
    return InitializeEvent;
}(GameEvent));

/**
 * Event thrown on a [[Scene]] on activation
 */
var ActivateEvent = /** @class */ (function (_super) {
    __extends(ActivateEvent, _super);
    /**
     * @param oldScene  The reference to the old scene
     */
    function ActivateEvent(oldScene, target) {
        var _this = _super.call(this) || this;
        _this.oldScene = oldScene;
        _this.target = target;
        return _this;
    }
    return ActivateEvent;
}(GameEvent));

/**
 * Event thrown on a [[Scene]] on deactivation
 */
var DeactivateEvent = /** @class */ (function (_super) {
    __extends(DeactivateEvent, _super);
    /**
     * @param newScene  The reference to the new scene
     */
    function DeactivateEvent(newScene, target) {
        var _this = _super.call(this) || this;
        _this.newScene = newScene;
        _this.target = target;
        return _this;
    }
    return DeactivateEvent;
}(GameEvent));

/**
 * Event thrown on an [[Actor]] when it completely leaves the screen.
 */
var ExitViewPortEvent = /** @class */ (function (_super) {
    __extends(ExitViewPortEvent, _super);
    function ExitViewPortEvent(target) {
        var _this = _super.call(this) || this;
        _this.target = target;
        return _this;
    }
    return ExitViewPortEvent;
}(GameEvent));

/**
 * Event thrown on an [[Actor]] when it completely leaves the screen.
 */
var EnterViewPortEvent = /** @class */ (function (_super) {
    __extends(EnterViewPortEvent, _super);
    function EnterViewPortEvent(target) {
        var _this = _super.call(this) || this;
        _this.target = target;
        return _this;
    }
    return EnterViewPortEvent;
}(GameEvent));

var EnterTriggerEvent = /** @class */ (function (_super) {
    __extends(EnterTriggerEvent, _super);
    function EnterTriggerEvent(target, actor) {
        var _this = _super.call(this) || this;
        _this.target = target;
        _this.actor = actor;
        return _this;
    }
    return EnterTriggerEvent;
}(GameEvent));

var ExitTriggerEvent = /** @class */ (function (_super) {
    __extends(ExitTriggerEvent, _super);
    function ExitTriggerEvent(target, actor) {
        var _this = _super.call(this) || this;
        _this.target = target;
        _this.actor = actor;
        return _this;
    }
    return ExitTriggerEvent;
}(GameEvent));



/***/ }),

/***/ "./Events/MediaEvents.ts":
/*!*******************************!*\
  !*** ./Events/MediaEvents.ts ***!
  \*******************************/
/*! exports provided: MediaEvent, NativeSoundEvent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MediaEvent", function() { return MediaEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "NativeSoundEvent", function() { return NativeSoundEvent; });
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Events */ "./Events.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var MediaEvent = /** @class */ (function (_super) {
    __extends(MediaEvent, _super);
    function MediaEvent(target, _name) {
        if (_name === void 0) { _name = 'MediaEvent'; }
        var _this = _super.call(this) || this;
        _this.target = target;
        _this._name = _name;
        return _this;
    }
    Object.defineProperty(MediaEvent.prototype, "bubbles", {
        /**
         * Media event cannot bubble
         */
        get: function () {
            return false;
        },
        /**
         * Media event cannot bubble
         */
        set: function (_value) {
            // stubbed
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MediaEvent.prototype, "_path", {
        /**
         * Media event cannot bubble, so they have no path
         */
        get: function () {
            return null;
        },
        /**
         * Media event cannot bubble, so they have no path
         */
        set: function (_val) {
            // stubbed
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Prevents event from bubbling
     */
    MediaEvent.prototype.stopPropagation = function () {
        /**
         * Stub
         */
    };
    /**
     * Action, that calls when event happens
     */
    MediaEvent.prototype.action = function () {
        /**
         * Stub
         */
    };
    /**
     * Propagate event further through event path
     */
    MediaEvent.prototype.propagate = function () {
        /**
         * Stub
         */
    };
    MediaEvent.prototype.layPath = function (_actor) {
        /**
         * Stub
         */
    };
    return MediaEvent;
}(_Events__WEBPACK_IMPORTED_MODULE_0__["GameEvent"]));

var NativeSoundEvent = /** @class */ (function (_super) {
    __extends(NativeSoundEvent, _super);
    function NativeSoundEvent(target, track) {
        var _this = _super.call(this, target, 'NativeSoundEvent') || this;
        _this.track = track;
        return _this;
    }
    return NativeSoundEvent;
}(MediaEvent));



/***/ }),

/***/ "./Group.ts":
/*!******************!*\
  !*** ./Group.ts ***!
  \******************/
/*! exports provided: Group */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Group", function() { return Group; });
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");
/* harmony import */ var _Actions_ActionContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Actions/ActionContext */ "./Actions/ActionContext.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Actor */ "./Actor.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Class */ "./Class.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





/**
 * Groups are used for logically grouping Actors so they can be acted upon
 * in bulk.
 *
 * [[include:Groups.md]]
 */
var Group = /** @class */ (function (_super) {
    __extends(Group, _super);
    function Group(name, scene) {
        var _this = _super.call(this) || this;
        _this.name = name;
        _this.scene = scene;
        _this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_3__["Logger"].getInstance();
        _this._members = [];
        _this.actions = new _Actions_ActionContext__WEBPACK_IMPORTED_MODULE_1__["ActionContext"]();
        if (scene == null) {
            _this._logger.error('Invalid constructor arguments passed to Group: ', name, ', scene must not be null!');
        }
        else {
            var existingGroup = scene.groups[name];
            if (existingGroup) {
                _this._logger.warn('Group with name', name, 'already exists. This new group will replace it.');
            }
            scene.groups[name] = _this;
        }
        return _this;
    }
    Group.prototype.add = function (actorOrActors) {
        if (actorOrActors instanceof _Actor__WEBPACK_IMPORTED_MODULE_2__["Actor"]) {
            actorOrActors = [].concat(actorOrActors);
        }
        var i = 0, len = actorOrActors.length, groupIdx;
        for (i; i < len; i++) {
            groupIdx = this.getMembers().indexOf(actorOrActors[i]);
            if (groupIdx === -1) {
                this._members.push(actorOrActors[i]);
                this.scene.add(actorOrActors[i]);
                this.actions.addActorToContext(actorOrActors[i]);
                this.eventDispatcher.wire(actorOrActors[i].eventDispatcher);
            }
        }
    };
    Group.prototype.remove = function (actor) {
        var index = this._members.indexOf(actor);
        if (index > -1) {
            this._members.splice(index, 1);
            this.actions.removeActorFromContext(actor);
            this.eventDispatcher.unwire(actor.eventDispatcher);
        }
    };
    Group.prototype.move = function (args) {
        var i = 0, members = this.getMembers(), len = members.length;
        if (arguments.length === 1 && args instanceof _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"]) {
            for (i; i < len; i++) {
                members[i].pos.x += args.x;
                members[i].pos.y += args.y;
            }
        }
        else if (typeof arguments[0] === 'number' && typeof arguments[1] === 'number') {
            var x = arguments[0];
            var y = arguments[1];
            for (i; i < len; i++) {
                members[i].pos.x += x;
                members[i].pos.y += y;
            }
        }
        else {
            this._logger.error('Invalid arguments passed to group move', this.name, 'args:', arguments);
        }
    };
    Group.prototype.rotate = function (angle) {
        if (typeof angle !== 'number') {
            this._logger.error('Invalid arguments passed to group rotate', this.name, 'args:', arguments);
            return;
        }
        for (var _i = 0, _a = this.getMembers(); _i < _a.length; _i++) {
            var member = _a[_i];
            member.rotation += angle;
        }
    };
    Group.prototype.on = function (eventName, handler) {
        this.eventDispatcher.on(eventName, handler);
    };
    Group.prototype.off = function (eventName, handler) {
        this.eventDispatcher.off(eventName, handler);
    };
    Group.prototype.emit = function (topic, event) {
        this.eventDispatcher.emit(topic, event);
    };
    Group.prototype.contains = function (actor) {
        return this.getMembers().indexOf(actor) > -1;
    };
    Group.prototype.getMembers = function () {
        return this._members;
    };
    Group.prototype.getRandomMember = function () {
        return this._members[Math.floor(Math.random() * this._members.length)];
    };
    Group.prototype.getBounds = function () {
        return this.getMembers()
            .map(function (a) { return a.getBounds(); })
            .reduce(function (prev, curr) {
            return prev.combine(curr);
        });
    };
    return Group;
}(_Class__WEBPACK_IMPORTED_MODULE_4__["Class"]));



/***/ }),

/***/ "./Input/Gamepad.ts":
/*!**************************!*\
  !*** ./Input/Gamepad.ts ***!
  \**************************/
/*! exports provided: Gamepads, Gamepad, Buttons, Axes */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Gamepads", function() { return Gamepads; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Gamepad", function() { return Gamepad; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Buttons", function() { return Buttons; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Axes", function() { return Axes; });
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Class */ "./Class.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Events */ "./Events.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


/**
 * Excalibur leverages the HTML5 Gamepad API [where it is supported](http://caniuse.com/#feat=gamepad)
 * to provide controller support for your games.
 *
 * [[include:Gamepads.md]]
 */
var Gamepads = /** @class */ (function (_super) {
    __extends(Gamepads, _super);
    function Gamepads() {
        var _this = _super.call(this) || this;
        /**
         * Whether or not to poll for Gamepad input (default: `false`)
         */
        _this.enabled = false;
        /**
         * Whether or not Gamepad API is supported
         */
        _this.supported = !!navigator.getGamepads;
        _this._gamePadTimeStamps = [0, 0, 0, 0];
        _this._oldPads = [];
        _this._pads = [];
        _this._initSuccess = false;
        _this._navigator = navigator;
        _this._minimumConfiguration = null;
        return _this;
    }
    Gamepads.prototype.init = function () {
        if (!this.supported) {
            return;
        }
        if (this._initSuccess) {
            return;
        }
        // In Chrome, this will return 4 undefined items until a button is pressed
        // In FF, this will not return any items until a button is pressed
        this._oldPads = this._clonePads(this._navigator.getGamepads());
        if (this._oldPads.length && this._oldPads[0]) {
            this._initSuccess = true;
        }
    };
    /**
     * Sets the minimum gamepad configuration, for example {axis: 4, buttons: 4} means
     * this game requires at minimum 4 axis inputs and 4 buttons, this is not restrictive
     * all other controllers with more axis or buttons are valid as well. If no minimum
     * configuration is set all pads are valid.
     */
    Gamepads.prototype.setMinimumGamepadConfiguration = function (config) {
        this._enableAndUpdate(); // if config is used, implicitly enable
        this._minimumConfiguration = config;
    };
    /**
     * When implicitly enabled, set the enabled flag and run an update so information is updated
     */
    Gamepads.prototype._enableAndUpdate = function () {
        if (!this.enabled) {
            this.enabled = true;
            this.update();
        }
    };
    /**
     * Checks a navigator gamepad against the minimum configuration if present.
     */
    Gamepads.prototype._isGamepadValid = function (pad) {
        if (!this._minimumConfiguration) {
            return true;
        }
        if (!pad) {
            return false;
        }
        var axesLength = pad.axes.filter(function (value) {
            return typeof value !== undefined;
        }).length;
        var buttonLength = pad.buttons.filter(function (value) {
            return typeof value !== undefined;
        }).length;
        return axesLength >= this._minimumConfiguration.axis && buttonLength >= this._minimumConfiguration.buttons && pad.connected;
    };
    Gamepads.prototype.on = function (eventName, handler) {
        this._enableAndUpdate(); // implicitly enable
        _super.prototype.on.call(this, eventName, handler);
    };
    Gamepads.prototype.off = function (eventName, handler) {
        this._enableAndUpdate(); // implicitly enable
        _super.prototype.off.call(this, eventName, handler);
    };
    /**
     * Updates Gamepad state and publishes Gamepad events
     */
    Gamepads.prototype.update = function () {
        if (!this.enabled || !this.supported) {
            return;
        }
        this.init();
        var gamepads = this._navigator.getGamepads();
        for (var i = 0; i < gamepads.length; i++) {
            if (!gamepads[i]) {
                var gamepad = this.at(i);
                // If was connected, but now isn't emit the disconnect event
                if (gamepad.connected) {
                    this.eventDispatcher.emit('disconnect', new _Events__WEBPACK_IMPORTED_MODULE_1__["GamepadDisconnectEvent"](i, gamepad));
                }
                // Reset connection status
                gamepad.connected = false;
                continue;
            }
            else {
                if (!this.at(i).connected && this._isGamepadValid(gamepads[i])) {
                    this.eventDispatcher.emit('connect', new _Events__WEBPACK_IMPORTED_MODULE_1__["GamepadConnectEvent"](i, this.at(i)));
                }
                // Set connection status
                this.at(i).connected = true;
            }
            // Only supported in Chrome
            if (gamepads[i].timestamp && gamepads[i].timestamp === this._gamePadTimeStamps[i]) {
                continue;
            }
            this._gamePadTimeStamps[i] = gamepads[i].timestamp;
            // Add reference to navigator gamepad
            this.at(i).navigatorGamepad = gamepads[i];
            // Buttons
            var b, bi, a, ai, value;
            for (b in Buttons) {
                bi = Buttons[b];
                if (typeof bi === 'number') {
                    if (gamepads[i].buttons[bi]) {
                        value = gamepads[i].buttons[bi].value;
                        if (value !== this._oldPads[i].getButton(bi)) {
                            if (gamepads[i].buttons[bi].pressed) {
                                this.at(i).updateButton(bi, value);
                                this.at(i).eventDispatcher.emit('button', new _Events__WEBPACK_IMPORTED_MODULE_1__["GamepadButtonEvent"](bi, value, this.at(i)));
                            }
                            else {
                                this.at(i).updateButton(bi, 0);
                            }
                        }
                    }
                }
            }
            // Axes
            for (a in Axes) {
                ai = Axes[a];
                if (typeof ai === 'number') {
                    value = gamepads[i].axes[ai];
                    if (value !== this._oldPads[i].getAxes(ai)) {
                        this.at(i).updateAxes(ai, value);
                        this.at(i).eventDispatcher.emit('axis', new _Events__WEBPACK_IMPORTED_MODULE_1__["GamepadAxisEvent"](ai, value, this.at(i)));
                    }
                }
            }
            this._oldPads[i] = this._clonePad(gamepads[i]);
        }
    };
    /**
     * Safely retrieves a Gamepad at a specific index and creates one if it doesn't yet exist
     */
    Gamepads.prototype.at = function (index) {
        this._enableAndUpdate(); // implicitly enable gamepads when at() is called
        if (index >= this._pads.length) {
            // Ensure there is a pad to retrieve
            for (var i = this._pads.length - 1, max = index; i < max; i++) {
                this._pads.push(new Gamepad());
                this._oldPads.push(new Gamepad());
            }
        }
        return this._pads[index];
    };
    /**
     * Returns a list of all valid gamepads that meet the minimum configuration requirement.
     */
    Gamepads.prototype.getValidGamepads = function () {
        this._enableAndUpdate();
        var result = [];
        for (var i = 0; i < this._pads.length; i++) {
            if (this._isGamepadValid(this.at(i).navigatorGamepad) && this.at(i).connected) {
                result.push(this.at(i));
            }
        }
        return result;
    };
    /**
     * Gets the number of connected gamepads
     */
    Gamepads.prototype.count = function () {
        return this._pads.filter(function (p) { return p.connected; }).length;
    };
    Gamepads.prototype._clonePads = function (pads) {
        var arr = [];
        for (var i = 0, len = pads.length; i < len; i++) {
            arr.push(this._clonePad(pads[i]));
        }
        return arr;
    };
    /**
     * Fastest way to clone a known object is to do it yourself
     */
    Gamepads.prototype._clonePad = function (pad) {
        var i, len;
        var clonedPad = new Gamepad();
        if (!pad) {
            return clonedPad;
        }
        for (i = 0, len = pad.buttons.length; i < len; i++) {
            if (pad.buttons[i]) {
                clonedPad.updateButton(i, pad.buttons[i].value);
            }
        }
        for (i = 0, len = pad.axes.length; i < len; i++) {
            clonedPad.updateAxes(i, pad.axes[i]);
        }
        return clonedPad;
    };
    /**
     * The minimum value an axis has to move before considering it a change
     */
    Gamepads.MinAxisMoveThreshold = 0.05;
    return Gamepads;
}(_Class__WEBPACK_IMPORTED_MODULE_0__["Class"]));

/**
 * Gamepad holds state information for a connected controller. See [[Gamepads]]
 * for more information on handling controller input.
 */
var Gamepad = /** @class */ (function (_super) {
    __extends(Gamepad, _super);
    function Gamepad() {
        var _this = _super.call(this) || this;
        _this.connected = false;
        _this._buttons = new Array(16);
        _this._axes = new Array(4);
        var i;
        for (i = 0; i < _this._buttons.length; i++) {
            _this._buttons[i] = 0;
        }
        for (i = 0; i < _this._axes.length; i++) {
            _this._axes[i] = 0;
        }
        return _this;
    }
    /**
     * Whether or not the given button is pressed
     * @param button     The button to query
     * @param threshold  The threshold over which the button is considered to be pressed
     */
    Gamepad.prototype.isButtonPressed = function (button, threshold) {
        if (threshold === void 0) { threshold = 1; }
        return this._buttons[button] >= threshold;
    };
    /**
     * Gets the given button value between 0 and 1
     */
    Gamepad.prototype.getButton = function (button) {
        return this._buttons[button];
    };
    /**
     * Gets the given axis value between -1 and 1. Values below
     * [[MinAxisMoveThreshold]] are considered 0.
     */
    Gamepad.prototype.getAxes = function (axes) {
        var value = this._axes[axes];
        if (Math.abs(value) < Gamepads.MinAxisMoveThreshold) {
            return 0;
        }
        else {
            return value;
        }
    };
    Gamepad.prototype.updateButton = function (buttonIndex, value) {
        this._buttons[buttonIndex] = value;
    };
    Gamepad.prototype.updateAxes = function (axesIndex, value) {
        this._axes[axesIndex] = value;
    };
    return Gamepad;
}(_Class__WEBPACK_IMPORTED_MODULE_0__["Class"]));

/**
 * Gamepad Buttons enumeration
 */
var Buttons;
(function (Buttons) {
    /**
     * Face 1 button (e.g. A)
     */
    Buttons[Buttons["Face1"] = 0] = "Face1";
    /**
     * Face 2 button (e.g. B)
     */
    Buttons[Buttons["Face2"] = 1] = "Face2";
    /**
     * Face 3 button (e.g. X)
     */
    Buttons[Buttons["Face3"] = 2] = "Face3";
    /**
     * Face 4 button (e.g. Y)
     */
    Buttons[Buttons["Face4"] = 3] = "Face4";
    /**
     * Left bumper button
     */
    Buttons[Buttons["LeftBumper"] = 4] = "LeftBumper";
    /**
     * Right bumper button
     */
    Buttons[Buttons["RightBumper"] = 5] = "RightBumper";
    /**
     * Left trigger button
     */
    Buttons[Buttons["LeftTrigger"] = 6] = "LeftTrigger";
    /**
     * Right trigger button
     */
    Buttons[Buttons["RightTrigger"] = 7] = "RightTrigger";
    /**
     * Select button
     */
    Buttons[Buttons["Select"] = 8] = "Select";
    /**
     * Start button
     */
    Buttons[Buttons["Start"] = 9] = "Start";
    /**
     * Left analog stick press (e.g. L3)
     */
    Buttons[Buttons["LeftStick"] = 10] = "LeftStick";
    /**
     * Right analog stick press (e.g. R3)
     */
    Buttons[Buttons["RightStick"] = 11] = "RightStick";
    /**
     * D-pad up
     */
    Buttons[Buttons["DpadUp"] = 12] = "DpadUp";
    /**
     * D-pad down
     */
    Buttons[Buttons["DpadDown"] = 13] = "DpadDown";
    /**
     * D-pad left
     */
    Buttons[Buttons["DpadLeft"] = 14] = "DpadLeft";
    /**
     * D-pad right
     */
    Buttons[Buttons["DpadRight"] = 15] = "DpadRight";
})(Buttons || (Buttons = {}));
/**
 * Gamepad Axes enumeration
 */
var Axes;
(function (Axes) {
    /**
     * Left analogue stick X direction
     */
    Axes[Axes["LeftStickX"] = 0] = "LeftStickX";
    /**
     * Left analogue stick Y direction
     */
    Axes[Axes["LeftStickY"] = 1] = "LeftStickY";
    /**
     * Right analogue stick X direction
     */
    Axes[Axes["RightStickX"] = 2] = "RightStickX";
    /**
     * Right analogue stick Y direction
     */
    Axes[Axes["RightStickY"] = 3] = "RightStickY";
})(Axes || (Axes = {}));


/***/ }),

/***/ "./Input/Index.ts":
/*!************************!*\
  !*** ./Input/Index.ts ***!
  \************************/
/*! exports provided: Gamepads, Gamepad, Buttons, Axes, PointerType, PointerButton, WheelDeltaMode, PointerScope, PointerEvent, PointerEventFactory, PointerDragEvent, PointerUpEvent, PointerDownEvent, PointerMoveEvent, PointerEnterEvent, PointerLeaveEvent, PointerCancelEvent, WheelEvent, Pointers, Pointer, Keys, KeyEvent, Keyboard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Gamepad__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Gamepad */ "./Input/Gamepad.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Gamepads", function() { return _Gamepad__WEBPACK_IMPORTED_MODULE_0__["Gamepads"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Gamepad", function() { return _Gamepad__WEBPACK_IMPORTED_MODULE_0__["Gamepad"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Buttons", function() { return _Gamepad__WEBPACK_IMPORTED_MODULE_0__["Buttons"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Axes", function() { return _Gamepad__WEBPACK_IMPORTED_MODULE_0__["Axes"]; });

/* harmony import */ var _Pointer__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Pointer */ "./Input/Pointer.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerType", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerType"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerButton", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerButton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "WheelDeltaMode", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["WheelDeltaMode"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerScope", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerScope"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerEvent", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerEventFactory", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerEventFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerDragEvent", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerDragEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerUpEvent", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerUpEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerDownEvent", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerDownEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerMoveEvent", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerMoveEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerEnterEvent", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerEnterEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerLeaveEvent", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerLeaveEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PointerCancelEvent", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["PointerCancelEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "WheelEvent", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["WheelEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Pointers", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["Pointers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Pointer", function() { return _Pointer__WEBPACK_IMPORTED_MODULE_1__["Pointer"]; });

/* harmony import */ var _Keyboard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Keyboard */ "./Input/Keyboard.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Keys", function() { return _Keyboard__WEBPACK_IMPORTED_MODULE_2__["Keys"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "KeyEvent", function() { return _Keyboard__WEBPACK_IMPORTED_MODULE_2__["KeyEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Keyboard", function() { return _Keyboard__WEBPACK_IMPORTED_MODULE_2__["Keyboard"]; });

/**
 * Provides support for mice, keyboards, and controllers.
 *
 * [[include:Input.md]]
 */
/**
 * @typedoc
 */





/***/ }),

/***/ "./Input/Keyboard.ts":
/*!***************************!*\
  !*** ./Input/Keyboard.ts ***!
  \***************************/
/*! exports provided: Keys, KeyEvent, Keyboard */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Keys", function() { return Keys; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "KeyEvent", function() { return KeyEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Keyboard", function() { return Keyboard; });
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Class */ "./Class.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Events */ "./Events.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


/**
 * Enum representing input key codes
 */
var Keys;
(function (Keys) {
    Keys[Keys["Num1"] = 97] = "Num1";
    Keys[Keys["Num2"] = 98] = "Num2";
    Keys[Keys["Num3"] = 99] = "Num3";
    Keys[Keys["Num4"] = 100] = "Num4";
    Keys[Keys["Num5"] = 101] = "Num5";
    Keys[Keys["Num6"] = 102] = "Num6";
    Keys[Keys["Num7"] = 103] = "Num7";
    Keys[Keys["Num8"] = 104] = "Num8";
    Keys[Keys["Num9"] = 105] = "Num9";
    Keys[Keys["Num0"] = 96] = "Num0";
    Keys[Keys["Numlock"] = 144] = "Numlock";
    Keys[Keys["Semicolon"] = 186] = "Semicolon";
    Keys[Keys["A"] = 65] = "A";
    Keys[Keys["B"] = 66] = "B";
    Keys[Keys["C"] = 67] = "C";
    Keys[Keys["D"] = 68] = "D";
    Keys[Keys["E"] = 69] = "E";
    Keys[Keys["F"] = 70] = "F";
    Keys[Keys["G"] = 71] = "G";
    Keys[Keys["H"] = 72] = "H";
    Keys[Keys["I"] = 73] = "I";
    Keys[Keys["J"] = 74] = "J";
    Keys[Keys["K"] = 75] = "K";
    Keys[Keys["L"] = 76] = "L";
    Keys[Keys["M"] = 77] = "M";
    Keys[Keys["N"] = 78] = "N";
    Keys[Keys["O"] = 79] = "O";
    Keys[Keys["P"] = 80] = "P";
    Keys[Keys["Q"] = 81] = "Q";
    Keys[Keys["R"] = 82] = "R";
    Keys[Keys["S"] = 83] = "S";
    Keys[Keys["T"] = 84] = "T";
    Keys[Keys["U"] = 85] = "U";
    Keys[Keys["V"] = 86] = "V";
    Keys[Keys["W"] = 87] = "W";
    Keys[Keys["X"] = 88] = "X";
    Keys[Keys["Y"] = 89] = "Y";
    Keys[Keys["Z"] = 90] = "Z";
    Keys[Keys["Shift"] = 16] = "Shift";
    Keys[Keys["Alt"] = 18] = "Alt";
    Keys[Keys["Up"] = 38] = "Up";
    Keys[Keys["Down"] = 40] = "Down";
    Keys[Keys["Left"] = 37] = "Left";
    Keys[Keys["Right"] = 39] = "Right";
    Keys[Keys["Space"] = 32] = "Space";
    Keys[Keys["Esc"] = 27] = "Esc";
})(Keys || (Keys = {}));
/**
 * Event thrown on a game object for a key event
 */
var KeyEvent = /** @class */ (function (_super) {
    __extends(KeyEvent, _super);
    /**
     * @param key  The key responsible for throwing the event
     */
    function KeyEvent(key) {
        var _this = _super.call(this) || this;
        _this.key = key;
        return _this;
    }
    return KeyEvent;
}(_Events__WEBPACK_IMPORTED_MODULE_1__["GameEvent"]));

/**
 * Provides keyboard support for Excalibur.
 *
 * [[include:Keyboard.md]]
 */
var Keyboard = /** @class */ (function (_super) {
    __extends(Keyboard, _super);
    function Keyboard() {
        var _this = _super.call(this) || this;
        _this._keys = [];
        _this._keysUp = [];
        _this._keysDown = [];
        return _this;
    }
    Keyboard.prototype.on = function (eventName, handler) {
        _super.prototype.on.call(this, eventName, handler);
    };
    /**
     * Initialize Keyboard event listeners
     */
    Keyboard.prototype.init = function (global) {
        var _this = this;
        global = global || window;
        global.addEventListener('blur', function () {
            _this._keys.length = 0; // empties array efficiently
        });
        // key up is on window because canvas cannot have focus
        global.addEventListener('keyup', function (ev) {
            var code = _this._normalizeKeyCode(ev.keyCode);
            var key = _this._keys.indexOf(code);
            _this._keys.splice(key, 1);
            _this._keysUp.push(code);
            var keyEvent = new KeyEvent(code);
            // alias the old api, we may want to deprecate this in the future
            _this.eventDispatcher.emit('up', keyEvent);
            _this.eventDispatcher.emit('release', keyEvent);
        });
        // key down is on window because canvas cannot have focus
        global.addEventListener('keydown', function (ev) {
            var code = _this._normalizeKeyCode(ev.keyCode);
            if (_this._keys.indexOf(code) === -1) {
                _this._keys.push(code);
                _this._keysDown.push(code);
                var keyEvent = new KeyEvent(code);
                _this.eventDispatcher.emit('down', keyEvent);
                _this.eventDispatcher.emit('press', keyEvent);
            }
        });
    };
    Keyboard.prototype.update = function () {
        // Reset keysDown and keysUp after update is complete
        this._keysDown.length = 0;
        this._keysUp.length = 0;
        // Emit synthetic "hold" event
        for (var i = 0; i < this._keys.length; i++) {
            this.eventDispatcher.emit('hold', new KeyEvent(this._keys[i]));
        }
    };
    /**
     * Gets list of keys being pressed down
     */
    Keyboard.prototype.getKeys = function () {
        return this._keys;
    };
    /**
     * Tests if a certain key was just pressed this frame. This is cleared at the end of the update frame.
     * @param key Test whether a key was just pressed
     */
    Keyboard.prototype.wasPressed = function (key) {
        return this._keysDown.indexOf(key) > -1;
    };
    /**
     * Tests if a certain key is held down. This is persisted between frames.
     * @param key  Test whether a key is held down
     */
    Keyboard.prototype.isHeld = function (key) {
        return this._keys.indexOf(key) > -1;
    };
    /**
     * Tests if a certain key was just released this frame. This is cleared at the end of the update frame.
     * @param key  Test whether a key was just released
     */
    Keyboard.prototype.wasReleased = function (key) {
        return this._keysUp.indexOf(key) > -1;
    };
    /**
     * Normalizes some browser event key codes to map to standard Excalibur key codes
     * @param code Event keyCode
     * @see http://unixpapa.com/js/key.html
     */
    Keyboard.prototype._normalizeKeyCode = function (code) {
        switch (code) {
            case 59: // : ; in Firefox, Opera
                return Keys.Semicolon;
            default:
                return code;
        }
    };
    return Keyboard;
}(_Class__WEBPACK_IMPORTED_MODULE_0__["Class"]));



/***/ }),

/***/ "./Input/Pointer.ts":
/*!**************************!*\
  !*** ./Input/Pointer.ts ***!
  \**************************/
/*! exports provided: PointerType, PointerButton, WheelDeltaMode, PointerScope, PointerEvent, PointerEventFactory, PointerDragEvent, PointerUpEvent, PointerDownEvent, PointerMoveEvent, PointerEnterEvent, PointerLeaveEvent, PointerCancelEvent, WheelEvent, Pointers, Pointer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerType", function() { return PointerType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerButton", function() { return PointerButton; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WheelDeltaMode", function() { return WheelDeltaMode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerScope", function() { return PointerScope; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerEvent", function() { return PointerEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerEventFactory", function() { return PointerEventFactory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerDragEvent", function() { return PointerDragEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerUpEvent", function() { return PointerUpEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerDownEvent", function() { return PointerDownEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerMoveEvent", function() { return PointerMoveEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerEnterEvent", function() { return PointerEnterEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerLeaveEvent", function() { return PointerLeaveEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PointerCancelEvent", function() { return PointerCancelEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WheelEvent", function() { return WheelEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Pointers", function() { return Pointers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Pointer", function() { return Pointer; });
/* harmony import */ var _Engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Engine */ "./Engine.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Events */ "./Events.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../Class */ "./Class.ts");
/* harmony import */ var _Util_Actors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../Util/Actors */ "./Util/Actors.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();






/**
 * The type of pointer for a [[PointerEvent]].
 */
var PointerType;
(function (PointerType) {
    PointerType[PointerType["Touch"] = 0] = "Touch";
    PointerType[PointerType["Mouse"] = 1] = "Mouse";
    PointerType[PointerType["Pen"] = 2] = "Pen";
    PointerType[PointerType["Unknown"] = 3] = "Unknown";
})(PointerType || (PointerType = {}));
/**
 * The mouse button being pressed.
 */
var PointerButton;
(function (PointerButton) {
    PointerButton[PointerButton["Left"] = 0] = "Left";
    PointerButton[PointerButton["Middle"] = 1] = "Middle";
    PointerButton[PointerButton["Right"] = 2] = "Right";
    PointerButton[PointerButton["Unknown"] = 3] = "Unknown";
})(PointerButton || (PointerButton = {}));
var WheelDeltaMode;
(function (WheelDeltaMode) {
    WheelDeltaMode[WheelDeltaMode["Pixel"] = 0] = "Pixel";
    WheelDeltaMode[WheelDeltaMode["Line"] = 1] = "Line";
    WheelDeltaMode[WheelDeltaMode["Page"] = 2] = "Page";
})(WheelDeltaMode || (WheelDeltaMode = {}));
/**
 * Determines the scope of handling mouse/touch events. See [[Pointers]] for more information.
 */
var PointerScope;
(function (PointerScope) {
    /**
     * Handle events on the `canvas` element only. Events originating outside the
     * `canvas` will not be handled.
     */
    PointerScope[PointerScope["Canvas"] = 0] = "Canvas";
    /**
     * Handles events on the entire document. All events will be handled by Excalibur.
     */
    PointerScope[PointerScope["Document"] = 1] = "Document";
})(PointerScope || (PointerScope = {}));
/**
 * A constant used to normalize wheel events across different browsers
 *
 * This normalization factor is pulled from https://developer.mozilla.org/en-US/docs/Web/Events/wheel#Listening_to_this_event_across_browser
 */
var ScrollWheelNormalizationFactor = -1 / 40;
/**
 * Pointer events
 *
 * Represents a mouse, touch, or stylus event. See [[Pointers]] for more information on
 * handling pointer input.
 *
 * For mouse-based events, you can inspect [[PointerEvent.button]] to see what button was pressed.
 */
var PointerEvent = /** @class */ (function (_super) {
    __extends(PointerEvent, _super);
    /**
     * @param coordinates         The [[GlobalCoordinates]] of the event
     * @param pointer             The [[Pointer]] of the event
     * @param index               The index of the pointer (zero-based)
     * @param pointerType         The type of pointer
     * @param button              The button pressed (if [[PointerType.Mouse]])
     * @param ev                  The raw DOM event being handled
     * @param pos                 (Will be added to signature in 0.14.0 release) The position of the event (in world coordinates)
     */
    function PointerEvent(coordinates, pointer, index, pointerType, button, ev) {
        var _this = _super.call(this) || this;
        _this.coordinates = coordinates;
        _this.pointer = pointer;
        _this.index = index;
        _this.pointerType = pointerType;
        _this.button = button;
        _this.ev = ev;
        return _this;
    }
    Object.defineProperty(PointerEvent.prototype, "worldPos", {
        /** The world coordinates of the event. */
        get: function () {
            return this.coordinates.worldPos.clone();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PointerEvent.prototype, "pagePos", {
        /** The page coordinates of the event. */
        get: function () {
            return this.coordinates.pagePos.clone();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PointerEvent.prototype, "screenPos", {
        /** The screen coordinates of the event. */
        get: function () {
            return this.coordinates.screenPos.clone();
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(PointerEvent.prototype, "pos", {
        get: function () {
            return this.coordinates.worldPos.clone();
        },
        enumerable: true,
        configurable: true
    });
    /**
     * Sets event path to actor, depending on actor provided.
     * If actor is lower in hierarchy tree, previous path'll be kept.
     * @param actor Actor, to lay path form.
     */
    PointerEvent.prototype.layPath = function (actor) {
        if (!this.pointer.isActorUnderPointer(actor)) {
            return;
        }
        var actorPath = actor.getAncestors();
        this._path = actorPath.length > this._path.length ? actorPath : this._path;
    };
    return PointerEvent;
}(_Events__WEBPACK_IMPORTED_MODULE_1__["GameEvent"]));

var PointerEventFactory = /** @class */ (function () {
    function PointerEventFactory(_pointerEventType) {
        this._pointerEventType = _pointerEventType;
    }
    /**
     * Create specific PointerEvent
     */
    PointerEventFactory.prototype.create = function (coordinates, pointer, index, pointerType, button, ev) {
        return new this._pointerEventType(coordinates, pointer, index, pointerType, button, ev);
    };
    return PointerEventFactory;
}());

var PointerDragEvent = /** @class */ (function (_super) {
    __extends(PointerDragEvent, _super);
    function PointerDragEvent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return PointerDragEvent;
}(PointerEvent));

var PointerUpEvent = /** @class */ (function (_super) {
    __extends(PointerUpEvent, _super);
    function PointerUpEvent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._name = 'pointerup';
        return _this;
    }
    PointerUpEvent.prototype._onActionEnd = function (actor) {
        var pointer = this.pointer;
        if (pointer.isDragEnd && actor.capturePointer.captureDragEvents) {
            actor.eventDispatcher.emit('pointerdragend', this);
        }
    };
    return PointerUpEvent;
}(PointerEvent));

var PointerDownEvent = /** @class */ (function (_super) {
    __extends(PointerDownEvent, _super);
    function PointerDownEvent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._name = 'pointerdown';
        return _this;
    }
    PointerDownEvent.prototype._onActionEnd = function (actor) {
        if (this.pointer.isDragStart && actor.capturePointer.captureDragEvents) {
            actor.eventDispatcher.emit('pointerdragstart', this);
        }
    };
    return PointerDownEvent;
}(PointerEvent));

var PointerMoveEvent = /** @class */ (function (_super) {
    __extends(PointerMoveEvent, _super);
    function PointerMoveEvent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._name = 'pointermove';
        return _this;
    }
    PointerMoveEvent.prototype.propagate = function () {
        var _this = this;
        if (!this.eventPath.length) {
            if (this.pointer.hasActorsUnderPointer) {
                var actors = this.pointer.getActorsUnderPointer();
                actors.forEach(function (actor) {
                    if (!_this.pointer.isActorUnderPointer(actor)) {
                        _this._onActorLeave(actor);
                    }
                });
            }
            return;
        }
        this.action();
        if (this.bubbles) {
            this.propagate();
        }
    };
    /**
     * Sets event path to actor, depending on actor provided.
     * If actor is in a dragging state, current dragging target would be used.
     * @param actor Actor, to lay path form.
     */
    PointerMoveEvent.prototype.layPath = function (actor) {
        /**
         *  double-check is preformed, because user could move pointer too fast and
         *  in that case, pointer can appear out of boundings of the dragging element
         */
        if (this.pointer.isDragging) {
            actor = this.pointer.dragTarget || actor;
        }
        else if (!this.pointer.isActorUnderPointer(actor)) {
            return;
        }
        var actorPath = actor.getAncestors();
        this._path = actorPath.length > this._path.length ? actorPath : this._path;
    };
    PointerMoveEvent.prototype._onActionStart = function (actor) {
        if (!actor.capturePointer.captureMoveEvents) {
            return;
        }
        if (this.pointer.isActorUnderPointer(actor) && !this.pointer.hasActorUnderPointerInList(actor)) {
            this._onActorEnter(actor);
        }
        if (this.pointer.isDragging && actor.capturePointer.captureDragEvents) {
            actor.eventDispatcher.emit('pointerdragmove', this);
        }
    };
    PointerMoveEvent.prototype._onActorEnter = function (actor) {
        var pe = createPointerEventByName('enter', this.coordinates, this.pointer, this.index, this.pointerType, this.button, this.ev);
        pe.layPath(actor);
        pe.propagate();
        this.pointer.addActorUnderPointer(actor);
        if (this.pointer.isDragging) {
            this.pointer.dragTarget = actor;
        }
    };
    PointerMoveEvent.prototype._onActorLeave = function (actor) {
        var pe = createPointerEventByName('leave', this.coordinates, this.pointer, this.index, this.pointerType, this.button, this.ev);
        pe.layPath(actor);
        pe.propagate();
        this.pointer.removeActorUnderPointer(actor);
    };
    return PointerMoveEvent;
}(PointerEvent));

var PointerEnterEvent = /** @class */ (function (_super) {
    __extends(PointerEnterEvent, _super);
    function PointerEnterEvent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._name = 'pointerenter';
        return _this;
    }
    PointerEnterEvent.prototype._onActionStart = function (actor) {
        if (!actor.capturePointer.captureMoveEvents) {
            return;
        }
    };
    PointerEnterEvent.prototype._onActionEnd = function (actor) {
        var pointer = this.pointer;
        if (pointer.isDragging && actor.capturePointer.captureDragEvents) {
            actor.eventDispatcher.emit('pointerdragenter', this);
        }
    };
    return PointerEnterEvent;
}(PointerEvent));

var PointerLeaveEvent = /** @class */ (function (_super) {
    __extends(PointerLeaveEvent, _super);
    function PointerLeaveEvent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._name = 'pointerleave';
        return _this;
    }
    PointerLeaveEvent.prototype.layPath = function (actor) {
        var actorPath = actor.getAncestors();
        this._path = actorPath.length > this._path.length ? actorPath : this._path;
    };
    PointerLeaveEvent.prototype._onActionStart = function (actor) {
        if (!actor.capturePointer.captureMoveEvents) {
            return;
        }
    };
    PointerLeaveEvent.prototype._onActionEnd = function (actor) {
        var pointer = this.pointer;
        if (pointer.isDragging && actor.capturePointer.captureDragEvents) {
            actor.eventDispatcher.emit('pointerdragleave', this);
        }
    };
    return PointerLeaveEvent;
}(PointerEvent));

var PointerCancelEvent = /** @class */ (function (_super) {
    __extends(PointerCancelEvent, _super);
    function PointerCancelEvent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._name = 'pointercancel';
        return _this;
    }
    return PointerCancelEvent;
}(PointerEvent));

/**
 * Wheel Events
 *
 * Represents a mouse wheel event. See [[Pointers]] for more information on
 * handling point input.
 */
var WheelEvent = /** @class */ (function (_super) {
    __extends(WheelEvent, _super);
    /**
     * @param x            The `x` coordinate of the event (in world coordinates)
     * @param y            The `y` coordinate of the event (in world coordinates)
     * @param pageX        The `x` coordinate of the event (in document coordinates)
     * @param pageY        The `y` coordinate of the event (in document coordinates)
     * @param screenX      The `x` coordinate of the event (in screen coordinates)
     * @param screenY      The `y` coordinate of the event (in screen coordinates)
     * @param index        The index of the pointer (zero-based)
     * @param deltaX       The type of pointer
     * @param deltaY       The type of pointer
     * @param deltaZ       The type of pointer
     * @param deltaMode    The type of movement [[WheelDeltaMode]]
     * @param ev           The raw DOM event being handled
     */
    function WheelEvent(x, y, pageX, pageY, screenX, screenY, index, deltaX, deltaY, deltaZ, deltaMode, ev) {
        var _this = _super.call(this) || this;
        _this.x = x;
        _this.y = y;
        _this.pageX = pageX;
        _this.pageY = pageY;
        _this.screenX = screenX;
        _this.screenY = screenY;
        _this.index = index;
        _this.deltaX = deltaX;
        _this.deltaY = deltaY;
        _this.deltaZ = deltaZ;
        _this.deltaMode = deltaMode;
        _this.ev = ev;
        return _this;
    }
    return WheelEvent;
}(_Events__WEBPACK_IMPORTED_MODULE_1__["GameEvent"]));

function createPointerEventByName(eventName, coordinates, pointer, index, pointerType, button, ev) {
    var factory;
    switch (eventName) {
        case 'up':
            factory = new PointerEventFactory(PointerUpEvent);
            break;
        case 'down':
            factory = new PointerEventFactory(PointerDownEvent);
            break;
        case 'move':
            factory = new PointerEventFactory(PointerMoveEvent);
            break;
        case 'cancel':
            factory = new PointerEventFactory(PointerCancelEvent);
            break;
        case 'enter':
            factory = new PointerEventFactory(PointerEnterEvent);
            break;
        case 'leave':
            factory = new PointerEventFactory(PointerLeaveEvent);
            break;
    }
    return factory.create(coordinates, pointer, index, pointerType, button, ev);
}
/**
 * Handles pointer events (mouse, touch, stylus, etc.) and normalizes to
 * [W3C Pointer Events](http://www.w3.org/TR/pointerevents/).
 *
 * [[include:Pointers.md]]
 */
var Pointers = /** @class */ (function (_super) {
    __extends(Pointers, _super);
    function Pointers(engine) {
        var _this = _super.call(this) || this;
        _this._pointerDown = [];
        _this._pointerUp = [];
        _this._pointerMove = [];
        _this._pointerCancel = [];
        _this._wheel = [];
        _this._pointers = [];
        _this._activePointers = [];
        _this._engine = engine;
        _this._pointers.push(new Pointer());
        _this._activePointers = [-1];
        _this.primary = _this._pointers[0];
        return _this;
    }
    Pointers.prototype.on = function (eventName, handler) {
        _super.prototype.on.call(this, eventName, handler);
    };
    /**
     * Initializes pointer event listeners
     */
    Pointers.prototype.init = function (target) {
        target = target || this._engine.canvas;
        // Touch Events
        target.addEventListener('touchstart', this._handleTouchEvent('down', this._pointerDown));
        target.addEventListener('touchend', this._handleTouchEvent('up', this._pointerUp));
        target.addEventListener('touchmove', this._handleTouchEvent('move', this._pointerMove));
        target.addEventListener('touchcancel', this._handleTouchEvent('cancel', this._pointerCancel));
        // W3C Pointer Events
        // Current: IE11, IE10
        if (window.PointerEvent) {
            // IE11
            this._engine.canvas.style.touchAction = 'none';
            target.addEventListener('pointerdown', this._handlePointerEvent('down', this._pointerDown));
            target.addEventListener('pointerup', this._handlePointerEvent('up', this._pointerUp));
            target.addEventListener('pointermove', this._handlePointerEvent('move', this._pointerMove));
            target.addEventListener('pointercancel', this._handlePointerEvent('cancel', this._pointerCancel));
        }
        else if (window.MSPointerEvent) {
            // IE10
            this._engine.canvas.style.msTouchAction = 'none';
            target.addEventListener('MSPointerDown', this._handlePointerEvent('down', this._pointerDown));
            target.addEventListener('MSPointerUp', this._handlePointerEvent('up', this._pointerUp));
            target.addEventListener('MSPointerMove', this._handlePointerEvent('move', this._pointerMove));
            target.addEventListener('MSPointerCancel', this._handlePointerEvent('cancel', this._pointerCancel));
        }
        else {
            // Mouse Events
            target.addEventListener('mousedown', this._handleMouseEvent('down', this._pointerDown));
            target.addEventListener('mouseup', this._handleMouseEvent('up', this._pointerUp));
            target.addEventListener('mousemove', this._handleMouseEvent('move', this._pointerMove));
        }
        // MDN MouseWheelEvent
        if ('onwheel' in document.createElement('div')) {
            // Modern Browsers
            target.addEventListener('wheel', this._handleWheelEvent('wheel', this._wheel));
        }
        else if (document.onmousewheel !== undefined) {
            // Webkit and IE
            target.addEventListener('mousewheel', this._handleWheelEvent('wheel', this._wheel));
        }
        else {
            // Remaining browser and older Firefox
            target.addEventListener('MozMousePixelScroll', this._handleWheelEvent('wheel', this._wheel));
        }
    };
    Pointers.prototype.update = function () {
        this._pointerUp.length = 0;
        this._pointerDown.length = 0;
        this._pointerMove.length = 0;
        this._pointerCancel.length = 0;
        this._wheel.length = 0;
        for (var i = 0; i < this._pointers.length; i++) {
            this._pointers[i].update();
        }
    };
    /**
     * Safely gets a Pointer at a specific index and initializes one if it doesn't yet exist
     * @param index  The pointer index to retrieve
     */
    Pointers.prototype.at = function (index) {
        if (index >= this._pointers.length) {
            // Ensure there is a pointer to retrieve
            for (var i = this._pointers.length - 1, max = index; i < max; i++) {
                this._pointers.push(new Pointer());
                this._activePointers.push(-1);
            }
        }
        return this._pointers[index];
    };
    /**
     * Get number of pointers being watched
     */
    Pointers.prototype.count = function () {
        return this._pointers.length;
    };
    /**
     * Propogates events through ancestors chain if necessary
     */
    Pointers.prototype.propagate = function () {
        this._propagatePointerEvent(this._pointerDown);
        this._propagatePointerEvent(this._pointerUp);
        this._propagatePointerEvent(this._pointerMove);
        this._propagatePointerEvent(this._pointerCancel);
        this._propagateWheelEvent('pointerwheel', this._wheel);
    };
    /**
     * Revises pointer events paths accordingly to actor provided
     * @param actor  Actor to be revised
     */
    Pointers.prototype.revisePointerEventsPaths = function (actor) {
        this._revisePointerEventPath(actor, this._pointerDown);
        this._revisePointerEventPath(actor, this._pointerUp);
        this._revisePointerEventPath(actor, this._pointerMove);
        this._revisePointerEventPath(actor, this._pointerCancel);
        this._validateWheelEventPath(this._wheel, actor);
    };
    Pointers.prototype._propagatePointerEvent = function (pointers) {
        var len = pointers.length;
        for (var i = 0; i < len; i++) {
            pointers[i].propagate();
        }
    };
    Pointers.prototype._revisePointerEventPath = function (actor, pointers) {
        var len = pointers.length;
        for (var i = 0; i < len; i++) {
            var pointerEvent = pointers[i];
            pointerEvent.layPath(actor);
        }
    };
    Pointers.prototype._validateWheelEventPath = function (pointers, actor) {
        for (var i = 0; i < pointers.length; i++) {
            var wheelEvent = pointers[i];
            var isNotUIActor = !_Util_Actors__WEBPACK_IMPORTED_MODULE_4__["isUIActor"](actor);
            if (actor.contains(wheelEvent.x, wheelEvent.y, isNotUIActor)) {
                wheelEvent.layPath(actor);
            }
        }
    };
    Pointers.prototype._propagateWheelEvent = function (eventName, pointers) {
        var len = pointers.length;
        var wheelEvent;
        for (var i = 0; i < len; i++) {
            wheelEvent = pointers[i];
            switch (eventName) {
                case 'pointerwheel':
                    this._propagateWheelPointerEvent(wheelEvent);
                    break;
            }
        }
    };
    Pointers.prototype._propagateWheelPointerEvent = function (wheelEvent) {
        if (!wheelEvent.eventPath.length) {
            return;
        }
        var actor = wheelEvent.eventPath.pop();
        actor.eventDispatcher.emit('pointerwheel', wheelEvent);
        if (wheelEvent.bubbles) {
            this._propagateWheelPointerEvent(wheelEvent);
        }
    };
    Pointers.prototype._handleMouseEvent = function (eventName, eventArr) {
        var _this = this;
        return function (e) {
            e.preventDefault();
            var pointer = _this.at(0);
            var coordinates = _Algebra__WEBPACK_IMPORTED_MODULE_2__["GlobalCoordinates"].fromPagePosition(e.pageX, e.pageY, _this._engine);
            var pe = createPointerEventByName(eventName, coordinates, pointer, 0, PointerType.Mouse, e.button, e);
            eventArr.push(pe);
            pointer.eventDispatcher.emit(eventName, pe);
        };
    };
    Pointers.prototype._handleTouchEvent = function (eventName, eventArr) {
        var _this = this;
        return function (e) {
            e.preventDefault();
            for (var i = 0, len = e.changedTouches.length; i < len; i++) {
                var index = _this._pointers.length > 1 ? _this._getPointerIndex(e.changedTouches[i].identifier) : 0;
                if (index === -1) {
                    continue;
                }
                var pointer = _this.at(index);
                var coordinates = _Algebra__WEBPACK_IMPORTED_MODULE_2__["GlobalCoordinates"].fromPagePosition(e.changedTouches[i].pageX, e.changedTouches[i].pageY, _this._engine);
                var pe = createPointerEventByName(eventName, coordinates, pointer, index, PointerType.Touch, PointerButton.Unknown, e);
                eventArr.push(pe);
                pointer.eventDispatcher.emit(eventName, pe);
                // only with multi-pointer
                if (_this._pointers.length > 1) {
                    if (eventName === 'up') {
                        // remove pointer ID from pool when pointer is lifted
                        _this._activePointers[index] = -1;
                    }
                    else if (eventName === 'down') {
                        // set pointer ID to given index
                        _this._activePointers[index] = e.changedTouches[i].identifier;
                    }
                }
            }
        };
    };
    Pointers.prototype._handlePointerEvent = function (eventName, eventArr) {
        var _this = this;
        return function (e) {
            e.preventDefault();
            // get the index for this pointer ID if multi-pointer is asked for
            var index = _this._pointers.length > 1 ? _this._getPointerIndex(e.pointerId) : 0;
            if (index === -1) {
                return;
            }
            var pointer = _this.at(index);
            var coordinates = _Algebra__WEBPACK_IMPORTED_MODULE_2__["GlobalCoordinates"].fromPagePosition(e.pageX, e.pageY, _this._engine);
            var pe = createPointerEventByName(eventName, coordinates, pointer, index, _this._stringToPointerType(e.pointerType), e.button, e);
            eventArr.push(pe);
            pointer.eventDispatcher.emit(eventName, pe);
            // only with multi-pointer
            if (_this._pointers.length > 1) {
                if (eventName === 'up') {
                    // remove pointer ID from pool when pointer is lifted
                    _this._activePointers[index] = -1;
                }
                else if (eventName === 'down') {
                    // set pointer ID to given index
                    _this._activePointers[index] = e.pointerId;
                }
            }
        };
    };
    Pointers.prototype._handleWheelEvent = function (eventName, eventArr) {
        var _this = this;
        return function (e) {
            // Should we prevent page scroll because of this event
            if (_this._engine.pageScrollPreventionMode === _Engine__WEBPACK_IMPORTED_MODULE_0__["ScrollPreventionMode"].All ||
                (_this._engine.pageScrollPreventionMode === _Engine__WEBPACK_IMPORTED_MODULE_0__["ScrollPreventionMode"].Canvas && e.target === _this._engine.canvas)) {
                e.preventDefault();
            }
            var x = e.pageX - _Util_Util__WEBPACK_IMPORTED_MODULE_5__["getPosition"](_this._engine.canvas).x;
            var y = e.pageY - _Util_Util__WEBPACK_IMPORTED_MODULE_5__["getPosition"](_this._engine.canvas).y;
            var transformedPoint = _this._engine.screenToWorldCoordinates(new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](x, y));
            // deltaX, deltaY, and deltaZ are the standard modern properties
            // wheelDeltaX, wheelDeltaY, are legacy properties in webkit browsers and older IE
            // e.detail is only used in opera
            var deltaX = e.deltaX || e.wheelDeltaX * ScrollWheelNormalizationFactor || 0;
            var deltaY = e.deltaY || e.wheelDeltaY * ScrollWheelNormalizationFactor || e.wheelDelta * ScrollWheelNormalizationFactor || e.detail || 0;
            var deltaZ = e.deltaZ || 0;
            var deltaMode = WheelDeltaMode.Pixel;
            if (e.deltaMode) {
                if (e.deltaMode === 1) {
                    deltaMode = WheelDeltaMode.Line;
                }
                else if (e.deltaMode === 2) {
                    deltaMode = WheelDeltaMode.Page;
                }
            }
            var we = new WheelEvent(transformedPoint.x, transformedPoint.y, e.pageX, e.pageY, x, y, 0, deltaX, deltaY, deltaZ, deltaMode, e);
            eventArr.push(we);
            _this.at(0).eventDispatcher.emit(eventName, we);
        };
    };
    /**
     * Gets the index of the pointer specified for the given pointer ID or finds the next empty pointer slot available.
     * This is required because IE10/11 uses incrementing pointer IDs so we need to store a mapping of ID => idx
     */
    Pointers.prototype._getPointerIndex = function (pointerId) {
        var idx;
        if ((idx = this._activePointers.indexOf(pointerId)) > -1) {
            return idx;
        }
        for (var i = 0; i < this._activePointers.length; i++) {
            if (this._activePointers[i] === -1) {
                return i;
            }
        }
        // ignore pointer because game isn't watching
        return -1;
    };
    Pointers.prototype._stringToPointerType = function (s) {
        switch (s) {
            case 'touch':
                return PointerType.Touch;
            case 'mouse':
                return PointerType.Mouse;
            case 'pen':
                return PointerType.Pen;
            default:
                return PointerType.Unknown;
        }
    };
    return Pointers;
}(_Class__WEBPACK_IMPORTED_MODULE_3__["Class"]));

/**
 * Captures and dispatches PointerEvents
 */
var Pointer = /** @class */ (function (_super) {
    __extends(Pointer, _super);
    function Pointer() {
        var _this = _super.call(this) || this;
        _this._isDown = false;
        _this._wasDown = false;
        _this._actorsUnderPointer = { length: 0 };
        /**
         * The last position on the document this pointer was at. Can be `null` if pointer was never active.
         */
        _this.lastPagePos = null;
        /**
         * The last position on the screen this pointer was at. Can be `null` if pointer was never active.
         */
        _this.lastScreenPos = null;
        /**
         * The last position in the game world coordinates this pointer was at. Can be `null` if pointer was never active.
         */
        _this.lastWorldPos = null;
        /**
         * Returns the currently dragging target or null if it isn't exist
         */
        _this.dragTarget = null;
        _this.on('move', _this._onPointerMove);
        _this.on('down', _this._onPointerDown);
        _this.on('up', _this._onPointerUp);
        return _this;
    }
    Object.defineProperty(Pointer.prototype, "isDragging", {
        /**
         * Whether the Pointer is currently dragging.
         */
        get: function () {
            return this._isDown;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Pointer.prototype, "isDragStart", {
        /**
         * Whether the Pointer just started dragging.
         */
        get: function () {
            return !this._wasDown && this._isDown;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Pointer.prototype, "isDragEnd", {
        /**
         * Whether the Pointer just ended dragging.
         */
        get: function () {
            return this._wasDown && !this._isDown;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Pointer.prototype, "hasActorsUnderPointer", {
        /**
         * Returns true if pointer has any actors under
         */
        get: function () {
            return !!this._actorsUnderPointer.length;
        },
        enumerable: true,
        configurable: true
    });
    Pointer.prototype.update = function () {
        if (this._wasDown && !this._isDown) {
            this._wasDown = false;
        }
        else if (!this._wasDown && this._isDown) {
            this._wasDown = true;
        }
    };
    /**
     * Adds an Actor to actorsUnderPointer object.
     * @param actor An Actor to be added;
     */
    Pointer.prototype.addActorUnderPointer = function (actor) {
        if (!this.hasActorUnderPointerInList(actor)) {
            this._actorsUnderPointer[actor.id] = actor;
            this._actorsUnderPointer.length += 1;
        }
    };
    /**
     * Removes an Actor from actorsUnderPointer object.
     * @param actor An Actor to be removed;
     */
    Pointer.prototype.removeActorUnderPointer = function (actor) {
        if (this.hasActorUnderPointerInList(actor)) {
            delete this._actorsUnderPointer[actor.id];
            this._actorsUnderPointer.length -= 1;
        }
    };
    /**
     * Returns an Actor from actorsUnderPointer object.
     * @param actor An Actor to be ;
     */
    Pointer.prototype.getActorsUnderPointer = function () {
        var actors = [];
        for (var id in this._actorsUnderPointer) {
            if (id === 'length') {
                continue;
            }
            var actor = this._actorsUnderPointer[id];
            actors.push(actor);
        }
        return actors;
    };
    /**
     * Checks if Pointer has a specific Actor under.
     * @param actor An Actor for check;
     */
    Pointer.prototype.isActorUnderPointer = function (actor) {
        if (this.lastWorldPos) {
            return actor.contains(this.lastWorldPos.x, this.lastWorldPos.y, !_Util_Actors__WEBPACK_IMPORTED_MODULE_4__["isUIActor"](actor));
        }
        return false;
    };
    /**
     * Checks if Pointer has a specific Actor in ActrorsUnderPointer list.
     * @param actor An Actor for check;
     */
    Pointer.prototype.hasActorUnderPointerInList = function (actor) {
        return this._actorsUnderPointer.hasOwnProperty(actor.id.toString());
    };
    Pointer.prototype._onPointerMove = function (ev) {
        this.lastPagePos = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](ev.pagePos.x, ev.pagePos.y);
        this.lastScreenPos = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](ev.screenPos.x, ev.screenPos.y);
        this.lastWorldPos = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](ev.worldPos.x, ev.worldPos.y);
    };
    Pointer.prototype._onPointerDown = function (ev) {
        this.lastPagePos = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](ev.pagePos.x, ev.pagePos.y);
        this.lastScreenPos = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](ev.screenPos.x, ev.screenPos.y);
        this.lastWorldPos = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](ev.worldPos.x, ev.worldPos.y);
        this._isDown = true;
    };
    Pointer.prototype._onPointerUp = function () {
        this._isDown = false;
        this.dragTarget = null;
    };
    return Pointer;
}(_Class__WEBPACK_IMPORTED_MODULE_3__["Class"]));



/***/ }),

/***/ "./Interfaces/IAudioImplementation.ts":
/*!********************************************!*\
  !*** ./Interfaces/IAudioImplementation.ts ***!
  \********************************************/
/*! exports provided: ExResponse */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExResponse", function() { return ExResponse; });
var ExResponse = /** @class */ (function () {
    function ExResponse() {
    }
    ExResponse.type = {
        any: '',
        blob: 'blob',
        json: 'json',
        text: 'text',
        document: 'document',
        arraybuffer: 'arraybuffer'
    };
    return ExResponse;
}());



/***/ }),

/***/ "./Interfaces/Index.ts":
/*!*****************************!*\
  !*** ./Interfaces/Index.ts ***!
  \*****************************/
/*! exports provided: ExResponse */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _IAudioImplementation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./IAudioImplementation */ "./Interfaces/IAudioImplementation.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExResponse", function() { return _IAudioImplementation__WEBPACK_IMPORTED_MODULE_0__["ExResponse"]; });




/***/ }),

/***/ "./Label.ts":
/*!******************!*\
  !*** ./Label.ts ***!
  \******************/
/*! exports provided: FontUnit, TextAlign, BaseAlign, FontStyle, LabelImpl, Label */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FontUnit", function() { return FontUnit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TextAlign", function() { return TextAlign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BaseAlign", function() { return BaseAlign; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FontStyle", function() { return FontStyle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LabelImpl", function() { return LabelImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Label", function() { return Label; });
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Actor */ "./Actor.ts");
/* harmony import */ var _Configurable__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Configurable */ "./Configurable.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



/**
 * Enum representing the different font size units
 * https://developer.mozilla.org/en-US/docs/Web/CSS/font-size
 */
var FontUnit;
(function (FontUnit) {
    /**
     * Em is a scalable unit, 1 em is equal to the current font size of the current element, parent elements can effect em values
     */
    FontUnit[FontUnit["Em"] = 0] = "Em";
    /**
     * Rem is similar to the Em, it is a scalable unit. 1 rem is eqaul to the font size of the root element
     */
    FontUnit[FontUnit["Rem"] = 1] = "Rem";
    /**
     * Pixel is a unit of length in screen pixels
     */
    FontUnit[FontUnit["Px"] = 2] = "Px";
    /**
     * Point is a physical unit length (1/72 of an inch)
     */
    FontUnit[FontUnit["Pt"] = 3] = "Pt";
    /**
     * Percent is a scalable unit similar to Em, the only difference is the Em units scale faster when Text-Size stuff
     */
    FontUnit[FontUnit["Percent"] = 4] = "Percent";
})(FontUnit || (FontUnit = {}));
/**
 * Enum representing the different horizontal text alignments
 */
var TextAlign;
(function (TextAlign) {
    /**
     * The text is left-aligned.
     */
    TextAlign[TextAlign["Left"] = 0] = "Left";
    /**
     * The text is right-aligned.
     */
    TextAlign[TextAlign["Right"] = 1] = "Right";
    /**
     * The text is centered.
     */
    TextAlign[TextAlign["Center"] = 2] = "Center";
    /**
     * The text is aligned at the normal start of the line (left-aligned for left-to-right locales,
     * right-aligned for right-to-left locales).
     */
    TextAlign[TextAlign["Start"] = 3] = "Start";
    /**
     * The text is aligned at the normal end of the line (right-aligned for left-to-right locales,
     * left-aligned for right-to-left locales).
     */
    TextAlign[TextAlign["End"] = 4] = "End";
})(TextAlign || (TextAlign = {}));
/**
 * Enum representing the different baseline text alignments
 */
var BaseAlign;
(function (BaseAlign) {
    /**
     * The text baseline is the top of the em square.
     */
    BaseAlign[BaseAlign["Top"] = 0] = "Top";
    /**
     * The text baseline is the hanging baseline.  Currently unsupported; this will act like
     * alphabetic.
     */
    BaseAlign[BaseAlign["Hanging"] = 1] = "Hanging";
    /**
     * The text baseline is the middle of the em square.
     */
    BaseAlign[BaseAlign["Middle"] = 2] = "Middle";
    /**
     * The text baseline is the normal alphabetic baseline.
     */
    BaseAlign[BaseAlign["Alphabetic"] = 3] = "Alphabetic";
    /**
     * The text baseline is the ideographic baseline; this is the bottom of
     * the body of the characters, if the main body of characters protrudes
     * beneath the alphabetic baseline.  Currently unsupported; this will
     * act like alphabetic.
     */
    BaseAlign[BaseAlign["Ideographic"] = 4] = "Ideographic";
    /**
     * The text baseline is the bottom of the bounding box.  This differs
     * from the ideographic baseline in that the ideographic baseline
     * doesn't consider descenders.
     */
    BaseAlign[BaseAlign["Bottom"] = 5] = "Bottom";
})(BaseAlign || (BaseAlign = {}));
/**
 * Enum representing the different possible font styles
 */
var FontStyle;
(function (FontStyle) {
    FontStyle[FontStyle["Normal"] = 0] = "Normal";
    FontStyle[FontStyle["Italic"] = 1] = "Italic";
    FontStyle[FontStyle["Oblique"] = 2] = "Oblique";
})(FontStyle || (FontStyle = {}));
/**
 * @hidden
 */
var LabelImpl = /** @class */ (function (_super) {
    __extends(LabelImpl, _super);
    /**
     * @param text        The text of the label
     * @param x           The x position of the label
     * @param y           The y position of the label
     * @param fontFamily  Use any valid CSS font string for the label's font. Web fonts are supported. Default is `10px sans-serif`.
     * @param spriteFont  Use an Excalibur sprite font for the label's font, if a SpriteFont is provided it will take precedence
     * over a css font.
     */
    function LabelImpl(textOrConfig, x, y, fontFamily, spriteFont) {
        var _this = _super.call(this, textOrConfig && typeof textOrConfig === 'object'
            ? {
                x: textOrConfig.x,
                y: textOrConfig.y
            }
            : { x: x, y: y }) || this;
        /**
         * Sets or gets the bold property of the label's text, by default it's false
         */
        _this.bold = false;
        /**
         * The font size in the selected units, default is 10 (default units is pixel)
         */
        _this.fontSize = 10;
        /**
         * The font style for this label, the default is [[FontStyle.Normal]]
         */
        _this.fontStyle = FontStyle.Normal;
        /**
         * The css units for a font size such as px, pt, em (SpriteFont only support px), by default is 'px';
         */
        _this.fontUnit = FontUnit.Px;
        /**
         * Gets or sets the horizontal text alignment property for the label.
         */
        _this.textAlign = TextAlign.Left;
        /**
         * Gets or sets the baseline alignment property for the label.
         */
        _this.baseAlign = BaseAlign.Bottom;
        /**
         * Gets or sets the letter spacing on a Label. Only supported with Sprite Fonts.
         */
        _this.letterSpacing = 0; //px
        /**
         * Whether or not the [[SpriteFont]] will be case-sensitive when matching characters.
         */
        _this.caseInsensitive = true;
        var text = '';
        if (textOrConfig && typeof textOrConfig === 'object') {
            fontFamily = textOrConfig.fontFamily;
            spriteFont = textOrConfig.spriteFont;
            text = textOrConfig.text;
        }
        else {
            text = textOrConfig;
        }
        _this.text = text || '';
        _this.color = _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__["Color"].Black.clone();
        _this.spriteFont = spriteFont;
        _this.collisionType = _Actor__WEBPACK_IMPORTED_MODULE_1__["CollisionType"].PreventCollision;
        _this.fontFamily = fontFamily || 'sans-serif'; // coalesce to default canvas font
        _this._textShadowOn = false;
        _this._shadowOffsetX = 0;
        _this._shadowOffsetY = 0;
        if (spriteFont) {
            //this._textSprites = spriteFont.getTextSprites();
        }
        return _this;
    }
    /**
     * Returns the width of the text in the label (in pixels);
     * @param ctx  Rendering context to measure the string with
     */
    LabelImpl.prototype.getTextWidth = function (ctx) {
        var oldFont = ctx.font;
        ctx.font = this._fontString;
        var width = ctx.measureText(this.text).width;
        ctx.font = oldFont;
        return width;
    };
    // TypeScript doesn't support string enums :(
    LabelImpl.prototype._lookupFontUnit = function (fontUnit) {
        switch (fontUnit) {
            case FontUnit.Em:
                return 'em';
            case FontUnit.Rem:
                return 'rem';
            case FontUnit.Pt:
                return 'pt';
            case FontUnit.Px:
                return 'px';
            case FontUnit.Percent:
                return '%';
            default:
                return 'px';
        }
    };
    LabelImpl.prototype._lookupTextAlign = function (textAlign) {
        switch (textAlign) {
            case TextAlign.Left:
                return 'left';
            case TextAlign.Right:
                return 'right';
            case TextAlign.Center:
                return 'center';
            case TextAlign.End:
                return 'end';
            case TextAlign.Start:
                return 'start';
            default:
                return 'start';
        }
    };
    LabelImpl.prototype._lookupBaseAlign = function (baseAlign) {
        switch (baseAlign) {
            case BaseAlign.Alphabetic:
                return 'alphabetic';
            case BaseAlign.Bottom:
                return 'bottom';
            case BaseAlign.Hanging:
                return 'hangin';
            case BaseAlign.Ideographic:
                return 'ideographic';
            case BaseAlign.Middle:
                return 'middle';
            case BaseAlign.Top:
                return 'top';
            default:
                return 'alphabetic';
        }
    };
    LabelImpl.prototype._lookupFontStyle = function (fontStyle) {
        var boldstring = this.bold ? ' bold' : '';
        switch (fontStyle) {
            case FontStyle.Italic:
                return 'italic' + boldstring;
            case FontStyle.Normal:
                return 'normal' + boldstring;
            case FontStyle.Oblique:
                return 'oblique' + boldstring;
            default:
                return 'normal' + boldstring;
        }
    };
    /**
     * Sets the text shadow for sprite fonts
     * @param offsetX      The x offset in pixels to place the shadow
     * @param offsetY      The y offset in pixels to place the shadow
     * @param shadowColor  The color of the text shadow
     */
    LabelImpl.prototype.setTextShadow = function (offsetX, offsetY, shadowColor) {
        this.spriteFont.setTextShadow(offsetX, offsetY, shadowColor);
    };
    /**
     * Toggles text shadows on or off, only applies when using sprite fonts
     */
    LabelImpl.prototype.useTextShadow = function (on) {
        this.spriteFont.useTextShadow(on);
    };
    /**
     * Clears the current text shadow
     */
    LabelImpl.prototype.clearTextShadow = function () {
        this._textShadowOn = false;
        this._shadowOffsetX = 0;
        this._shadowOffsetY = 0;
    };
    LabelImpl.prototype.update = function (engine, delta) {
        _super.prototype.update.call(this, engine, delta);
    };
    LabelImpl.prototype.draw = function (ctx, delta) {
        ctx.save();
        ctx.translate(this.pos.x, this.pos.y);
        ctx.scale(this.scale.x, this.scale.y);
        ctx.rotate(this.rotation);
        if (this._textShadowOn) {
            ctx.save();
            ctx.translate(this._shadowOffsetX, this._shadowOffsetY);
            this._fontDraw(ctx);
            ctx.restore();
        }
        this._fontDraw(ctx);
        _super.prototype.draw.call(this, ctx, delta);
        ctx.restore();
    };
    LabelImpl.prototype._fontDraw = function (ctx) {
        if (this.spriteFont) {
            this.spriteFont.draw(ctx, this.text, 0, 0, {
                color: this.color.clone(),
                baseAlign: this.baseAlign,
                textAlign: this.textAlign,
                fontSize: this.fontSize,
                letterSpacing: this.letterSpacing,
                opacity: this.opacity
            });
        }
        else {
            var oldAlign = ctx.textAlign;
            var oldTextBaseline = ctx.textBaseline;
            ctx.textAlign = this._lookupTextAlign(this.textAlign);
            ctx.textBaseline = this._lookupBaseAlign(this.baseAlign);
            if (this.color) {
                this.color.a = this.opacity;
            }
            ctx.fillStyle = this.color.toString();
            ctx.font = this._fontString;
            if (this.maxWidth) {
                ctx.fillText(this.text, 0, 0, this.maxWidth);
            }
            else {
                ctx.fillText(this.text, 0, 0);
            }
            ctx.textAlign = oldAlign;
            ctx.textBaseline = oldTextBaseline;
        }
    };
    Object.defineProperty(LabelImpl.prototype, "_fontString", {
        get: function () {
            return this._lookupFontStyle(this.fontStyle) + " " + this.fontSize + this._lookupFontUnit(this.fontUnit) + " " + this.fontFamily;
        },
        enumerable: true,
        configurable: true
    });
    LabelImpl.prototype.debugDraw = function (ctx) {
        _super.prototype.debugDraw.call(this, ctx);
    };
    return LabelImpl;
}(_Actor__WEBPACK_IMPORTED_MODULE_1__["Actor"]));

/**
 * Labels are the way to draw small amounts of text to the screen. They are
 * actors and inherit all of the benefits and capabilities.
 *
 * [[include:Labels.md]]
 */
var Label = /** @class */ (function (_super) {
    __extends(Label, _super);
    function Label(textOrConfig, x, y, fontFamily, spriteFont) {
        return _super.call(this, textOrConfig, x, y, fontFamily, spriteFont) || this;
    }
    return Label;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_2__["Configurable"])(LabelImpl)));



/***/ }),

/***/ "./Loader.css":
/*!********************!*\
  !*** ./Loader.css ***!
  \********************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {


        var result = __webpack_require__(/*! !../../node_modules/css-loader!./Loader.css */ "../../node_modules/css-loader/index.js!./Loader.css");

        if (typeof result === "string") {
            module.exports = result;
        } else {
            module.exports = result.toString();
        }
    

/***/ }),

/***/ "./Loader.logo.png":
/*!*************************!*\
  !*** ./Loader.logo.png ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "data:image/png;base64,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"

/***/ }),

/***/ "./Loader.ts":
/*!*******************!*\
  !*** ./Loader.ts ***!
  \*******************/
/*! exports provided: Loader, PauseAfterLoader */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Loader", function() { return Loader; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PauseAfterLoader", function() { return PauseAfterLoader; });
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Util_WebAudio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Util/WebAudio */ "./Util/WebAudio.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Promises */ "./Promises.ts");
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Class */ "./Class.ts");
/* harmony import */ var _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Util/DrawUtil */ "./Util/DrawUtil.ts");
/* harmony import */ var _Util_Decorators__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Util/Decorators */ "./Util/Decorators.ts");
/* harmony import */ var _Loader_logo_png__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Loader.logo.png */ "./Loader.logo.png");
/* harmony import */ var _Loader_logo_png__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(_Loader_logo_png__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var _Loader_css__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Loader.css */ "./Loader.css");
/* harmony import */ var _Loader_css__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(_Loader_css__WEBPACK_IMPORTED_MODULE_8__);
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};









/**
 * Pre-loading assets
 *
 * The loader provides a mechanism to preload multiple resources at
 * one time. The loader must be passed to the engine in order to
 * trigger the loading progress bar.
 *
 * The [[Loader]] itself implements [[ILoadable]] so you can load loaders.
 *
 * ## Example: Pre-loading resources for a game
 *
 * ```js
 * // create a loader
 * var loader = new ex.Loader();
 *
 * // create a resource dictionary (best practice is to keep a separate file)
 * var resources = {
 *   TextureGround: new ex.Texture("/images/textures/ground.png"),
 *   SoundDeath: new ex.Sound("/sound/death.wav", "/sound/death.mp3")
 * };
 *
 * // loop through dictionary and add to loader
 * for (var loadable in resources) {
 *   if (resources.hasOwnProperty(loadable)) {
 *     loader.addResource(resources[loadable]);
 *   }
 * }
 *
 * // start game
 * game.start(loader).then(function () {
 *   console.log("Game started!");
 * });
 * ```
 *
 * ## Customize the Loader
 *
 * The loader can be customized to show different, text, logo, background color, and button.
 *
 * ```typescript
 * var loader = new ex.Loader([playerTexture]);
 *
 * // The loaders button text can simply modified using this
 * loader.playButtonText = 'Start the best game ever';
 *
 * // The logo can be changed by inserting a base64 image string here
 *
 * loader.logo = 'data:image/png;base64,iVBORw...';
 * loader.logoWidth = 15;
 * loader.logoHeight = 14;
 *
 * // The background color can be changed like so by supplying a valid CSS color string
 *
 * loader.backgroundColor = 'red'
 * loader.backgroundColor = '#176BAA'
 *
 * // To build a completely new button
 * loader.startButtonFactory = () => {
 *     let myButton = document.createElement('button');
 *     myButton.textContent = 'The best button';
 *     return myButton;
 * };
 *
 * engine.start(loader).then(() => {});
 * ```
 */
var Loader = /** @class */ (function (_super) {
    __extends(Loader, _super);
    /**
     * @param loadables  Optionally provide the list of resources you want to load at constructor time
     */
    function Loader(loadables) {
        var _this = _super.call(this) || this;
        _this._resourceList = [];
        _this._index = 0;
        _this._playButtonShown = false;
        _this._resourceCount = 0;
        _this._numLoaded = 0;
        _this._progressCounts = {};
        _this._totalCounts = {};
        // logo drawing stuff
        // base64 string encoding of the excalibur logo (logo-white.png)
        _this.logo = _Loader_logo_png__WEBPACK_IMPORTED_MODULE_7___default.a;
        _this.logoWidth = 468;
        _this.logoHeight = 118;
        _this.backgroundColor = '#176BAA';
        _this.suppressPlayButton = false;
        /** Loads the css from Loader.css */
        _this._playButtonStyles = _Loader_css__WEBPACK_IMPORTED_MODULE_8___default.a.toString();
        /**
         * Get/set play button text
         */
        _this.playButtonText = 'Play game';
        /**
         * Return a html button element for excalibur to use as a play button
         */
        _this.startButtonFactory = function () {
            var buttonElement = document.createElement('button');
            buttonElement.id = 'excalibur-play';
            buttonElement.textContent = _this.playButtonText;
            buttonElement.style.display = 'none';
            return buttonElement;
        };
        _this.getData = function () {
            return;
        };
        _this.setData = function () {
            return;
        };
        _this.processData = function () {
            return;
        };
        _this.onprogress = function (e) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_2__["Logger"].getInstance().debug('[ex.Loader] Loading ' + ((100 * e.loaded) / e.total).toFixed(0));
            return;
        };
        _this.oncomplete = function () {
            return;
        };
        _this.onerror = function () {
            return;
        };
        if (loadables) {
            _this.addResources(loadables);
        }
        return _this;
    }
    Object.defineProperty(Loader.prototype, "_image", {
        get: function () {
            if (!this._imageElement) {
                this._imageElement = new Image();
                this._imageElement.src = this.logo;
            }
            return this._imageElement;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Loader.prototype, "_playButton", {
        get: function () {
            if (!this._playButtonRootElement) {
                this._playButtonRootElement = document.createElement('div');
                this._playButtonRootElement.style.position = 'absolute';
                document.body.appendChild(this._playButtonRootElement);
            }
            if (!this._styleBlock) {
                this._styleBlock = document.createElement('style');
                this._styleBlock.textContent = this._playButtonStyles;
                document.head.appendChild(this._styleBlock);
            }
            if (!this._playButtonElement) {
                this._playButtonElement = this.startButtonFactory();
                this._playButtonRootElement.appendChild(this._playButtonElement);
            }
            return this._playButtonElement;
        },
        enumerable: true,
        configurable: true
    });
    Loader.prototype.wireEngine = function (engine) {
        this._engine = engine;
    };
    /**
     * Add a resource to the loader to load
     * @param loadable  Resource to add
     */
    Loader.prototype.addResource = function (loadable) {
        var key = this._index++;
        this._resourceList.push(loadable);
        this._progressCounts[key] = 0;
        this._totalCounts[key] = 1;
        this._resourceCount++;
    };
    /**
     * Add a list of resources to the loader to load
     * @param loadables  The list of resources to load
     */
    Loader.prototype.addResources = function (loadables) {
        var i = 0, len = loadables.length;
        for (i; i < len; i++) {
            this.addResource(loadables[i]);
        }
    };
    /**
     * Returns true if the loader has completely loaded all resources
     */
    Loader.prototype.isLoaded = function () {
        return this._numLoaded === this._resourceCount;
    };
    /**
     * Shows the play button and returns a promise that resolves when clicked
     */
    Loader.prototype.showPlayButton = function () {
        if (this.suppressPlayButton) {
            return _Promises__WEBPACK_IMPORTED_MODULE_3__["Promise"].resolve();
        }
        else {
            this._playButtonShown = true;
            this._playButton.style.display = 'block';
            var promise_1 = new _Promises__WEBPACK_IMPORTED_MODULE_3__["Promise"]();
            this._playButton.addEventListener('click', function () { return (promise_1.state() === _Promises__WEBPACK_IMPORTED_MODULE_3__["PromiseState"].Pending ? promise_1.resolve() : promise_1); });
            this._playButton.addEventListener('touchend', function () { return (promise_1.state() === _Promises__WEBPACK_IMPORTED_MODULE_3__["PromiseState"].Pending ? promise_1.resolve() : promise_1); });
            this._playButton.addEventListener('pointerup', function () { return (promise_1.state() === _Promises__WEBPACK_IMPORTED_MODULE_3__["PromiseState"].Pending ? promise_1.resolve() : promise_1); });
            return promise_1;
        }
    };
    Loader.prototype.hidePlayButton = function () {
        this._playButtonShown = false;
        this._playButton.style.display = 'none';
    };
    /**
     * Begin loading all of the supplied resources, returning a promise
     * that resolves when loading of all is complete
     */
    Loader.prototype.load = function () {
        var _this = this;
        var complete = new _Promises__WEBPACK_IMPORTED_MODULE_3__["Promise"]();
        var me = this;
        if (this._resourceList.length === 0) {
            me.showPlayButton().then(function () {
                // Unlock audio context in chrome after user gesture
                // https://github.com/excaliburjs/Excalibur/issues/262
                // https://github.com/excaliburjs/Excalibur/issues/1031
                _Util_WebAudio__WEBPACK_IMPORTED_MODULE_1__["WebAudio"].unlock().then(function () {
                    me.hidePlayButton();
                    me.oncomplete.call(me);
                    complete.resolve();
                });
            });
            return complete;
        }
        var progressArray = new Array(this._resourceList.length);
        var progressChunks = this._resourceList.length;
        this._resourceList.forEach(function (r, i) {
            if (_this._engine) {
                r.wireEngine(_this._engine);
            }
            r.onprogress = function (e) {
                var total = e.total;
                var loaded = e.loaded;
                progressArray[i] = { loaded: (loaded / total) * (100 / progressChunks), total: 100 };
                var progressResult = progressArray.reduce(function (accum, next) {
                    return { loaded: accum.loaded + next.loaded, total: 100 };
                }, { loaded: 0, total: 100 });
                me.onprogress.call(me, progressResult);
            };
            r.oncomplete = r.onerror = function () {
                me._numLoaded++;
                if (me._numLoaded === me._resourceCount) {
                    setTimeout(function () {
                        me.showPlayButton().then(function () {
                            // Unlock audio context in chrome after user gesture
                            // https://github.com/excaliburjs/Excalibur/issues/262
                            // https://github.com/excaliburjs/Excalibur/issues/1031
                            _Util_WebAudio__WEBPACK_IMPORTED_MODULE_1__["WebAudio"].unlock().then(function () {
                                me.hidePlayButton();
                                me.oncomplete.call(me);
                                complete.resolve();
                            });
                        });
                    }, 200); // short delay in showing the button for aesthetics
                }
            };
        });
        function loadNext(list, index) {
            if (!list[index]) {
                return;
            }
            list[index].load().then(function () {
                loadNext(list, index + 1);
            });
        }
        loadNext(this._resourceList, 0);
        return complete;
    };
    /**
     * Loader draw function. Draws the default Excalibur loading screen.
     * Override `logo`, `logoWidth`, `logoHeight` and `backgroundColor` properties
     * to customize the drawing, or just override entire method.
     */
    Loader.prototype.draw = function (ctx) {
        var canvasHeight = this._engine.canvasHeight / window.devicePixelRatio;
        var canvasWidth = this._engine.canvasWidth / window.devicePixelRatio;
        if (this._playButtonRootElement) {
            var left = ctx.canvas.offsetLeft;
            var top_1 = ctx.canvas.offsetTop;
            var buttonWidth = this._playButton.clientWidth;
            var buttonHeight = this._playButton.clientHeight;
            this._playButtonRootElement.style.left = left + canvasWidth / 2 - buttonWidth / 2 + "px";
            this._playButtonRootElement.style.top = top_1 + canvasHeight / 2 - buttonHeight / 2 + 100 + "px";
        }
        ctx.fillStyle = this.backgroundColor;
        ctx.fillRect(0, 0, canvasWidth, canvasHeight);
        var y = canvasHeight / 2;
        var width = Math.min(this.logoWidth, canvasWidth * 0.75);
        var x = canvasWidth / 2 - width / 2;
        var imageHeight = Math.floor(width * (this.logoHeight / this.logoWidth)); // OG height/width factor
        var oldAntialias = this._engine.getAntialiasing();
        this._engine.setAntialiasing(true);
        ctx.drawImage(this._image, 0, 0, this.logoWidth, this.logoHeight, x, y - imageHeight - 20, width, imageHeight);
        // loading box
        if (!this.suppressPlayButton && this._playButtonShown) {
            this._engine.setAntialiasing(oldAntialias);
            return;
        }
        ctx.lineWidth = 2;
        _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_5__["roundRect"](ctx, x, y, width, 20, 10);
        var progress = width * (this._numLoaded / this._resourceCount);
        var margin = 5;
        var progressWidth = progress - margin * 2;
        var height = 20 - margin * 2;
        _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_5__["roundRect"](ctx, x + margin, y + margin, progressWidth > 0 ? progressWidth : 0, height, 5, null, _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__["Color"].White);
        this._engine.setAntialiasing(oldAntialias);
    };
    /**
     * Perform any calculations or logic in the `update` method. The default `Loader` does not
     * do anything in this method so it is safe to override.
     */
    Loader.prototype.update = function (_engine, _delta) {
        // overridable update
    };
    return Loader;
}(_Class__WEBPACK_IMPORTED_MODULE_4__["Class"]));

/**
 * @obsolete Use [[Loader]] instead, this functionality has been made default
 *
 * A [[Loader]] that pauses after loading to allow user
 * to proceed to play the game. Typically you will
 * want to use this loader for iOS to allow sounds
 * to play after loading (Apple Safari requires user
 * interaction to allow sounds, even for games)
 *
 * **Note:** Because Loader is not part of a Scene, you must
 * call `update` and `draw` manually on "child" objects.
 *
 * ## Implementing a Trigger
 *
 * The `PauseAfterLoader` requires an element to act as the trigger button
 * to start the game.
 *
 * For example, let's create an `<a>` tag to be our trigger and call it `tap-to-play`.
 *
 * ```html
 * <div id="wrapper">
 *    <canvas id="game"></canvas>
 *    <a id="tap-to-play" href='javascript:void(0);'>Tap to Play</a>
 * </div>
 * ```
 *
 * We've put it inside a wrapper to position it properly over the game canvas.
 *
 * Now let's add some CSS to style it (insert into `<head>`):
 *
 * ```html
 * <style>
 *     #wrapper {
 *         position: relative;
 *         width: 500px;
 *         height: 500px;
 *     }
 *     #tap-to-play {
 *         display: none;
 *         font-size: 24px;
 *         font-family: sans-serif;
 *         text-align: center;
 *         border: 3px solid white;
 *         position: absolute;
 *         color: white;
 *         width: 200px;
 *         height: 50px;
 *         line-height: 50px;
 *         text-decoration: none;
 *         left: 147px;
 *         top: 80%;
 *     }
 * </style>
 * ```
 *
 * Now we can create a `PauseAfterLoader` with a reference to our trigger button:
 *
 * ```ts
 * var loader = new ex.PauseAfterLoader('tap-to-play', [...]);
 * ```
 *
 * ## Use PauseAfterLoader for iOS
 *
 * The primary use case for pausing before starting the game is to
 * pass Apple's requirement of user interaction. The Web Audio context
 * in Safari is disabled by default until user interaction.
 *
 * Therefore, you can use this snippet to only use PauseAfterLoader when
 * iOS is detected (see [this thread](http://stackoverflow.com/questions/9038625/detect-if-device-is-ios)
 * for more techniques).
 *
 * ```ts
 * var iOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !(<any>window).MSStream;
 * var loader: ex.Loader = iOS ? new ex.PauseAfterLoader('tap-to-play') : new ex.Loader();
 *
 * loader.addResource(...);
 * ```
 */
var PauseAfterLoader = /** @class */ (function (_super) {
    __extends(PauseAfterLoader, _super);
    function PauseAfterLoader(triggerElementId, loadables) {
        var _this = _super.call(this, loadables) || this;
        _this._handleOnTrigger = function () {
            if (_this._waitPromise.state() !== _Promises__WEBPACK_IMPORTED_MODULE_3__["PromiseState"].Pending) {
                return false;
            }
            // unlock Safari WebAudio context
            _Util_WebAudio__WEBPACK_IMPORTED_MODULE_1__["WebAudio"].unlock();
            // continue to play game
            _this._waitPromise.resolve(_this._loadedValue);
            // hide DOM element
            _this._playTrigger.style.display = 'none';
            return false;
        };
        _this._playTrigger = document.getElementById(triggerElementId);
        _this._playTrigger.addEventListener('click', _this._handleOnTrigger);
        return _this;
    }
    PauseAfterLoader.prototype.load = function () {
        var _this = this;
        this._waitPromise = new _Promises__WEBPACK_IMPORTED_MODULE_3__["Promise"]();
        // wait until user indicates to proceed before finishing load
        _super.prototype.load.call(this).then(function (value) {
            _this._loadedValue = value;
            // show element
            _this._playTrigger.style.display = 'block';
        }, function (value) {
            _this._waitPromise.reject(value);
        });
        return this._waitPromise;
    };
    __decorate([
        Object(_Util_Decorators__WEBPACK_IMPORTED_MODULE_6__["obsolete"])({ message: 'Deprecated in v0.20.0', alternateMethod: 'Use ex.Loader instead' })
    ], PauseAfterLoader.prototype, "load", null);
    return PauseAfterLoader;
}(Loader));



/***/ }),

/***/ "./Math/Index.ts":
/*!***********************!*\
  !*** ./Math/Index.ts ***!
  \***********************/
/*! exports provided: PerlinGenerator, PerlinDrawer2D, Random */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _PerlinNoise__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./PerlinNoise */ "./Math/PerlinNoise.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PerlinGenerator", function() { return _PerlinNoise__WEBPACK_IMPORTED_MODULE_0__["PerlinGenerator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PerlinDrawer2D", function() { return _PerlinNoise__WEBPACK_IMPORTED_MODULE_0__["PerlinDrawer2D"]; });

/* harmony import */ var _Random__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Random */ "./Math/Random.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Random", function() { return _Random__WEBPACK_IMPORTED_MODULE_1__["Random"]; });





/***/ }),

/***/ "./Math/PerlinNoise.ts":
/*!*****************************!*\
  !*** ./Math/PerlinNoise.ts ***!
  \*****************************/
/*! exports provided: PerlinGenerator, PerlinDrawer2D */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PerlinGenerator", function() { return PerlinGenerator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PerlinDrawer2D", function() { return PerlinDrawer2D; });
/* harmony import */ var _Random__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Random */ "./Math/Random.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util/Util */ "./Util/Util.ts");



function _lerp(time, a, b) {
    return a + time * (b - a);
}
function _fade(t) {
    return t * t * t * (t * (t * 6 - 15) + 10);
}
/**
 * Generates perlin noise based on the 2002 Siggraph paper http://mrl.nyu.edu/~perlin/noise/
 * Also https://flafla2.github.io/2014/08/09/perlinnoise.html
 */
var PerlinGenerator = /** @class */ (function () {
    function PerlinGenerator(options) {
        this._perm = [
            151,
            160,
            137,
            91,
            90,
            15,
            131,
            13,
            201,
            95,
            96,
            53,
            194,
            233,
            7,
            225,
            140,
            36,
            103,
            30,
            69,
            142,
            8,
            99,
            37,
            240,
            21,
            10,
            23,
            190,
            6,
            148,
            247,
            120,
            234,
            75,
            0,
            26,
            197,
            62,
            94,
            252,
            219,
            203,
            117,
            35,
            11,
            32,
            57,
            177,
            33,
            88,
            237,
            149,
            56,
            87,
            174,
            20,
            125,
            136,
            171,
            168,
            68,
            175,
            74,
            165,
            71,
            134,
            139,
            48,
            27,
            166,
            77,
            146,
            158,
            231,
            83,
            111,
            229,
            122,
            60,
            211,
            133,
            230,
            220,
            105,
            92,
            41,
            55,
            46,
            245,
            40,
            244,
            102,
            143,
            54,
            65,
            25,
            63,
            161,
            1,
            216,
            80,
            73,
            209,
            76,
            132,
            187,
            208,
            89,
            18,
            169,
            200,
            196,
            135,
            130,
            116,
            188,
            159,
            86,
            164,
            100,
            109,
            198,
            173,
            186,
            3,
            64,
            52,
            217,
            226,
            250,
            124,
            123,
            5,
            202,
            38,
            147,
            118,
            126,
            255,
            82,
            85,
            212,
            207,
            206,
            59,
            227,
            47,
            16,
            58,
            17,
            182,
            189,
            28,
            42,
            223,
            183,
            170,
            213,
            119,
            248,
            152,
            2,
            44,
            154,
            163,
            70,
            221,
            153,
            101,
            155,
            167,
            43,
            172,
            9,
            129,
            22,
            39,
            253,
            19,
            98,
            108,
            110,
            79,
            113,
            224,
            232,
            178,
            185,
            112,
            104,
            218,
            246,
            97,
            228,
            251,
            34,
            242,
            193,
            238,
            210,
            144,
            12,
            191,
            179,
            162,
            241,
            81,
            51,
            145,
            235,
            249,
            14,
            239,
            107,
            49,
            192,
            214,
            31,
            181,
            199,
            106,
            157,
            184,
            84,
            204,
            176,
            115,
            121,
            50,
            45,
            127,
            4,
            150,
            254,
            138,
            236,
            205,
            93,
            222,
            114,
            67,
            29,
            24,
            72,
            243,
            141,
            128,
            195,
            78,
            66,
            215,
            61,
            156,
            180
        ];
        this._p = new Uint8Array(512);
        this._defaultPerlinOptions = {
            octaves: 1,
            frequency: 1,
            amplitude: 1,
            persistance: 0.5
        };
        options = _Util_Util__WEBPACK_IMPORTED_MODULE_2__["extend"]({}, this._defaultPerlinOptions, options);
        this.persistance = options.persistance;
        this.amplitude = options.amplitude;
        this.frequency = options.frequency;
        this.octaves = options.octaves;
        if (options.seed) {
            this._random = new _Random__WEBPACK_IMPORTED_MODULE_0__["Random"](options.seed);
        }
        else {
            this._random = new _Random__WEBPACK_IMPORTED_MODULE_0__["Random"]();
        }
        this._perm = this._random.shuffle(this._perm);
        for (var i = 0; i < 512; i++) {
            this._p[i] = this._perm[i % 256] & 0xff;
        }
    }
    PerlinGenerator.prototype.noise = function () {
        var amp = this.amplitude;
        var freq = this.frequency;
        var total = 0;
        var maxValue = 0;
        for (var i = 0; i < this.octaves; i++) {
            switch (arguments.length) {
                case 1:
                    total += this._noise1d(arguments[0] * freq) * amp;
                    break;
                case 2:
                    total += this._noise2d(arguments[0] * freq, arguments[1] * freq) * amp;
                    break;
                case 3:
                    total += this._noise3d(arguments[0] * freq, arguments[1] * freq, arguments[2] * freq) * amp;
                    break;
                /* istanbul ignore next */
                default:
                    throw new Error('Invalid arguments for perlin noise');
            }
            maxValue += amp;
            amp *= this.persistance;
            freq *= 2;
        }
        return total / maxValue;
    };
    /**
     * Generates a list starting at 0 and ending at 1 of contious perlin noise, by default the step is 1/length;
     *
     */
    PerlinGenerator.prototype.sequence = function (length, step) {
        if (!step) {
            step = 1 / length;
        }
        var array = new Array(length);
        for (var i = 0; i < length; i++) {
            array[i] = this.noise(i * step);
        }
        return array;
    };
    /**
     * Generates a 2D grid of perlin noise given a step value packed into a 1D array i = (x + y*width),
     * by default the step will 1/(min(dimension))
     */
    PerlinGenerator.prototype.grid = function (width, height, step) {
        if (!step) {
            step = 1 / Math.min(width, height);
        }
        var array = new Array(width * height);
        for (var y = 0; y < height; y++) {
            for (var x = 0; x < width; x++) {
                array[x + y * width] = this.noise(x * step, y * step);
            }
        }
        return array;
    };
    PerlinGenerator.prototype._gradient3d = function (hash, x, y, z) {
        var h = hash & 0xf;
        var u = h < 8 ? x : y;
        var v = h < 4 ? y : h === 12 || h === 14 ? x : z;
        return ((h & 1) === 0 ? u : -u) + ((h & 2) === 0 ? v : -v);
    };
    PerlinGenerator.prototype._gradient2d = function (hash, x, y) {
        var value = (hash & 1) === 0 ? x : y;
        return (hash & 2) === 0 ? -value : value;
    };
    PerlinGenerator.prototype._gradient1d = function (hash, x) {
        return (hash & 1) === 0 ? -x : x;
    };
    PerlinGenerator.prototype._noise1d = function (x) {
        var intX = Math.floor(x) & 0xff; // force 0-255 integers to lookup in permutation
        x -= Math.floor(x);
        var fadeX = _fade(x);
        return (_lerp(fadeX, this._gradient1d(this._p[intX], x), this._gradient1d(this._p[intX + 1], x - 1)) + 1) / 2;
    };
    PerlinGenerator.prototype._noise2d = function (x, y) {
        var intX = Math.floor(x) & 0xff;
        var intY = Math.floor(y) & 0xff;
        x -= Math.floor(x);
        y -= Math.floor(y);
        var fadeX = _fade(x);
        var fadeY = _fade(y);
        var a = this._p[intX] + intY;
        var b = this._p[intX + 1] + intY;
        return ((_lerp(fadeY, _lerp(fadeX, this._gradient2d(this._p[a], x, y), this._gradient2d(this._p[b], x - 1, y)), _lerp(fadeX, this._gradient2d(this._p[a + 1], x, y - 1), this._gradient2d(this._p[b + 1], x - 1, y - 1))) +
            1) /
            2);
    };
    PerlinGenerator.prototype._noise3d = function (x, y, z) {
        var intX = Math.floor(x) & 0xff;
        var intY = Math.floor(y) & 0xff;
        var intZ = Math.floor(z) & 0xff;
        x -= Math.floor(x);
        y -= Math.floor(y);
        z -= Math.floor(z);
        var fadeX = _fade(x);
        var fadeY = _fade(y);
        var fadeZ = _fade(z);
        var a = this._p[intX] + intY;
        var b = this._p[intX + 1] + intY;
        var aa = this._p[a] + intZ;
        var ba = this._p[b] + intZ;
        var ab = this._p[a + 1] + intZ;
        var bb = this._p[b + 1] + intZ;
        return ((_lerp(fadeZ, _lerp(fadeY, _lerp(fadeX, this._gradient3d(this._p[aa], x, y, z), this._gradient3d(this._p[ba], x - 1, y, z)), _lerp(fadeX, this._gradient3d(this._p[ab], x, y - 1, z), this._gradient3d(this._p[bb], x - 1, y - 1, z))), _lerp(fadeY, _lerp(fadeX, this._gradient3d(this._p[aa + 1], x, y, z - 1), this._gradient3d(this._p[ba + 1], x - 1, y, z - 1)), _lerp(fadeX, this._gradient3d(this._p[ab + 1], x, y - 1, z - 1), this._gradient3d(this._p[bb + 1], x - 1, y - 1, z - 1)))) +
            1) /
            2);
    };
    return PerlinGenerator;
}());

/**
 * A helper to draw 2D perlin maps given a perlin generator and a function
 */
var PerlinDrawer2D = /** @class */ (function () {
    /**
     * @param generator - An existing perlin generator
     * @param colorFcn - A color function that takes a value between [0, 255] derived from the perlin generator, and returns a color
     */
    function PerlinDrawer2D(generator, colorFcn) {
        this.generator = generator;
        this.colorFcn = colorFcn;
        if (!colorFcn) {
            this.colorFcn = function (val) {
                return val < 125 ? _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Black : _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].White;
            };
        }
    }
    /**
     * Returns an image of 2D perlin noise
     */
    PerlinDrawer2D.prototype.image = function (width, height) {
        var image = document.createElement('img');
        var canvas = document.createElement('canvas');
        canvas.width = width;
        canvas.height = height;
        var ctx = canvas.getContext('2d');
        this.draw(ctx, 0, 0, width, height);
        image.src = canvas.toDataURL();
        return image;
    };
    /**
     * This draws a 2D perlin grid on a canvas context, not recommended to be called every frame due to performance
     */
    PerlinDrawer2D.prototype.draw = function (ctx, x, y, width, height) {
        var grid = this.generator.grid(width, height);
        var imageData = ctx.getImageData(x, y, width, height);
        for (var j = 0; j < height; j++) {
            for (var i = 0; i < width; i++) {
                var val = grid[i + width * j];
                var c = Math.floor(val * 255) & 0xff;
                var pixel = (i + j * imageData.width) * 4;
                var color = this.colorFcn(c);
                imageData.data[pixel] = color.r;
                imageData.data[pixel + 1] = color.g;
                imageData.data[pixel + 2] = color.b;
                imageData.data[pixel + 3] = Math.floor(color.a * 255);
            }
        }
        ctx.putImageData(imageData, x, y);
    };
    return PerlinDrawer2D;
}());



/***/ }),

/***/ "./Math/Random.ts":
/*!************************!*\
  !*** ./Math/Random.ts ***!
  \************************/
/*! exports provided: Random */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Random", function() { return Random; });
/**
 * Pseudo-Random Utility
 *
 * A pseudo-random utility to add seeded random support for help in
 * generating things like terrain or reproducible randomness. Uses the
 * [Mersenne Twister](https://en.wikipedia.org/wiki/Mersenne_Twister) algorithm.
 *
 * [[include:Random.md]]
 */
/**
 * 32-bit mask
 */
var BITMASK32 = 0xffffffff;
/**
 * Pseudo-random number generator following the Mersenne_Twister algorithm. Given a seed this generator will produce the same sequence
 * of numbers each time it is called.
 * See https://en.wikipedia.org/wiki/Mersenne_Twister for more details.
 * Uses the MT19937-32 (2002) implementation documented here http://www.math.sci.hiroshima-u.ac.jp/~m-mat/MT/MT2002/emt19937ar.html
 *
 * Api inspired by http://chancejs.com/# https://github.com/chancejs/chancejs
 */
var Random = /** @class */ (function () {
    /**
     * If no seed is specified, the Date.now() is used
     */
    function Random(seed) {
        this.seed = seed;
        // Separation point of one one word, the number of bits in the lower bitmask 0 <= r <= w-1
        this._lowerMask = 0x7fffffff; // 31 bits same as _r
        this._upperMask = 0x80000000; // 34 high bits
        // Word size, 64 bits
        this._w = 32;
        // Degree of recurrance
        this._n = 624;
        // Middle word, an offset used in the recurrance defining the series x, 1<=m<n
        this._m = 397;
        // coefficients of teh rational normal form twist matrix
        this._a = 0x9908b0df;
        // tempering bit shifts and masks
        this._u = 11;
        this._s = 7;
        this._b = 0x9d2c5680;
        this._t = 15;
        this._c = 0xefc60000;
        this._l = 18;
        this._f = 1812433253;
        this._mt = new Array(this._n);
        // need to mask to support higher bit machines
        this._mt[0] = (seed || Date.now()) >>> 0;
        for (var i = 1; i < this._n; i++) {
            var s = this._mt[i - 1] ^ (this._mt[i - 1] >>> (this._w - 2));
            // numbers are bigger than the JS max safe int, add in 16-bit chunks to prevent IEEE rounding errors on high bits
            this._mt[i] = (((this._f * ((s & 0xffff0000) >>> 16)) << 16) + this._f * (s & 0xffff) + i) >>> 0;
        }
        this._index = this._n;
    }
    /**
     * Apply the twist
     */
    Random.prototype._twist = function () {
        var mag01 = [0x0, this._a];
        var y = 0;
        for (var i = 0; i < this._n - this._m; i++) {
            y = (this._mt[i] & this._upperMask) | (this._mt[i + 1] & this._lowerMask);
            this._mt[i] = this._mt[i + this._m] ^ (y >>> 1) ^ (mag01[y & 0x1] & BITMASK32);
        }
        for (; i < this._n - 1; i++) {
            y = (this._mt[i] & this._upperMask) | (this._mt[i + 1] & this._lowerMask);
            this._mt[i] = this._mt[i + (this._m - this._n)] ^ (y >>> 1) ^ (mag01[y & 0x1] & BITMASK32);
        }
        y = (this._mt[this._n - 1] & this._upperMask) | (this._mt[0] & this._lowerMask);
        this._mt[this._n - 1] = this._mt[this._m - 1] ^ (y >>> 1) ^ (mag01[y & 0x1] & BITMASK32);
        this._index = 0;
    };
    /**
     * Return next 32 bit integer number in sequence
     */
    Random.prototype.nextInt = function () {
        if (this._index >= this._n) {
            this._twist();
        }
        var y = this._mt[this._index++];
        y ^= y >>> this._u;
        y ^= (y << this._s) & this._b;
        y ^= (y << this._t) & this._c;
        y ^= y >>> this._l;
        return y >>> 0;
    };
    /**
     * Return a random floating point number between [0, 1)
     */
    Random.prototype.next = function () {
        return this.nextInt() * (1.0 / 4294967296.0); // divided by 2^32
    };
    /**
     * Return a random floating point in range [min, max) min is included, max is not included
     */
    Random.prototype.floating = function (min, max) {
        return (max - min) * this.next() + min;
    };
    /**
     * Return a random integer in range [min, max] min is included, max is included.
     * Implemented with rejection sampling, see https://medium.com/@betable/tifu-by-using-math-random-f1c308c4fd9d#.i13tdiu5a
     */
    Random.prototype.integer = function (min, max) {
        return Math.floor((max - min + 1) * this.next() + min);
    };
    /**
     * Returns true or false randomly with 50/50 odds by default.
     * By default the likelihood of returning a true is .5 (50%).
     * @param likelihood takes values between [0, 1]
     */
    Random.prototype.bool = function (likelihood) {
        if (likelihood === void 0) { likelihood = 0.5; }
        return this.next() <= likelihood;
    };
    /**
     * Returns one element from an array at random
     */
    Random.prototype.pickOne = function (array) {
        return array[this.integer(0, array.length - 1)];
    };
    /**
     * Returns a new array random picking elements from the original
     * @param array Original array to pick from
     * @param numPicks can be any positive number
     * @param allowDuplicates indicates whether the returned set is allowed duplicates (it does not mean there will always be duplicates
     * just that it is possible)
     */
    Random.prototype.pickSet = function (array, numPicks, allowDuplicates) {
        if (allowDuplicates === void 0) { allowDuplicates = false; }
        if (allowDuplicates) {
            return this._pickSetWithDuplicates(array, numPicks);
        }
        else {
            return this._pickSetWithoutDuplicates(array, numPicks);
        }
    };
    /**
     * Returns a new array randomly picking elements in the original (not reused)
     * @param numPicks must be less than or equal to the number of elements in the array.
     */
    Random.prototype._pickSetWithoutDuplicates = function (array, numPicks) {
        if (numPicks > array.length || numPicks < 0) {
            throw new Error('Invalid number of elements to pick, must pick a value 0 < n <= length');
        }
        if (numPicks === array.length) {
            return array;
        }
        var result = new Array(numPicks);
        var currentPick = 0;
        var tempArray = array.slice(0);
        while (currentPick < numPicks) {
            var index = this.integer(0, tempArray.length - 1);
            result[currentPick++] = tempArray[index];
            tempArray.splice(index, 1);
        }
        return result;
    };
    /**
     * Returns a new array random picking elements from the original allowing duplicates
     * @param numPicks can be any positive number
     */
    Random.prototype._pickSetWithDuplicates = function (array, numPicks) {
        // Typescript numbers are all floating point, so do we add check for int? (or floor the input?)
        if (numPicks < 0) {
            throw new Error('Invalid number of elements to pick, must pick a value 0 <= n < MAX_INT');
        }
        var result = new Array(numPicks);
        for (var i = 0; i < numPicks; i++) {
            result[i] = this.pickOne(array);
        }
        return result;
    };
    /**
     * Returns a new array that has its elements shuffled. Using the Fisher/Yates method
     * https://en.wikipedia.org/wiki/Fisher%E2%80%93Yates_shuffle
     */
    Random.prototype.shuffle = function (array) {
        var tempArray = array.slice(0);
        var swap = null;
        for (var i = 0; i < tempArray.length - 2; i++) {
            var randomIndex = this.integer(i, tempArray.length - 1);
            swap = tempArray[i];
            tempArray[i] = tempArray[randomIndex];
            tempArray[randomIndex] = swap;
        }
        return tempArray;
    };
    /**
     * Generate a list of random integer numbers
     * @param length the length of the final array
     * @param min the minimum integer number to generate inclusive
     * @param max the maximum integer number to generate inclusive
     */
    Random.prototype.range = function (length, min, max) {
        var result = new Array(length);
        for (var i = 0; i < length; i++) {
            result[i] = this.integer(min, max);
        }
        return result;
    };
    /**
     * Returns the result of a d4 dice roll
     */
    Random.prototype.d4 = function () {
        return this.integer(1, 4);
    };
    /**
     * Returns the result of a d6 dice roll
     */
    Random.prototype.d6 = function () {
        return this.integer(1, 6);
    };
    /**
     * Returns the result of a d8 dice roll
     */
    Random.prototype.d8 = function () {
        return this.integer(1, 8);
    };
    /**
     * Returns the result of a d10 dice roll
     */
    Random.prototype.d10 = function () {
        return this.integer(1, 10);
    };
    /**
     * Returns the result of a d12 dice roll
     */
    Random.prototype.d12 = function () {
        return this.integer(1, 12);
    };
    /**
     * Returns the result of a d20 dice roll
     */
    Random.prototype.d20 = function () {
        return this.integer(1, 20);
    };
    return Random;
}());



/***/ }),

/***/ "./Particles.ts":
/*!**********************!*\
  !*** ./Particles.ts ***!
  \**********************/
/*! exports provided: EmitterType, ParticleImpl, Particle, ParticleEmitterImpl, ParticleEmitter */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EmitterType", function() { return EmitterType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ParticleImpl", function() { return ParticleImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Particle", function() { return Particle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ParticleEmitterImpl", function() { return ParticleEmitterImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ParticleEmitter", function() { return ParticleEmitter; });
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Actor */ "./Actor.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Util/Util */ "./Util/Util.ts");
/* harmony import */ var _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Util/DrawUtil */ "./Util/DrawUtil.ts");
/* harmony import */ var _Traits_Index__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Traits/Index */ "./Traits/Index.ts");
/* harmony import */ var _Configurable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Configurable */ "./Configurable.ts");
/* harmony import */ var _Math_Random__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Math/Random */ "./Math/Random.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();








/**
 * An enum that represents the types of emitter nozzles
 */
var EmitterType;
(function (EmitterType) {
    /**
     * Constant for the circular emitter type
     */
    EmitterType[EmitterType["Circle"] = 0] = "Circle";
    /**
     * Constant for the rectangular emitter type
     */
    EmitterType[EmitterType["Rectangle"] = 1] = "Rectangle";
})(EmitterType || (EmitterType = {}));
/**
 * @hidden
 */
var ParticleImpl = /** @class */ (function () {
    function ParticleImpl(emitterOrConfig, life, opacity, beginColor, endColor, position, velocity, acceleration, startSize, endSize) {
        this.position = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](0, 0);
        this.velocity = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](0, 0);
        this.acceleration = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](0, 0);
        this.particleRotationalVelocity = 0;
        this.currentRotation = 0;
        this.focus = null;
        this.focusAccel = 0;
        this.opacity = 1;
        this.beginColor = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].White.clone();
        this.endColor = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].White.clone();
        // Life is counted in ms
        this.life = 300;
        this.fadeFlag = false;
        // Color transitions
        this._rRate = 1;
        this._gRate = 1;
        this._bRate = 1;
        this._aRate = 0;
        this._currentColor = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].White.clone();
        this.emitter = null;
        this.particleSize = 5;
        this.particleSprite = null;
        this.sizeRate = 0;
        this.elapsedMultiplier = 0;
        var emitter = emitterOrConfig;
        if (emitter && !(emitterOrConfig instanceof ParticleEmitter)) {
            var config = emitterOrConfig;
            emitter = config.emitter;
            life = config.life;
            opacity = config.opacity;
            endColor = config.endColor;
            beginColor = config.beginColor;
            position = config.position;
            velocity = config.velocity;
            acceleration = config.acceleration;
            startSize = config.startSize;
            endSize = config.endSize;
        }
        this.emitter = emitter;
        this.life = life || this.life;
        this.opacity = opacity || this.opacity;
        this.endColor = endColor || this.endColor.clone();
        this.beginColor = beginColor || this.beginColor.clone();
        this._currentColor = this.beginColor.clone();
        this.position = position || this.position;
        this.velocity = velocity || this.velocity;
        this.acceleration = acceleration || this.acceleration;
        this._rRate = (this.endColor.r - this.beginColor.r) / this.life;
        this._gRate = (this.endColor.g - this.beginColor.g) / this.life;
        this._bRate = (this.endColor.b - this.beginColor.b) / this.life;
        this._aRate = this.opacity / this.life;
        this.startSize = startSize || 0;
        this.endSize = endSize || 0;
        if (this.endSize > 0 && this.startSize > 0) {
            this.sizeRate = (this.endSize - this.startSize) / this.life;
            this.particleSize = this.startSize;
        }
    }
    ParticleImpl.prototype.kill = function () {
        this.emitter.removeParticle(this);
    };
    ParticleImpl.prototype.update = function (delta) {
        this.life = this.life - delta;
        this.elapsedMultiplier = this.elapsedMultiplier + delta;
        if (this.life < 0) {
            this.kill();
        }
        if (this.fadeFlag) {
            this.opacity = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["clamp"](this._aRate * this.life, 0.0001, 1);
        }
        if (this.startSize > 0 && this.endSize > 0) {
            this.particleSize = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["clamp"](this.sizeRate * delta + this.particleSize, Math.min(this.startSize, this.endSize), Math.max(this.startSize, this.endSize));
        }
        this._currentColor.r = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["clamp"](this._currentColor.r + this._rRate * delta, 0, 255);
        this._currentColor.g = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["clamp"](this._currentColor.g + this._gRate * delta, 0, 255);
        this._currentColor.b = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["clamp"](this._currentColor.b + this._bRate * delta, 0, 255);
        this._currentColor.a = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["clamp"](this.opacity, 0.0001, 1);
        if (this.focus) {
            var accel = this.focus
                .sub(this.position)
                .normalize()
                .scale(this.focusAccel)
                .scale(delta / 1000);
            this.velocity = this.velocity.add(accel);
        }
        else {
            this.velocity = this.velocity.add(this.acceleration.scale(delta / 1000));
        }
        this.position = this.position.add(this.velocity.scale(delta / 1000));
        if (this.particleRotationalVelocity) {
            this.currentRotation = (this.currentRotation + (this.particleRotationalVelocity * delta) / 1000) % (2 * Math.PI);
        }
    };
    ParticleImpl.prototype.draw = function (ctx) {
        if (this.particleSprite) {
            this.particleSprite.rotation = this.currentRotation;
            this.particleSprite.scale.setTo(this.particleSize, this.particleSize);
            this.particleSprite.draw(ctx, this.position.x, this.position.y);
            return;
        }
        this._currentColor.a = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["clamp"](this.opacity, 0.0001, 1);
        ctx.fillStyle = this._currentColor.toString();
        ctx.beginPath();
        ctx.arc(this.position.x, this.position.y, this.particleSize, 0, Math.PI * 2);
        ctx.fill();
        ctx.closePath();
    };
    return ParticleImpl;
}());

/**
 * Particle is used in a [[ParticleEmitter]]
 */
var Particle = /** @class */ (function (_super) {
    __extends(Particle, _super);
    function Particle(emitterOrConfig, life, opacity, beginColor, endColor, position, velocity, acceleration, startSize, endSize) {
        return _super.call(this, emitterOrConfig, life, opacity, beginColor, endColor, position, velocity, acceleration, startSize, endSize) || this;
    }
    return Particle;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_6__["Configurable"])(ParticleImpl)));

/**
 * @hidden
 */
var ParticleEmitterImpl = /** @class */ (function (_super) {
    __extends(ParticleEmitterImpl, _super);
    /**
     * @param x       The x position of the emitter
     * @param y       The y position of the emitter
     * @param width   The width of the emitter
     * @param height  The height of the emitter
     */
    function ParticleEmitterImpl(xOrConfig, y, width, height) {
        var _this = _super.call(this, typeof xOrConfig === 'number' ? { x: xOrConfig, y: y, width: width, height: height } : xOrConfig) || this;
        _this.numParticles = 0;
        /**
         * Gets or sets the isEmitting flag
         */
        _this.isEmitting = true;
        /**
         * Gets or sets the backing particle collection
         */
        _this.particles = null;
        /**
         * Gets or sets the backing deadParticle collection
         */
        _this.deadParticles = null;
        /**
         * Gets or sets the minimum particle velocity
         */
        _this.minVel = 0;
        /**
         * Gets or sets the maximum particle velocity
         */
        _this.maxVel = 0;
        /**
         * Gets or sets the acceleration vector for all particles
         */
        _this.acceleration = new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](0, 0);
        /**
         * Gets or sets the minimum angle in radians
         */
        _this.minAngle = 0;
        /**
         * Gets or sets the maximum angle in radians
         */
        _this.maxAngle = 0;
        /**
         * Gets or sets the emission rate for particles (particles/sec)
         */
        _this.emitRate = 1; //particles/sec
        /**
         * Gets or sets the life of each particle in milliseconds
         */
        _this.particleLife = 2000;
        /**
         * Gets or sets the opacity of each particle from 0 to 1.0
         */
        _this.opacity = 1;
        /**
         * Gets or sets the fade flag which causes particles to gradually fade out over the course of their life.
         */
        _this.fadeFlag = false;
        /**
         * Gets or sets the optional focus where all particles should accelerate towards
         */
        _this.focus = null;
        /**
         * Gets or sets the acceleration for focusing particles if a focus has been specified
         */
        _this.focusAccel = 1;
        /*
          * Gets or sets the optional starting size for the particles
          */
        _this.startSize = null;
        /*
          * Gets or sets the optional ending size for the particles
          */
        _this.endSize = null;
        /**
         * Gets or sets the minimum size of all particles
         */
        _this.minSize = 5;
        /**
         * Gets or sets the maximum size of all particles
         */
        _this.maxSize = 5;
        /**
         * Gets or sets the beginning color of all particles
         */
        _this.beginColor = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].White.clone();
        /**
         * Gets or sets the ending color of all particles
         */
        _this.endColor = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].White.clone();
        /**
         * Gets or sets the sprite that a particle should use
         * @warning Performance intensive
         */
        _this.particleSprite = null;
        /**
         * Gets or sets the emitter type for the particle emitter
         */
        _this.emitterType = EmitterType.Rectangle;
        /**
         * Gets or sets the emitter radius, only takes effect when the [[emitterType]] is [[EmitterType.Circle]]
         */
        _this.radius = 0;
        /**
         * Gets or sets the particle rotational speed velocity
         */
        _this.particleRotationalVelocity = 0;
        /**
         * Indicates whether particles should start with a random rotation
         */
        _this.randomRotation = false;
        _this._particlesToEmit = 0;
        _this.collisionType = _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].PreventCollision;
        _this.particles = new _Util_Util__WEBPACK_IMPORTED_MODULE_3__["Collection"]();
        _this.deadParticles = new _Util_Util__WEBPACK_IMPORTED_MODULE_3__["Collection"]();
        _this.random = new _Math_Random__WEBPACK_IMPORTED_MODULE_7__["Random"]();
        // Remove offscreen culling from particle emitters
        for (var i = 0; i < _this.traits.length; i++) {
            if (_this.traits[i] instanceof _Traits_Index__WEBPACK_IMPORTED_MODULE_5__["OffscreenCulling"]) {
                _this.traits.splice(i, 1);
            }
        }
        return _this;
    }
    ParticleEmitterImpl.prototype.removeParticle = function (particle) {
        this.deadParticles.push(particle);
    };
    /**
     * Causes the emitter to emit particles
     * @param particleCount  Number of particles to emit right now
     */
    ParticleEmitterImpl.prototype.emitParticles = function (particleCount) {
        for (var i = 0; i < particleCount; i++) {
            this.particles.push(this._createParticle());
        }
    };
    ParticleEmitterImpl.prototype.clearParticles = function () {
        this.particles.clear();
    };
    // Creates a new particle given the constraints of the emitter
    ParticleEmitterImpl.prototype._createParticle = function () {
        // todo implement emitter constraints;
        var ranX = 0;
        var ranY = 0;
        var angle = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["randomInRange"](this.minAngle, this.maxAngle, this.random);
        var vel = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["randomInRange"](this.minVel, this.maxVel, this.random);
        var size = this.startSize || _Util_Util__WEBPACK_IMPORTED_MODULE_3__["randomInRange"](this.minSize, this.maxSize, this.random);
        var dx = vel * Math.cos(angle);
        var dy = vel * Math.sin(angle);
        if (this.emitterType === EmitterType.Rectangle) {
            ranX = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["randomInRange"](this.pos.x, this.pos.x + this.getWidth(), this.random);
            ranY = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["randomInRange"](this.pos.y, this.pos.y + this.getHeight(), this.random);
        }
        else if (this.emitterType === EmitterType.Circle) {
            var radius = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["randomInRange"](0, this.radius, this.random);
            ranX = radius * Math.cos(angle) + this.pos.x;
            ranY = radius * Math.sin(angle) + this.pos.y;
        }
        var p = new Particle(this, this.particleLife, this.opacity, this.beginColor, this.endColor, new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](ranX, ranY), new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](dx, dy), this.acceleration, this.startSize, this.endSize);
        p.fadeFlag = this.fadeFlag;
        p.particleSize = size;
        if (this.particleSprite) {
            p.particleSprite = this.particleSprite;
        }
        p.particleRotationalVelocity = this.particleRotationalVelocity;
        if (this.randomRotation) {
            p.currentRotation = _Util_Util__WEBPACK_IMPORTED_MODULE_3__["randomInRange"](0, Math.PI * 2, this.random);
        }
        if (this.focus) {
            p.focus = this.focus.add(new _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"](this.pos.x, this.pos.y));
            p.focusAccel = this.focusAccel;
        }
        return p;
    };
    ParticleEmitterImpl.prototype.update = function (engine, delta) {
        var _this = this;
        _super.prototype.update.call(this, engine, delta);
        if (this.isEmitting) {
            this._particlesToEmit += this.emitRate * (delta / 1000);
            //var numParticles = Math.ceil(this.emitRate * delta / 1000);
            if (this._particlesToEmit > 1.0) {
                this.emitParticles(Math.floor(this._particlesToEmit));
                this._particlesToEmit = this._particlesToEmit - Math.floor(this._particlesToEmit);
            }
        }
        this.particles.forEach(function (p) { return p.update(delta); });
        this.deadParticles.forEach(function (p) { return _this.particles.removeElement(p); });
        this.deadParticles.clear();
    };
    ParticleEmitterImpl.prototype.draw = function (ctx) {
        // todo is there a more efficient to draw
        // possibly use a webgl offscreen canvas and shaders to do particles?
        this.particles.forEach(function (p) { return p.draw(ctx); });
    };
    ParticleEmitterImpl.prototype.debugDraw = function (ctx) {
        _super.prototype.debugDraw.call(this, ctx);
        ctx.fillStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Black.toString();
        ctx.fillText('Particles: ' + this.particles.count(), this.pos.x, this.pos.y + 20);
        if (this.focus) {
            ctx.fillRect(this.focus.x + this.pos.x, this.focus.y + this.pos.y, 3, 3);
            _Util_DrawUtil__WEBPACK_IMPORTED_MODULE_4__["line"](ctx, _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Yellow, this.focus.x + this.pos.x, this.focus.y + this.pos.y, _super.prototype.getCenter.call(this).x, _super.prototype.getCenter.call(this).y);
            ctx.fillText('Focus', this.focus.x + this.pos.x, this.focus.y + this.pos.y);
        }
    };
    return ParticleEmitterImpl;
}(_Actor__WEBPACK_IMPORTED_MODULE_0__["Actor"]));

/**
 * Using a particle emitter is a great way to create interesting effects
 * in your game, like smoke, fire, water, explosions, etc. `ParticleEmitter`
 * extend [[Actor]] allowing you to use all of the features that come with.
 *
 * [[include:Particles.md]]
 */
var ParticleEmitter = /** @class */ (function (_super) {
    __extends(ParticleEmitter, _super);
    function ParticleEmitter(xOrConfig, y, width, height) {
        return _super.call(this, xOrConfig, y, width, height) || this;
    }
    return ParticleEmitter;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_6__["Configurable"])(ParticleEmitterImpl)));



/***/ }),

/***/ "./Physics.ts":
/*!********************!*\
  !*** ./Physics.ts ***!
  \********************/
/*! exports provided: CollisionResolutionStrategy, BroadphaseStrategy, Integrator, Physics */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CollisionResolutionStrategy", function() { return CollisionResolutionStrategy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BroadphaseStrategy", function() { return BroadphaseStrategy; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Integrator", function() { return Integrator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Physics", function() { return Physics; });
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");

/**
 * Possible collision resolution strategies
 *
 * The default is [[CollisionResolutionStrategy.Box]] which performs simple axis aligned arcade style physics.
 *
 * More advanced rigid body physics are enabled by setting [[CollisionResolutionStrategy.RigidBody]] which allows for complicated
 * simulated physical interactions.
 */
var CollisionResolutionStrategy;
(function (CollisionResolutionStrategy) {
    CollisionResolutionStrategy[CollisionResolutionStrategy["Box"] = 0] = "Box";
    CollisionResolutionStrategy[CollisionResolutionStrategy["RigidBody"] = 1] = "RigidBody";
})(CollisionResolutionStrategy || (CollisionResolutionStrategy = {}));
/**
 * Possible broadphase collision pair identification strategies
 *
 * The default strategy is [[BroadphaseStrategy.DynamicAABBTree]] which uses a binary tree of axis-aligned bounding boxes to identify
 * potential collision pairs which is O(nlog(n)) faster. The other possible strategy is the [[BroadphaseStrategy.Naive]] strategy
 * which loops over every object for every object in the scene to identify collision pairs which is O(n^2) slower.
 */
var BroadphaseStrategy;
(function (BroadphaseStrategy) {
    BroadphaseStrategy[BroadphaseStrategy["Naive"] = 0] = "Naive";
    BroadphaseStrategy[BroadphaseStrategy["DynamicAABBTree"] = 1] = "DynamicAABBTree";
})(BroadphaseStrategy || (BroadphaseStrategy = {}));
/**
 * Possible numerical integrators for position and velocity
 */
var Integrator;
(function (Integrator) {
    Integrator[Integrator["Euler"] = 0] = "Euler";
})(Integrator || (Integrator = {}));
/**
 * The [[Physics]] object is the global configuration object for all Excalibur physics.
 *
 * [[include:Physics.md]]
 */
/* istanbul ignore next */
var Physics = /** @class */ (function () {
    function Physics() {
    }
    /**
     * Configures Excalibur to use box physics. Box physics which performs simple axis aligned arcade style physics.
     */
    Physics.useBoxPhysics = function () {
        Physics.collisionResolutionStrategy = CollisionResolutionStrategy.Box;
    };
    /**
     * Configures Excalibur to use rigid body physics. Rigid body physics allows for complicated
     * simulated physical interactions.
     */
    Physics.useRigidBodyPhysics = function () {
        Physics.collisionResolutionStrategy = CollisionResolutionStrategy.RigidBody;
    };
    /**
     * Global acceleration that is applied to all vanilla actors that have a [[CollisionType.Active|active]] collision type.
     * Global acceleration won't effect [[Label|labels]], [[UIActor|ui actors]], or [[Trigger|triggers]] in Excalibur.
     *
     * This is a great way to globally simulate effects like gravity.
     */
    Physics.acc = new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](0, 0);
    /**
     * Globally switches all Excalibur physics behavior on or off.
     */
    Physics.enabled = true;
    /**
     * Gets or sets the number of collision passes for Excalibur to perform on physics bodies.
     *
     * Reducing collision passes may cause things not to collide as expected in your game, but may increase performance.
     *
     * More passes can improve the visual quality of collisions when many objects are on the screen. This can reduce jitter, improve the
     * collision resolution of fast move objects, or the stability of large numbers of objects stacked together.
     *
     * Fewer passes will improve the performance of the game at the cost of collision quality, more passes will improve quality at the
     * cost of performance.
     *
     * The default is set to 5 passes which is a good start.
     */
    Physics.collisionPasses = 5;
    /**
     * Gets or sets the broadphase pair identification strategy.
     *
     * The default strategy is [[BroadphaseStrategy.DynamicAABBTree]] which uses a binary tree of axis-aligned bounding boxes to identify
     * potential collision pairs which is O(nlog(n)) faster. The other possible strategy is the [[BroadphaseStrategy.Naive]] strategy
     * which loops over every object for every object in the scene to identify collision pairs which is O(n^2) slower.
     */
    Physics.broadphaseStrategy = BroadphaseStrategy.DynamicAABBTree;
    /**
     * Globally switches the debug information for the broadphase strategy
     */
    Physics.broadphaseDebug = false;
    /**
     * Show the normals as a result of collision on the screen.
     */
    Physics.showCollisionNormals = false;
    /**
     * Show the position, velocity, and acceleration as graphical vectors.
     */
    Physics.showMotionVectors = false;
    /**
     * Show the axis-aligned bounding boxes of the collision bodies on the screen.
     */
    Physics.showBounds = false;
    /**
     * Show the bounding collision area shapes
     */
    Physics.showArea = false;
    /**
     * Show points of collision interpreted by excalibur as a result of collision.
     */
    Physics.showContacts = false;
    /**
     * Show the surface normals of the collision areas.
     */
    Physics.showNormals = false;
    /**
     * Gets or sets the global collision resolution strategy (narrowphase).
     *
     * The default is [[CollisionResolutionStrategy.Box]] which performs simple axis aligned arcade style physics.
     *
     * More advanced rigid body physics are enabled by setting [[CollisionResolutionStrategy.RigidBody]] which allows for complicated
     * simulated physical interactions.
     */
    Physics.collisionResolutionStrategy = CollisionResolutionStrategy.Box;
    /**
     * The default mass to use if none is specified
     */
    Physics.defaultMass = 10;
    /**
     * Gets or sets the position and velocity positional integrator, currently only Euler is supported.
     */
    Physics.integrator = Integrator.Euler;
    /**
     * Number of steps to use in integration. A higher number improves the positional accuracy over time. This can be useful to increase
     * if you have fast moving objects in your simulation or you have a large number of objects and need to increase stability.
     */
    Physics.integrationSteps = 1;
    /**
     * Gets or sets whether rotation is allowed in a RigidBody collision resolution
     */
    Physics.allowRigidBodyRotation = true;
    /**
     * Small value to help collision passes settle themselves after the narrowphase.
     */
    Physics.collisionShift = 0.001;
    /**
     * Factor to add to the RigidBody BoundingBox, bounding box (dimensions += vel * dynamicTreeVelocityMultiplyer);
     */
    Physics.dynamicTreeVelocityMultiplyer = 2;
    /**
     * Pad RigidBody BoundingBox by a constant amount
     */
    Physics.boundsPadding = 5;
    /**
     * Surface epsilon is used to help deal with surface penatration
     */
    Physics.surfaceEpsilon = 0.1;
    /**
     * Enable fast moving body checking, this enables checking for collision pairs via raycast for fast moving objects to prevent
     * bodies from tunneling through one another.
     */
    Physics.checkForFastBodies = true;
    /**
     * Disable minimum fast moving body raycast, by default if ex.Physics.checkForFastBodies = true Excalibur will only check if the
     * body is moving at least half of its minimum diminension in an update. If ex.Physics.disableMinimumSpeedForFastBody is set to true,
     * Excalibur will always perform the fast body raycast regardless of speed.
     */
    Physics.disableMinimumSpeedForFastBody = false;
    return Physics;
}());



/***/ }),

/***/ "./Polyfill.ts":
/*!*********************!*\
  !*** ./Polyfill.ts ***!
  \*********************/
/*! no static exports found */
/***/ (function(module, exports) {

/* istanbul ignore next */
if (typeof window === 'undefined') {
    window = {
        audioContext: function () {
            return;
        }
    };
}
/* istanbul ignore next */
if (typeof window !== 'undefined' && !window.requestAnimationFrame) {
    window.requestAnimationFrame =
        window.webkitRequestAnimationFrame ||
            window.mozRequestAnimationFrame ||
            function (callback) {
                window.setInterval(callback, 1000 / 60);
            };
}
/* istanbul ignore next */
if (typeof window !== 'undefined' && !window.cancelAnimationFrame) {
    window.cancelAnimationFrame =
        window.webkitCancelAnimationFrame ||
            window.mozCancelAnimationFrame ||
            function () {
                return;
            };
}
/* istanbul ignore next */
if (typeof window !== 'undefined' && !window.AudioContext) {
    window.AudioContext =
        window.AudioContext ||
            window.webkitAudioContext ||
            window.mozAudioContext ||
            window.msAudioContext ||
            window.oAudioContext;
}
if (typeof window !== 'undefined' && !window.devicePixelRatio) {
    window.devicePixelRatio = window.devicePixelRatio || 1;
}
// Polyfill from https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/forEach
// Production steps of ECMA-262, Edition 5, 15.4.4.18
// Reference: http://es5.github.io/#x15.4.4.18
/* istanbul ignore next */
if (!Array.prototype.forEach) {
    Array.prototype.forEach = function (callback, thisArg) {
        var T, k;
        if (this == null) {
            throw new TypeError('this is null or not defined');
        }
        // 1. Let O be the result of calling ToObject passing the |this| value as the argument.
        var O = Object(this);
        // 2. Let lenValue be the result of calling the Get internal method of O with the argument "length".
        // 3. Let len be ToUint32(lenValue).
        var len = O.length >>> 0;
        // 4. If IsCallable(callback) is false, throw a TypeError exception.
        // See: http://es5.github.com/#x9.11
        if (typeof callback !== 'function') {
            throw new TypeError(callback + ' is not a function');
        }
        // 5. If thisArg was supplied, let T be thisArg; else let T be undefined.
        if (arguments.length > 1) {
            T = thisArg;
        }
        // 6. Let k be 0
        k = 0;
        // 7. Repeat, while k < len
        while (k < len) {
            var kValue;
            // a. Let Pk be ToString(k).
            //   This is implicit for LHS operands of the in operator
            // b. Let kPresent be the result of calling the HasProperty internal method of O with argument Pk.
            //   This step can be combined with c
            // c. If kPresent is true, then
            if (k in O) {
                // i. Let kValue be the result of calling the Get internal method of O with argument Pk.
                kValue = O[k];
                // ii. Call the Call internal method of callback with T as the this value and
                // argument list containing kValue, k, and O.
                callback.call(T, kValue, k, O);
            }
            // d. Increase k by 1.
            k++;
        }
        // 8. return undefined
    };
}
// Polyfill from https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/some
/* istanbul ignore next */
if (!Array.prototype.some) {
    Array.prototype.some = function (fun /*, thisArg */) {
        'use strict';
        if (this === void 0 || this === null) {
            throw new TypeError();
        }
        var t = Object(this);
        var len = t.length >>> 0;
        if (typeof fun !== 'function') {
            throw new TypeError();
        }
        var thisArg = arguments.length >= 2 ? arguments[1] : void 0;
        for (var i = 0; i < len; i++) {
            if (i in t && fun.call(thisArg, t[i], i, t)) {
                return true;
            }
        }
        return false;
    };
}
// Polyfill from  https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Function/bind#Polyfill
/* istanbul ignore next */
if (!Function.prototype.bind) {
    Function.prototype.bind = function (oThis) {
        if (typeof this !== 'function') {
            // closest thing possible to the ECMAScript 5
            // internal IsCallable function
            throw new TypeError('Function.prototype.bind - what is trying to be bound is not callable');
        }
        var aArgs = Array.prototype.slice.call(arguments, 1), fToBind = this, fNOP = function () {
            return;
        }, fBound = function () {
            return fToBind.apply(this instanceof fNOP && oThis ? this : oThis, aArgs.concat(Array.prototype.slice.call(arguments)));
        };
        fNOP.prototype = this.prototype;
        fBound.prototype = new fNOP();
        return fBound;
    };
}


/***/ }),

/***/ "./PostProcessing/ColorBlindCorrector.ts":
/*!***********************************************!*\
  !*** ./PostProcessing/ColorBlindCorrector.ts ***!
  \***********************************************/
/*! exports provided: ColorBlindness, ColorBlindCorrector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColorBlindness", function() { return ColorBlindness; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ColorBlindCorrector", function() { return ColorBlindCorrector; });
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Util/Log */ "./Util/Log.ts");

var ColorBlindness;
(function (ColorBlindness) {
    ColorBlindness[ColorBlindness["Protanope"] = 0] = "Protanope";
    ColorBlindness[ColorBlindness["Deuteranope"] = 1] = "Deuteranope";
    ColorBlindness[ColorBlindness["Tritanope"] = 2] = "Tritanope";
})(ColorBlindness || (ColorBlindness = {}));
/**
 * This post processor can correct colors and simulate color blindness.
 * It is possible to use this on every game, but the game's performance
 * will suffer measurably. It's better to use it as a helpful tool while developing your game.
 * Remember, the best practice is to design with color blindness in mind.
 *
 * [[include:ColorBlind.md]]
 */
var ColorBlindCorrector = /** @class */ (function () {
    function ColorBlindCorrector(engine, simulate, colorMode) {
        if (simulate === void 0) { simulate = false; }
        if (colorMode === void 0) { colorMode = ColorBlindness.Protanope; }
        this.engine = engine;
        this.simulate = simulate;
        this.colorMode = colorMode;
        this._vertexShader = 'attribute vec2 a_position;' +
            'attribute vec2 a_texCoord;' +
            'uniform vec2 u_resolution;' +
            'varying vec2 v_texCoord;' +
            'void main() {' +
            // convert the rectangle from pixels to 0.0 to 1.0
            'vec2 zeroToOne = a_position / u_resolution;' +
            // convert from 0->1 to 0->2
            'vec2 zeroToTwo = zeroToOne * 2.0;' +
            // convert from 0->2 to -1->+1 (clipspace)
            'vec2 clipSpace = zeroToTwo - 1.0;' +
            'gl_Position = vec4(clipSpace * vec2(1, -1), 0, 1);' +
            // pass the texCoord to the fragment shader
            // The GPU will interpolate this value between points.
            'v_texCoord = a_texCoord;' +
            '}';
        this._fragmentShader = 'precision mediump float;' +
            // our texture
            'uniform sampler2D u_image;' +
            // the texCoords passed in from the vertex shader.
            'varying vec2 v_texCoord;' +
            // Color blind conversions
            /*'mat3 m[9] =' +
           '{' +
              'mat3(1.0, 0.0, 0.0,  0.0, 1.0, 0.0,  0.0, 0.0, 1.0  ),' + // normal
              'mat3(0.567, 0.433, 0.0,  0.558, 0.442, 0.0,  0.0, 0.242, 0.758),' + // protanopia
              'mat3(0.817, 0.183, 0.0,  0.333, 0.667, 0.0,  0.0, 0.125,0.875),' + // protanomaly
              'mat3(0.625, 0.375, 0.0,  0.7, 0.3, 0.0,  0.0, 0.3,0.7  ),' + // deuteranopia
              'mat3(0.8, 0.2, 0.0,  0.258, 0.742, 0.0,  0.0, 0.142,0.858),' + // deuteranomaly
              'mat3(0.95, 0.05, 0.0,  0.0, 0.433, 0.567,  0.0, 0.475,0.525),' + // tritanopia
              'mat3(0.967, 0.033, 0.0,  0.0, 0.733, 0.267,  0.0, 0.183,0.817),' + // tritanomaly
              'mat3(0.299, 0.587, 0.114,  0.299, 0.587, 0.114,  0.299, 0.587,0.114),' + // achromatopsia
              'mat3(0.618, 0.320, 0.062,  0.163, 0.775, 0.062,  0.163, 0.320,0.516)' +  // achromatomaly
           '};' +*/
            'void main() {' +
            'vec4 o =  texture2D(u_image, v_texCoord);' +
            // RGB to LMS matrix conversion
            'float L = (17.8824 * o.r) + (43.5161 * o.g) + (4.11935 * o.b);' +
            'float M = (3.45565 * o.r) + (27.1554 * o.g) + (3.86714 * o.b);' +
            'float S = (0.0299566 * o.r) + (0.184309 * o.g) + (1.46709 * o.b);' +
            // Simulate color blindness
            '//MODE CODE//' +
            /* Deuteranope for testing
              'float l = 1.0 * L + 0.0 * M + 0.0 * S;' +
                    'float m = 0.494207 * L + 0.0 * M + 1.24827 * S;' +
                    'float s = 0.0 * L + 0.0 * M + 1.0 * S;' +*/
            // LMS to RGB matrix conversion
            'vec4 error;' +
            'error.r = (0.0809444479 * l) + (-0.130504409 * m) + (0.116721066 * s);' +
            'error.g = (-0.0102485335 * l) + (0.0540193266 * m) + (-0.113614708 * s);' +
            'error.b = (-0.000365296938 * l) + (-0.00412161469 * m) + (0.693511405 * s);' +
            'error.a = 1.0;' +
            'vec4 diff = o - error;' +
            'vec4 correction;' +
            'correction.r = 0.0;' +
            'correction.g =  (diff.r * 0.7) + (diff.g * 1.0);' +
            'correction.b =  (diff.r * 0.7) + (diff.b * 1.0);' +
            'correction = o + correction;' +
            'correction.a = o.a;' +
            '//SIMULATE//' +
            '}';
        this._internalCanvas = document.createElement('canvas');
        this._internalCanvas.width = engine.drawWidth;
        this._internalCanvas.height = engine.drawHeight;
        this._gl = this._internalCanvas.getContext('webgl', { preserveDrawingBuffer: true });
        this._program = this._gl.createProgram();
        var fragmentShader = this._getShader('Fragment', this._getFragmentShaderByMode(colorMode));
        var vertextShader = this._getShader('Vertex', this._vertexShader);
        this._gl.attachShader(this._program, vertextShader);
        this._gl.attachShader(this._program, fragmentShader);
        this._gl.linkProgram(this._program);
        if (!this._gl.getProgramParameter(this._program, this._gl.LINK_STATUS)) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_0__["Logger"].getInstance().error('Unable to link shader program!');
        }
        this._gl.useProgram(this._program);
    }
    ColorBlindCorrector.prototype._getFragmentShaderByMode = function (colorMode) {
        var code = '';
        if (colorMode === ColorBlindness.Protanope) {
            code =
                'float l = 0.0 * L + 2.02344 * M + -2.52581 * S;' +
                    'float m = 0.0 * L + 1.0 * M + 0.0 * S;' +
                    'float s = 0.0 * L + 0.0 * M + 1.0 * S;';
        }
        else if (colorMode === ColorBlindness.Deuteranope) {
            code =
                'float l = 1.0 * L + 0.0 * M + 0.0 * S;' +
                    'float m = 0.494207 * L + 0.0 * M + 1.24827 * S;' +
                    'float s = 0.0 * L + 0.0 * M + 1.0 * S;';
        }
        else if (colorMode === ColorBlindness.Tritanope) {
            code =
                'float l = 1.0 * L + 0.0 * M + 0.0 * S;' +
                    'float m = 0.0 * L + 1.0 * M + 0.0 * S;' +
                    'float s = -0.395913 * L + 0.801109 * M + 0.0 * S;';
        }
        if (this.simulate) {
            this._fragmentShader = this._fragmentShader.replace('//SIMULATE//', 'gl_FragColor = error.rgba;');
        }
        else {
            this._fragmentShader = this._fragmentShader.replace('//SIMULATE//', 'gl_FragColor = correction.rgba;');
        }
        return this._fragmentShader.replace('//MODE CODE//', code);
    };
    ColorBlindCorrector.prototype._setRectangle = function (x, y, width, height) {
        var x1 = x;
        var x2 = x + width;
        var y1 = y;
        var y2 = y + height;
        this._gl.bufferData(this._gl.ARRAY_BUFFER, new Float32Array([x1, y1, x2, y1, x1, y2, x1, y2, x2, y1, x2, y2]), this._gl.STATIC_DRAW);
    };
    ColorBlindCorrector.prototype._getShader = function (type, program) {
        var shader;
        if (type === 'Fragment') {
            shader = this._gl.createShader(this._gl.FRAGMENT_SHADER);
        }
        else if (type === 'Vertex') {
            shader = this._gl.createShader(this._gl.VERTEX_SHADER);
        }
        else {
            _Util_Log__WEBPACK_IMPORTED_MODULE_0__["Logger"].getInstance().error('Error unknown shader type', type);
        }
        this._gl.shaderSource(shader, program);
        this._gl.compileShader(shader);
        if (!this._gl.getShaderParameter(shader, this._gl.COMPILE_STATUS)) {
            _Util_Log__WEBPACK_IMPORTED_MODULE_0__["Logger"].getInstance().error('Unable to compile shader!', this._gl.getShaderInfoLog(shader));
            return null;
        }
        return shader;
    };
    ColorBlindCorrector.prototype.process = function (image, out) {
        // look up where the vertex data needs to go.
        var positionLocation = this._gl.getAttribLocation(this._program, 'a_position');
        var texCoordLocation = this._gl.getAttribLocation(this._program, 'a_texCoord');
        var texCoordBuffer = this._gl.createBuffer();
        this._gl.bindBuffer(this._gl.ARRAY_BUFFER, texCoordBuffer);
        this._gl.bufferData(this._gl.ARRAY_BUFFER, new Float32Array([0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 1.0, 1.0]), this._gl.STATIC_DRAW);
        this._gl.enableVertexAttribArray(texCoordLocation);
        this._gl.vertexAttribPointer(texCoordLocation, 2, this._gl.FLOAT, false, 0, 0);
        // Create a texture.
        var texture = this._gl.createTexture();
        this._gl.bindTexture(this._gl.TEXTURE_2D, texture);
        // Set the parameters so we can render any size image.
        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_S, this._gl.CLAMP_TO_EDGE);
        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_WRAP_T, this._gl.CLAMP_TO_EDGE);
        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MIN_FILTER, this._gl.NEAREST);
        this._gl.texParameteri(this._gl.TEXTURE_2D, this._gl.TEXTURE_MAG_FILTER, this._gl.NEAREST);
        // Flip the texture when unpacking into the gl context, gl reads textures in the opposite order as everything else :/
        this._gl.pixelStorei(this._gl.UNPACK_FLIP_Y_WEBGL, 1);
        // Upload the image into the texture.
        this._gl.texImage2D(this._gl.TEXTURE_2D, 0, this._gl.RGBA, this._gl.RGBA, this._gl.UNSIGNED_BYTE, image);
        // lookup uniforms
        var resolutionLocation = this._gl.getUniformLocation(this._program, 'u_resolution');
        // set the resolution
        this._gl.uniform2f(resolutionLocation, this._internalCanvas.width, this._internalCanvas.height);
        // Create a buffer for the position of the rectangle corners.
        var positionBuffer = this._gl.createBuffer();
        this._gl.bindBuffer(this._gl.ARRAY_BUFFER, positionBuffer);
        this._gl.enableVertexAttribArray(positionLocation);
        this._gl.vertexAttribPointer(positionLocation, 2, this._gl.FLOAT, false, 0, 0);
        // Set a rectangle the same size as the image.
        this._setRectangle(0, 0, image.width, image.height);
        // Draw the rectangle.
        this._gl.drawArrays(this._gl.TRIANGLES, 0, 6);
        // Grab tranformed image from internal canvas
        var pixelData = new Uint8Array(image.width * image.height * 4);
        this._gl.readPixels(0, 0, image.width, image.height, this._gl.RGBA, this._gl.UNSIGNED_BYTE, pixelData);
        image.data.set(pixelData);
        out.putImageData(image, 0, 0);
    };
    return ColorBlindCorrector;
}());



/***/ }),

/***/ "./PostProcessing/Index.ts":
/*!*********************************!*\
  !*** ./PostProcessing/Index.ts ***!
  \*********************************/
/*! exports provided: ColorBlindness, ColorBlindCorrector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ColorBlindCorrector__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ColorBlindCorrector */ "./PostProcessing/ColorBlindCorrector.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ColorBlindness", function() { return _ColorBlindCorrector__WEBPACK_IMPORTED_MODULE_0__["ColorBlindness"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ColorBlindCorrector", function() { return _ColorBlindCorrector__WEBPACK_IMPORTED_MODULE_0__["ColorBlindCorrector"]; });




/***/ }),

/***/ "./Promises.ts":
/*!*********************!*\
  !*** ./Promises.ts ***!
  \*********************/
/*! exports provided: PromiseState, Promise */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PromiseState", function() { return PromiseState; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Promise", function() { return Promise; });
// Promises/A+ Spec http://promises-aplus.github.io/promises-spec/
/**
 * Valid states for a promise to be in
 */
var PromiseState;
(function (PromiseState) {
    PromiseState[PromiseState["Resolved"] = 0] = "Resolved";
    PromiseState[PromiseState["Rejected"] = 1] = "Rejected";
    PromiseState[PromiseState["Pending"] = 2] = "Pending";
})(PromiseState || (PromiseState = {}));
/**
 * Promises are used to do asynchronous work and they are useful for
 * creating a chain of actions. In Excalibur they are used for loading,
 * sounds, animation, actions, and more.
 *
 * [[include:Promises.md]]
 */
var Promise = /** @class */ (function () {
    function Promise() {
        this._state = PromiseState.Pending;
        this._successCallbacks = [];
        this._rejectCallback = function () {
            return;
        };
    }
    /**
     * Create and resolve a Promise with an optional value
     * @param value  An optional value to wrap in a resolved promise
     */
    Promise.resolve = function (value) {
        var promise = new Promise().resolve(value);
        return promise;
    };
    /**
     * Create and reject a Promise with an optional value
     * @param value  An optional value to wrap in a rejected promise
     */
    Promise.reject = function (value) {
        var promise = new Promise().reject(value);
        return promise;
    };
    Promise.join = function () {
        var promises = [];
        if (arguments.length > 0 && !Array.isArray(arguments[0])) {
            for (var _i = 0; _i < arguments.length; _i++) {
                promises[_i - 0] = arguments[_i];
            }
        }
        else if (arguments.length === 1 && Array.isArray(arguments[0])) {
            promises = arguments[0];
        }
        var joinedPromise = new Promise();
        if (!promises || !promises.length) {
            return joinedPromise.resolve();
        }
        var total = promises.length;
        var successes = 0;
        var rejects = 0;
        var errors = [];
        promises.forEach(function (p) {
            p.then(function () {
                successes += 1;
                if (successes === total) {
                    joinedPromise.resolve();
                }
                else if (successes + rejects + errors.length === total) {
                    joinedPromise.reject(errors);
                }
            }, function () {
                rejects += 1;
                if (successes + rejects + errors.length === total) {
                    joinedPromise.reject(errors);
                }
            }).error(function (e) {
                errors.push(e);
                if (errors.length + successes + rejects === total) {
                    joinedPromise.reject(errors);
                }
            });
        });
        return joinedPromise;
    };
    /**
     * Chain success and reject callbacks after the promise is resolved
     * @param successCallback  Call on resolution of promise
     * @param rejectCallback   Call on rejection of promise
     */
    Promise.prototype.then = function (successCallback, rejectCallback) {
        if (successCallback) {
            this._successCallbacks.push(successCallback);
            // If the promise is already resovled call immediately
            if (this.state() === PromiseState.Resolved) {
                try {
                    successCallback.call(this, this._value);
                }
                catch (e) {
                    this._handleError(e);
                }
            }
        }
        if (rejectCallback) {
            this._rejectCallback = rejectCallback;
            // If the promise is already rejected call immediately
            if (this.state() === PromiseState.Rejected) {
                try {
                    rejectCallback.call(this, this._value);
                }
                catch (e) {
                    this._handleError(e);
                }
            }
        }
        return this;
    };
    /**
     * Add an error callback to the promise
     * @param errorCallback  Call if there was an error in a callback
     */
    Promise.prototype.error = function (errorCallback) {
        if (errorCallback) {
            this._errorCallback = errorCallback;
        }
        return this;
    };
    /**
     * Resolve the promise and pass an option value to the success callbacks
     * @param value  Value to pass to the success callbacks
     */
    Promise.prototype.resolve = function (value) {
        var _this = this;
        if (this._state === PromiseState.Pending) {
            this._value = value;
            try {
                this._state = PromiseState.Resolved;
                this._successCallbacks.forEach(function (cb) {
                    cb.call(_this, _this._value);
                });
            }
            catch (e) {
                this._handleError(e);
            }
        }
        else {
            throw new Error('Cannot resolve a promise that is not in a pending state!');
        }
        return this;
    };
    /**
     * Reject the promise and pass an option value to the reject callbacks
     * @param value  Value to pass to the reject callbacks
     */
    Promise.prototype.reject = function (value) {
        if (this._state === PromiseState.Pending) {
            this._value = value;
            try {
                this._state = PromiseState.Rejected;
                this._rejectCallback.call(this, this._value);
            }
            catch (e) {
                this._handleError(e);
            }
        }
        else {
            throw new Error('Cannot reject a promise that is not in a pending state!');
        }
        return this;
    };
    /**
     * Inspect the current state of a promise
     */
    Promise.prototype.state = function () {
        return this._state;
    };
    Promise.prototype._handleError = function (e) {
        if (this._errorCallback) {
            this._errorCallback.call(this, e);
        }
        else {
            // rethrow error
            throw e;
        }
    };
    return Promise;
}());



/***/ }),

/***/ "./Resources/Index.ts":
/*!****************************!*\
  !*** ./Resources/Index.ts ***!
  \****************************/
/*! exports provided: Resource, Texture, Sound, AudioContextFactory, AudioInstanceFactory, AudioInstance, AudioTagInstance, WebAudioInstance */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Resource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Resource */ "./Resources/Resource.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Resource", function() { return _Resource__WEBPACK_IMPORTED_MODULE_0__["Resource"]; });

/* harmony import */ var _Sound_Index__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Sound/Index */ "./Resources/Sound/Index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Sound", function() { return _Sound_Index__WEBPACK_IMPORTED_MODULE_1__["Sound"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioContextFactory", function() { return _Sound_Index__WEBPACK_IMPORTED_MODULE_1__["AudioContextFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioInstanceFactory", function() { return _Sound_Index__WEBPACK_IMPORTED_MODULE_1__["AudioInstanceFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioInstance", function() { return _Sound_Index__WEBPACK_IMPORTED_MODULE_1__["AudioInstance"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioTagInstance", function() { return _Sound_Index__WEBPACK_IMPORTED_MODULE_1__["AudioTagInstance"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "WebAudioInstance", function() { return _Sound_Index__WEBPACK_IMPORTED_MODULE_1__["WebAudioInstance"]; });

/* harmony import */ var _Texture__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Texture */ "./Resources/Texture.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Texture", function() { return _Texture__WEBPACK_IMPORTED_MODULE_2__["Texture"]; });






/***/ }),

/***/ "./Resources/Resource.ts":
/*!*******************************!*\
  !*** ./Resources/Resource.ts ***!
  \*******************************/
/*! exports provided: Resource */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Resource", function() { return Resource; });
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Class */ "./Class.ts");
/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Promises */ "./Promises.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Util/Log */ "./Util/Log.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



/**
 * The [[Resource]] type allows games built in Excalibur to load generic resources.
 * For any type of remote resource it is recommended to use [[Resource]] for preloading.
 *
 * [[include:Resources.md]]
 */
var Resource = /** @class */ (function (_super) {
    __extends(Resource, _super);
    /**
     * @param path          Path to the remote resource
     * @param responseType  The type to expect as a response: "" | "arraybuffer" | "blob" | "document" | "json" | "text";
     * @param bustCache     Whether or not to cache-bust requests
     */
    function Resource(path, responseType, bustCache) {
        if (bustCache === void 0) { bustCache = true; }
        var _this = _super.call(this) || this;
        _this.path = path;
        _this.responseType = responseType;
        _this.bustCache = bustCache;
        _this.data = null;
        _this.logger = _Util_Log__WEBPACK_IMPORTED_MODULE_2__["Logger"].getInstance();
        _this.onprogress = function () {
            return;
        };
        _this.oncomplete = function () {
            return;
        };
        _this.onerror = function () {
            return;
        };
        return _this;
    }
    /**
     * Returns true if the Resource is completely loaded and is ready
     * to be drawn.
     */
    Resource.prototype.isLoaded = function () {
        return this.data !== null;
    };
    Resource.prototype.wireEngine = function (_engine) {
        // override me
    };
    Resource.prototype._cacheBust = function (uri) {
        var query = /\?\w*=\w*/;
        if (query.test(uri)) {
            uri += '&__=' + Date.now();
        }
        else {
            uri += '?__=' + Date.now();
        }
        return uri;
    };
    Resource.prototype._start = function () {
        this.logger.debug('Started loading resource ' + this.path);
    };
    /**
     * Begin loading the resource and returns a promise to be resolved on completion
     */
    Resource.prototype.load = function () {
        var _this = this;
        var complete = new _Promises__WEBPACK_IMPORTED_MODULE_1__["Promise"]();
        // Exit early if we already have data
        if (this.data !== null) {
            this.logger.debug('Already have data for resource', this.path);
            complete.resolve(this.data);
            this.oncomplete();
            return complete;
        }
        var request = new XMLHttpRequest();
        request.open('GET', this.bustCache ? this._cacheBust(this.path) : this.path, true);
        request.responseType = this.responseType;
        request.onloadstart = function () {
            _this._start();
        };
        request.onprogress = this.onprogress;
        request.onerror = this.onerror;
        request.onload = function () {
            // XHR on file:// success status is 0, such as with PhantomJS
            if (request.status !== 0 && request.status !== 200) {
                _this.logger.error('Failed to load resource ', _this.path, ' server responded with error code', request.status);
                _this.onerror(request.response);
                complete.resolve(request.response);
                return;
            }
            _this.data = _this.processData(request.response);
            _this.oncomplete();
            _this.logger.debug('Completed loading resource', _this.path);
            complete.resolve(_this.data);
        };
        request.send();
        return complete;
    };
    /**
     * Returns the loaded data once the resource is loaded
     */
    Resource.prototype.getData = function () {
        return this.data;
    };
    /**
     * Sets the data for this resource directly
     */
    Resource.prototype.setData = function (data) {
        this.data = this.processData(data);
    };
    /**
     * This method is meant to be overriden to handle any additional
     * processing. Such as decoding downloaded audio bits.
     */
    Resource.prototype.processData = function (data) {
        // https://developer.mozilla.org/en-US/docs/Web/API/XMLHttpRequest/responseType
        // Blob requires an object url
        if (this.responseType === 'blob') {
            return URL.createObjectURL(data);
        }
        return data;
    };
    return Resource;
}(_Class__WEBPACK_IMPORTED_MODULE_0__["Class"]));



/***/ }),

/***/ "./Resources/Sound/AudioContext.ts":
/*!*****************************************!*\
  !*** ./Resources/Sound/AudioContext.ts ***!
  \*****************************************/
/*! exports provided: AudioContextFactory */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AudioContextFactory", function() { return AudioContextFactory; });
/**
 * Internal class used to build instances of AudioContext
 */
/* istanbul ignore next */
var AudioContextFactory = /** @class */ (function () {
    function AudioContextFactory() {
    }
    AudioContextFactory.create = function () {
        if (!this._INSTANCE) {
            if (window.AudioContext || window.webkitAudioContext) {
                this._INSTANCE = new window.AudioContext();
            }
        }
        return this._INSTANCE;
    };
    AudioContextFactory._INSTANCE = null;
    return AudioContextFactory;
}());



/***/ }),

/***/ "./Resources/Sound/AudioInstance.ts":
/*!******************************************!*\
  !*** ./Resources/Sound/AudioInstance.ts ***!
  \******************************************/
/*! exports provided: AudioInstanceFactory, AudioInstance, AudioTagInstance, WebAudioInstance */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AudioInstanceFactory", function() { return AudioInstanceFactory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AudioInstance", function() { return AudioInstance; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AudioTagInstance", function() { return AudioTagInstance; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WebAudioInstance", function() { return WebAudioInstance; });
/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Promises */ "./Promises.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../Util/Util */ "./Util/Util.ts");
/* harmony import */ var _AudioContext__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AudioContext */ "./Resources/Sound/AudioContext.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



/**
 * Internal class for producing of AudioInstances
 */
/* istanbul ignore next */
var AudioInstanceFactory = /** @class */ (function () {
    function AudioInstanceFactory() {
    }
    AudioInstanceFactory.create = function (src) {
        if (typeof src === 'string') {
            return new AudioTagInstance(src);
        }
        if (src instanceof AudioBuffer) {
            return new WebAudioInstance(src);
        }
        return new AudioInstance(src);
    };
    return AudioInstanceFactory;
}());

/**
 * Internal class representing base AudioInstance implementation
 */
/* istanbul ignore next */
var AudioInstance = /** @class */ (function () {
    function AudioInstance(_src) {
        this._src = _src;
        this._volume = 1;
        this._loop = false;
        this._isPlaying = false;
        this._isPaused = false;
    }
    Object.defineProperty(AudioInstance.prototype, "loop", {
        get: function () {
            return this._loop;
        },
        set: function (value) {
            this._loop = value;
            if (this._instance) {
                this._instance.loop = value;
                this._wireUpOnEnded();
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(AudioInstance.prototype, "volume", {
        get: function () {
            return this._volume;
        },
        set: function (value) {
            this._volume = _Util_Util__WEBPACK_IMPORTED_MODULE_1__["clamp"](value, 0, 1.0);
        },
        enumerable: true,
        configurable: true
    });
    AudioInstance.prototype.isPlaying = function () {
        return this._isPlaying;
    };
    AudioInstance.prototype.pause = function () {
        if (!this._isPlaying) {
            return;
        }
        this._isPaused = true;
        this._isPlaying = false;
    };
    AudioInstance.prototype.stop = function () {
        if (!this._isPlaying) {
            return;
        }
        this._isPlaying = false;
        this._isPaused = false;
    };
    AudioInstance.prototype.play = function () {
        if (this._isPaused) {
            this._resumePlayBack();
        }
        if (!this._isPlaying) {
            this._startPlayBack();
        }
        return this._playingPromise;
    };
    AudioInstance.prototype._startPlayBack = function () {
        this._isPlaying = true;
        this._isPaused = false;
        this._playingPromise = new _Promises__WEBPACK_IMPORTED_MODULE_0__["Promise"]();
    };
    AudioInstance.prototype._resumePlayBack = function () {
        if (!this._isPaused) {
            return;
        }
        this._isPaused = false;
        this._isPlaying = true;
    };
    AudioInstance.prototype._wireUpOnEnded = function () {
        var _this = this;
        if (!this.loop) {
            this._instance.onended = function () { return _this._handleOnEnded(); };
        }
    };
    AudioInstance.prototype._handleOnEnded = function () {
        /**
         * Override me
         */
    };
    return AudioInstance;
}());

/**
 * Internal class representing a HTML5 audio instance
 */
/* istanbul ignore next */
var AudioTagInstance = /** @class */ (function (_super) {
    __extends(AudioTagInstance, _super);
    function AudioTagInstance(src) {
        var _this = _super.call(this, src) || this;
        _this._instance = new Audio(src);
        return _this;
    }
    Object.defineProperty(AudioTagInstance.prototype, "volume", {
        get: function () {
            return this._volume;
        },
        set: function (value) {
            value = _Util_Util__WEBPACK_IMPORTED_MODULE_1__["clamp"](value, 0, 1.0);
            this._volume = value;
            this._instance.volume = value;
        },
        enumerable: true,
        configurable: true
    });
    AudioTagInstance.prototype.pause = function () {
        if (!this._isPlaying) {
            return;
        }
        this._instance.pause();
        this._isPaused = true;
        this._isPlaying = false;
    };
    AudioTagInstance.prototype.stop = function () {
        _super.prototype.stop.call(this);
        this._instance.pause();
        this._instance.currentTime = 0;
        this._handleOnEnded();
    };
    AudioTagInstance.prototype._startPlayBack = function () {
        _super.prototype._startPlayBack.call(this);
        this._instance.load();
        this._instance.loop = this.loop;
        this._instance.play();
        this._wireUpOnEnded();
    };
    AudioTagInstance.prototype._resumePlayBack = function () {
        _super.prototype._resumePlayBack.call(this);
        this._instance.play();
        this._wireUpOnEnded();
    };
    AudioTagInstance.prototype._handleOnEnded = function () {
        this._isPlaying = false;
        this._isPaused = false;
        this._playingPromise.resolve(true);
    };
    return AudioTagInstance;
}(AudioInstance));

/**
 * Internal class representing a Web Audio AudioBufferSourceNode instance
 * @see https://developer.mozilla.org/en-US/docs/Web/API/Web_Audio_API
 */
/* istanbul ignore next */
var WebAudioInstance = /** @class */ (function (_super) {
    __extends(WebAudioInstance, _super);
    function WebAudioInstance(_src) {
        var _this = _super.call(this, _src) || this;
        _this._audioContext = _AudioContext__WEBPACK_IMPORTED_MODULE_2__["AudioContextFactory"].create();
        _this._volumeNode = _this._audioContext.createGain();
        /**
         * Current playback offset (in seconds)
         */
        _this._currentOffset = 0;
        _this._createNewBufferSource();
        return _this;
    }
    Object.defineProperty(WebAudioInstance.prototype, "volume", {
        get: function () {
            return this._volume;
        },
        set: function (value) {
            value = _Util_Util__WEBPACK_IMPORTED_MODULE_1__["clamp"](value, 0, 1.0);
            this._volume = value;
            if (this._volumeNode.gain.setTargetAtTime) {
                // https://developer.mozilla.org/en-US/docs/Web/API/AudioParam/setTargetAtTime
                // After each .1 seconds timestep, the target value will ~63.2% closer to the target value.
                // This exponential ramp provides a more pleasant trasition in gain
                this._volumeNode.gain.setTargetAtTime(value, this._audioContext.currentTime, 0.1);
            }
            else {
                this._volumeNode.gain.value = value;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(WebAudioInstance.prototype, "_playbackRate", {
        get: function () {
            return this._instance ? 1 / (this._instance.playbackRate.value || 1.0) : null;
        },
        enumerable: true,
        configurable: true
    });
    WebAudioInstance.prototype.pause = function () {
        _super.prototype.pause.call(this);
        this._instance.stop(0);
        // Playback rate will be a scale factor of how fast/slow the audio is being played
        // default is 1.0
        // we need to invert it to get the time scale
        this._setPauseOffset();
    };
    WebAudioInstance.prototype.stop = function () {
        _super.prototype.stop.call(this);
        this._currentOffset = 0;
        this._instance.stop(0);
        // handler will not be wired up if we were looping
        if (!this._instance.onended) {
            this._handleOnEnded();
        }
    };
    WebAudioInstance.prototype._startPlayBack = function () {
        _super.prototype._startPlayBack.call(this);
        if (!this._instance) {
            this._createNewBufferSource();
        }
        this._rememberStartTime();
        this._volumeNode.connect(this._audioContext.destination);
        this._instance.start(0, 0);
        this._currentOffset = 0;
        this._playingPromise = new _Promises__WEBPACK_IMPORTED_MODULE_0__["Promise"]();
        this._wireUpOnEnded();
    };
    WebAudioInstance.prototype._resumePlayBack = function () {
        _super.prototype._resumePlayBack.call(this);
        // a buffer source can only be started once
        // so we need to dispose of the previous instance before
        // "resuming" the next one
        this._instance.onended = null; // dispose of any previous event handler
        this._createNewBufferSource();
        var duration = this._playbackRate * this._src.duration;
        var restartTime = this._currentOffset % duration;
        this._rememberStartTime(restartTime * -1000);
        this._instance.start(0, restartTime);
        this._wireUpOnEnded();
    };
    WebAudioInstance.prototype._handleOnEnded = function () {
        // pausing calls stop(0) which triggers onended event
        // so we don't "resolve" yet (when we resume we'll try again)
        if (!this._isPaused) {
            this._isPlaying = false;
            this._playingPromise.resolve(true);
        }
    };
    WebAudioInstance.prototype._rememberStartTime = function (amend) {
        this._startTime = new Date().getTime() + (amend | 0);
    };
    WebAudioInstance.prototype._setPauseOffset = function () {
        this._currentOffset = ((new Date().getTime() - this._startTime) * this._playbackRate) / 1000; // in seconds
    };
    WebAudioInstance.prototype._createNewBufferSource = function () {
        this._instance = this._audioContext.createBufferSource();
        this._instance.buffer = this._src;
        this._instance.loop = this.loop;
        this._instance.playbackRate.setValueAtTime(1.0, 0);
        this._instance.connect(this._volumeNode);
    };
    return WebAudioInstance;
}(AudioInstance));



/***/ }),

/***/ "./Resources/Sound/Index.ts":
/*!**********************************!*\
  !*** ./Resources/Sound/Index.ts ***!
  \**********************************/
/*! exports provided: Sound, AudioContextFactory, AudioInstanceFactory, AudioInstance, AudioTagInstance, WebAudioInstance */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Sound__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Sound */ "./Resources/Sound/Sound.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Sound", function() { return _Sound__WEBPACK_IMPORTED_MODULE_0__["Sound"]; });

/* harmony import */ var _AudioContext__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AudioContext */ "./Resources/Sound/AudioContext.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioContextFactory", function() { return _AudioContext__WEBPACK_IMPORTED_MODULE_1__["AudioContextFactory"]; });

/* harmony import */ var _AudioInstance__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AudioInstance */ "./Resources/Sound/AudioInstance.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioInstanceFactory", function() { return _AudioInstance__WEBPACK_IMPORTED_MODULE_2__["AudioInstanceFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioInstance", function() { return _AudioInstance__WEBPACK_IMPORTED_MODULE_2__["AudioInstance"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioTagInstance", function() { return _AudioInstance__WEBPACK_IMPORTED_MODULE_2__["AudioTagInstance"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "WebAudioInstance", function() { return _AudioInstance__WEBPACK_IMPORTED_MODULE_2__["WebAudioInstance"]; });






/***/ }),

/***/ "./Resources/Sound/Sound.ts":
/*!**********************************!*\
  !*** ./Resources/Sound/Sound.ts ***!
  \**********************************/
/*! exports provided: Sound */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Sound", function() { return Sound; });
/* harmony import */ var _Interfaces_IAudioImplementation__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../Interfaces/IAudioImplementation */ "./Interfaces/IAudioImplementation.ts");
/* harmony import */ var _Resource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Resource */ "./Resources/Resource.ts");
/* harmony import */ var _AudioInstance__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./AudioInstance */ "./Resources/Sound/AudioInstance.ts");
/* harmony import */ var _AudioContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./AudioContext */ "./Resources/Sound/AudioContext.ts");
/* harmony import */ var _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../Events/MediaEvents */ "./Events/MediaEvents.ts");
/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../Promises */ "./Promises.ts");
/* harmony import */ var _Util_Sound__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../Util/Sound */ "./Util/Sound.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();







/**
 * The [[Sound]] object allows games built in Excalibur to load audio
 * components, from soundtracks to sound effects. [[Sound]] is an [[ILoadable]]
 * which means it can be passed to a [[Loader]] to pre-load before a game or level.
 *
 * [[include:Sounds.md]]
 */
var Sound = /** @class */ (function (_super) {
    __extends(Sound, _super);
    /**
     * @param paths A list of audio sources (clip.wav, clip.mp3, clip.ogg) for this audio clip. This is done for browser compatibility.
     */
    function Sound() {
        var paths = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            paths[_i] = arguments[_i];
        }
        var _this = _super.call(this, '', '') || this;
        _this._loop = false;
        _this._volume = 1;
        _this._isPaused = false;
        _this._tracks = [];
        _this._wasPlayingOnHidden = false;
        _this._processedData = new _Promises__WEBPACK_IMPORTED_MODULE_5__["Promise"]();
        _this._audioContext = _AudioContext__WEBPACK_IMPORTED_MODULE_3__["AudioContextFactory"].create();
        _this._detectResponseType();
        /* Chrome : MP3, WAV, Ogg
             * Firefox : WAV, Ogg,
             * IE : MP3, WAV coming soon
             * Safari MP3, WAV, Ogg
             */
        for (var _a = 0, paths_1 = paths; _a < paths_1.length; _a++) {
            var path = paths_1[_a];
            if (Object(_Util_Sound__WEBPACK_IMPORTED_MODULE_6__["canPlayFile"])(path)) {
                _this.path = path;
                break;
            }
        }
        if (!_this.path) {
            _this.logger.warn('This browser does not support any of the audio files specified:', paths.join(', '));
            _this.logger.warn('Attempting to use', paths[0]);
            _this.path = paths[0]; // select the first specified
        }
        return _this;
    }
    Object.defineProperty(Sound.prototype, "loop", {
        get: function () {
            return this._loop;
        },
        /**
         * Indicates whether the clip should loop when complete
         * @param value  Set the looping flag
         */
        set: function (value) {
            this._loop = value;
            for (var _i = 0, _a = this._tracks; _i < _a.length; _i++) {
                var track = _a[_i];
                track.loop = this._loop;
            }
            this.logger.debug('Set loop for all instances of sound', this.path, 'to', this._loop);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Sound.prototype, "volume", {
        get: function () {
            return this._volume;
        },
        set: function (value) {
            this._volume = value;
            for (var _i = 0, _a = this._tracks; _i < _a.length; _i++) {
                var track = _a[_i];
                track.volume = this._volume;
            }
            this.emit('volumechange', new _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_4__["NativeSoundEvent"](this));
            this.logger.debug('Set loop for all instances of sound', this.path, 'to', this._volume);
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Sound.prototype, "instances", {
        /**
         * Return array of Current AudioInstances playing or being paused
         */
        get: function () {
            return this._tracks;
        },
        enumerable: true,
        configurable: true
    });
    Sound.prototype.wireEngine = function (engine) {
        var _this = this;
        if (engine) {
            this._engine = engine;
            this._engine.on('hidden', function () {
                if (engine.pauseAudioWhenHidden && _this.isPlaying()) {
                    _this._wasPlayingOnHidden = true;
                    _this.pause();
                }
            });
            this._engine.on('visible', function () {
                if (engine.pauseAudioWhenHidden && _this._wasPlayingOnHidden) {
                    _this.play();
                    _this._wasPlayingOnHidden = false;
                }
            });
        }
    };
    /**
     * Returns how many instances of the sound are currently playing
     */
    Sound.prototype.instanceCount = function () {
        return this._tracks.length;
    };
    /**
     * Whether or not the sound is playing right now
     */
    Sound.prototype.isPlaying = function () {
        return this._tracks.some(function (t) { return t.isPlaying(); });
    };
    /**
     * Play the sound, returns a promise that resolves when the sound is done playing
     * An optional volume argument can be passed in to play the sound. Max volume is 1.0
     */
    Sound.prototype.play = function (volume) {
        if (!this.isLoaded()) {
            this.logger.warn('Cannot start playing. Resource', this.path, 'is not loaded yet');
            return _Promises__WEBPACK_IMPORTED_MODULE_5__["Promise"].resolve(true);
        }
        this.volume = volume || this.volume;
        if (this._isPaused) {
            return this._resumePlayback();
        }
        else {
            return this._startPlayback();
        }
    };
    /**
     * Stop the sound, and do not rewind
     */
    Sound.prototype.pause = function () {
        if (!this.isPlaying()) {
            return;
        }
        for (var _i = 0, _a = this._tracks; _i < _a.length; _i++) {
            var track = _a[_i];
            track.pause();
        }
        this._isPaused = true;
        this.emit('pause', new _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_4__["NativeSoundEvent"](this));
        this.logger.debug('Paused all instances of sound', this.path);
    };
    /**
     * Stop the sound and rewind
     */
    Sound.prototype.stop = function () {
        if (!this.isPlaying()) {
            return;
        }
        for (var _i = 0, _a = this._tracks; _i < _a.length; _i++) {
            var track = _a[_i];
            track.stop();
        }
        this.emit('stop', new _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_4__["NativeSoundEvent"](this));
        this._isPaused = false;
        this._tracks.length = 0;
        this.logger.debug('Stopped all instances of sound', this.path);
    };
    Sound.prototype.setData = function (data) {
        this.emit('emptied', new _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_4__["NativeSoundEvent"](this));
        this.data = data;
        this._processedData = new _Promises__WEBPACK_IMPORTED_MODULE_5__["Promise"]();
    };
    Sound.prototype.processData = function (data) {
        var _this = this;
        /**
         * Processes raw arraybuffer data and decodes into WebAudio buffer (async).
         */
        var processPromise = data instanceof ArrayBuffer ? this._processArrayBufferData(data) : this._processBlobData(data);
        return processPromise.then(function (processedData) { return _this._setProcessedData(processedData); });
    };
    /**
     * Get Id of provided AudioInstance in current trackList
     * @param track [[AudioInstance]] which Id is to be given
     */
    Sound.prototype.getTrackId = function (track) {
        return this._tracks.indexOf(track);
    };
    Sound.prototype._resumePlayback = function () {
        if (this._isPaused) {
            var resumed = [];
            // ensure we resume *current* tracks (if paused)
            for (var _i = 0, _a = this._tracks; _i < _a.length; _i++) {
                var track = _a[_i];
                resumed.push(track.play());
            }
            this._isPaused = false;
            this.emit('resume', new _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_4__["NativeSoundEvent"](this));
            this.logger.debug('Resuming paused instances for sound', this.path, this._tracks);
            // resolve when resumed tracks are done
            return _Promises__WEBPACK_IMPORTED_MODULE_5__["Promise"].join(resumed);
        }
        else {
            return _Promises__WEBPACK_IMPORTED_MODULE_5__["Promise"].resolve(true);
        }
    };
    Sound.prototype._startPlayback = function () {
        var _this = this;
        var newTrack = this._createNewTrack();
        var playPromise = new _Promises__WEBPACK_IMPORTED_MODULE_5__["Promise"]();
        newTrack.then(function (track) {
            track.play().then(function (resolved) {
                // when done, remove track
                _this.emit('playbackend', new _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_4__["NativeSoundEvent"](_this, track));
                _this._tracks.splice(_this.getTrackId(track), 1);
                playPromise.resolve(resolved);
                return resolved;
            });
            _this.emit('playbackstart', new _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_4__["NativeSoundEvent"](_this, track));
            _this.logger.debug('Playing new instance for sound', _this.path);
        });
        return playPromise;
    };
    Sound.prototype._processArrayBufferData = function (data) {
        var _this = this;
        var complete = new _Promises__WEBPACK_IMPORTED_MODULE_5__["Promise"]();
        this._audioContext.decodeAudioData(data, function (buffer) {
            complete.resolve(buffer);
        }, function () {
            _this.logger.error('Unable to decode ' +
                ' this browser may not fully support this format, or the file may be corrupt, ' +
                'if this is an mp3 try removing id3 tags and album art from the file.');
            complete.resolve(undefined);
        });
        return complete;
    };
    Sound.prototype._processBlobData = function (data) {
        return new _Promises__WEBPACK_IMPORTED_MODULE_5__["Promise"]().resolve(_super.prototype.processData.call(this, data));
    };
    Sound.prototype._setProcessedData = function (processedData) {
        this._processedData.resolve(processedData);
    };
    Sound.prototype._createNewTrack = function () {
        var _this = this;
        var aiPromise = new _Promises__WEBPACK_IMPORTED_MODULE_5__["Promise"]();
        if (this._processedData.state() !== 0) {
            this.processData(this.data);
        }
        this._processedData.then(function (processedData) {
            aiPromise.resolve(_this._getTrackInstance(processedData));
            return processedData;
        }, function (error) {
            _this.logger.error(error, 'Cannot create AudioInstance due to wrong processed data.');
        });
        return aiPromise;
    };
    Sound.prototype._getTrackInstance = function (data) {
        var newTrack = _AudioInstance__WEBPACK_IMPORTED_MODULE_2__["AudioInstanceFactory"].create(data);
        newTrack.loop = this.loop;
        newTrack.volume = this.volume;
        this._tracks.push(newTrack);
        return newTrack;
    };
    Sound.prototype._detectResponseType = function () {
        if (window.AudioContext) {
            this.responseType = _Interfaces_IAudioImplementation__WEBPACK_IMPORTED_MODULE_0__["ExResponse"].type.arraybuffer;
        }
        else {
            this.responseType = _Interfaces_IAudioImplementation__WEBPACK_IMPORTED_MODULE_0__["ExResponse"].type.blob;
        }
    };
    return Sound;
}(_Resource__WEBPACK_IMPORTED_MODULE_1__["Resource"]));



/***/ }),

/***/ "./Resources/Texture.ts":
/*!******************************!*\
  !*** ./Resources/Texture.ts ***!
  \******************************/
/*! exports provided: Texture */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Texture", function() { return Texture; });
/* harmony import */ var _Resource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Resource */ "./Resources/Resource.ts");
/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Promises */ "./Promises.ts");
/* harmony import */ var _Drawing_Sprite__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Drawing/Sprite */ "./Drawing/Sprite.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



/**
 * The [[Texture]] object allows games built in Excalibur to load image resources.
 * [[Texture]] is an [[ILoadable]] which means it can be passed to a [[Loader]]
 * to pre-load before starting a level or game.
 *
 * [[include:Textures.md]]
 */
var Texture = /** @class */ (function (_super) {
    __extends(Texture, _super);
    /**
     * @param path       Path to the image resource
     * @param bustCache  Optionally load texture with cache busting
     */
    function Texture(path, bustCache) {
        if (bustCache === void 0) { bustCache = true; }
        var _this = _super.call(this, path, 'blob', bustCache) || this;
        _this.path = path;
        _this.bustCache = bustCache;
        /**
         * A [[Promise]] that resolves when the Texture is loaded.
         */
        _this.loaded = new _Promises__WEBPACK_IMPORTED_MODULE_1__["Promise"]();
        _this._isLoaded = false;
        _this._sprite = null;
        _this._sprite = new _Drawing_Sprite__WEBPACK_IMPORTED_MODULE_2__["Sprite"](_this, 0, 0, 0, 0);
        return _this;
    }
    /**
     * Returns true if the Texture is completely loaded and is ready
     * to be drawn.
     */
    Texture.prototype.isLoaded = function () {
        return this._isLoaded;
    };
    /**
     * Begins loading the texture and returns a promise to be resolved on completion
     */
    Texture.prototype.load = function () {
        var _this = this;
        var complete = new _Promises__WEBPACK_IMPORTED_MODULE_1__["Promise"]();
        var loaded = _super.prototype.load.call(this);
        loaded.then(function () {
            _this.image = new Image();
            _this.image.addEventListener('load', function () {
                _this._isLoaded = true;
                _this.width = _this._sprite.width = _this.image.naturalWidth;
                _this.height = _this._sprite.height = _this.image.naturalHeight;
                _this.loaded.resolve(_this.image);
                complete.resolve(_this.image);
            });
            _this.image.src = _super.prototype.getData.call(_this);
        }, function () {
            complete.reject('Error loading texture.');
        });
        return complete;
    };
    Texture.prototype.asSprite = function () {
        return this._sprite;
    };
    return Texture;
}(_Resource__WEBPACK_IMPORTED_MODULE_0__["Resource"]));



/***/ }),

/***/ "./Scene.ts":
/*!******************!*\
  !*** ./Scene.ts ***!
  \******************/
/*! exports provided: Scene */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Scene", function() { return Scene; });
/* harmony import */ var _UIActor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./UIActor */ "./UIActor.ts");
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Physics */ "./Physics.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Timer__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Timer */ "./Timer.ts");
/* harmony import */ var _Collision_DynamicTreeCollisionBroadphase__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Collision/DynamicTreeCollisionBroadphase */ "./Collision/DynamicTreeCollisionBroadphase.ts");
/* harmony import */ var _Util_SortedList__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Util/SortedList */ "./Util/SortedList.ts");
/* harmony import */ var _Group__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./Group */ "./Group.ts");
/* harmony import */ var _TileMap__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./TileMap */ "./TileMap.ts");
/* harmony import */ var _Camera__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Camera */ "./Camera.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Actor */ "./Actor.ts");
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Class */ "./Class.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Util/Util */ "./Util/Util.ts");
/* harmony import */ var _Util_Actors__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Util/Actors */ "./Util/Actors.ts");
/* harmony import */ var _Trigger__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Trigger */ "./Trigger.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();















/**
 * [[Actor|Actors]] are composed together into groupings called Scenes in
 * Excalibur. The metaphor models the same idea behind real world
 * actors in a scene. Only actors in scenes will be updated and drawn.
 *
 * Typical usages of a scene include: levels, menus, loading screens, etc.
 *
 * [[include:Scenes.md]]
 */
var Scene = /** @class */ (function (_super) {
    __extends(Scene, _super);
    function Scene(engine) {
        var _this = _super.call(this) || this;
        /**
         * The actors in the current scene
         */
        _this.actors = [];
        /**
         * The triggers in the current scene
         */
        _this.triggers = [];
        /**
         * The [[TileMap]]s in the scene, if any
         */
        _this.tileMaps = [];
        /**
         * The [[Group]]s in the scene, if any
         */
        _this.groups = {};
        /**
         * The [[UIActor]]s in a scene, if any; these are drawn last
         */
        _this.uiActors = [];
        _this._isInitialized = false;
        _this._sortedDrawingTree = new _Util_SortedList__WEBPACK_IMPORTED_MODULE_6__["SortedList"](_Actor__WEBPACK_IMPORTED_MODULE_10__["Actor"].prototype.getZIndex);
        _this._broadphase = new _Collision_DynamicTreeCollisionBroadphase__WEBPACK_IMPORTED_MODULE_5__["DynamicTreeCollisionBroadphase"]();
        _this._killQueue = [];
        _this._triggerKillQueue = [];
        _this._timers = [];
        _this._cancelQueue = [];
        _this._logger = _Util_Log__WEBPACK_IMPORTED_MODULE_3__["Logger"].getInstance();
        _this.camera = new _Camera__WEBPACK_IMPORTED_MODULE_9__["BaseCamera"]();
        if (engine) {
            _this.camera.x = engine.halfDrawWidth;
            _this.camera.y = engine.halfDrawHeight;
        }
        return _this;
    }
    Scene.prototype.on = function (eventName, handler) {
        _super.prototype.on.call(this, eventName, handler);
    };
    Scene.prototype.once = function (eventName, handler) {
        _super.prototype.once.call(this, eventName, handler);
    };
    Scene.prototype.off = function (eventName, handler) {
        _super.prototype.off.call(this, eventName, handler);
    };
    /**
     * This is called before the first update of the [[Scene]]. Initializes scene members like the camera. This method is meant to be
     * overridden. This is where initialization of child actors should take place.
     */
    Scene.prototype.onInitialize = function (_engine) {
        // will be overridden
    };
    /**
     * This is called when the scene is made active and started. It is meant to be overriden,
     * this is where you should setup any DOM UI or event handlers needed for the scene.
     */
    Scene.prototype.onActivate = function (_oldScene, _newScene) {
        // will be overridden
    };
    /**
     * This is called when the scene is made transitioned away from and stopped. It is meant to be overriden,
     * this is where you should cleanup any DOM UI or event handlers needed for the scene.
     */
    Scene.prototype.onDeactivate = function (_oldScene, _newScene) {
        // will be overridden
    };
    /**
     * Safe to override onPreUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPreUpdate` is called directly before a scene is updated.
     */
    Scene.prototype.onPreUpdate = function (_engine, _delta) {
        // will be overridden
    };
    /**
     * Safe to override onPostUpdate lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPostUpdate` is called directly after a scene is updated.
     */
    Scene.prototype.onPostUpdate = function (_engine, _delta) {
        // will be overridden
    };
    /**
     * Safe to override onPreDraw lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPreDraw` is called directly before a scene is drawn.
     */
    Scene.prototype.onPreDraw = function (_ctx, _delta) {
        // will be overridden
    };
    /**
     * Safe to override onPostDraw lifecycle event handler. Synonymous with `.on('preupdate', (evt) =>{...})`
     *
     * `onPostDraw` is called directly after a scene is drawn.
     */
    Scene.prototype.onPostDraw = function (_ctx, _delta) {
        // will be overridden
    };
    /**
     * Initializes actors in the scene
     */
    Scene.prototype._initializeChildren = function () {
        for (var _i = 0, _a = this.actors; _i < _a.length; _i++) {
            var child = _a[_i];
            child._initialize(this.engine);
        }
    };
    Object.defineProperty(Scene.prototype, "isInitialized", {
        /**
         * Gets whether or not the [[Scene]] has been initialized
         */
        get: function () {
            return this._isInitialized;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Initializes the scene before the first update, meant to be called by engine not by users of
     * Excalibur
     * @internal
     */
    Scene.prototype._initialize = function (engine) {
        if (!this.isInitialized) {
            if (this.camera) {
                this.camera.x = engine.halfDrawWidth;
                this.camera.y = engine.halfDrawHeight;
            }
            this._initializeChildren();
            this._logger.debug('Scene.onInitialize', this, engine);
            this.eventDispatcher.emit('initialize', new _Events__WEBPACK_IMPORTED_MODULE_2__["InitializeEvent"](engine, this));
            this.onInitialize.call(this, engine);
            this._isInitialized = true;
        }
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Activates the scene with the base behavior, then calls the overridable `onActivate` implementation.
     * @internal
     */
    Scene.prototype._activate = function (oldScene, newScene) {
        this._logger.debug('Scene.onActivate', this);
        this.onActivate(oldScene, newScene);
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Deactivates the scene with the base behavior, then calls the overridable `onDeactivate` implementation.
     * @internal
     */
    Scene.prototype._deactivate = function (oldScene, newScene) {
        this._logger.debug('Scene.onDectivate', this);
        this.onDeactivate(oldScene, newScene);
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _preupdate handler for [[onPreUpdate]] lifecycle event
     * @internal
     */
    Scene.prototype._preupdate = function (_engine, delta) {
        this.emit('preupdate', new _Events__WEBPACK_IMPORTED_MODULE_2__["PreUpdateEvent"](_engine, delta, this));
        this.onPreUpdate(_engine, delta);
    };
    /**
     *  It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _preupdate handler for [[onPostUpdate]] lifecycle event
     * @internal
     */
    Scene.prototype._postupdate = function (_engine, delta) {
        this.emit('postupdate', new _Events__WEBPACK_IMPORTED_MODULE_2__["PostUpdateEvent"](_engine, delta, this));
        this.onPostUpdate(_engine, delta);
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _predraw handler for [[onPreDraw]] lifecycle event
     *
     * @internal
     */
    Scene.prototype._predraw = function (_ctx, _delta) {
        this.emit('predraw', new _Events__WEBPACK_IMPORTED_MODULE_2__["PreDrawEvent"](_ctx, _delta, this));
        this.onPreDraw(_ctx, _delta);
    };
    /**
     * It is not recommended that internal excalibur methods be overriden, do so at your own risk.
     *
     * Internal _postdraw handler for [[onPostDraw]] lifecycle event
     *
     * @internal
     */
    Scene.prototype._postdraw = function (_ctx, _delta) {
        this.emit('postdraw', new _Events__WEBPACK_IMPORTED_MODULE_2__["PostDrawEvent"](_ctx, _delta, this));
        this.onPostDraw(_ctx, _delta);
    };
    /**
     * Updates all the actors and timers in the scene. Called by the [[Engine]].
     * @param engine  Reference to the current Engine
     * @param delta   The number of milliseconds since the last update
     */
    Scene.prototype.update = function (engine, delta) {
        this._preupdate(engine, delta);
        var i, len;
        // Remove timers in the cancel queue before updating them
        for (i = 0, len = this._cancelQueue.length; i < len; i++) {
            this.removeTimer(this._cancelQueue[i]);
        }
        this._cancelQueue.length = 0;
        // Cycle through timers updating timers
        for (var _i = 0, _a = this._timers; _i < _a.length; _i++) {
            var timer = _a[_i];
            timer.update(delta);
        }
        // Cycle through actors updating UI actors
        for (i = 0, len = this.uiActors.length; i < len; i++) {
            this.uiActors[i].update(engine, delta);
        }
        // Cycle through actors updating tile maps
        for (i = 0, len = this.tileMaps.length; i < len; i++) {
            this.tileMaps[i].update(engine, delta);
        }
        // Cycle through actors updating actors
        for (i = 0, len = this.actors.length; i < len; i++) {
            this.actors[i].update(engine, delta);
        }
        // Cycle through triggers updating
        for (i = 0, len = this.triggers.length; i < len; i++) {
            this.triggers[i].update(engine, delta);
        }
        this._collectActorStats(engine);
        // propagates all events through their paths assigned
        engine.input.pointers.propagate();
        // Run the broadphase and narrowphase
        if (this._broadphase && _Physics__WEBPACK_IMPORTED_MODULE_1__["Physics"].enabled) {
            var beforeBroadphase = Date.now();
            this._broadphase.update(this.actors, delta);
            var pairs = this._broadphase.broadphase(this.actors, delta, engine.stats.currFrame);
            var afterBroadphase = Date.now();
            var beforeNarrowphase = Date.now();
            var iter = _Physics__WEBPACK_IMPORTED_MODULE_1__["Physics"].collisionPasses;
            var collisionDelta = delta / iter;
            while (iter > 0) {
                // Run the narrowphase
                pairs = this._broadphase.narrowphase(pairs, engine.stats.currFrame);
                // Run collision resolution strategy
                pairs = this._broadphase.resolve(pairs, collisionDelta, _Physics__WEBPACK_IMPORTED_MODULE_1__["Physics"].collisionResolutionStrategy);
                this._broadphase.runCollisionStartEnd(pairs);
                iter--;
            }
            var afterNarrowphase = Date.now();
            engine.stats.currFrame.physics.broadphase = afterBroadphase - beforeBroadphase;
            engine.stats.currFrame.physics.narrowphase = afterNarrowphase - beforeNarrowphase;
        }
        engine.stats.currFrame.actors.killed = this._killQueue.length + this._triggerKillQueue.length;
        this._processKillQueue(this._killQueue, this.actors);
        this._processKillQueue(this._triggerKillQueue, this.triggers);
        if (this.camera) {
            this.camera.update(engine, delta);
        }
        this._postupdate(engine, delta);
    };
    Scene.prototype._processKillQueue = function (killQueue, collection) {
        // Remove actors from scene graph after being killed
        var actorIndex;
        for (var _i = 0, killQueue_1 = killQueue; _i < killQueue_1.length; _i++) {
            var killed = killQueue_1[_i];
            //don't remove actors that were readded during the same frame they were killed
            if (killed.isKilled()) {
                actorIndex = collection.indexOf(killed);
                if (actorIndex > -1) {
                    this._sortedDrawingTree.removeByComparable(killed);
                    collection.splice(actorIndex, 1);
                }
            }
        }
        killQueue.length = 0;
    };
    /**
     * Draws all the actors in the Scene. Called by the [[Engine]].
     * @param ctx    The current rendering context
     * @param delta  The number of milliseconds since the last draw
     */
    Scene.prototype.draw = function (ctx, delta) {
        this._predraw(ctx, delta);
        ctx.save();
        if (this.camera) {
            this.camera.draw(ctx);
        }
        var i, len;
        for (i = 0, len = this.tileMaps.length; i < len; i++) {
            this.tileMaps[i].draw(ctx, delta);
        }
        var sortedChildren = this._sortedDrawingTree.list();
        for (i = 0, len = sortedChildren.length; i < len; i++) {
            // only draw actors that are visible and on screen
            if (sortedChildren[i].visible && !sortedChildren[i].isOffScreen) {
                sortedChildren[i].draw(ctx, delta);
            }
        }
        if (this.engine && this.engine.isDebug) {
            ctx.strokeStyle = 'yellow';
            this.debugDraw(ctx);
        }
        ctx.restore();
        for (i = 0, len = this.uiActors.length; i < len; i++) {
            // only draw ui actors that are visible and on screen
            if (this.uiActors[i].visible) {
                this.uiActors[i].draw(ctx, delta);
            }
        }
        if (this.engine && this.engine.isDebug) {
            for (i = 0, len = this.uiActors.length; i < len; i++) {
                this.uiActors[i].debugDraw(ctx);
            }
        }
        this._postdraw(ctx, delta);
    };
    /**
     * Draws all the actors' debug information in the Scene. Called by the [[Engine]].
     * @param ctx  The current rendering context
     */
    /* istanbul ignore next */
    Scene.prototype.debugDraw = function (ctx) {
        this.emit('predebugdraw', new _Events__WEBPACK_IMPORTED_MODULE_2__["PreDebugDrawEvent"](ctx, this));
        var i, len;
        for (i = 0, len = this.tileMaps.length; i < len; i++) {
            this.tileMaps[i].debugDraw(ctx);
        }
        for (i = 0, len = this.actors.length; i < len; i++) {
            this.actors[i].debugDraw(ctx);
        }
        for (i = 0, len = this.triggers.length; i < len; i++) {
            this.triggers[i].debugDraw(ctx);
        }
        this._broadphase.debugDraw(ctx, 20);
        this.camera.debugDraw(ctx);
        this.emit('postdebugdraw', new _Events__WEBPACK_IMPORTED_MODULE_2__["PostDebugDrawEvent"](ctx, this));
    };
    /**
     * Checks whether an actor is contained in this scene or not
     */
    Scene.prototype.contains = function (actor) {
        return this.actors.indexOf(actor) > -1;
    };
    Scene.prototype.add = function (entity) {
        if (entity instanceof _Actor__WEBPACK_IMPORTED_MODULE_10__["Actor"]) {
            entity.unkill();
        }
        if (entity instanceof _UIActor__WEBPACK_IMPORTED_MODULE_0__["UIActor"]) {
            if (!_Util_Util__WEBPACK_IMPORTED_MODULE_12__["contains"](this.uiActors, entity)) {
                this.addUIActor(entity);
            }
            return;
        }
        if (entity instanceof _Actor__WEBPACK_IMPORTED_MODULE_10__["Actor"]) {
            if (!_Util_Util__WEBPACK_IMPORTED_MODULE_12__["contains"](this.actors, entity)) {
                this._addChild(entity);
            }
            return;
        }
        if (entity instanceof _Timer__WEBPACK_IMPORTED_MODULE_4__["Timer"]) {
            if (!_Util_Util__WEBPACK_IMPORTED_MODULE_12__["contains"](this._timers, entity)) {
                this.addTimer(entity);
            }
            return;
        }
        if (entity instanceof _TileMap__WEBPACK_IMPORTED_MODULE_8__["TileMap"]) {
            if (!_Util_Util__WEBPACK_IMPORTED_MODULE_12__["contains"](this.tileMaps, entity)) {
                this.addTileMap(entity);
            }
        }
    };
    Scene.prototype.remove = function (entity) {
        if (entity instanceof _UIActor__WEBPACK_IMPORTED_MODULE_0__["UIActor"]) {
            this.removeUIActor(entity);
            return;
        }
        if (entity instanceof _Actor__WEBPACK_IMPORTED_MODULE_10__["Actor"]) {
            this._removeChild(entity);
        }
        if (entity instanceof _Timer__WEBPACK_IMPORTED_MODULE_4__["Timer"]) {
            this.removeTimer(entity);
        }
        if (entity instanceof _TileMap__WEBPACK_IMPORTED_MODULE_8__["TileMap"]) {
            this.removeTileMap(entity);
        }
    };
    /**
     * Adds (any) actor to act as a piece of UI, meaning it is always positioned
     * in screen coordinates. UI actors do not participate in collisions.
     * @todo Should this be `UIActor` only?
     */
    Scene.prototype.addUIActor = function (actor) {
        this.uiActors.push(actor);
        actor.scene = this;
    };
    /**
     * Removes an actor as a piece of UI
     */
    Scene.prototype.removeUIActor = function (actor) {
        var index = this.uiActors.indexOf(actor);
        if (index > -1) {
            this.uiActors.splice(index, 1);
        }
    };
    /**
     * Adds an actor to the scene, once this is done the actor will be drawn and updated.
     */
    Scene.prototype._addChild = function (actor) {
        this._broadphase.track(actor.body);
        actor.scene = this;
        if (actor instanceof _Trigger__WEBPACK_IMPORTED_MODULE_14__["Trigger"]) {
            this.triggers.push(actor);
        }
        else {
            this.actors.push(actor);
        }
        this._sortedDrawingTree.add(actor);
    };
    /**
     * Adds a [[TileMap]] to the scene, once this is done the TileMap will be drawn and updated.
     */
    Scene.prototype.addTileMap = function (tileMap) {
        this.tileMaps.push(tileMap);
    };
    /**
     * Removes a [[TileMap]] from the scene, it will no longer be drawn or updated.
     */
    Scene.prototype.removeTileMap = function (tileMap) {
        var index = this.tileMaps.indexOf(tileMap);
        if (index > -1) {
            this.tileMaps.splice(index, 1);
        }
    };
    /**
     * Removes an actor from the scene, it will no longer be drawn or updated.
     */
    Scene.prototype._removeChild = function (actor) {
        if (!_Util_Util__WEBPACK_IMPORTED_MODULE_12__["contains"](this.actors, actor)) {
            return;
        }
        this._broadphase.untrack(actor.body);
        if (actor instanceof _Trigger__WEBPACK_IMPORTED_MODULE_14__["Trigger"]) {
            this._triggerKillQueue.push(actor);
        }
        else {
            if (!actor.isKilled()) {
                actor.kill();
            }
            this._killQueue.push(actor);
        }
        actor.parent = null;
    };
    /**
     * Adds a [[Timer]] to the scene
     * @param timer  The timer to add
     */
    Scene.prototype.addTimer = function (timer) {
        this._timers.push(timer);
        timer.scene = this;
        return timer;
    };
    /**
     * Removes a [[Timer]] from the scene.
     * @warning Can be dangerous, use [[cancelTimer]] instead
     * @param timer  The timer to remove
     */
    Scene.prototype.removeTimer = function (timer) {
        var i = this._timers.indexOf(timer);
        if (i !== -1) {
            this._timers.splice(i, 1);
        }
        return timer;
    };
    /**
     * Cancels a [[Timer]], removing it from the scene nicely
     * @param timer  The timer to cancel
     */
    Scene.prototype.cancelTimer = function (timer) {
        this._cancelQueue.push(timer);
        return timer;
    };
    /**
     * Tests whether a [[Timer]] is active in the scene
     */
    Scene.prototype.isTimerActive = function (timer) {
        return this._timers.indexOf(timer) > -1 && !timer.complete;
    };
    /**
     * Creates and adds a [[Group]] to the scene with a name
     */
    Scene.prototype.createGroup = function (name) {
        return new _Group__WEBPACK_IMPORTED_MODULE_7__["Group"](name, this);
    };
    /**
     * Returns a [[Group]] by name
     */
    Scene.prototype.getGroup = function (name) {
        return this.groups[name];
    };
    Scene.prototype.removeGroup = function (group) {
        if (typeof group === 'string') {
            delete this.groups[group];
        }
        else if (group instanceof _Group__WEBPACK_IMPORTED_MODULE_7__["Group"]) {
            delete this.groups[group.name];
        }
        else {
            this._logger.error('Invalid arguments to removeGroup', group);
        }
    };
    /**
     * Removes the given actor from the sorted drawing tree
     */
    Scene.prototype.cleanupDrawTree = function (actor) {
        this._sortedDrawingTree.removeByComparable(actor);
    };
    /**
     * Updates the given actor's position in the sorted drawing tree
     */
    Scene.prototype.updateDrawTree = function (actor) {
        this._sortedDrawingTree.add(actor);
    };
    /**
     * Checks if an actor is in this scene's sorted draw tree
     */
    Scene.prototype.isActorInDrawTree = function (actor) {
        return this._sortedDrawingTree.find(actor);
    };
    Scene.prototype.isCurrentScene = function () {
        if (this.engine) {
            return this.engine.currentScene === this;
        }
        return false;
    };
    Scene.prototype._collectActorStats = function (engine) {
        for (var _i = 0, _a = this.uiActors; _i < _a.length; _i++) {
            var _ui = _a[_i];
            engine.stats.currFrame.actors.ui++;
        }
        for (var _b = 0, _c = this.actors; _b < _c.length; _b++) {
            var actor = _c[_b];
            engine.stats.currFrame.actors.alive++;
            for (var _d = 0, _e = actor.children; _d < _e.length; _d++) {
                var child = _e[_d];
                if (_Util_Actors__WEBPACK_IMPORTED_MODULE_13__["isUIActor"](child)) {
                    engine.stats.currFrame.actors.ui++;
                }
                else {
                    engine.stats.currFrame.actors.alive++;
                }
            }
        }
    };
    return Scene;
}(_Class__WEBPACK_IMPORTED_MODULE_11__["Class"]));



/***/ }),

/***/ "./TileMap.ts":
/*!********************!*\
  !*** ./TileMap.ts ***!
  \********************/
/*! exports provided: TileMapImpl, TileMap, TileSprite, CellImpl, Cell */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TileMapImpl", function() { return TileMapImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TileMap", function() { return TileMap; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TileSprite", function() { return TileSprite; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CellImpl", function() { return CellImpl; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Cell", function() { return Cell; });
/* harmony import */ var _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Collision/BoundingBox */ "./Collision/BoundingBox.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Class */ "./Class.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");
/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony import */ var _Configurable__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Configurable */ "./Configurable.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();







/**
 * @hidden
 */
var TileMapImpl = /** @class */ (function (_super) {
    __extends(TileMapImpl, _super);
    /**
     * @param x             The x coordinate to anchor the TileMap's upper left corner (should not be changed once set)
     * @param y             The y coordinate to anchor the TileMap's upper left corner (should not be changed once set)
     * @param cellWidth     The individual width of each cell (in pixels) (should not be changed once set)
     * @param cellHeight    The individual height of each cell (in pixels) (should not be changed once set)
     * @param rows          The number of rows in the TileMap (should not be changed once set)
     * @param cols          The number of cols in the TileMap (should not be changed once set)
     */
    function TileMapImpl(xOrConfig, y, cellWidth, cellHeight, rows, cols) {
        var _this = _super.call(this) || this;
        _this._collidingX = -1;
        _this._collidingY = -1;
        _this._onScreenXStart = 0;
        _this._onScreenXEnd = 9999;
        _this._onScreenYStart = 0;
        _this._onScreenYEnd = 9999;
        _this._spriteSheets = {};
        _this.logger = _Util_Log__WEBPACK_IMPORTED_MODULE_4__["Logger"].getInstance();
        _this.data = [];
        if (xOrConfig && typeof xOrConfig === 'object') {
            var config = xOrConfig;
            xOrConfig = config.x;
            y = config.y;
            cellWidth = config.cellWidth;
            cellHeight = config.cellHeight;
            rows = config.rows;
            cols = config.cols;
        }
        _this.x = xOrConfig;
        _this.y = y;
        _this.cellWidth = cellWidth;
        _this.cellHeight = cellHeight;
        _this.rows = rows;
        _this.cols = cols;
        _this.data = new Array(rows * cols);
        for (var i = 0; i < cols; i++) {
            for (var j = 0; j < rows; j++) {
                (function () {
                    var cd = new Cell(i * cellWidth + xOrConfig, j * cellHeight + y, cellWidth, cellHeight, i + j * cols);
                    _this.data[i + j * cols] = cd;
                })();
            }
        }
        return _this;
    }
    TileMapImpl.prototype.on = function (eventName, handler) {
        _super.prototype.on.call(this, eventName, handler);
    };
    TileMapImpl.prototype.registerSpriteSheet = function (key, spriteSheet) {
        this._spriteSheets[key] = spriteSheet;
    };
    /**
     * Returns the intersection vector that can be used to resolve collisions with actors. If there
     * is no collision null is returned.
     */
    TileMapImpl.prototype.collides = function (actor) {
        var width = actor.pos.x + actor.getWidth();
        var height = actor.pos.y + actor.getHeight();
        var actorBounds = actor.getBounds();
        var overlaps = [];
        // trace points for overlap
        for (var x = actorBounds.left; x <= width; x += Math.min(actor.getWidth() / 2, this.cellWidth / 2)) {
            for (var y = actorBounds.top; y <= height; y += Math.min(actor.getHeight() / 2, this.cellHeight / 2)) {
                var cell = this.getCellByPoint(x, y);
                if (cell && cell.solid) {
                    var overlap = actorBounds.collides(cell.getBounds());
                    var dir = actor.getCenter().sub(cell.getCenter());
                    if (overlap && overlap.dot(dir) > 0) {
                        overlaps.push(overlap);
                    }
                }
            }
        }
        if (overlaps.length === 0) {
            return null;
        }
        // Return the smallest change other than zero
        var result = overlaps.reduce(function (accum, next) {
            var x = accum.x;
            var y = accum.y;
            if (Math.abs(accum.x) < Math.abs(next.x)) {
                x = next.x;
            }
            if (Math.abs(accum.y) < Math.abs(next.y)) {
                y = next.y;
            }
            return new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"](x, y);
        });
        return result;
    };
    /**
     * Returns the [[Cell]] by index (row major order)
     */
    TileMapImpl.prototype.getCellByIndex = function (index) {
        return this.data[index];
    };
    /**
     * Returns the [[Cell]] by its x and y coordinates
     */
    TileMapImpl.prototype.getCell = function (x, y) {
        if (x < 0 || y < 0 || x >= this.cols || y >= this.rows) {
            return null;
        }
        return this.data[x + y * this.cols];
    };
    /**
     * Returns the [[Cell]] by testing a point in global coordinates,
     * returns `null` if no cell was found.
     */
    TileMapImpl.prototype.getCellByPoint = function (x, y) {
        x = Math.floor((x - this.x) / this.cellWidth);
        y = Math.floor((y - this.y) / this.cellHeight);
        var cell = this.getCell(x, y);
        if (x >= 0 && y >= 0 && x < this.cols && y < this.rows && cell) {
            return cell;
        }
        return null;
    };
    TileMapImpl.prototype.update = function (engine, delta) {
        this.emit('preupdate', new _Events__WEBPACK_IMPORTED_MODULE_5__["PreUpdateEvent"](engine, delta, this));
        var worldCoordsUpperLeft = engine.screenToWorldCoordinates(new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"](0, 0));
        var worldCoordsLowerRight = engine.screenToWorldCoordinates(new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"](engine.canvas.clientWidth, engine.canvas.clientHeight));
        this._onScreenXStart = Math.max(Math.floor((worldCoordsUpperLeft.x - this.x) / this.cellWidth) - 2, 0);
        this._onScreenYStart = Math.max(Math.floor((worldCoordsUpperLeft.y - this.y) / this.cellHeight) - 2, 0);
        this._onScreenXEnd = Math.max(Math.floor((worldCoordsLowerRight.x - this.x) / this.cellWidth) + 2, 0);
        this._onScreenYEnd = Math.max(Math.floor((worldCoordsLowerRight.y - this.y) / this.cellHeight) + 2, 0);
        this.emit('postupdate', new _Events__WEBPACK_IMPORTED_MODULE_5__["PostUpdateEvent"](engine, delta, this));
    };
    /**
     * Draws the tile map to the screen. Called by the [[Scene]].
     * @param ctx    The current rendering context
     * @param delta  The number of milliseconds since the last draw
     */
    TileMapImpl.prototype.draw = function (ctx, delta) {
        this.emit('predraw', new _Events__WEBPACK_IMPORTED_MODULE_5__["PreDrawEvent"](ctx, delta, this));
        ctx.save();
        ctx.translate(this.x, this.y);
        var x = this._onScreenXStart;
        var xEnd = Math.min(this._onScreenXEnd, this.cols);
        var y = this._onScreenYStart;
        var yEnd = Math.min(this._onScreenYEnd, this.rows);
        var cs, csi, cslen;
        for (x; x < xEnd; x++) {
            for (y; y < yEnd; y++) {
                // get non-negative tile sprites
                cs = this.getCell(x, y).sprites.filter(function (s) {
                    return s.spriteId > -1;
                });
                for (csi = 0, cslen = cs.length; csi < cslen; csi++) {
                    var ss = this._spriteSheets[cs[csi].spriteSheetKey];
                    // draw sprite, warning if sprite doesn't exist
                    if (ss) {
                        var sprite = ss.getSprite(cs[csi].spriteId);
                        if (sprite) {
                            sprite.draw(ctx, x * this.cellWidth, y * this.cellHeight);
                        }
                        else {
                            this.logger.warn('Sprite does not exist for id', cs[csi].spriteId, 'in sprite sheet', cs[csi].spriteSheetKey, sprite, ss);
                        }
                    }
                    else {
                        this.logger.warn('Sprite sheet', cs[csi].spriteSheetKey, 'does not exist', ss);
                    }
                }
            }
            y = this._onScreenYStart;
        }
        ctx.restore();
        this.emit('postdraw', new _Events__WEBPACK_IMPORTED_MODULE_5__["PostDrawEvent"](ctx, delta, this));
    };
    /**
     * Draws all the tile map's debug info. Called by the [[Scene]].
     * @param ctx  The current rendering context
     */
    TileMapImpl.prototype.debugDraw = function (ctx) {
        var width = this.cols * this.cellWidth;
        var height = this.rows * this.cellHeight;
        ctx.save();
        ctx.strokeStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Red.toString();
        for (var x = 0; x < this.cols + 1; x++) {
            ctx.beginPath();
            ctx.moveTo(this.x + x * this.cellWidth, this.y);
            ctx.lineTo(this.x + x * this.cellWidth, this.y + height);
            ctx.stroke();
        }
        for (var y = 0; y < this.rows + 1; y++) {
            ctx.beginPath();
            ctx.moveTo(this.x, this.y + y * this.cellHeight);
            ctx.lineTo(this.x + width, this.y + y * this.cellHeight);
            ctx.stroke();
        }
        var solid = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Red.clone();
        solid.a = 0.3;
        this.data
            .filter(function (cell) {
            return cell.solid;
        })
            .forEach(function (cell) {
            ctx.fillStyle = solid.toString();
            ctx.fillRect(cell.x, cell.y, cell.width, cell.height);
        });
        if (this._collidingY > -1 && this._collidingX > -1) {
            ctx.fillStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Cyan.toString();
            ctx.fillRect(this.x + this._collidingX * this.cellWidth, this.y + this._collidingY * this.cellHeight, this.cellWidth, this.cellHeight);
        }
        ctx.restore();
    };
    return TileMapImpl;
}(_Class__WEBPACK_IMPORTED_MODULE_2__["Class"]));

/**
 * The [[TileMap]] class provides a lightweight way to do large complex scenes with collision
 * without the overhead of actors.
 *
 * [[include:TileMaps.md]]
 */
var TileMap = /** @class */ (function (_super) {
    __extends(TileMap, _super);
    function TileMap(xOrConfig, y, cellWidth, cellHeight, rows, cols) {
        return _super.call(this, xOrConfig, y, cellWidth, cellHeight, rows, cols) || this;
    }
    return TileMap;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_6__["Configurable"])(TileMapImpl)));

/**
 * Tile sprites are used to render a specific sprite from a [[TileMap]]'s spritesheet(s)
 */
var TileSprite = /** @class */ (function () {
    /**
     * @param spriteSheetKey  The key of the spritesheet to use
     * @param spriteId        The index of the sprite in the [[SpriteSheet]]
     */
    function TileSprite(spriteSheetKey, spriteId) {
        this.spriteSheetKey = spriteSheetKey;
        this.spriteId = spriteId;
    }
    return TileSprite;
}());

/**
 * @hidden
 */
var CellImpl = /** @class */ (function () {
    /**
     * @param x       Gets or sets x coordinate of the cell in world coordinates
     * @param y       Gets or sets y coordinate of the cell in world coordinates
     * @param width   Gets or sets the width of the cell
     * @param height  Gets or sets the height of the cell
     * @param index   The index of the cell in row major order
     * @param solid   Gets or sets whether this cell is solid
     * @param sprites The list of tile sprites to use to draw in this cell (in order)
     */
    function CellImpl(xOrConfig, y, width, height, index, solid, sprites) {
        if (solid === void 0) { solid = false; }
        if (sprites === void 0) { sprites = []; }
        this.solid = false;
        this.sprites = [];
        if (xOrConfig && typeof xOrConfig === 'object') {
            var config = xOrConfig;
            xOrConfig = config.x;
            y = config.y;
            width = config.width;
            height = config.height;
            index = config.index;
            solid = config.solid;
            sprites = config.sprites;
        }
        this.x = xOrConfig;
        this.y = y;
        this.width = width;
        this.height = height;
        this.index = index;
        this.solid = solid;
        this.sprites = sprites;
        this._bounds = new _Collision_BoundingBox__WEBPACK_IMPORTED_MODULE_0__["BoundingBox"](this.x, this.y, this.x + this.width, this.y + this.height);
    }
    /**
     * Returns the bounding box for this cell
     */
    CellImpl.prototype.getBounds = function () {
        return this._bounds;
    };
    /**
     * Gets the center coordinate of this cell
     */
    CellImpl.prototype.getCenter = function () {
        return new _Algebra__WEBPACK_IMPORTED_MODULE_3__["Vector"](this.x + this.width / 2, this.y + this.height / 2);
    };
    /**
     * Add another [[TileSprite]] to this cell
     */
    CellImpl.prototype.pushSprite = function (tileSprite) {
        this.sprites.push(tileSprite);
    };
    /**
     * Remove an instance of [[TileSprite]] from this cell
     */
    CellImpl.prototype.removeSprite = function (tileSprite) {
        var index = -1;
        if ((index = this.sprites.indexOf(tileSprite)) > -1) {
            this.sprites.splice(index, 1);
        }
    };
    /**
     * Clear all sprites from this cell
     */
    CellImpl.prototype.clearSprites = function () {
        this.sprites.length = 0;
    };
    return CellImpl;
}());

/**
 * TileMap Cell
 *
 * A light-weight object that occupies a space in a collision map. Generally
 * created by a [[TileMap]].
 *
 * Cells can draw multiple sprites. Note that the order of drawing is the order
 * of the sprites in the array so the last one will be drawn on top. You can
 * use transparency to create layers this way.
 */
var Cell = /** @class */ (function (_super) {
    __extends(Cell, _super);
    function Cell(xOrConfig, y, width, height, index, solid, sprites) {
        return _super.call(this, xOrConfig, y, width, height, index, solid, sprites) || this;
    }
    return Cell;
}(Object(_Configurable__WEBPACK_IMPORTED_MODULE_6__["Configurable"])(CellImpl)));



/***/ }),

/***/ "./Timer.ts":
/*!******************!*\
  !*** ./Timer.ts ***!
  \******************/
/*! exports provided: Timer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Timer", function() { return Timer; });
/**
 * The Excalibur timer hooks into the internal timer and fires callbacks,
 * after a certain interval, optionally repeating.
 */
var Timer = /** @class */ (function () {
    /**
     * @param fcn        The callback to be fired after the interval is complete.
     * @param interval   Interval length
     * @param repeats    Indicates whether this call back should be fired only once, or repeat after every interval as completed.
     * @param numberOfRepeats Specifies a maximum number of times that this timer will execute.
     */
    function Timer(fcn, interval, repeats, numberOfRepeats) {
        this.id = 0;
        this.interval = 10;
        this.fcn = function () {
            return;
        };
        this.repeats = false;
        this.maxNumberOfRepeats = -1;
        this._elapsedTime = 0;
        this._totalTimeAlive = 0;
        this._paused = false;
        this._numberOfTicks = 0;
        this.complete = false;
        this.scene = null;
        if (!!numberOfRepeats && numberOfRepeats >= 0) {
            this.maxNumberOfRepeats = numberOfRepeats;
            if (!repeats) {
                throw new Error('repeats must be set to true if numberOfRepeats is set');
            }
        }
        this.id = Timer.id++;
        this.interval = interval || this.interval;
        this.fcn = fcn || this.fcn;
        this.repeats = repeats || this.repeats;
    }
    /**
     * Updates the timer after a certain number of milliseconds have elapsed. This is used internally by the engine.
     * @param delta  Number of elapsed milliseconds since the last update.
     */
    Timer.prototype.update = function (delta) {
        if (!this._paused) {
            this._totalTimeAlive += delta;
            this._elapsedTime += delta;
            if (this.maxNumberOfRepeats > -1 && this._numberOfTicks >= this.maxNumberOfRepeats) {
                this.complete = true;
            }
            if (!this.complete && this._elapsedTime >= this.interval) {
                this.fcn.call(this);
                this._numberOfTicks++;
                if (this.repeats) {
                    this._elapsedTime = 0;
                }
                else {
                    this.complete = true;
                }
            }
        }
    };
    /**
     * Resets the timer so that it can be reused, and optionally reconfigure the timers interval.
     * @param newInterval If specified, sets a new non-negative interval in milliseconds to refire the callback
     * @param newNumberOfRepeats If specified, sets a new non-negative upper limit to the number of time this timer executes
     */
    Timer.prototype.reset = function (newInterval, newNumberOfRepeats) {
        if (!!newInterval && newInterval >= 0) {
            this.interval = newInterval;
        }
        if (!!this.maxNumberOfRepeats && this.maxNumberOfRepeats >= 0) {
            this.maxNumberOfRepeats = newNumberOfRepeats;
            if (!this.repeats) {
                throw new Error('repeats must be set to true if numberOfRepeats is set');
            }
        }
        this.complete = false;
        this._elapsedTime = 0;
        this._numberOfTicks = 0;
    };
    Object.defineProperty(Timer.prototype, "timesRepeated", {
        get: function () {
            return this._numberOfTicks;
        },
        enumerable: true,
        configurable: true
    });
    Timer.prototype.getTimeRunning = function () {
        return this._totalTimeAlive;
    };
    /**
     * Pauses the timer so that no more time will be incremented towards the next call
     */
    Timer.prototype.pause = function () {
        this._paused = true;
    };
    /**
     * Unpauses the timer. Time will now increment towards the next call
     */
    Timer.prototype.unpause = function () {
        this._paused = false;
    };
    /**
     * Cancels the timer, preventing any further executions.
     */
    Timer.prototype.cancel = function () {
        if (this.scene) {
            this.scene.cancelTimer(this);
        }
    };
    Timer.id = 0;
    return Timer;
}());



/***/ }),

/***/ "./Traits/CapturePointer.ts":
/*!**********************************!*\
  !*** ./Traits/CapturePointer.ts ***!
  \**********************************/
/*! exports provided: CapturePointer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CapturePointer", function() { return CapturePointer; });
/**
 * Revises pointer events path accordingly to the actor
 */
var CapturePointer = /** @class */ (function () {
    function CapturePointer() {
    }
    CapturePointer.prototype.update = function (actor, engine) {
        if (!actor.enableCapturePointer) {
            return;
        }
        if (actor.isKilled()) {
            return;
        }
        engine.input.pointers.revisePointerEventsPaths(actor);
    };
    return CapturePointer;
}());



/***/ }),

/***/ "./Traits/EulerMovement.ts":
/*!*********************************!*\
  !*** ./Traits/EulerMovement.ts ***!
  \*********************************/
/*! exports provided: EulerMovement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EulerMovement", function() { return EulerMovement; });
/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Physics */ "./Physics.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Actor */ "./Actor.ts");


var EulerMovement = /** @class */ (function () {
    function EulerMovement() {
    }
    EulerMovement.prototype.update = function (actor, _engine, delta) {
        // Update placements based on linear algebra
        var seconds = delta / 1000;
        var totalAcc = actor.acc.clone();
        // Only active vanilla actors are affected by global acceleration
        if (actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_1__["CollisionType"].Active) {
            totalAcc.addEqual(_Physics__WEBPACK_IMPORTED_MODULE_0__["Physics"].acc);
        }
        actor.oldVel = actor.vel;
        actor.vel.addEqual(totalAcc.scale(seconds));
        actor.pos.addEqual(actor.vel.scale(seconds)).addEqual(totalAcc.scale(0.5 * seconds * seconds));
        actor.rx += actor.torque * (1.0 / actor.moi) * seconds;
        actor.rotation += actor.rx * seconds;
        actor.scale.x += (actor.sx * delta) / 1000;
        actor.scale.y += (actor.sy * delta) / 1000;
    };
    return EulerMovement;
}());



/***/ }),

/***/ "./Traits/Index.ts":
/*!*************************!*\
  !*** ./Traits/Index.ts ***!
  \*************************/
/*! exports provided: CapturePointer, EulerMovement, OffscreenCulling, TileMapCollisionDetection */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CapturePointer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CapturePointer */ "./Traits/CapturePointer.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CapturePointer", function() { return _CapturePointer__WEBPACK_IMPORTED_MODULE_0__["CapturePointer"]; });

/* harmony import */ var _EulerMovement__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./EulerMovement */ "./Traits/EulerMovement.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EulerMovement", function() { return _EulerMovement__WEBPACK_IMPORTED_MODULE_1__["EulerMovement"]; });

/* harmony import */ var _OffscreenCulling__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./OffscreenCulling */ "./Traits/OffscreenCulling.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "OffscreenCulling", function() { return _OffscreenCulling__WEBPACK_IMPORTED_MODULE_2__["OffscreenCulling"]; });

/* harmony import */ var _TileMapCollisionDetection__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./TileMapCollisionDetection */ "./Traits/TileMapCollisionDetection.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TileMapCollisionDetection", function() { return _TileMapCollisionDetection__WEBPACK_IMPORTED_MODULE_3__["TileMapCollisionDetection"]; });







/***/ }),

/***/ "./Traits/OffscreenCulling.ts":
/*!************************************!*\
  !*** ./Traits/OffscreenCulling.ts ***!
  \************************************/
/*! exports provided: OffscreenCulling */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OffscreenCulling", function() { return OffscreenCulling; });
/* harmony import */ var _Util_CullingBox__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../Util/CullingBox */ "./Util/CullingBox.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Events */ "./Events.ts");



var OffscreenCulling = /** @class */ (function () {
    function OffscreenCulling() {
        this.cullingBox = new _Util_CullingBox__WEBPACK_IMPORTED_MODULE_0__["CullingBox"]();
    }
    OffscreenCulling.prototype.update = function (actor, engine) {
        var eventDispatcher = actor.eventDispatcher;
        var anchor = actor.anchor;
        var globalScale = actor.getGlobalScale();
        var width = (globalScale.x * actor.getWidth()) / actor.scale.x;
        var height = (globalScale.y * actor.getHeight()) / actor.scale.y;
        var cameraPos = engine.currentScene.camera.pos;
        var worldPos = actor.getWorldPos();
        var actorScreenCoords = engine.worldToScreenCoordinates(new _Algebra__WEBPACK_IMPORTED_MODULE_1__["Vector"](worldPos.x - anchor.x * width, worldPos.y - anchor.y * height));
        var cameraScreenCoords = engine.worldToScreenCoordinates(cameraPos);
        var zoom = 1.0;
        if (actor.scene && actor.scene.camera) {
            zoom = Math.abs(actor.scene.camera.getZoom());
        }
        var isSpriteOffScreen = true;
        if (actor.currentDrawing != null) {
            isSpriteOffScreen = this.cullingBox.isSpriteOffScreen(actor, engine);
        }
        if (!actor.isOffScreen) {
            if ((actorScreenCoords.x + width * zoom < 0 ||
                actorScreenCoords.y + height * zoom < 0 ||
                actorScreenCoords.x > engine.halfDrawWidth + cameraScreenCoords.x ||
                actorScreenCoords.y > engine.halfDrawHeight + cameraScreenCoords.y) &&
                isSpriteOffScreen) {
                eventDispatcher.emit('exitviewport', new _Events__WEBPACK_IMPORTED_MODULE_2__["ExitViewPortEvent"](actor));
                actor.isOffScreen = true;
            }
        }
        else {
            if ((actorScreenCoords.x + width * zoom > 0 &&
                actorScreenCoords.y + height * zoom > 0 &&
                actorScreenCoords.x < engine.halfDrawWidth + cameraScreenCoords.x &&
                actorScreenCoords.y < engine.halfDrawHeight + cameraScreenCoords.y) ||
                !isSpriteOffScreen) {
                eventDispatcher.emit('enterviewport', new _Events__WEBPACK_IMPORTED_MODULE_2__["EnterViewPortEvent"](actor));
                actor.isOffScreen = false;
            }
        }
    };
    return OffscreenCulling;
}());



/***/ }),

/***/ "./Traits/TileMapCollisionDetection.ts":
/*!*********************************************!*\
  !*** ./Traits/TileMapCollisionDetection.ts ***!
  \*********************************************/
/*! exports provided: TileMapCollisionDetection */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TileMapCollisionDetection", function() { return TileMapCollisionDetection; });
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Actor */ "./Actor.ts");
/* harmony import */ var _Collision_Side__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Collision/Side */ "./Collision/Side.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Events */ "./Events.ts");



var TileMapCollisionDetection = /** @class */ (function () {
    function TileMapCollisionDetection() {
    }
    TileMapCollisionDetection.prototype.update = function (actor, engine) {
        var eventDispatcher = actor.eventDispatcher;
        if (actor.collisionType !== _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].PreventCollision && engine.currentScene && engine.currentScene.tileMaps) {
            for (var j = 0; j < engine.currentScene.tileMaps.length; j++) {
                var map = engine.currentScene.tileMaps[j];
                var intersectMap;
                var side = _Collision_Side__WEBPACK_IMPORTED_MODULE_1__["Side"].None;
                var max = 2;
                while ((intersectMap = map.collides(actor))) {
                    if (max-- < 0) {
                        break;
                    }
                    side = actor.getSideFromIntersect(intersectMap);
                    eventDispatcher.emit('precollision', new _Events__WEBPACK_IMPORTED_MODULE_2__["PreCollisionEvent"](actor, null, side, intersectMap));
                    if (actor.collisionType === _Actor__WEBPACK_IMPORTED_MODULE_0__["CollisionType"].Active) {
                        actor.pos.y += intersectMap.y;
                        actor.pos.x += intersectMap.x;
                        eventDispatcher.emit('postcollision', new _Events__WEBPACK_IMPORTED_MODULE_2__["PostCollisionEvent"](actor, null, side, intersectMap));
                    }
                }
            }
        }
    };
    return TileMapCollisionDetection;
}());



/***/ }),

/***/ "./Trigger.ts":
/*!********************!*\
  !*** ./Trigger.ts ***!
  \********************/
/*! exports provided: Trigger */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Trigger", function() { return Trigger; });
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Drawing/Color */ "./Drawing/Color.ts");
/* harmony import */ var _Actions_Action__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Actions/Action */ "./Actions/Action.ts");
/* harmony import */ var _EventDispatcher__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./EventDispatcher */ "./EventDispatcher.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Actor */ "./Actor.ts");
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");
/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony import */ var _Util_Util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Util/Util */ "./Util/Util.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();







var triggerDefaults = {
    pos: _Algebra__WEBPACK_IMPORTED_MODULE_4__["Vector"].Zero.clone(),
    width: 10,
    height: 10,
    visible: false,
    action: function () {
        return;
    },
    filter: function () { return true; },
    repeat: -1
};
/**
 * Triggers are a method of firing arbitrary code on collision. These are useful
 * as 'buttons', 'switches', or to trigger effects in a game. By default triggers
 * are invisible, and can only be seen when [[Trigger.visible]] is set to `true`.
 *
 * [[include:Triggers.md]]
 */
var Trigger = /** @class */ (function (_super) {
    __extends(Trigger, _super);
    /**
     *
     * @param opts Trigger options
     */
    function Trigger(opts) {
        var _this = _super.call(this, opts.pos.x, opts.pos.y, opts.width, opts.height) || this;
        /**
         * Action to fire when triggered by collision
         */
        _this.action = function () {
            return;
        };
        /**
         * Filter to add additional granularity to action dispatch, if a filter is specified the action will only fire when
         * filter return true for the collided actor.
         */
        _this.filter = function () { return true; };
        /**
         * Number of times to repeat before killing the trigger,
         */
        _this.repeat = -1;
        opts = _Util_Util__WEBPACK_IMPORTED_MODULE_6__["extend"]({}, triggerDefaults, opts);
        _this.filter = opts.filter || _this.filter;
        _this.repeat = opts.repeat || _this.repeat;
        _this.action = opts.action || _this.action;
        if (opts.target) {
            _this.target = opts.target;
        }
        _this.visible = opts.visible;
        _this.collisionType = _Actor__WEBPACK_IMPORTED_MODULE_3__["CollisionType"].Passive;
        _this.eventDispatcher = new _EventDispatcher__WEBPACK_IMPORTED_MODULE_2__["EventDispatcher"](_this);
        _this.actionQueue = new _Actions_Action__WEBPACK_IMPORTED_MODULE_1__["ActionQueue"](_this);
        _this.on('collisionstart', function (evt) {
            if (_this.filter(evt.other)) {
                _this.emit('enter', new _Events__WEBPACK_IMPORTED_MODULE_5__["EnterTriggerEvent"](_this, evt.other));
                _this._dispatchAction();
                // remove trigger if its done, -1 repeat forever
                if (_this.repeat === 0) {
                    _this.kill();
                }
            }
        });
        _this.on('collisionend', function (evt) {
            if (_this.filter(evt.other)) {
                _this.emit('exit', new _Events__WEBPACK_IMPORTED_MODULE_5__["ExitTriggerEvent"](_this, evt.other));
            }
        });
        return _this;
    }
    Object.defineProperty(Trigger.prototype, "target", {
        get: function () {
            return this._target;
        },
        set: function (target) {
            this._target = target;
            this.filter = function (actor) { return actor === target; };
        },
        enumerable: true,
        configurable: true
    });
    Trigger.prototype._initialize = function (engine) {
        _super.prototype._initialize.call(this, engine);
    };
    Trigger.prototype._dispatchAction = function () {
        this.action.call(this);
        this.repeat--;
    };
    /* istanbul ignore next */
    Trigger.prototype.debugDraw = function (ctx) {
        _super.prototype.debugDraw.call(this, ctx);
        // Meant to draw debug information about actors
        ctx.save();
        ctx.translate(this.pos.x, this.pos.y);
        var bb = this.getBounds();
        var wp = this.getWorldPos();
        bb.left = bb.left - wp.x;
        bb.right = bb.right - wp.x;
        bb.top = bb.top - wp.y;
        bb.bottom = bb.bottom - wp.y;
        // Currently collision primitives cannot rotate
        // ctx.rotate(this.rotation);
        ctx.fillStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__["Color"].Violet.toString();
        ctx.strokeStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__["Color"].Violet.toString();
        ctx.fillText('Trigger', 10, 10);
        bb.debugDraw(ctx);
        ctx.restore();
    };
    return Trigger;
}(_Actor__WEBPACK_IMPORTED_MODULE_3__["Actor"]));



/***/ }),

/***/ "./UIActor.ts":
/*!********************!*\
  !*** ./UIActor.ts ***!
  \********************/
/*! exports provided: UIActor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UIActor", function() { return UIActor; });
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");
/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Actor */ "./Actor.ts");
/* harmony import */ var _Traits_Index__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Traits/Index */ "./Traits/Index.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



/**
 * Helper [[Actor]] primitive for drawing UI's, optimized for UI drawing. Does
 * not participate in collisions. Drawn on top of all other actors.
 */
var UIActor = /** @class */ (function (_super) {
    __extends(UIActor, _super);
    /**
     * @param x       The starting x coordinate of the actor
     * @param y       The starting y coordinate of the actor
     * @param width   The starting width of the actor
     * @param height  The starting height of the actor
     */
    function UIActor(xOrConfig, y, width, height) {
        var _this = this;
        if (typeof xOrConfig !== 'object') {
            _this = _super.call(this, xOrConfig, y, width, height) || this;
        }
        else {
            _this = _super.call(this, xOrConfig) || this;
        }
        _this.traits = [];
        _this.traits.push(new _Traits_Index__WEBPACK_IMPORTED_MODULE_2__["CapturePointer"]());
        _this.anchor.setTo(0, 0);
        _this.collisionType = _Actor__WEBPACK_IMPORTED_MODULE_1__["CollisionType"].PreventCollision;
        _this.enableCapturePointer = true;
        return _this;
    }
    UIActor.prototype._initialize = function (engine) {
        this._engine = engine;
        _super.prototype._initialize.call(this, engine);
    };
    UIActor.prototype.contains = function (x, y, useWorld) {
        if (useWorld === void 0) { useWorld = true; }
        if (useWorld) {
            return _super.prototype.contains.call(this, x, y);
        }
        var coords = this._engine.worldToScreenCoordinates(new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](x, y));
        return _super.prototype.contains.call(this, coords.x, coords.y);
    };
    return UIActor;
}(_Actor__WEBPACK_IMPORTED_MODULE_1__["Actor"]));



/***/ }),

/***/ "./Util/Actors.ts":
/*!************************!*\
  !*** ./Util/Actors.ts ***!
  \************************/
/*! exports provided: isVanillaActor, isUIActor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isVanillaActor", function() { return isVanillaActor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "isUIActor", function() { return isUIActor; });
/* harmony import */ var _UIActor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../UIActor */ "./UIActor.ts");
/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Label */ "./Label.ts");
/* harmony import */ var _Trigger__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Trigger */ "./Trigger.ts");



function isVanillaActor(actor) {
    return !(actor instanceof _UIActor__WEBPACK_IMPORTED_MODULE_0__["UIActor"]) && !(actor instanceof _Trigger__WEBPACK_IMPORTED_MODULE_2__["Trigger"]) && !(actor instanceof _Label__WEBPACK_IMPORTED_MODULE_1__["Label"]);
}
function isUIActor(actor) {
    return actor instanceof _UIActor__WEBPACK_IMPORTED_MODULE_0__["UIActor"];
}


/***/ }),

/***/ "./Util/CullingBox.ts":
/*!****************************!*\
  !*** ./Util/CullingBox.ts ***!
  \****************************/
/*! exports provided: CullingBox */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CullingBox", function() { return CullingBox; });
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Drawing/Color */ "./Drawing/Color.ts");


var CullingBox = /** @class */ (function () {
    function CullingBox() {
        this._topLeft = new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](0, 0);
        this._topRight = new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](0, 0);
        this._bottomLeft = new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](0, 0);
        this._bottomRight = new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](0, 0);
    }
    CullingBox.prototype.isSpriteOffScreen = function (actor, engine) {
        var drawingWidth = actor.currentDrawing.drawWidth;
        var drawingHeight = actor.currentDrawing.drawHeight;
        var rotation = actor.rotation;
        var anchor = actor.getCenter();
        var worldPos = actor.getWorldPos();
        this._topLeft.x = worldPos.x - drawingWidth / 2;
        this._topLeft.y = worldPos.y - drawingHeight / 2;
        this._topLeft = this._topLeft.rotate(rotation, anchor);
        this._topRight.x = worldPos.x + drawingWidth / 2;
        this._topRight.y = worldPos.y - drawingHeight / 2;
        this._topRight = this._topRight.rotate(rotation, anchor);
        this._bottomLeft.x = worldPos.x - drawingWidth / 2;
        this._bottomLeft.y = worldPos.y + drawingHeight / 2;
        this._bottomLeft = this._bottomLeft.rotate(rotation, anchor);
        this._bottomRight.x = worldPos.x + drawingWidth / 2;
        this._bottomRight.y = worldPos.y + drawingHeight / 2;
        this._bottomRight = this._bottomRight.rotate(rotation, anchor);
        ///
        var topLeftScreen = engine.worldToScreenCoordinates(this._topLeft);
        var topRightScreen = engine.worldToScreenCoordinates(this._topRight);
        var bottomLeftScreen = engine.worldToScreenCoordinates(this._bottomLeft);
        var bottomRightScreen = engine.worldToScreenCoordinates(this._bottomRight);
        this._xCoords = [];
        this._yCoords = [];
        this._xCoords.push(topLeftScreen.x, topRightScreen.x, bottomLeftScreen.x, bottomRightScreen.x);
        this._yCoords.push(topLeftScreen.y, topRightScreen.y, bottomLeftScreen.y, bottomRightScreen.y);
        this._xMin = Math.min.apply(null, this._xCoords);
        this._yMin = Math.min.apply(null, this._yCoords);
        this._xMax = Math.max.apply(null, this._xCoords);
        this._yMax = Math.max.apply(null, this._yCoords);
        var minWorld = engine.screenToWorldCoordinates(new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](this._xMin, this._yMin));
        var maxWorld = engine.screenToWorldCoordinates(new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](this._xMax, this._yMax));
        this._xMinWorld = minWorld.x;
        this._yMinWorld = minWorld.y;
        this._xMaxWorld = maxWorld.x;
        this._yMaxWorld = maxWorld.y;
        var boundingPoints = [
            new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](this._xMin, this._yMin),
            new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](this._xMax, this._yMin),
            new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](this._xMin, this._yMax),
            new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](this._xMax, this._yMax)
        ]; // bottomright
        // sprite can be wider than canvas screen (and still visible within canvas)
        // top or bottom of sprite must be within canvas
        if (boundingPoints[0].x < 0 &&
            boundingPoints[1].x > engine.canvas.clientWidth &&
            (boundingPoints[0].y > 0 || boundingPoints[2].y < engine.canvas.clientHeight)) {
            return false;
        }
        // sprite can be taller than canvas screen (and still visible within canvas)
        // left or right of sprite must be within canvas
        if (boundingPoints[0].y < 0 &&
            boundingPoints[2].y > engine.canvas.clientHeight &&
            (boundingPoints[1].x > 0 || boundingPoints[0].x < engine.canvas.clientWidth)) {
            return false;
        }
        // otherwise if any corner is visible, we're not offscreen
        for (var i = 0; i < boundingPoints.length; i++) {
            if (boundingPoints[i].x > 0 &&
                boundingPoints[i].y > 0 &&
                boundingPoints[i].x < engine.canvas.clientWidth &&
                boundingPoints[i].y < engine.canvas.clientHeight) {
                return false;
            }
        }
        return true;
    };
    CullingBox.prototype.debugDraw = function (ctx) {
        // bounding rectangle
        ctx.beginPath();
        ctx.strokeStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].White.toString();
        ctx.rect(this._xMinWorld, this._yMinWorld, this._xMaxWorld - this._xMinWorld, this._yMaxWorld - this._yMinWorld);
        ctx.stroke();
        ctx.fillStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Red.toString();
        ctx.beginPath();
        ctx.arc(this._topLeft.x, this._topLeft.y, 5, 0, Math.PI * 2);
        ctx.closePath();
        ctx.fill();
        ctx.fillStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Green.toString();
        ctx.beginPath();
        ctx.arc(this._topRight.x, this._topRight.y, 5, 0, Math.PI * 2);
        ctx.closePath();
        ctx.fill();
        ctx.fillStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Blue.toString();
        ctx.beginPath();
        ctx.arc(this._bottomLeft.x, this._bottomLeft.y, 5, 0, Math.PI * 2);
        ctx.closePath();
        ctx.fill();
        ctx.fillStyle = _Drawing_Color__WEBPACK_IMPORTED_MODULE_1__["Color"].Magenta.toString();
        ctx.beginPath();
        ctx.arc(this._bottomRight.x, this._bottomRight.y, 5, 0, Math.PI * 2);
        ctx.closePath();
        ctx.fill();
    };
    return CullingBox;
}());



/***/ }),

/***/ "./Util/Decorators.ts":
/*!****************************!*\
  !*** ./Util/Decorators.ts ***!
  \****************************/
/*! exports provided: obsolete */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "obsolete", function() { return obsolete; });
/* harmony import */ var _Log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Log */ "./Util/Log.ts");
/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Util */ "./Util/Util.ts");


/**
 * Obsolete decorator for marking Excalibur methods obsolete, you can optionally specify a custom message and/or alternate replacement
 * method do the deprecated one. Inspired by https://github.com/jayphelps/core-decorators.js
 */
function obsolete(options) {
    options = _Util__WEBPACK_IMPORTED_MODULE_1__["extend"]({}, { message: 'This method will be removed in future versions of Excalibur.', alternateMethod: null }, options);
    return function (target, property, descriptor) {
        if (!(typeof descriptor.value === 'function' || typeof descriptor.get === 'function' || typeof descriptor.set === 'function')) {
            throw new SyntaxError('Only functions/getters/setters can be marked as obsolete');
        }
        var methodSignature = "" + (target.name || '') + (target.name ? '.' : '') + property;
        var message = methodSignature + " is marked obsolete: " + options.message +
            (options.alternateMethod ? " Use " + options.alternateMethod + " instead" : '');
        var method = _Util__WEBPACK_IMPORTED_MODULE_1__["extend"]({}, descriptor);
        if (descriptor.value) {
            method.value = function () {
                _Log__WEBPACK_IMPORTED_MODULE_0__["Logger"].getInstance().warn(message);
                return descriptor.value.apply(this, arguments);
            };
            return method;
        }
        if (descriptor.get) {
            method.get = function () {
                _Log__WEBPACK_IMPORTED_MODULE_0__["Logger"].getInstance().warn(message);
                return descriptor.get.apply(this, arguments);
            };
        }
        if (descriptor.set) {
            method.set = function () {
                _Log__WEBPACK_IMPORTED_MODULE_0__["Logger"].getInstance().warn(message);
                return descriptor.set.apply(this, arguments);
            };
        }
        return method;
    };
}


/***/ }),

/***/ "./Util/Detector.ts":
/*!**************************!*\
  !*** ./Util/Detector.ts ***!
  \**************************/
/*! exports provided: Detector */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Detector", function() { return Detector; });
/* harmony import */ var _Log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Log */ "./Util/Log.ts");

/**
 * This is the list of features that will be used to log the supported
 * features to the console when Detector.logBrowserFeatures() is called.
 */
var REPORTED_FEATURES = {
    webgl: 'WebGL',
    webaudio: 'WebAudio',
    gamepadapi: 'Gamepad API'
};
/**
 * Excalibur internal feature detection helper class
 */
var Detector = /** @class */ (function () {
    function Detector() {
        this._features = null;
        this.failedTests = [];
        // critical browser features required for ex to run
        this._criticalTests = {
            // Test canvas/2d context support
            canvasSupport: function () {
                var elem = document.createElement('canvas');
                return !!(elem.getContext && elem.getContext('2d'));
            },
            // Test array buffer support ex uses for downloading binary data
            arrayBufferSupport: function () {
                var xhr = new XMLHttpRequest();
                xhr.open('GET', '/');
                try {
                    xhr.responseType = 'arraybuffer';
                }
                catch (e) {
                    return false;
                }
                return xhr.responseType === 'arraybuffer';
            },
            // Test data urls ex uses for sprites
            dataUrlSupport: function () {
                var canvas = document.createElement('canvas');
                return canvas.toDataURL('image/png').indexOf('data:image/png') === 0;
            },
            // Test object url support for loading
            objectUrlSupport: function () {
                return 'URL' in window && 'revokeObjectURL' in URL && 'createObjectURL' in URL;
            },
            // RGBA support for colors
            rgbaSupport: function () {
                var style = document.createElement('a').style;
                style.cssText = 'background-color:rgba(150,255,150,.5)';
                return ('' + style.backgroundColor).indexOf('rgba') > -1;
            }
        };
        // warnings excalibur performance will be degraded
        this._warningTest = {
            webAudioSupport: function () {
                return !!(window.AudioContext ||
                    window.webkitAudioContext ||
                    window.mozAudioContext ||
                    window.msAudioContext ||
                    window.oAudioContext);
            },
            webglSupport: function () {
                var elem = document.createElement('canvas');
                return !!(elem.getContext && elem.getContext('webgl'));
            }
        };
        this._features = this._loadBrowserFeatures();
    }
    /**
     * Returns a map of currently supported browser features. This method
     * treats the features as a singleton and will only calculate feature
     * support if it has not previously been done.
     */
    Detector.prototype.getBrowserFeatures = function () {
        if (this._features === null) {
            this._features = this._loadBrowserFeatures();
        }
        return this._features;
    };
    /**
     * Report on non-critical browser support for debugging purposes.
     * Use native browser console colors for visibility.
     */
    Detector.prototype.logBrowserFeatures = function () {
        var msg = '%cSUPPORTED BROWSER FEATURES\n==========================%c\n';
        var args = ['font-weight: bold; color: navy', 'font-weight: normal; color: inherit'];
        var supported = this.getBrowserFeatures();
        for (var _i = 0, _a = Object.keys(REPORTED_FEATURES); _i < _a.length; _i++) {
            var feature = _a[_i];
            if (supported[feature]) {
                msg += '(%c\u2713%c)'; // (✓)
                args.push('font-weight: bold; color: green');
                args.push('font-weight: normal; color: inherit');
            }
            else {
                msg += '(%c\u2717%c)'; // (✗)
                args.push('font-weight: bold; color: red');
                args.push('font-weight: normal; color: inherit');
            }
            msg += ' ' + REPORTED_FEATURES[feature] + '\n';
        }
        args.unshift(msg);
        console.log.apply(console, args);
    };
    /**
     * Executes several IIFE's to get a constant reference to supported
     * features within the current execution context.
     */
    Detector.prototype._loadBrowserFeatures = function () {
        var _this = this;
        return {
            // IIFE to check canvas support
            canvas: (function () {
                return _this._criticalTests.canvasSupport();
            })(),
            // IIFE to check arraybuffer support
            arraybuffer: (function () {
                return _this._criticalTests.arrayBufferSupport();
            })(),
            // IIFE to check dataurl support
            dataurl: (function () {
                return _this._criticalTests.dataUrlSupport();
            })(),
            // IIFE to check objecturl support
            objecturl: (function () {
                return _this._criticalTests.objectUrlSupport();
            })(),
            // IIFE to check rgba support
            rgba: (function () {
                return _this._criticalTests.rgbaSupport();
            })(),
            // IIFE to check webaudio support
            webaudio: (function () {
                return _this._warningTest.webAudioSupport();
            })(),
            // IIFE to check webgl support
            webgl: (function () {
                return _this._warningTest.webglSupport();
            })(),
            // IIFE to check gamepadapi support
            gamepadapi: (function () {
                return !!navigator.getGamepads;
            })()
        };
    };
    Detector.prototype.test = function () {
        // Critical test will for ex not to run
        var failedCritical = false;
        for (var test in this._criticalTests) {
            if (!this._criticalTests[test].call(this)) {
                this.failedTests.push(test);
                _Log__WEBPACK_IMPORTED_MODULE_0__["Logger"].getInstance().error('Critical browser feature missing, Excalibur requires:', test);
                failedCritical = true;
            }
        }
        if (failedCritical) {
            return false;
        }
        // Warning tests do not for ex to return false to compatibility
        for (var warning in this._warningTest) {
            if (!this._warningTest[warning]()) {
                _Log__WEBPACK_IMPORTED_MODULE_0__["Logger"].getInstance().warn('Warning browser feature missing, Excalibur will have reduced performance:', warning);
            }
        }
        return true;
    };
    return Detector;
}());



/***/ }),

/***/ "./Util/DrawUtil.ts":
/*!**************************!*\
  !*** ./Util/DrawUtil.ts ***!
  \**************************/
/*! exports provided: line, point, vector, roundRect, circle */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "line", function() { return line; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "point", function() { return point; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "vector", function() { return vector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "roundRect", function() { return roundRect; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "circle", function() { return circle; });
/* harmony import */ var _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Drawing/Color */ "./Drawing/Color.ts");

/**
 * Draw a line on canvas context
 *
 * @param ctx The canvas context
 * @param color The color of the line
 * @param x1 The start x coordinate
 * @param y1 The start y coordinate
 * @param x2 The ending x coordinate
 * @param y2 The ending y coordinate
 * @param thickness The line thickness
 * @param cap The [[LineCapStyle]] (butt, round, or square)
 */
/* istanbul ignore next */
function line(ctx, color, x1, y1, x2, y2, thickness, cap) {
    if (color === void 0) { color = _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__["Color"].Red.clone(); }
    if (thickness === void 0) { thickness = 1; }
    if (cap === void 0) { cap = 'butt'; }
    ctx.beginPath();
    ctx.lineWidth = thickness;
    ctx.lineCap = cap;
    ctx.strokeStyle = color.toString();
    ctx.moveTo(x1, y1);
    ctx.lineTo(x2, y2);
    ctx.closePath();
    ctx.stroke();
}
/**
 * Draw the vector as a point onto the canvas.
 */
/* istanbul ignore next */
function point(ctx, color, point) {
    if (color === void 0) { color = _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__["Color"].Red.clone(); }
    ctx.beginPath();
    ctx.strokeStyle = color.toString();
    ctx.arc(point.x, point.y, 5, 0, Math.PI * 2);
    ctx.closePath();
    ctx.stroke();
}
/**
 * Draw the vector as a line onto the canvas starting a origin point.
 */
/* istanbul ignore next */
function vector(ctx, color, origin, vector, scale) {
    if (scale === void 0) { scale = 1.0; }
    var c = color ? color.toString() : 'blue';
    var v = vector.scale(scale);
    ctx.beginPath();
    ctx.strokeStyle = c;
    ctx.moveTo(origin.x, origin.y);
    ctx.lineTo(origin.x + v.x, origin.y + v.y);
    ctx.closePath();
    ctx.stroke();
}
/**
 * Draw a round rectangle on a canvas context
 *
 * @param ctx The canvas context
 * @param x The top-left x coordinate
 * @param y The top-left y coordinate
 * @param width The width of the rectangle
 * @param height The height of the rectangle
 * @param radius The border radius of the rectangle
 * @param fill The [[Color]] to fill rectangle with
 * @param stroke The [[Color]] to stroke rectangle with
 */
function roundRect(ctx, x, y, width, height, radius, stroke, fill) {
    if (radius === void 0) { radius = 5; }
    if (stroke === void 0) { stroke = _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__["Color"].White; }
    if (fill === void 0) { fill = null; }
    var br;
    if (typeof radius === 'number') {
        br = { tl: radius, tr: radius, br: radius, bl: radius };
    }
    else {
        var defaultRadius = { tl: 0, tr: 0, br: 0, bl: 0 };
        for (var prop in defaultRadius) {
            if (defaultRadius.hasOwnProperty(prop)) {
                var side = prop;
                br[side] = radius[side] || defaultRadius[side];
            }
        }
    }
    ctx.beginPath();
    ctx.moveTo(x + br.tl, y);
    ctx.lineTo(x + width - br.tr, y);
    ctx.quadraticCurveTo(x + width, y, x + width, y + br.tr);
    ctx.lineTo(x + width, y + height - br.br);
    ctx.quadraticCurveTo(x + width, y + height, x + width - br.br, y + height);
    ctx.lineTo(x + br.bl, y + height);
    ctx.quadraticCurveTo(x, y + height, x, y + height - br.bl);
    ctx.lineTo(x, y + br.tl);
    ctx.quadraticCurveTo(x, y, x + br.tl, y);
    ctx.closePath();
    if (fill) {
        ctx.fillStyle = fill.toString();
        ctx.fill();
    }
    if (stroke) {
        ctx.strokeStyle = stroke.toString();
        ctx.stroke();
    }
}
function circle(ctx, x, y, radius, stroke, fill) {
    if (stroke === void 0) { stroke = _Drawing_Color__WEBPACK_IMPORTED_MODULE_0__["Color"].White; }
    if (fill === void 0) { fill = null; }
    ctx.beginPath();
    ctx.arc(x, y, radius, 0, Math.PI * 2);
    ctx.closePath();
    if (fill) {
        ctx.fillStyle = fill.toString();
        ctx.fill();
    }
    if (stroke) {
        ctx.strokeStyle = stroke.toString();
        ctx.stroke();
    }
}


/***/ }),

/***/ "./Util/EasingFunctions.ts":
/*!*********************************!*\
  !*** ./Util/EasingFunctions.ts ***!
  \*********************************/
/*! exports provided: EasingFunctions */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EasingFunctions", function() { return EasingFunctions; });
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");

/**
 * Standard easing functions for motion in Excalibur, defined on a domain of [0, duration] and a range from [+startValue,+endValue]
 * Given a time, the function will return a value from positive startValue to positive endValue.
 *
 * ```js
 * function Linear (t) {
 *    return t * t;
 * }
 *
 * // accelerating from zero velocity
 * function EaseInQuad (t) {
 *    return t * t;
 * }
 *
 * // decelerating to zero velocity
 * function EaseOutQuad (t) {
 *    return t * (2 - t);
 * }
 *
 * // acceleration until halfway, then deceleration
 * function EaseInOutQuad (t) {
 *    return t < .5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
 * }
 *
 * // accelerating from zero velocity
 * function EaseInCubic (t) {
 *    return t * t * t;
 * }
 *
 * // decelerating to zero velocity
 * function EaseOutCubic (t) {
 *    return (--t) * t * t + 1;
 * }
 *
 * // acceleration until halfway, then deceleration
 * function EaseInOutCubic (t) {
 *    return t < .5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
 * }
 * ```
 */
var EasingFunctions = /** @class */ (function () {
    function EasingFunctions() {
    }
    EasingFunctions.CreateReversableEasingFunction = function (easing) {
        return function (time, start, end, duration) {
            if (end < start) {
                return start - (easing(time, end, start, duration) - end);
            }
            else {
                return easing(time, start, end, duration);
            }
        };
    };
    EasingFunctions.CreateVectorEasingFunction = function (easing) {
        return function (time, start, end, duration) {
            return new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](easing(time, start.x, end.x, duration), easing(time, start.y, end.y, duration));
        };
    };
    EasingFunctions.Linear = EasingFunctions.CreateReversableEasingFunction(function (currentTime, startValue, endValue, duration) {
        endValue = endValue - startValue;
        return (endValue * currentTime) / duration + startValue;
    });
    EasingFunctions.EaseInQuad = EasingFunctions.CreateReversableEasingFunction(function (currentTime, startValue, endValue, duration) {
        endValue = endValue - startValue;
        currentTime /= duration;
        return endValue * currentTime * currentTime + startValue;
    });
    EasingFunctions.EaseOutQuad = EasingFunctions.CreateReversableEasingFunction(function (currentTime, startValue, endValue, duration) {
        endValue = endValue - startValue;
        currentTime /= duration;
        return -endValue * currentTime * (currentTime - 2) + startValue;
    });
    EasingFunctions.EaseInOutQuad = EasingFunctions.CreateReversableEasingFunction(function (currentTime, startValue, endValue, duration) {
        endValue = endValue - startValue;
        currentTime /= duration / 2;
        if (currentTime < 1) {
            return (endValue / 2) * currentTime * currentTime + startValue;
        }
        currentTime--;
        return (-endValue / 2) * (currentTime * (currentTime - 2) - 1) + startValue;
    });
    EasingFunctions.EaseInCubic = EasingFunctions.CreateReversableEasingFunction(function (currentTime, startValue, endValue, duration) {
        endValue = endValue - startValue;
        currentTime /= duration;
        return endValue * currentTime * currentTime * currentTime + startValue;
    });
    EasingFunctions.EaseOutCubic = EasingFunctions.CreateReversableEasingFunction(function (currentTime, startValue, endValue, duration) {
        endValue = endValue - startValue;
        currentTime /= duration;
        currentTime--;
        return endValue * (currentTime * currentTime * currentTime + 1) + startValue;
    });
    EasingFunctions.EaseInOutCubic = EasingFunctions.CreateReversableEasingFunction(function (currentTime, startValue, endValue, duration) {
        endValue = endValue - startValue;
        currentTime /= duration / 2;
        if (currentTime < 1) {
            return (endValue / 2) * currentTime * currentTime * currentTime + startValue;
        }
        currentTime -= 2;
        return (endValue / 2) * (currentTime * currentTime * currentTime + 2) + startValue;
    });
    return EasingFunctions;
}());



/***/ }),

/***/ "./Util/Index.ts":
/*!***********************!*\
  !*** ./Util/Index.ts ***!
  \***********************/
/*! exports provided: DrawUtil, TwoPI, extend, base64Encode, clamp, randomInRange, randomIntInRange, canonicalizeAngle, toDegrees, toRadians, getPosition, addItemToArray, removeItemFromArray, contains, getOppositeSide, getSideFromVector, Collection */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _Util__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Util */ "./Util/Util.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TwoPI", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["TwoPI"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "extend", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["extend"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "base64Encode", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["base64Encode"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "clamp", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["clamp"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "randomInRange", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["randomInRange"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "randomIntInRange", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["randomIntInRange"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "canonicalizeAngle", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["canonicalizeAngle"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toDegrees", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["toDegrees"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "toRadians", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["toRadians"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getPosition", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["getPosition"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "addItemToArray", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["addItemToArray"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "removeItemFromArray", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["removeItemFromArray"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "contains", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["contains"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getOppositeSide", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["getOppositeSide"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "getSideFromVector", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["getSideFromVector"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Collection", function() { return _Util__WEBPACK_IMPORTED_MODULE_0__["Collection"]; });

/* harmony import */ var _DrawUtil__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./DrawUtil */ "./Util/DrawUtil.ts");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "DrawUtil", function() { return _DrawUtil__WEBPACK_IMPORTED_MODULE_1__; });





/***/ }),

/***/ "./Util/Log.ts":
/*!*********************!*\
  !*** ./Util/Log.ts ***!
  \*********************/
/*! exports provided: LogLevel, Logger, ConsoleAppender, ScreenAppender */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LogLevel", function() { return LogLevel; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Logger", function() { return Logger; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConsoleAppender", function() { return ConsoleAppender; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ScreenAppender", function() { return ScreenAppender; });
/**
 * Logging level that Excalibur will tag
 */
var LogLevel;
(function (LogLevel) {
    LogLevel[LogLevel["Debug"] = 0] = "Debug";
    LogLevel[LogLevel["Info"] = 1] = "Info";
    LogLevel[LogLevel["Warn"] = 2] = "Warn";
    LogLevel[LogLevel["Error"] = 3] = "Error";
    LogLevel[LogLevel["Fatal"] = 4] = "Fatal";
})(LogLevel || (LogLevel = {}));
/**
 * Static singleton that represents the logging facility for Excalibur.
 * Excalibur comes built-in with a [[ConsoleAppender]] and [[ScreenAppender]].
 * Derive from [[IAppender]] to create your own logging appenders.
 *
 * [[include:Logger.md]]
 */
var Logger = /** @class */ (function () {
    function Logger() {
        this._appenders = [];
        /**
         * Gets or sets the default logging level. Excalibur will only log
         * messages if equal to or above this level. Default: [[LogLevel.Info]]
         */
        this.defaultLevel = LogLevel.Info;
        if (Logger._instance) {
            throw new Error('Logger is a singleton');
        }
        Logger._instance = this;
        // Default console appender
        Logger._instance.addAppender(new ConsoleAppender());
        return Logger._instance;
    }
    /**
     * Gets the current static instance of Logger
     */
    Logger.getInstance = function () {
        if (Logger._instance == null) {
            Logger._instance = new Logger();
        }
        return Logger._instance;
    };
    /**
     * Adds a new [[IAppender]] to the list of appenders to write to
     */
    Logger.prototype.addAppender = function (appender) {
        this._appenders.push(appender);
    };
    /**
     * Clears all appenders from the logger
     */
    Logger.prototype.clearAppenders = function () {
        this._appenders.length = 0;
    };
    /**
     * Logs a message at a given LogLevel
     * @param level  The LogLevel`to log the message at
     * @param args   An array of arguments to write to an appender
     */
    Logger.prototype._log = function (level, args) {
        if (level == null) {
            level = this.defaultLevel;
        }
        var i = 0, len = this._appenders.length;
        for (i; i < len; i++) {
            if (level >= this.defaultLevel) {
                this._appenders[i].log(level, args);
            }
        }
    };
    /**
     * Writes a log message at the [[LogLevel.Debug]] level
     * @param args  Accepts any number of arguments
     */
    Logger.prototype.debug = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        this._log(LogLevel.Debug, args);
    };
    /**
     * Writes a log message at the [[LogLevel.Info]] level
     * @param args  Accepts any number of arguments
     */
    Logger.prototype.info = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        this._log(LogLevel.Info, args);
    };
    /**
     * Writes a log message at the [[LogLevel.Warn]] level
     * @param args  Accepts any number of arguments
     */
    Logger.prototype.warn = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        this._log(LogLevel.Warn, args);
    };
    /**
     * Writes a log message at the [[LogLevel.Error]] level
     * @param args  Accepts any number of arguments
     */
    Logger.prototype.error = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        this._log(LogLevel.Error, args);
    };
    /**
     * Writes a log message at the [[LogLevel.Fatal]] level
     * @param args  Accepts any number of arguments
     */
    Logger.prototype.fatal = function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        this._log(LogLevel.Fatal, args);
    };
    Logger._instance = null;
    return Logger;
}());

/**
 * Console appender for browsers (i.e. `console.log`)
 */
var ConsoleAppender = /** @class */ (function () {
    function ConsoleAppender() {
    }
    /**
     * Logs a message at the given [[LogLevel]]
     * @param level  Level to log at
     * @param args   Arguments to log
     */
    ConsoleAppender.prototype.log = function (level, args) {
        // Check for console support
        if (!console && !console.log && console.warn && console.error) {
            // todo maybe do something better than nothing
            return;
        }
        // Create a new console args array
        var consoleArgs = [];
        consoleArgs.unshift.apply(consoleArgs, args);
        consoleArgs.unshift('[' + LogLevel[level] + '] : ');
        if (level < LogLevel.Warn) {
            // Call .log for Debug/Info
            if (console.log.apply) {
                // this is required on some older browsers that don't support apply on console.log :(
                console.log.apply(console, consoleArgs);
            }
            else {
                console.log(consoleArgs.join(' '));
            }
        }
        else if (level < LogLevel.Error) {
            // Call .warn for Warn
            if (console.warn.apply) {
                console.warn.apply(console, consoleArgs);
            }
            else {
                console.warn(consoleArgs.join(' '));
            }
        }
        else {
            // Call .error for Error/Fatal
            if (console.error.apply) {
                console.error.apply(console, consoleArgs);
            }
            else {
                console.error(consoleArgs.join(' '));
            }
        }
    };
    return ConsoleAppender;
}());

/**
 * On-screen (canvas) appender
 */
var ScreenAppender = /** @class */ (function () {
    /**
     * @param width   Width of the screen appender in pixels
     * @param height  Height of the screen appender in pixels
     */
    function ScreenAppender(width, height) {
        // @todo Clean this up
        this._messages = [];
        this._canvas = document.createElement('canvas');
        this._canvas.width = width || window.innerWidth;
        this._canvas.height = height || window.innerHeight;
        this._canvas.style.position = 'absolute';
        this._ctx = this._canvas.getContext('2d');
        document.body.appendChild(this._canvas);
    }
    /**
     * Logs a message at the given [[LogLevel]]
     * @param level  Level to log at
     * @param args   Arguments to log
     */
    ScreenAppender.prototype.log = function (level, args) {
        var message = args.join(',');
        this._ctx.clearRect(0, 0, this._canvas.width, this._canvas.height);
        this._messages.unshift('[' + LogLevel[level] + '] : ' + message);
        var pos = 10;
        var opacity = 1.0;
        for (var i = 0; i < this._messages.length; i++) {
            this._ctx.fillStyle = 'rgba(255,255,255,' + opacity.toFixed(2) + ')';
            this._ctx.fillText(this._messages[i], 200, pos);
            pos += 10;
            opacity = opacity > 0 ? opacity - 0.05 : 0;
        }
    };
    return ScreenAppender;
}());



/***/ }),

/***/ "./Util/SortedList.ts":
/*!****************************!*\
  !*** ./Util/SortedList.ts ***!
  \****************************/
/*! exports provided: SortedList, BinaryTreeNode, MockedElement */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SortedList", function() { return SortedList; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BinaryTreeNode", function() { return BinaryTreeNode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MockedElement", function() { return MockedElement; });
/**
 * A sorted list implementation. NOTE: this implementation is not self-balancing
 */
var SortedList = /** @class */ (function () {
    function SortedList(getComparable) {
        this._getComparable = getComparable;
    }
    SortedList.prototype.find = function (element) {
        return this._find(this._root, element);
    };
    SortedList.prototype._find = function (node, element) {
        if (node == null) {
            return false;
        }
        else if (this._getComparable.call(element) === node.getKey()) {
            if (node.getData().indexOf(element) > -1) {
                return true;
            }
            else {
                return false;
            }
        }
        else if (this._getComparable.call(element) < node.getKey()) {
            return this._find(node.getLeft(), element);
        }
        else {
            return this._find(node.getRight(), element);
        }
    };
    // returns the array of elements at a specific key value
    SortedList.prototype.get = function (key) {
        return this._get(this._root, key);
    };
    SortedList.prototype._get = function (node, key) {
        if (node == null) {
            return [];
        }
        else if (key === node.getKey()) {
            return node.getData();
        }
        else if (key < node.getKey()) {
            return this._get(node.getLeft(), key);
        }
        else {
            return this._get(node.getRight(), key);
        }
    };
    SortedList.prototype.add = function (element) {
        if (this._root == null) {
            this._root = new BinaryTreeNode(this._getComparable.call(element), [element], null, null);
            return true;
        }
        else {
            return this._insert(this._root, element);
        }
    };
    SortedList.prototype._insert = function (node, element) {
        if (node != null) {
            if (this._getComparable.call(element) === node.getKey()) {
                if (node.getData().indexOf(element) > -1) {
                    return false; // the element we're trying to insert already exists
                }
                else {
                    node.getData().push(element);
                    return true;
                }
            }
            else if (this._getComparable.call(element) < node.getKey()) {
                if (node.getLeft() == null) {
                    node.setLeft(new BinaryTreeNode(this._getComparable.call(element), [element], null, null));
                    return true;
                }
                else {
                    return this._insert(node.getLeft(), element);
                }
            }
            else {
                if (node.getRight() == null) {
                    node.setRight(new BinaryTreeNode(this._getComparable.call(element), [element], null, null));
                    return true;
                }
                else {
                    return this._insert(node.getRight(), element);
                }
            }
        }
        return false;
    };
    SortedList.prototype.removeByComparable = function (element) {
        this._root = this._remove(this._root, element);
    };
    SortedList.prototype._remove = function (node, element) {
        if (node == null) {
            return null;
        }
        else if (this._getComparable.call(element) === node.getKey()) {
            var elementIndex = node.getData().indexOf(element);
            // if the node contains the element, remove the element
            if (elementIndex > -1) {
                node.getData().splice(elementIndex, 1);
                // if we have removed the last element at this node, remove the node
                if (node.getData().length === 0) {
                    // if the node is a leaf
                    if (node.getLeft() == null && node.getRight() == null) {
                        return null;
                    }
                    else if (node.getLeft() == null) {
                        return node.getRight();
                    }
                    else if (node.getRight() == null) {
                        return node.getLeft();
                    }
                    // if node has 2 children
                    var temp = this._findMinNode(node.getRight());
                    node.setKey(temp.getKey());
                    node.setData(temp.getData());
                    node.setRight(this._cleanup(node.getRight(), temp)); //"cleanup nodes" (move them up recursively)
                    return node;
                }
                else {
                    // this prevents the node from being removed since it still contains elements
                    return node;
                }
            }
        }
        else if (this._getComparable.call(element) < node.getKey()) {
            node.setLeft(this._remove(node.getLeft(), element));
            return node;
        }
        else {
            node.setRight(this._remove(node.getRight(), element));
            return node;
        }
        return null;
    };
    // called once we have successfully removed the element we wanted, recursively corrects the part of the tree below the removed node
    SortedList.prototype._cleanup = function (node, element) {
        var comparable = element.getKey();
        if (node == null) {
            return null;
        }
        else if (comparable === node.getKey()) {
            // if the node is a leaf
            if (node.getLeft() == null && node.getRight() == null) {
                return null;
            }
            else if (node.getLeft() == null) {
                return node.getRight();
            }
            else if (node.getRight() == null) {
                return node.getLeft();
            }
            // if node has 2 children
            var temp = this._findMinNode(node.getRight());
            node.setKey(temp.getKey());
            node.setData(temp.getData());
            node.setRight(this._cleanup(node.getRight(), temp));
            return node;
        }
        else if (this._getComparable.call(element) < node.getKey()) {
            node.setLeft(this._cleanup(node.getLeft(), element));
            return node;
        }
        else {
            node.setRight(this._cleanup(node.getRight(), element));
            return node;
        }
    };
    SortedList.prototype._findMinNode = function (node) {
        var current = node;
        while (current.getLeft() != null) {
            current = current.getLeft();
        }
        return current;
    };
    SortedList.prototype.list = function () {
        var results = new Array();
        this._list(this._root, results);
        return results;
    };
    SortedList.prototype._list = function (treeNode, results) {
        if (treeNode != null) {
            this._list(treeNode.getLeft(), results);
            treeNode.getData().forEach(function (element) {
                results.push(element);
            });
            this._list(treeNode.getRight(), results);
        }
    };
    return SortedList;
}());

/**
 * A tree node part of [[SortedList]]
 */
var BinaryTreeNode = /** @class */ (function () {
    function BinaryTreeNode(key, data, left, right) {
        this._key = key;
        this._data = data;
        this._left = left;
        this._right = right;
    }
    BinaryTreeNode.prototype.getKey = function () {
        return this._key;
    };
    BinaryTreeNode.prototype.setKey = function (key) {
        this._key = key;
    };
    BinaryTreeNode.prototype.getData = function () {
        return this._data;
    };
    BinaryTreeNode.prototype.setData = function (data) {
        this._data = data;
    };
    BinaryTreeNode.prototype.getLeft = function () {
        return this._left;
    };
    BinaryTreeNode.prototype.setLeft = function (left) {
        this._left = left;
    };
    BinaryTreeNode.prototype.getRight = function () {
        return this._right;
    };
    BinaryTreeNode.prototype.setRight = function (right) {
        this._right = right;
    };
    return BinaryTreeNode;
}());

/**
 * Mock element for testing
 *
 * @internal
 */
var MockedElement = /** @class */ (function () {
    function MockedElement(key) {
        this._key = 0;
        this._key = key;
    }
    MockedElement.prototype.getTheKey = function () {
        return this._key;
    };
    MockedElement.prototype.setKey = function (key) {
        this._key = key;
    };
    return MockedElement;
}());



/***/ }),

/***/ "./Util/Sound.ts":
/*!***********************!*\
  !*** ./Util/Sound.ts ***!
  \***********************/
/*! exports provided: canPlayFile */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "canPlayFile", function() { return canPlayFile; });
/* harmony import */ var _Log__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Log */ "./Util/Log.ts");

/**
 * Whether or not the browser can play this file as HTML5 Audio
 */
function canPlayFile(file) {
    try {
        var a = new Audio();
        var filetype = /.*\.([A-Za-z0-9]+)$/;
        var type = file.match(filetype)[1];
        if (a.canPlayType('audio/' + type)) {
            return true;
        }
        else {
            return false;
        }
    }
    catch (e) {
        _Log__WEBPACK_IMPORTED_MODULE_0__["Logger"].getInstance().warn('Cannot determine audio support, assuming no support for the Audio Tag', e);
        return false;
    }
}


/***/ }),

/***/ "./Util/Util.ts":
/*!**********************!*\
  !*** ./Util/Util.ts ***!
  \**********************/
/*! exports provided: TwoPI, extend, base64Encode, clamp, randomInRange, randomIntInRange, canonicalizeAngle, toDegrees, toRadians, getPosition, addItemToArray, removeItemFromArray, contains, getOppositeSide, getSideFromVector, Collection */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "TwoPI", function() { return TwoPI; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "extend", function() { return extend; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "base64Encode", function() { return base64Encode; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "clamp", function() { return clamp; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "randomInRange", function() { return randomInRange; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "randomIntInRange", function() { return randomIntInRange; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "canonicalizeAngle", function() { return canonicalizeAngle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toDegrees", function() { return toDegrees; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "toRadians", function() { return toRadians; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getPosition", function() { return getPosition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "addItemToArray", function() { return addItemToArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "removeItemFromArray", function() { return removeItemFromArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "contains", function() { return contains; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getOppositeSide", function() { return getOppositeSide; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getSideFromVector", function() { return getSideFromVector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Collection", function() { return Collection; });
/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Algebra */ "./Algebra.ts");
/* harmony import */ var _Math_Random__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Math/Random */ "./Math/Random.ts");
/* harmony import */ var _Collision_Side__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../Collision/Side */ "./Collision/Side.ts");



/**
 * Two PI constant
 */
var TwoPI = Math.PI * 2;
/**
 * Merges one or more objects into a single target object
 *
 * @returns Merged object with properties from other objects
 * @credit https://gomakethings.com/vanilla-javascript-version-of-jquery-extend/
 */
function extend() {
    var extended = {};
    var deep = false;
    var i = 0;
    var length = arguments.length;
    // Check if a deep merge
    if (Object.prototype.toString.call(arguments[0]) === '[object Boolean]') {
        deep = arguments[0];
        i++;
    }
    // Merge the object into the extended object
    var assignExists = typeof Object.assign === 'function';
    var merge = null;
    if (!assignExists) {
        merge = function (obj) {
            for (var prop in obj) {
                if (Object.prototype.hasOwnProperty.call(obj, prop)) {
                    // If deep merge and property is an object, merge properties
                    if (deep && Object.prototype.toString.call(obj[prop]) === '[object Object]') {
                        extended[prop] = extend(true, extended[prop], obj[prop]);
                    }
                    else {
                        extended[prop] = obj[prop];
                    }
                }
            }
        };
    }
    else {
        merge = Object.assign;
    }
    // Loop through each object and conduct a merge
    for (; i < length; i++) {
        var obj = arguments[i];
        if (!assignExists) {
            merge(obj);
        }
        else {
            merge(extended, obj);
        }
    }
    return extended;
}
function base64Encode(inputStr) {
    var b64 = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
    var outputStr = '';
    var i = 0;
    while (i < inputStr.length) {
        //all three "& 0xff" added below are there to fix a known bug
        //with bytes returned by xhr.responseText
        var byte1 = inputStr.charCodeAt(i++) & 0xff;
        var byte2 = inputStr.charCodeAt(i++) & 0xff;
        var byte3 = inputStr.charCodeAt(i++) & 0xff;
        var enc1 = byte1 >> 2;
        var enc2 = ((byte1 & 3) << 4) | (byte2 >> 4);
        var enc3, enc4;
        if (isNaN(byte2)) {
            enc3 = enc4 = 64;
        }
        else {
            enc3 = ((byte2 & 15) << 2) | (byte3 >> 6);
            if (isNaN(byte3)) {
                enc4 = 64;
            }
            else {
                enc4 = byte3 & 63;
            }
        }
        outputStr += b64.charAt(enc1) + b64.charAt(enc2) + b64.charAt(enc3) + b64.charAt(enc4);
    }
    return outputStr;
}
/**
 * Clamps a value between a min and max inclusive
 */
function clamp(val, min, max) {
    return Math.min(Math.max(min, val), max);
}
function randomInRange(min, max, random) {
    if (random === void 0) { random = new _Math_Random__WEBPACK_IMPORTED_MODULE_1__["Random"](); }
    return random ? random.floating(min, max) : min + Math.random() * (max - min);
}
function randomIntInRange(min, max, random) {
    if (random === void 0) { random = new _Math_Random__WEBPACK_IMPORTED_MODULE_1__["Random"](); }
    return random ? random.integer(min, max) : Math.round(randomInRange(min, max));
}
function canonicalizeAngle(angle) {
    var tmpAngle = angle;
    if (angle > TwoPI) {
        while (tmpAngle > TwoPI) {
            tmpAngle -= TwoPI;
        }
    }
    if (angle < 0) {
        while (tmpAngle < 0) {
            tmpAngle += TwoPI;
        }
    }
    return tmpAngle;
}
function toDegrees(radians) {
    return (180 / Math.PI) * radians;
}
function toRadians(degrees) {
    return (degrees / 180) * Math.PI;
}
function getPosition(el) {
    var oLeft = 0, oTop = 0;
    var calcOffsetLeft = function (parent) {
        oLeft += parent.offsetLeft;
        if (parent.offsetParent) {
            calcOffsetLeft(parent.offsetParent);
        }
    };
    var calcOffsetTop = function (parent) {
        oTop += parent.offsetTop;
        if (parent.offsetParent) {
            calcOffsetTop(parent.offsetParent);
        }
    };
    calcOffsetLeft(el);
    calcOffsetTop(el);
    return new _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"](oLeft, oTop);
}
function addItemToArray(item, array) {
    if (array.indexOf(item) === -1) {
        array.push(item);
        return true;
    }
    return false;
}
function removeItemFromArray(item, array) {
    var index = -1;
    if ((index = array.indexOf(item)) > -1) {
        array.splice(index, 1);
        return true;
    }
    return false;
}
function contains(array, obj) {
    for (var i = 0; i < array.length; i++) {
        if (array[i] === obj) {
            return true;
        }
    }
    return false;
}
function getOppositeSide(side) {
    if (side === _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Top) {
        return _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Bottom;
    }
    if (side === _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Bottom) {
        return _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Top;
    }
    if (side === _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Left) {
        return _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Right;
    }
    if (side === _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Right) {
        return _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Left;
    }
    return _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].None;
}
function getSideFromVector(direction) {
    var directions = [_Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"].Left, _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"].Right, _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"].Up, _Algebra__WEBPACK_IMPORTED_MODULE_0__["Vector"].Down];
    var directionEnum = [_Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Left, _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Right, _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Top, _Collision_Side__WEBPACK_IMPORTED_MODULE_2__["Side"].Bottom];
    var max = -Number.MAX_VALUE;
    var maxIndex = -1;
    for (var i = 0; i < directions.length; i++) {
        if (directions[i].dot(direction) > max) {
            max = directions[i].dot(direction);
            maxIndex = i;
        }
    }
    return directionEnum[maxIndex];
}
/**
 * Excalibur's dynamically resizing collection
 */
var Collection = /** @class */ (function () {
    /**
     * @param initialSize  Initial size of the internal backing array
     */
    function Collection(initialSize) {
        if (initialSize === void 0) { initialSize = Collection.DefaultSize; }
        this._internalArray = null;
        this._endPointer = 0;
        this._internalArray = new Array(initialSize);
    }
    Collection.prototype._resize = function () {
        var newSize = this._internalArray.length * 2;
        var newArray = new Array(newSize);
        var count = this.count();
        for (var i = 0; i < count; i++) {
            newArray[i] = this._internalArray[i];
        }
        delete this._internalArray;
        this._internalArray = newArray;
    };
    /**
     * Push elements to the end of the collection
     */
    Collection.prototype.push = function (element) {
        if (this._endPointer === this._internalArray.length) {
            this._resize();
        }
        return (this._internalArray[this._endPointer++] = element);
    };
    /**
     * Removes elements from the end of the collection
     */
    Collection.prototype.pop = function () {
        this._endPointer = this._endPointer - 1 < 0 ? 0 : this._endPointer - 1;
        return this._internalArray[this._endPointer];
    };
    /**
     * Returns the count of the collection
     */
    Collection.prototype.count = function () {
        return this._endPointer;
    };
    /**
     * Empties the collection
     */
    Collection.prototype.clear = function () {
        this._endPointer = 0;
    };
    /**
     * Returns the size of the internal backing array
     */
    Collection.prototype.internalSize = function () {
        return this._internalArray.length;
    };
    /**
     * Returns an element at a specific index
     * @param index  Index of element to retrieve
     */
    Collection.prototype.elementAt = function (index) {
        if (index >= this.count()) {
            //Logger.getInstance().error('Invalid parameter: ' + index);
            throw new Error('Invalid index ' + index);
        }
        return this._internalArray[index];
    };
    /**
     * Inserts an element at a specific index
     * @param index  Index to insert the element
     * @param value  Element to insert
     */
    Collection.prototype.insert = function (index, value) {
        if (index >= this.count()) {
            this._resize();
        }
        return (this._internalArray[index] = value);
    };
    /**
     * Removes an element at a specific index
     * @param index  Index of element to remove
     */
    Collection.prototype.remove = function (index) {
        var count = this.count();
        if (count === 0) {
            //Logger.getInstance().error('Invalid parameter: ' + index);
            throw new Error('Invalid parameter ' + index);
        }
        // O(n) Shift
        var removed = this._internalArray[index];
        for (var i = index; i < count; i++) {
            this._internalArray[i] = this._internalArray[i + 1];
        }
        this._endPointer--;
        return removed;
    };
    /**
     * Removes an element by reference
     * @param element  Element to retrieve
     */
    Collection.prototype.removeElement = function (element) {
        var index = this._internalArray.indexOf(element);
        this.remove(index);
    };
    /**
     * Returns a array representing the collection
     */
    Collection.prototype.toArray = function () {
        return this._internalArray.slice(0, this._endPointer);
    };
    /**
     * Iterate over every element in the collection
     * @param func  Callback to call for each element passing a reference to the element and its index, returned values are ignored
     */
    Collection.prototype.forEach = function (func) {
        var i = 0, count = this.count();
        for (i; i < count; i++) {
            func.call(this, this._internalArray[i], i);
        }
    };
    /**
     * Mutate every element in the collection
     * @param func  Callback to call for each element passing a reference to the element and its index, any values returned mutate
     * the collection
     */
    Collection.prototype.map = function (func) {
        var count = this.count();
        for (var i = 0; i < count; i++) {
            this._internalArray[i] = func.call(this, this._internalArray[i], i);
        }
    };
    /**
     * Default collection size
     */
    Collection.DefaultSize = 200;
    return Collection;
}());



/***/ }),

/***/ "./Util/WebAudio.ts":
/*!**************************!*\
  !*** ./Util/WebAudio.ts ***!
  \**************************/
/*! exports provided: WebAudio */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WebAudio", function() { return WebAudio; });
/* harmony import */ var _Resources_Sound_AudioContext__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Resources/Sound/AudioContext */ "./Resources/Sound/AudioContext.ts");
/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../Promises */ "./Promises.ts");


function isLegacyWebAudioSource(source) {
    return !!source.playbackState;
}
var WebAudio = /** @class */ (function () {
    function WebAudio() {
    }
    /**
     * Play an empty sound to unlock Safari WebAudio context. Call this function
     * right after a user interaction event. Typically used by [[PauseAfterLoader]]
     * @source https://paulbakaus.com/tutorials/html5/web-audio-on-ios/
     */
    WebAudio.unlock = function () {
        var promise = new _Promises__WEBPACK_IMPORTED_MODULE_1__["Promise"]();
        if (WebAudio._unlocked || !_Resources_Sound_AudioContext__WEBPACK_IMPORTED_MODULE_0__["AudioContextFactory"].create()) {
            return promise.resolve(true);
        }
        var audioContext = _Resources_Sound_AudioContext__WEBPACK_IMPORTED_MODULE_0__["AudioContextFactory"].create();
        audioContext.resume().then(function () {
            // create empty buffer and play it
            var buffer = audioContext.createBuffer(1, 1, 22050);
            var source = audioContext.createBufferSource();
            var ended = false;
            source.buffer = buffer;
            source.connect(audioContext.destination);
            source.onended = function () { return (ended = true); };
            if (source.noteOn) {
                // deprecated
                source.noteOn(0);
            }
            else {
                source.start(0);
            }
            // by checking the play state after some time, we know if we're really unlocked
            setTimeout(function () {
                if (isLegacyWebAudioSource(source)) {
                    if (source.playbackState === source.PLAYING_STATE || source.playbackState === source.FINISHED_STATE) {
                        WebAudio._unlocked = true;
                    }
                }
                else {
                    if (audioContext.currentTime > 0 || ended) {
                        WebAudio._unlocked = true;
                    }
                }
            }, 0);
            promise.resolve();
        }, function () {
            promise.reject(false);
        });
        return promise;
    };
    WebAudio.isUnlocked = function () {
        return this._unlocked;
    };
    WebAudio._unlocked = false;
    return WebAudio;
}());



/***/ }),

/***/ "./index.ts":
/*!******************!*\
  !*** ./index.ts ***!
  \******************/
/*! exports provided: EX_VERSION, Actor, CollisionType, Label, FontStyle, FontUnit, TextAlign, BaseAlign, Particle, ParticleEmitter, EmitterType, TileMap, Cell, TileSprite, Events, Input, Traits, Util, DisplayMode, ScrollPreventionMode, Engine, Vector, Ray, Line, Projection, GlobalCoordinates, StrategyContainer, Axis, LockCameraToActorStrategy, LockCameraToActorAxisStrategy, ElasticToActorStrategy, RadiusAroundActorStrategy, BaseCamera, Class, Configurable, Debug, FrameStats, PhysicsStats, EventDispatcher, MediaEvent, NativeSoundEvent, GameEvent, KillEvent, PreKillEvent, PostKillEvent, GameStartEvent, GameStopEvent, PreDrawEvent, PostDrawEvent, PreDebugDrawEvent, PostDebugDrawEvent, PreUpdateEvent, PostUpdateEvent, PreFrameEvent, PostFrameEvent, GamepadConnectEvent, GamepadDisconnectEvent, GamepadButtonEvent, GamepadAxisEvent, SubscribeEvent, UnsubscribeEvent, VisibleEvent, HiddenEvent, PreCollisionEvent, PostCollisionEvent, CollisionStartEvent, CollisionEndEvent, InitializeEvent, ActivateEvent, DeactivateEvent, ExitViewPortEvent, EnterViewPortEvent, EnterTriggerEvent, ExitTriggerEvent, Group, Loader, PauseAfterLoader, CollisionResolutionStrategy, BroadphaseStrategy, Integrator, Physics, PromiseState, Promise, Scene, Timer, Trigger, UIActor, Actions, Internal, Animation, Sprite, SpriteSheet, SpriteFont, Effects, obsolete, Detector, CullingBox, EasingFunctions, LogLevel, Logger, ConsoleAppender, ScreenAppender, SortedList, BinaryTreeNode, MockedElement, ActionContext, RotationType, Body, BoundingBox, CircleArea, CollisionContact, CollisionJumpTable, TreeNode, DynamicTree, DynamicTreeCollisionBroadphase, EdgeArea, NaiveCollisionBroadphase, Pair, PolygonArea, Side, Color, Polygon, ExResponse, PerlinGenerator, PerlinDrawer2D, Random, ColorBlindness, ColorBlindCorrector, Resource, Texture, Sound, AudioContextFactory, AudioInstanceFactory, AudioInstance, AudioTagInstance, WebAudioInstance */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EX_VERSION", function() { return EX_VERSION; });
/* harmony import */ var _Engine__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Engine */ "./Engine.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DisplayMode", function() { return _Engine__WEBPACK_IMPORTED_MODULE_0__["DisplayMode"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ScrollPreventionMode", function() { return _Engine__WEBPACK_IMPORTED_MODULE_0__["ScrollPreventionMode"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Engine", function() { return _Engine__WEBPACK_IMPORTED_MODULE_0__["Engine"]; });

/* harmony import */ var _Actor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Actor */ "./Actor.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Actor", function() { return _Actor__WEBPACK_IMPORTED_MODULE_1__["Actor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CollisionType", function() { return _Actor__WEBPACK_IMPORTED_MODULE_1__["CollisionType"]; });

/* harmony import */ var _Algebra__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./Algebra */ "./Algebra.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Vector", function() { return _Algebra__WEBPACK_IMPORTED_MODULE_2__["Vector"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Ray", function() { return _Algebra__WEBPACK_IMPORTED_MODULE_2__["Ray"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Line", function() { return _Algebra__WEBPACK_IMPORTED_MODULE_2__["Line"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Projection", function() { return _Algebra__WEBPACK_IMPORTED_MODULE_2__["Projection"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GlobalCoordinates", function() { return _Algebra__WEBPACK_IMPORTED_MODULE_2__["GlobalCoordinates"]; });

/* harmony import */ var _Camera__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./Camera */ "./Camera.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StrategyContainer", function() { return _Camera__WEBPACK_IMPORTED_MODULE_3__["StrategyContainer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Axis", function() { return _Camera__WEBPACK_IMPORTED_MODULE_3__["Axis"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LockCameraToActorStrategy", function() { return _Camera__WEBPACK_IMPORTED_MODULE_3__["LockCameraToActorStrategy"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LockCameraToActorAxisStrategy", function() { return _Camera__WEBPACK_IMPORTED_MODULE_3__["LockCameraToActorAxisStrategy"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ElasticToActorStrategy", function() { return _Camera__WEBPACK_IMPORTED_MODULE_3__["ElasticToActorStrategy"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RadiusAroundActorStrategy", function() { return _Camera__WEBPACK_IMPORTED_MODULE_3__["RadiusAroundActorStrategy"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BaseCamera", function() { return _Camera__WEBPACK_IMPORTED_MODULE_3__["BaseCamera"]; });

/* harmony import */ var _Class__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./Class */ "./Class.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Class", function() { return _Class__WEBPACK_IMPORTED_MODULE_4__["Class"]; });

/* harmony import */ var _Configurable__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./Configurable */ "./Configurable.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Configurable", function() { return _Configurable__WEBPACK_IMPORTED_MODULE_5__["Configurable"]; });

/* harmony import */ var _Debug__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./Debug */ "./Debug.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Debug", function() { return _Debug__WEBPACK_IMPORTED_MODULE_6__["Debug"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FrameStats", function() { return _Debug__WEBPACK_IMPORTED_MODULE_6__["FrameStats"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PhysicsStats", function() { return _Debug__WEBPACK_IMPORTED_MODULE_6__["PhysicsStats"]; });

/* harmony import */ var _EventDispatcher__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./EventDispatcher */ "./EventDispatcher.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EventDispatcher", function() { return _EventDispatcher__WEBPACK_IMPORTED_MODULE_7__["EventDispatcher"]; });

/* harmony import */ var _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./Events/MediaEvents */ "./Events/MediaEvents.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MediaEvent", function() { return _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_8__["MediaEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NativeSoundEvent", function() { return _Events_MediaEvents__WEBPACK_IMPORTED_MODULE_8__["NativeSoundEvent"]; });

/* harmony import */ var _Events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./Events */ "./Events.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GameEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["GameEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "KillEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["KillEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PreKillEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PreKillEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PostKillEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PostKillEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GameStartEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["GameStartEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GameStopEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["GameStopEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PreDrawEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PreDrawEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PostDrawEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PostDrawEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PreDebugDrawEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PreDebugDrawEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PostDebugDrawEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PostDebugDrawEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PreUpdateEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PreUpdateEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PostUpdateEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PostUpdateEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PreFrameEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PreFrameEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PostFrameEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PostFrameEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GamepadConnectEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["GamepadConnectEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GamepadDisconnectEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["GamepadDisconnectEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GamepadButtonEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["GamepadButtonEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "GamepadAxisEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["GamepadAxisEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SubscribeEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["SubscribeEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UnsubscribeEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["UnsubscribeEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VisibleEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["VisibleEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "HiddenEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["HiddenEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PreCollisionEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PreCollisionEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PostCollisionEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["PostCollisionEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CollisionStartEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["CollisionStartEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CollisionEndEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["CollisionEndEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "InitializeEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["InitializeEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActivateEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["ActivateEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DeactivateEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["DeactivateEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExitViewPortEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["ExitViewPortEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EnterViewPortEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["EnterViewPortEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EnterTriggerEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["EnterTriggerEvent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExitTriggerEvent", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__["ExitTriggerEvent"]; });

/* harmony import */ var _Group__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Group */ "./Group.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Group", function() { return _Group__WEBPACK_IMPORTED_MODULE_10__["Group"]; });

/* harmony import */ var _Label__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./Label */ "./Label.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Label", function() { return _Label__WEBPACK_IMPORTED_MODULE_11__["Label"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FontStyle", function() { return _Label__WEBPACK_IMPORTED_MODULE_11__["FontStyle"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FontUnit", function() { return _Label__WEBPACK_IMPORTED_MODULE_11__["FontUnit"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextAlign", function() { return _Label__WEBPACK_IMPORTED_MODULE_11__["TextAlign"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BaseAlign", function() { return _Label__WEBPACK_IMPORTED_MODULE_11__["BaseAlign"]; });

/* harmony import */ var _Loader__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./Loader */ "./Loader.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Loader", function() { return _Loader__WEBPACK_IMPORTED_MODULE_12__["Loader"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PauseAfterLoader", function() { return _Loader__WEBPACK_IMPORTED_MODULE_12__["PauseAfterLoader"]; });

/* harmony import */ var _Particles__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Particles */ "./Particles.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Particle", function() { return _Particles__WEBPACK_IMPORTED_MODULE_13__["Particle"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ParticleEmitter", function() { return _Particles__WEBPACK_IMPORTED_MODULE_13__["ParticleEmitter"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EmitterType", function() { return _Particles__WEBPACK_IMPORTED_MODULE_13__["EmitterType"]; });

/* harmony import */ var _Physics__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./Physics */ "./Physics.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CollisionResolutionStrategy", function() { return _Physics__WEBPACK_IMPORTED_MODULE_14__["CollisionResolutionStrategy"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BroadphaseStrategy", function() { return _Physics__WEBPACK_IMPORTED_MODULE_14__["BroadphaseStrategy"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Integrator", function() { return _Physics__WEBPACK_IMPORTED_MODULE_14__["Integrator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Physics", function() { return _Physics__WEBPACK_IMPORTED_MODULE_14__["Physics"]; });

/* harmony import */ var _Promises__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./Promises */ "./Promises.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PromiseState", function() { return _Promises__WEBPACK_IMPORTED_MODULE_15__["PromiseState"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Promise", function() { return _Promises__WEBPACK_IMPORTED_MODULE_15__["Promise"]; });

/* harmony import */ var _Scene__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./Scene */ "./Scene.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Scene", function() { return _Scene__WEBPACK_IMPORTED_MODULE_16__["Scene"]; });

/* harmony import */ var _TileMap__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./TileMap */ "./TileMap.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TileMap", function() { return _TileMap__WEBPACK_IMPORTED_MODULE_17__["TileMap"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Cell", function() { return _TileMap__WEBPACK_IMPORTED_MODULE_17__["Cell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TileSprite", function() { return _TileMap__WEBPACK_IMPORTED_MODULE_17__["TileSprite"]; });

/* harmony import */ var _Timer__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./Timer */ "./Timer.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Timer", function() { return _Timer__WEBPACK_IMPORTED_MODULE_18__["Timer"]; });

/* harmony import */ var _Trigger__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./Trigger */ "./Trigger.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Trigger", function() { return _Trigger__WEBPACK_IMPORTED_MODULE_19__["Trigger"]; });

/* harmony import */ var _UIActor__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./UIActor */ "./UIActor.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UIActor", function() { return _UIActor__WEBPACK_IMPORTED_MODULE_20__["UIActor"]; });

/* harmony import */ var _Actions_Index__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./Actions/Index */ "./Actions/Index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Actions", function() { return _Actions_Index__WEBPACK_IMPORTED_MODULE_21__["Actions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Internal", function() { return _Actions_Index__WEBPACK_IMPORTED_MODULE_21__["Internal"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionContext", function() { return _Actions_Index__WEBPACK_IMPORTED_MODULE_21__["ActionContext"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RotationType", function() { return _Actions_Index__WEBPACK_IMPORTED_MODULE_21__["RotationType"]; });

/* harmony import */ var _Collision_Index__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./Collision/Index */ "./Collision/Index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Body", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["Body"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BoundingBox", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["BoundingBox"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CircleArea", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["CircleArea"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CollisionContact", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["CollisionContact"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CollisionJumpTable", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["CollisionJumpTable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TreeNode", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["TreeNode"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DynamicTree", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["DynamicTree"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DynamicTreeCollisionBroadphase", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["DynamicTreeCollisionBroadphase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EdgeArea", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["EdgeArea"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NaiveCollisionBroadphase", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["NaiveCollisionBroadphase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Pair", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["Pair"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PolygonArea", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["PolygonArea"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Side", function() { return _Collision_Index__WEBPACK_IMPORTED_MODULE_22__["Side"]; });

/* harmony import */ var _Drawing_Index__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./Drawing/Index */ "./Drawing/Index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Animation", function() { return _Drawing_Index__WEBPACK_IMPORTED_MODULE_23__["Animation"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Sprite", function() { return _Drawing_Index__WEBPACK_IMPORTED_MODULE_23__["Sprite"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SpriteSheet", function() { return _Drawing_Index__WEBPACK_IMPORTED_MODULE_23__["SpriteSheet"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SpriteFont", function() { return _Drawing_Index__WEBPACK_IMPORTED_MODULE_23__["SpriteFont"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Effects", function() { return _Drawing_Index__WEBPACK_IMPORTED_MODULE_23__["Effects"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Color", function() { return _Drawing_Index__WEBPACK_IMPORTED_MODULE_23__["Color"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Polygon", function() { return _Drawing_Index__WEBPACK_IMPORTED_MODULE_23__["Polygon"]; });

/* harmony import */ var _Interfaces_Index__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./Interfaces/Index */ "./Interfaces/Index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExResponse", function() { return _Interfaces_Index__WEBPACK_IMPORTED_MODULE_24__["ExResponse"]; });

/* harmony import */ var _Math_Index__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./Math/Index */ "./Math/Index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PerlinGenerator", function() { return _Math_Index__WEBPACK_IMPORTED_MODULE_25__["PerlinGenerator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PerlinDrawer2D", function() { return _Math_Index__WEBPACK_IMPORTED_MODULE_25__["PerlinDrawer2D"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Random", function() { return _Math_Index__WEBPACK_IMPORTED_MODULE_25__["Random"]; });

/* harmony import */ var _PostProcessing_Index__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./PostProcessing/Index */ "./PostProcessing/Index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ColorBlindness", function() { return _PostProcessing_Index__WEBPACK_IMPORTED_MODULE_26__["ColorBlindness"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ColorBlindCorrector", function() { return _PostProcessing_Index__WEBPACK_IMPORTED_MODULE_26__["ColorBlindCorrector"]; });

/* harmony import */ var _Resources_Index__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./Resources/Index */ "./Resources/Index.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Resource", function() { return _Resources_Index__WEBPACK_IMPORTED_MODULE_27__["Resource"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Texture", function() { return _Resources_Index__WEBPACK_IMPORTED_MODULE_27__["Texture"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Sound", function() { return _Resources_Index__WEBPACK_IMPORTED_MODULE_27__["Sound"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioContextFactory", function() { return _Resources_Index__WEBPACK_IMPORTED_MODULE_27__["AudioContextFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioInstanceFactory", function() { return _Resources_Index__WEBPACK_IMPORTED_MODULE_27__["AudioInstanceFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioInstance", function() { return _Resources_Index__WEBPACK_IMPORTED_MODULE_27__["AudioInstance"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AudioTagInstance", function() { return _Resources_Index__WEBPACK_IMPORTED_MODULE_27__["AudioTagInstance"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "WebAudioInstance", function() { return _Resources_Index__WEBPACK_IMPORTED_MODULE_27__["WebAudioInstance"]; });

/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "Events", function() { return _Events__WEBPACK_IMPORTED_MODULE_9__; });
/* harmony import */ var _Input_Index__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./Input/Index */ "./Input/Index.ts");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "Input", function() { return _Input_Index__WEBPACK_IMPORTED_MODULE_28__; });
/* harmony import */ var _Traits_Index__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./Traits/Index */ "./Traits/Index.ts");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "Traits", function() { return _Traits_Index__WEBPACK_IMPORTED_MODULE_29__; });
/* harmony import */ var _Util_Index__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./Util/Index */ "./Util/Index.ts");
/* harmony reexport (module object) */ __webpack_require__.d(__webpack_exports__, "Util", function() { return _Util_Index__WEBPACK_IMPORTED_MODULE_30__; });
/* harmony import */ var _Util_Decorators__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./Util/Decorators */ "./Util/Decorators.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "obsolete", function() { return _Util_Decorators__WEBPACK_IMPORTED_MODULE_31__["obsolete"]; });

/* harmony import */ var _Util_Detector__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./Util/Detector */ "./Util/Detector.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Detector", function() { return _Util_Detector__WEBPACK_IMPORTED_MODULE_32__["Detector"]; });

/* harmony import */ var _Util_CullingBox__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./Util/CullingBox */ "./Util/CullingBox.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CullingBox", function() { return _Util_CullingBox__WEBPACK_IMPORTED_MODULE_33__["CullingBox"]; });

/* harmony import */ var _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./Util/EasingFunctions */ "./Util/EasingFunctions.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EasingFunctions", function() { return _Util_EasingFunctions__WEBPACK_IMPORTED_MODULE_34__["EasingFunctions"]; });

/* harmony import */ var _Util_Log__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./Util/Log */ "./Util/Log.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogLevel", function() { return _Util_Log__WEBPACK_IMPORTED_MODULE_35__["LogLevel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Logger", function() { return _Util_Log__WEBPACK_IMPORTED_MODULE_35__["Logger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConsoleAppender", function() { return _Util_Log__WEBPACK_IMPORTED_MODULE_35__["ConsoleAppender"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ScreenAppender", function() { return _Util_Log__WEBPACK_IMPORTED_MODULE_35__["ScreenAppender"]; });

/* harmony import */ var _Util_SortedList__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./Util/SortedList */ "./Util/SortedList.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SortedList", function() { return _Util_SortedList__WEBPACK_IMPORTED_MODULE_36__["SortedList"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BinaryTreeNode", function() { return _Util_SortedList__WEBPACK_IMPORTED_MODULE_36__["BinaryTreeNode"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MockedElement", function() { return _Util_SortedList__WEBPACK_IMPORTED_MODULE_36__["MockedElement"]; });

/**
 * The current Excalibur version string
 * @description `process.env.__EX_VERSION` gets replaced by Webpack on build
 */
var EX_VERSION = "0.19.1";
// This file is used as the bundle entrypoint and exports everything
// that will be exposed as the `ex` global variable.




























// ex.Events namespace


// ex.Input namespace


// ex.Traits namespace


// ex.Util namespaces










/***/ })

/******/ });
});
//# sourceMappingURL=excalibur.js.map