import type { Entity } from '../../EntityComponentSystem';
import type { Vector } from '../../Math';
import type { Action } from '../Action';
export interface CurveToOptions {
    /**
     * Bezier Curve in world coordinates to animate towards
     *
     * The start control point is assumed to be the actor's current position
     */
    controlPoints: [control1: Vector, control2: Vector, end: Vector];
    /**
     * Total duration for the action to run
     */
    duration: number;
    /**
     * Dynamic mode will speed up/slow down depending on the curve
     *
     * Uniform mode will animate at a consistent velocity across the curve
     *
     * Default: 'dynamic'
     */
    mode?: 'dynamic' | 'uniform';
    /**
     * Quality when sampling uniform points on the curve. Samples = 4 * quality;
     *
     * For bigger 'uniform' curves you may want to increase quality
     *
     * Default 4
     */
    quality?: number;
}
export declare class CurveTo implements Action {
    id: number;
    private _curve;
    private _durationMs;
    private _entity;
    private _tx;
    private _currentMs;
    private _started;
    private _stopped;
    private _mode;
    constructor(entity: Entity, options: CurveToOptions);
    update(elapsed: number): void;
    isComplete(entity: Entity): boolean;
    reset(): void;
    stop(): void;
}
