import { Vector } from '../../Math/vector';
import type { Action } from '../Action';
import type { Entity } from '../../EntityComponentSystem/Entity';
export interface ScaleToOptions {
    /**
     * Absolute scale to change to
     */
    scale: Vector;
    /**
     * Duration to take in milliseconds
     */
    duration: number;
}
/**
 *
 */
export declare function isScaleToOptions(x: any): x is ScaleToOptions;
export declare class ScaleToWithOptions implements Action {
    entity: Entity;
    id: number;
    private _durationMs;
    private _tx;
    private _started;
    private _currentMs;
    private _stopped;
    private _motion;
    private _endScale;
    private _startScale;
    constructor(entity: Entity, options: ScaleToOptions);
    update(elapsed: number): void;
    isComplete(): boolean;
    stop(): void;
    reset(): void;
}
export declare class ScaleTo implements Action {
    id: number;
    private _tx;
    private _motion;
    x: number;
    y: number;
    private _startX;
    private _startY;
    private _endX;
    private _endY;
    private _speedX;
    private _speedY;
    private _distanceX;
    private _distanceY;
    private _started;
    private _stopped;
    constructor(entity: Entity, scaleX: number, scaleY: number, speedX: number, speedY: number);
    update(elapsed: number): void;
    isComplete(): boolean;
    stop(): void;
    reset(): void;
}
