import type { Color } from '../../Color';
import type { ExcaliburGraphicsContext } from '../../Graphics/Context/ExcaliburGraphicsContext';
import type { LineSegment } from '../../Math/line-segment';
import { Projection } from '../../Math/projection';
import type { Ray } from '../../Math/ray';
import { Vector } from '../../Math/vector';
import { BoundingBox } from '../BoundingBox';
import type { CollisionContact } from '../Detection/CollisionContact';
import type { RayCastHit } from '../Detection/RayCastHit';
import { Collider } from './Collider';
import type { Transform } from '../../Math/transform';
export declare class CompositeCollider extends Collider {
    private _transform;
    private _collisionProcessor;
    private _dynamicAABBTree;
    private _colliders;
    private _compositeStrategy?;
    /**
     * Treat composite collider's member colliders as either separate colliders for the purposes of onCollisionStart/onCollision
     * or as a single collider together.
     *
     * This property can be overridden on individual {@apilink CompositeColliders}.
     *
     * For composites without gaps or small groups of colliders, you probably want 'together'
     *
     * For composites with deliberate gaps, like a platforming level layout, you probably want 'separate'
     *
     * Default is 'together' if unset
     */
    set compositeStrategy(value: 'separate' | 'together');
    get compositeStrategy(): 'separate' | 'together';
    constructor(colliders: Collider[]);
    clearColliders(): void;
    addCollider(collider: Collider): void;
    removeCollider(collider: Collider): void;
    getColliders(): Collider[];
    get worldPos(): Vector;
    get center(): Vector;
    get bounds(): BoundingBox;
    get localBounds(): BoundingBox;
    get axes(): Vector[];
    getFurthestPoint(direction: Vector): Vector;
    getInertia(mass: number): number;
    collide(other: Collider): CollisionContact[];
    getClosestLineBetween(other: Collider): LineSegment;
    contains(point: Vector): boolean;
    rayCast(ray: Ray, max?: number): RayCastHit | null;
    project(axis: Vector): Projection;
    update(transform: Transform): void;
    debug(ex: ExcaliburGraphicsContext, color: Color, options?: {
        lineWidth: number;
        pointSize: number;
    }): void;
    clone(): Collider;
}
