import { LineSegment } from '../../Math/line-segment';
import type { Vector } from '../../Math/vector';
import type { Collider } from './Collider';
import type { CircleCollider } from './CircleCollider';
import type { PolygonCollider } from './PolygonCollider';
import { Pool } from '../../Util/Pool';
/**
 * Specific information about a contact and it's separation
 */
export declare class SeparationInfo {
    /**
     * Collider A
     */
    collider: Collider;
    /**
     * Signed value (negative means overlap, positive no overlap)
     */
    separation: number;
    /**
     * Axis of separation from the collider's perspective
     */
    axis: Vector;
    /**
     * Local axis of separation from the collider's perspective
     */
    localAxis?: Vector;
    /**
     * Side of separation (reference) from the collider's perspective
     */
    side?: LineSegment;
    /**
     * Local side of separation (reference) from the collider's perspective
     */
    localSide?: LineSegment;
    /**
     * Index of the separation side (reference) from the collider's perspective
     */
    sideId?: number;
    /**
     * Point on collider B (incident point)
     */
    point: Vector;
    /**
     * Local point on collider B (incident point)
     */
    localPoint?: Vector;
}
export declare class SeparatingAxis {
    static SeparationPool: Pool<SeparationInfo>;
    private static _ZERO;
    private static _SCRATCH_POINT;
    private static _SCRATCH_SUB_POINT;
    private static _SCRATCH_NORMAL;
    private static _SCRATCH_MATRIX;
    static findPolygonPolygonSeparation(polyA: PolygonCollider, polyB: PolygonCollider): SeparationInfo;
    static findCirclePolygonSeparation(circle: CircleCollider, polygon: PolygonCollider): Vector | null;
    static findPolygonPolygonSeparationDegenerate(polyA: PolygonCollider, polyB: PolygonCollider): SeparationInfo;
}
