import type { ExcaliburGraphicsContext } from '../../Graphics';
import { BoundingBox } from '../BoundingBox';
export interface QuadTreeItem {
    bounds: BoundingBox;
}
export interface QuadTreeOptions {
    maxDepth?: number;
    capacity: number;
    level?: number;
}
/**
 * QuadTree spatial data structure. Useful for quickly retrieving all objects that might
 * be in a specific location.
 */
export declare class QuadTree<TItem extends QuadTreeItem> {
    bounds: BoundingBox;
    options?: QuadTreeOptions;
    private _defaultOptions;
    halfWidth: number;
    halfHeight: number;
    items: TItem[];
    private _isDivided;
    topLeft: QuadTree<TItem> | null;
    topRight: QuadTree<TItem> | null;
    bottomLeft: QuadTree<TItem> | null;
    bottomRight: QuadTree<TItem> | null;
    constructor(bounds: BoundingBox, options?: QuadTreeOptions);
    /**
     * Splits the quad tree one level deeper
     */
    private _split;
    private _insertIntoSubNodes;
    /**
     * Insert an item to be tracked in the QuadTree
     * @param item
     */
    insert(item: TItem): void;
    /**
     * Remove a tracked item in the QuadTree
     * @param item
     */
    remove(item: TItem): void;
    /**
     * Query the structure for all objects that intersect the bounding box
     * @param boundingBox
     * @returns items
     */
    query(boundingBox: BoundingBox): TItem[];
    clear(): void;
    getAllItems(): TItem[];
    getTreeDepth(): number;
    debug(ctx: ExcaliburGraphicsContext): void;
}
