import type { ExcaliburGraphicsContext } from '../../Graphics/Context/ExcaliburGraphicsContext';
import type { Vector } from '../../Math/vector';
import { BoundingBox } from '../BoundingBox';
export declare class HashGridProxy<T extends {
    bounds: BoundingBox;
}> {
    object: T;
    id: number;
    /**
     * left bounds x hash coordinate
     */
    leftX: number;
    /**
     * right bounds x hash coordinate
     */
    rightX: number;
    /**
     * bottom bounds y hash coordinate
     */
    bottomY: number;
    /**
     * top bounds y hash coordinate
     */
    topY: number;
    bounds: BoundingBox;
    cells: HashGridCell<T>[];
    hasZeroBounds: boolean;
    /**
     * Grid size in pixels
     */
    readonly gridSize: number;
    constructor(object: T, gridSize: number);
    /**
     * Has the hashed bounds changed
     */
    hasChanged(): boolean;
    /**
     * Clears all collider references
     */
    clear(): void;
    /**
     * Update bounds of the proxy
     */
    updateBounds(): void;
    /**
     * Updates the hashed bounds coordinates
     */
    update(): void;
}
export declare class HashGridCell<TObject extends {
    bounds: BoundingBox;
}, TProxy extends HashGridProxy<TObject> = HashGridProxy<TObject>> {
    proxies: TProxy[];
    key: string;
    x: number;
    y: number;
    configure(x: number, y: number): void;
    static calculateHashKey(x: number, y: number): string;
}
export declare class SparseHashGrid<TObject extends {
    bounds: BoundingBox;
}, TProxy extends HashGridProxy<TObject> = HashGridProxy<TObject>> {
    readonly gridSize: number;
    readonly sparseHashGrid: Map<string, HashGridCell<TObject, TProxy>>;
    readonly objectToProxy: Map<TObject, TProxy>;
    bounds: BoundingBox;
    private _hashGridCellPool;
    private _buildProxy;
    constructor(options: {
        size: number;
        proxyFactory?: (object: TObject, gridSize: number) => TProxy;
    });
    query(point: Vector): TObject[];
    query(bounds: BoundingBox): TObject[];
    get(xCoord: number, yCoord: number): HashGridCell<TObject>;
    private _insert;
    private _remove;
    track(target: TObject): void;
    untrack(target: TObject): void;
    update(targets: TObject[]): number;
    debug(ex: ExcaliburGraphicsContext, elapsed: number): void;
}
