import type { Entity, Query, World } from '../EntityComponentSystem';
import { MotionComponent } from '../EntityComponentSystem/Components/MotionComponent';
import { TransformComponent } from '../EntityComponentSystem/Components/TransformComponent';
import { System, SystemType } from '../EntityComponentSystem/System';
import type { PhysicsWorld } from './PhysicsWorld';
export declare class MotionSystem extends System {
    world: World;
    physics: PhysicsWorld;
    static priority: -5;
    systemType: SystemType;
    private _physicsConfigDirty;
    query: Query<typeof TransformComponent | typeof MotionComponent>;
    constructor(world: World, physics: PhysicsWorld);
    update(elapsed: number): void;
    captureOldTransformWithChildren(entity: Entity): void;
}
