import type { Scene } from '../Scene';
import type { Query, World } from '../EntityComponentSystem';
import { TransformComponent } from '../EntityComponentSystem';
import { System, SystemType } from '../EntityComponentSystem/System';
export declare class DebugSystem extends System {
    world: World;
    static priority: number;
    readonly systemType = SystemType.Draw;
    private _graphicsContext;
    private _collisionSystem;
    private _camera;
    private _engine;
    query: Query<typeof TransformComponent>;
    constructor(world: World);
    initialize(world: World, scene: Scene): void;
    update(): void;
    postupdate(engine: Scene<unknown>, elapsed: number): void;
    /**
     * This applies the current entity transform to the graphics context
     * @param entity
     */
    private _applyTransform;
    /**
     * Applies the current camera transform if in world coordinates
     * @param transform
     */
    private _pushCameraTransform;
    /**
     * Resets the current camera transform if in world coordinates
     * @param transform
     */
    private _popCameraTransform;
}
