import { Entity } from './Entity';
import type { World } from './World';
import type { Scene } from '../Scene';
export declare class EntityManager {
    private _world;
    entities: Entity[];
    _entityIndex: {
        [entityId: string]: Entity;
    };
    private _childAddedHandlerMap;
    private _childRemovedHandlerMap;
    constructor(_world: World);
    /**
     * Runs the entity lifecycle
     * @param scene
     * @param elapsed
     */
    updateEntities(scene: Scene, elapsed: number): void;
    findEntitiesForRemoval(): void;
    private _createChildAddedHandler;
    private _createChildRemovedHandler;
    /**
     * Adds an entity to be tracked by the EntityManager
     * @param entity
     */
    addEntity(entity: Entity): void;
    removeEntity(entity: Entity, deferred?: boolean): void;
    removeEntity(id: number, deferred?: boolean): void;
    private _entitiesToRemove;
    processEntityRemovals(): void;
    processComponentRemovals(): void;
    getById(id: number): Entity | undefined;
    getByName(name: string): Entity[];
    clear(): void;
}
