import type { SystemType } from './System';
import { System } from './System';
import type { Scene } from '../Scene';
import type { World } from './World';
export interface SystemCtor<T extends System> {
    new (...args: any[]): T;
}
/**
 *
 */
export declare function isSystemConstructor(x: any): x is SystemCtor<System>;
/**
 * The SystemManager is responsible for keeping track of all systems in a scene.
 * Systems are scene specific
 */
export declare class SystemManager {
    private _world;
    /**
     * List of systems, to add a new system call {@apilink SystemManager.addSystem}
     */
    systems: System[];
    initialized: boolean;
    constructor(_world: World);
    /**
     * Get a system registered in the manager by type
     * @param systemType
     */
    get<T extends System>(systemType: SystemCtor<T>): T | null;
    /**
     * Adds a system to the manager, it will now be updated every frame
     * @param systemOrCtor
     */
    addSystem(systemOrCtor: SystemCtor<System> | System): void;
    /**
     * Removes a system from the manager, it will no longer be updated
     * @param system
     */
    removeSystem(system: System): void;
    /**
     * Initialize all systems in the manager
     *
     * Systems added after initialize() will be initialized on add
     */
    initialize(): void;
    /**
     * Updates all systems
     * @param type whether this is an update or draw system
     * @param scene context reference
     * @param elapsed time in milliseconds
     */
    updateSystems(type: SystemType, scene: Scene, elapsed: number): void;
    clear(): void;
}
