import { Observable } from '../Util/Observable';
import type { Entity } from './Entity';
export declare class TagQuery<TKnownTags extends string = never> {
    readonly requiredTags: TKnownTags[];
    readonly id: string;
    tags: Set<TKnownTags>;
    entities: Entity<any>[];
    /**
     * This fires right after the component is added
     */
    entityAdded$: Observable<Entity<any>>;
    /**
     * This fires right before the component is actually removed from the entity, it will still be available for cleanup purposes
     */
    entityRemoved$: Observable<Entity<any>>;
    constructor(requiredTags: TKnownTags[]);
    static createId(requiredComponents: string[]): string;
    checkAndAdd(entity: Entity): boolean;
    removeEntity(entity: Entity): void;
    /**
     * Returns a list of entities that match the query
     * @param sort Optional sorting function to sort entities returned from the query
     */
    getEntities(sort?: (a: Entity, b: Entity) => number): Entity<any>[];
}
