export interface GarbageCollectionOptions {
    /**
     * Textures that aren't drawn after a certain number of milliseconds are unloaded from the GPU
     * Default 60_000 ms
     */
    textureCollectInterval?: number;
}
export declare const DefaultGarbageCollectionOptions: GarbageCollectionOptions;
export interface GarbageCollectorOptions {
    /**
     * Returns a timestamp in milliseconds representing now
     */
    getTimestamp: () => number;
}
export declare class GarbageCollector {
    options: GarbageCollectorOptions;
    private _collectHandle;
    private _running;
    private _collectionMap;
    private _collectors;
    constructor(options: GarbageCollectorOptions);
    /**
     *
     * @param type Resource type
     * @param timeoutInterval If resource type exceeds interval in milliseconds collect() is called
     * @param collect Collection implementation, returns true if collected
     */
    registerCollector(type: string, timeoutInterval: number, collect: (resource: any) => boolean): void;
    /**
     * Add a resource to be tracked for collection
     * @param type
     * @param resource
     */
    addCollectableResource(type: string, resource: any): void;
    /**
     * Update the resource last used timestamp preventing collection
     * @param resource
     */
    touch(resource: any): void;
    /**
     * Runs the collection loop to cleanup any stale resources given the registered collect handlers
     */
    collectStaleResources: (deadline?: IdleDeadline) => void;
    /**
     * Force collect all resources, useful for shutting down a game
     * or if you know that you will not use anything you've allocated before now
     */
    forceCollectAll(): void;
    running(): boolean;
    /**
     * Starts the garbage collection loop
     */
    start(): void;
    /**
     * Stops the garbage collection loop
     */
    stop(): void;
}
