import type { RasterOptions } from './Raster';
import { Raster } from './Raster';
export interface CircleOptions {
    radius: number;
}
/**
 * A circle {@apilink Graphic} for drawing circles to the {@apilink ExcaliburGraphicsContext}
 *
 * Circles default to {@apilink ImageFiltering.Blended}
 */
export declare class Circle extends Raster {
    private _radius;
    get radius(): number;
    set radius(value: number);
    constructor(options: RasterOptions & CircleOptions);
    clone(): Circle;
    execute(ctx: CanvasRenderingContext2D): void;
}
