import type { ExcaliburGraphicsContext, LineGraphicsOptions, RectGraphicsOptions, PointGraphicsOptions, ExcaliburGraphicsContextOptions, DebugDraw, HTMLImageSource } from './ExcaliburGraphicsContext';
import { Matrix } from '../../Math/matrix';
import { TransformStack } from './transform-stack';
import type { Vector } from '../../Math/vector';
import { Color } from '../../Color';
import { StateStack } from './state-stack';
import type { Resolution } from '../../Screen';
import type { PostProcessor } from '../PostProcessor/PostProcessor';
import { TextureLoader } from './texture-loader';
import type { RendererPlugin } from './renderer';
import type { AffineMatrix } from '../../Math/affine-matrix';
import type { MaterialOptions } from './material';
import { Material } from './material';
import type { ShaderOptions } from './shader';
import { Shader } from './shader';
import type { GarbageCollector } from '../../GarbageCollector';
export declare const pixelSnapEpsilon = 0.0001;
declare class ExcaliburGraphicsContextWebGLDebug implements DebugDraw {
    private _webglCtx;
    private _debugText;
    constructor(_webglCtx: ExcaliburGraphicsContextWebGL);
    /**
     * Draw a debugging rectangle to the context
     * @param x
     * @param y
     * @param width
     * @param height
     */
    drawRect(x: number, y: number, width: number, height: number, rectOptions?: RectGraphicsOptions): void;
    /**
     * Draw a debugging line to the context
     * @param start
     * @param end
     * @param lineOptions
     */
    drawLine(start: Vector, end: Vector, lineOptions?: LineGraphicsOptions): void;
    /**
     * Draw a debugging point to the context
     * @param point
     * @param pointOptions
     */
    drawPoint(point: Vector, pointOptions?: PointGraphicsOptions): void;
    drawText(text: string, pos: Vector): void;
}
export interface WebGLGraphicsContextInfo {
    transform: TransformStack;
    state: StateStack;
    ortho: Matrix;
    context: ExcaliburGraphicsContextWebGL;
}
export interface ExcaliburGraphicsContextWebGLOptions extends ExcaliburGraphicsContextOptions {
    context?: WebGL2RenderingContext;
    garbageCollector?: {
        garbageCollector: GarbageCollector;
        collectionInterval: number;
    };
    handleContextLost?: (e: Event) => void;
    handleContextRestored?: (e: Event) => void;
}
export declare class ExcaliburGraphicsContextWebGL implements ExcaliburGraphicsContext {
    private _logger;
    private _renderers;
    private _lazyRenderersFactory;
    imageRenderer: 'ex.image' | 'ex.image-v2';
    private _isDrawLifecycle;
    useDrawSorting: boolean;
    private _drawCallPool;
    private _drawCallIndex;
    private _drawCalls;
    private _renderTarget;
    private _msaaTarget;
    private _postProcessTargets;
    private _screenRenderer;
    private _postprocessors;
    /**
     * Meant for internal use only. Access the internal context at your own risk and no guarantees this will exist in the future.
     * @internal
     */
    __gl: WebGL2RenderingContext;
    private _transform;
    private _state;
    private _ortho;
    /**
     * Snaps the drawing x/y coordinate to the nearest whole pixel
     */
    snapToPixel: boolean;
    /**
     * Native context smoothing
     */
    readonly smoothing: boolean;
    /**
     * Whether the pixel art sampler is enabled for smooth sub pixel anti-aliasing
     */
    readonly pixelArtSampler: boolean;
    /**
     * UV padding in pixels to use in internal image rendering to prevent texture bleed
     *
     */
    uvPadding: number;
    backgroundColor: Color;
    textureLoader: TextureLoader;
    materialScreenTexture: WebGLTexture | null;
    get z(): number;
    set z(value: number);
    get opacity(): number;
    set opacity(value: number);
    get tint(): Color | undefined | null;
    set tint(color: Color | undefined | null);
    get width(): number;
    get height(): number;
    get ortho(): Matrix;
    /**
     * Checks the underlying webgl implementation if the requested internal resolution is supported
     * @param dim
     */
    checkIfResolutionSupported(dim: Resolution): boolean;
    readonly multiSampleAntialiasing: boolean;
    readonly samples?: number;
    readonly transparency: boolean;
    private _isContextLost;
    constructor(options: ExcaliburGraphicsContextWebGLOptions);
    private _disposed;
    dispose(): void;
    private _init;
    register<T extends RendererPlugin>(renderer: T): void;
    lazyRegister<TRenderer extends RendererPlugin>(type: TRenderer['type'], renderer: () => TRenderer): void;
    get(rendererName: string): RendererPlugin | undefined;
    private _currentRenderer;
    private _isCurrentRenderer;
    beginDrawLifecycle(): void;
    endDrawLifecycle(): void;
    draw<TRenderer extends RendererPlugin>(rendererName: TRenderer['type'], ...args: Parameters<TRenderer['draw']>): void;
    resetTransform(): void;
    updateViewport(resolution: Resolution): void;
    private _imageToWidth;
    private _getImageWidth;
    private _imageToHeight;
    private _getImageHeight;
    drawImage(image: HTMLImageSource, x: number, y: number): void;
    drawImage(image: HTMLImageSource, x: number, y: number, width: number, height: number): void;
    drawImage(image: HTMLImageSource, sx: number, sy: number, swidth?: number, sheight?: number, dx?: number, dy?: number, dwidth?: number, dheight?: number): void;
    drawLine(start: Vector, end: Vector, color: Color, thickness?: number): void;
    drawRectangle(pos: Vector, width: number, height: number, color: Color, stroke?: Color, strokeThickness?: number): void;
    drawCircle(pos: Vector, radius: number, color: Color, stroke?: Color, thickness?: number): void;
    debug: ExcaliburGraphicsContextWebGLDebug;
    save(): void;
    restore(): void;
    translate(x: number, y: number): void;
    rotate(angle: number): void;
    scale(x: number, y: number): void;
    transform(matrix: AffineMatrix): void;
    getTransform(): AffineMatrix;
    multiply(m: AffineMatrix): void;
    addPostProcessor(postprocessor: PostProcessor): void;
    removePostProcessor(postprocessor: PostProcessor): void;
    clearPostProcessors(): void;
    private _totalPostProcessorTime;
    updatePostProcessors(elapsed: number): void;
    set material(material: Material | null | undefined);
    get material(): Material | null | undefined;
    /**
     * Creates and initializes the material which compiles the internal shader
     * @param options
     * @returns Material
     */
    createMaterial(options: Omit<MaterialOptions, 'graphicsContext'>): Material;
    createShader(options: Omit<ShaderOptions, 'graphicsContext'>): Shader;
    clear(): void;
    /**
     * Flushes all batched rendering to the screen
     */
    flush(): void;
}
export {};
