import type { ExcaliburGraphicsContext } from '../Context/ExcaliburGraphicsContext';
import type { Vector } from '../../Math/vector';
/**
 * Internal debug text helper
 */
export declare class DebugText {
    constructor();
    /**
     * base64 font
     */
    readonly fontSheet: string;
    size: number;
    private _imageSource;
    private _spriteSheet;
    private _spriteFont;
    load(): Promise<void>;
    /**
     * Writes debug text using the built in sprint font
     * @param ctx
     * @param text
     * @param pos
     */
    write(ctx: ExcaliburGraphicsContext, text: string, pos: Vector): void;
}
