import type { Vector } from '../../../Math/vector';
import type { Color } from '../../../Color';
import type { ExcaliburGraphicsContextWebGL } from '../ExcaliburGraphicsContextWebGL';
import type { RendererPlugin } from '../renderer';
export interface LineOptions {
    color?: Color;
    width?: number;
}
export declare class LineRenderer implements RendererPlugin {
    readonly type = "ex.line";
    priority: number;
    private _context;
    private _gl;
    private _shader;
    private _maxLines;
    private _vertexBuffer;
    private _layout;
    private _vertexIndex;
    private _lineCount;
    initialize(gl: WebGL2RenderingContext, context: ExcaliburGraphicsContextWebGL): void;
    dispose(): void;
    private _startScratch;
    private _endScratch;
    draw(start: Vector, end: Vector, color: Color): void;
    private _isFull;
    hasPendingDraws(): boolean;
    flush(): void;
}
