import type { Vector } from '../Math/vector';
import type { ExcaliburGraphicsContext, LineGraphicsOptions, PointGraphicsOptions } from './Context/ExcaliburGraphicsContext';
import { Color } from '../Color';
import type { Ray } from '../Math/ray';
import type { BoundingBox } from '../Collision/BoundingBox';
export declare class Debug {
    static _drawCalls: ((ctx: ExcaliburGraphicsContext) => void)[];
    static _ctx: ExcaliburGraphicsContext;
    static z: number;
    static registerGraphicsContext(ctx: ExcaliburGraphicsContext): void;
    static draw(debugDrawCall: (ctx: ExcaliburGraphicsContext) => void): void;
    static drawPoint(point: Vector, options?: PointGraphicsOptions): void;
    static drawLine(start: Vector, end: Vector, options?: LineGraphicsOptions): void;
    static drawLines(points: Vector[], options?: LineGraphicsOptions): void;
    static drawText(text: string, pos: Vector): void;
    static drawPolygon(points: Vector[], options?: {
        color?: Color;
    }): void;
    static drawCircle(center: Vector, radius: number, options?: {
        color?: Color;
        strokeColor?: Color;
        width?: number;
    }): void;
    static drawBounds(boundingBox: BoundingBox, options?: {
        color?: Color;
    }): void;
    static drawRay(ray: Ray, options?: {
        distance?: number;
        color?: Color;
    }): void;
    static flush(ctx: ExcaliburGraphicsContext): void;
    static clear(): void;
}
