import { Vector } from '../Math/vector';
import type { GraphicOptions } from './Graphic';
import { Graphic } from './Graphic';
import type { HasTick } from './Animation';
import type { ExcaliburGraphicsContext } from './Context/ExcaliburGraphicsContext';
import { BoundingBox } from '../Collision/Index';
export interface GraphicsGroupingOptions {
    members: (GraphicsGrouping | Graphic)[];
    /**
     * Default true, GraphicsGroup will use the anchor to position all the graphics based on their combined bounds
     *
     * Setting to false will ignore anchoring from parent components and position the top left of all graphics at the actor's position,
     * positioning graphics in the group is done with the `offset` property.
     */
    useAnchor?: boolean;
}
export interface GraphicsGrouping {
    offset: Vector;
    graphic: Graphic;
    /**
     * Optionally disable this graphics bounds as part of group calculation, default true
     * if unspecified
     *
     * You may want disable this if you're using text because their bounds will affect
     * the centering of the whole group.
     *
     * **WARNING** having inaccurate bounds can cause offscreen culling issues.
     */
    useBounds?: boolean;
}
export declare class GraphicsGroup extends Graphic implements HasTick {
    private _logger;
    useAnchor: boolean;
    members: (GraphicsGrouping | Graphic)[];
    constructor(options: GraphicsGroupingOptions & GraphicOptions);
    clone(): GraphicsGroup;
    private _updateDimensions;
    get localBounds(): BoundingBox;
    private _isAnimationOrGroup;
    tick(elapsed: number, idempotencyToken?: number): void;
    reset(): void;
    protected _preDraw(ex: ExcaliburGraphicsContext, x: number, y: number): void;
    protected _drawImage(ex: ExcaliburGraphicsContext, x: number, y: number): void;
}
