import type { Scene } from '../Scene';
import { GraphicsComponent } from './GraphicsComponent';
import { TransformComponent } from '../EntityComponentSystem/Components/TransformComponent';
import type { Query, World } from '../EntityComponentSystem';
import { System, SystemType } from '../EntityComponentSystem';
export declare class GraphicsSystem extends System {
    world: World;
    static priority: 0;
    readonly systemType = SystemType.Draw;
    private _token;
    private _graphicsContext;
    private _camera;
    private _engine;
    private _sortedTransforms;
    query: Query<typeof TransformComponent | typeof GraphicsComponent>;
    get sortedTransforms(): TransformComponent[];
    constructor(world: World);
    initialize(world: World, scene: Scene): void;
    private _zHasChanged;
    private _zIndexUpdate;
    preupdate(): void;
    update(elapsed: number): void;
    private _drawGraphicsComponent;
    private _targetInterpolationTransform;
    /**
     * This applies the current entity transform to the graphics context
     * @param entity
     */
    private _applyTransform;
    private _applyOpacity;
}
