import { GraphicsComponent } from './GraphicsComponent';
import type { Scene } from '../Scene';
import { TransformComponent } from '../EntityComponentSystem/Components/TransformComponent';
import { System, SystemType } from '../EntityComponentSystem/System';
import type { Query, World } from '../EntityComponentSystem';
export declare class OffscreenSystem extends System {
    world: World;
    static priority: number;
    systemType: SystemType;
    private _camera;
    private _screen;
    private _worldBounds;
    query: Query<typeof TransformComponent | typeof GraphicsComponent>;
    constructor(world: World);
    initialize(world: World, scene: Scene): void;
    update(): void;
    private _isOffscreen;
}
