import { Vector } from '../Math/vector';
import type { ExcaliburGraphicsContext } from './Context/ExcaliburGraphicsContext';
import type { FontRenderer } from './FontCommon';
import type { GraphicOptions } from './Graphic';
import { Graphic } from './Graphic';
import type { SpriteSheet } from './SpriteSheet';
import { BoundingBox } from '../Collision/BoundingBox';
export interface SpriteFontOptions {
    /**
     * Alphabet string in spritesheet order (default is row column order)
     * example: 'abcdefghijklmnopqrstuvwxyz'
     */
    alphabet: string;
    /**
     * {@apilink SpriteSheet} to source character sprites from
     */
    spriteSheet: SpriteSheet;
    /**
     * Optionally ignore case in the supplied text;
     */
    caseInsensitive?: boolean;
    /**
     * Optionally override the text line height, useful for multiline text. If unset will use default.
     */
    lineHeight?: number | undefined;
    /**
     * Optionally adjust the spacing between character sprites
     */
    spacing?: number;
    /**
     * Optionally specify a "shadow"
     */
    shadow?: {
        offset: Vector;
    };
}
export declare class SpriteFont extends Graphic implements FontRenderer {
    private _text;
    alphabet: string;
    spriteSheet: SpriteSheet;
    shadow?: {
        offset: Vector;
    };
    caseInsensitive: boolean;
    spacing: number;
    lineHeight: number | undefined;
    private _logger;
    constructor(options: SpriteFontOptions & GraphicOptions);
    private _getCharacterSprites;
    measureText(text: string, maxWidth?: number): BoundingBox;
    protected _drawImage(ex: ExcaliburGraphicsContext, x: number, y: number, maxWidth?: number): void;
    render(ex: ExcaliburGraphicsContext, text: string, _color: any, x: number, y: number, maxWidth?: number): void;
    clone(): SpriteFont;
    /**
     * Return array of lines split based on the \n character, and the maxWidth? constraint
     * @param text
     * @param maxWidth
     */
    private _cachedText?;
    private _cachedLines?;
    private _cachedRenderWidth?;
    private _getLinesFromText;
}
