import type { ImageFiltering } from './Filtering';
import type { GraphicOptions } from './Graphic';
import type { ImageWrapConfiguration } from './ImageSource';
import { ImageSource } from './ImageSource';
import type { SourceView } from './Sprite';
import { Sprite } from './Sprite';
import { ImageWrapping } from './Wrapping';
export interface TiledSpriteOptions {
    image: ImageSource;
    /**
     * Source view into the {@link ImageSource image}
     */
    sourceView?: SourceView;
    /**
     * Optionally override {@link ImageFiltering filtering}
     */
    filtering?: ImageFiltering;
    /**
     * Optionally override {@link ImageWrapping wrapping} , default wrapping is Repeat for TiledSprite
     */
    wrapping?: ImageWrapConfiguration | ImageWrapping;
    /**
     * Total width in pixels for the tiling to take place over
     */
    width: number;
    /**
     * Total height in pixels for the tiling to take place over
     */
    height: number;
}
export declare class TiledSprite extends Sprite {
    private _ready;
    ready: Promise<void>;
    private _options;
    constructor(options: TiledSpriteOptions & GraphicOptions);
    static fromSprite(sprite: Sprite, options?: Partial<Omit<TiledSpriteOptions & GraphicOptions, 'image'>>): TiledSprite;
    private _applyTiling;
}
