import type { EventEmitter } from '../EventEmitter';
import type { GlobalCoordinates } from '../Math';
import type { PointerEventReceiver } from './PointerEventReceiver';
/**
 * Signals that an object has nested pointer events on nested objects that are not an Entity with
 * a PointerComponent. For example TileMap Tiles
 */
export interface HasNestedPointerEvents {
    _dispatchPointerEvents(receiver: PointerEventReceiver): void;
    _processPointerToObject(receiver: PointerEventReceiver): void;
}
export declare class PointerTargetObjectProxy<TObject extends {
    events: EventEmitter;
}> {
    object: TObject;
    contains: (point: GlobalCoordinates) => boolean;
    active: () => boolean;
    get events(): EventEmitter;
    init(object: TObject, contains: (point: GlobalCoordinates) => boolean, active: () => boolean): void;
}
export declare class PointerEventsToObjectDispatcher<TObject extends {
    events: EventEmitter;
}> {
    private _proxyPool;
    private _objectToProxy;
    private _proxies;
    /**
     * Tracks an object to associate with pointers and their events
     * @param object
     * @param contains
     * @param active
     */
    addObject(object: TObject, contains: (point: GlobalCoordinates) => boolean, active: () => boolean): void;
    private _getProxy;
    /**
     * Untracks an object associated with pointers and their events
     * @param object
     */
    removeObject(object: TObject): void;
    private _lastFrameObjectToPointers;
    private _currentFrameObjectToPointers;
    private _objectCurrentlyUnderPointer;
    private _objectWasUnderPointer;
    private _entered;
    private _left;
    /**
     * Manually associate a pointer id with an object.
     *
     * This assumes you've checked that the pointer is indeed over the object.
     */
    addPointerToObject(object: TObject, pointerId: number): void;
    private _addPointerToProxy;
    /**
     * Dispatches the appropriate pointer events in sortedObject order on tracked objects
     * @param receiver
     * @param sortedObjects
     */
    dispatchEvents(receiver: PointerEventReceiver, sortedObjects: TObject[]): void;
    /**
     * Given the tracked objects, update pointer containment given the provided contains()
     * @param receiver
     * @param objects
     */
    processPointerToObject(receiver: PointerEventReceiver, objects: TObject[]): void;
    /**
     * Clear current frames pointer-object associations and track last frame pointer-object associations
     */
    clear(): void;
    private _processDownAndEmit;
    private _processUpAndEmit;
    private _processMoveAndEmit;
    private _processEnterLeaveAndEmit;
    private _processCancelAndEmit;
    private _processWheelAndEmit;
}
