import { AffineMatrix } from './affine-matrix';
import type { Vector } from './vector';
export declare class Transform {
    private _parent;
    get parent(): Transform | null;
    set parent(transform: Transform | null);
    get children(): readonly Transform[];
    private _children;
    private _pos;
    set pos(v: Vector);
    get pos(): Vector;
    set globalPos(v: Vector);
    private _globalPos;
    get globalPos(): Vector;
    private _rotation;
    set rotation(rotation: number);
    get rotation(): number;
    set globalRotation(rotation: number);
    get globalRotation(): number;
    private _scale;
    set scale(v: Vector);
    get scale(): Vector;
    set globalScale(v: Vector);
    private _globalScale;
    get globalScale(): Vector;
    private _z;
    set z(z: number);
    get z(): number;
    set globalZ(z: number);
    get globalZ(): number;
    private _isDirty;
    private _isInverseDirty;
    private _matrix;
    private _inverse;
    /**
     * Calculates and returns the matrix representation of this transform
     *
     * Avoid mutating the matrix to update the transform, it is not the source of truth.
     * Update the transform pos, rotation, scale.
     */
    get matrix(): AffineMatrix;
    /**
     * Calculates and returns the inverse matrix representation of this transform
     */
    get inverse(): AffineMatrix;
    private _scratch;
    private _calculateMatrix;
    flagDirty(): void;
    apply(point: Vector): Vector;
    applyInverse(point: Vector): Vector;
    setTransform(pos: Vector, rotation: number, scale: Vector): void;
    /**
     * Returns true if the transform has a negative x scale or y scale, but not both
     */
    isMirrored(): boolean;
    /**
     * Clones the current transform
     * **Warning does not clone the parent**
     * @param dest
     */
    clone(dest?: Transform): Transform;
    /**
     * Clones but keeps the same parent reference
     */
    cloneWithParent(dest?: Transform): Transform;
    toString(): string;
}
