import type { Engine } from '../Engine';
import { Actor } from '../Actor';
import { EmitterType } from './EmitterType';
import type { ParticleEmitterArgs } from './Particles';
import type { GpuParticleConfig } from './GpuParticleRenderer';
import { GpuParticleRenderer } from './GpuParticleRenderer';
import { GraphicsComponent } from '../Graphics/GraphicsComponent';
import { Random } from '../Math/Random';
import type { Vector } from '../Math/vector';
import type { ExcaliburGraphicsContextWebGL } from '../Graphics/Context/ExcaliburGraphicsContextWebGL';
export declare class GpuParticleEmitter extends Actor {
    particle: GpuParticleConfig;
    graphics: GraphicsComponent;
    renderer: GpuParticleRenderer;
    isEmitting: boolean;
    emitRate: number;
    emitterType: EmitterType;
    radius: number;
    readonly maxParticles: number;
    random: Random;
    get pos(): Vector;
    set pos(pos: Vector);
    get z(): number;
    set z(z: number);
    constructor(config: ParticleEmitterArgs & {
        maxParticles?: number;
        particle?: GpuParticleConfig;
    });
    _initialize(engine: Engine): void;
    private _particlesToEmit;
    update(engine: Engine, elapsed: number): void;
    emitParticles(particleCount: number): void;
    clearParticles(): void;
    draw(ctx: ExcaliburGraphicsContextWebGL, elapsed: number): void;
}
