import type { Engine } from '../Engine';
import { Actor } from '../Actor';
import { Random } from '../Math/Random';
import { EmitterType } from './EmitterType';
import type { ParticleEmitterArgs, ParticleConfig } from './Particles';
import { Particle } from './Particles';
/**
 * Using a particle emitter is a great way to create interesting effects
 * in your game, like smoke, fire, water, explosions, etc. `ParticleEmitter`
 * extend {@apilink Actor} allowing you to use all of the features that come with.
 *
 * These particles are simulated on the CPU in JavaScript
 */
export declare class ParticleEmitter extends Actor {
    private _particlesToEmit;
    private _particlePool;
    numParticles: number;
    /**
     * Random number generator
     */
    random: Random;
    /**
     * Gets or sets the isEmitting flag
     */
    isEmitting: boolean;
    /**
     * Gets or sets the backing deadParticle collection
     */
    deadParticles: Particle[];
    /**
     * Gets or sets the emission rate for particles (particles/sec)
     */
    emitRate: number;
    /**
     * Gets or sets the emitter type for the particle emitter
     */
    emitterType: EmitterType;
    /**
     * Gets or sets the emitter radius, only takes effect when the {@apilink emitterType} is {@apilink EmitterType.Circle}
     */
    radius: number;
    particle: ParticleConfig;
    /**
     * @param config particle emitter options bag
     */
    constructor(config: ParticleEmitterArgs);
    removeParticle(particle: Particle): void;
    private _activeParticles;
    /**
     * Causes the emitter to emit particles
     * @param particleCount  Number of particles to emit right now
     */
    emitParticles(particleCount: number): void;
    clearParticles(): void;
    private _createParticle;
    update(engine: Engine, elapsed: number): void;
}
