import { Font } from '../Graphics/Font';
import type { FontOptions } from '../Graphics/FontCommon';
import type { GraphicOptions, RasterOptions } from '../Graphics';
import type { Loadable } from '../Interfaces/Loadable';
export interface FontSourceOptions extends Omit<FontOptions, 'family'>, GraphicOptions, RasterOptions {
    /**
     * Whether or not to cache-bust requests
     */
    bustCache?: boolean;
}
export declare class FontSource implements Loadable<FontFace> {
    /**
     * Path to the font resource relative from the HTML document hosting the game, or absolute
     */
    readonly path: string;
    /**
     * The font family name
     */
    readonly family: string;
    private _resource;
    private _isLoaded;
    private _options;
    data: FontFace;
    constructor(
    /**
     * Path to the font resource relative from the HTML document hosting the game, or absolute
     */
    path: string, 
    /**
     * The font family name
     */
    family: string, { bustCache, ...options }?: FontSourceOptions);
    load(): Promise<FontFace>;
    isLoaded(): boolean;
    /**
     * Build a font from this FontSource.
     * @param options {FontOptions} Override the font options
     */
    toFont(options?: FontOptions & GraphicOptions & RasterOptions): Font;
}
