import type { Engine } from './Engine';
import type { ActorArgs } from './Actor';
import { Actor } from './Actor';
/**
 * Type guard to detect a screen element
 */
export declare function isScreenElement(actor: Actor): actor is ScreenElement;
/**
 * Helper {@apilink Actor} primitive for drawing UI's, optimized for UI drawing. Does
 * not participate in collisions. Drawn on top of all other actors.
 */
export declare class ScreenElement extends Actor {
    protected _engine: Engine;
    constructor();
    constructor(config?: ActorArgs);
    _initialize(engine: Engine): void;
    contains(x: number, y: number, useWorld?: boolean): boolean;
}
