import { Component } from '../EntityComponentSystem/Component';
import type { IsometricMap } from './IsometricMap';
export interface IsometricEntityComponentOptions {
    columns: number;
    rows: number;
    tileWidth: number;
    tileHeight: number;
}
export declare class IsometricEntityComponent extends Component {
    /**
     * Vertical "height" in the isometric world
     */
    elevation: number;
    readonly columns: number;
    readonly rows: number;
    readonly tileWidth: number;
    readonly tileHeight: number;
    /**
     * Specify the isometric map to use to position this entity's z-index
     * @param mapOrOptions
     */
    constructor(mapOrOptions: IsometricMap | IsometricEntityComponentOptions);
}
