import type { Entity } from '../../EntityComponentSystem';
import type { Vector } from '../../Math';
import type { Action } from '../Action';
export interface CurveByOptions {
    /**
     * Bezier Curve relative to the current actor position to move
     */
    controlPoints: [control1: Vector, control2: Vector, end: Vector];
    /**
     * Total duration for the action to run
     */
    duration: number;
    /**
     * Dynamic mode will speed up/slow down depending on the curve
     *
     * Uniform mode will animate at a consistent velocity across the curve
     *
     * Default: 'dynamic'
     */
    mode?: 'dynamic' | 'uniform';
    /**
     * Quality when sampling uniform points on the curve. Samples = 4 * quality;
     *
     * For bigger 'uniform' curves you may want to increase quality to make the motion appear smooth
     *
     * Default 4
     */
    quality?: number;
}
export declare class CurveBy implements Action {
    id: number;
    private _curve;
    private _durationMs;
    private _entity;
    private _tx;
    private _currentMs;
    private _started;
    private _stopped;
    private _mode;
    constructor(entity: Entity, options: CurveByOptions);
    update(elapsed: number): void;
    isComplete(entity: Entity): boolean;
    reset(): void;
    stop(): void;
}
