import type { Entity } from '../../EntityComponentSystem/Entity';
import { Vector } from '../../Math/vector';
import type { EasingFunction } from '../../Util/EasingFunctions';
import type { Action } from '../Action';
export interface MoveByOptions {
    offset: Vector;
    duration: number;
    easing?: EasingFunction;
}
/**
 *
 */
export declare function isMoveByOptions(x: any): x is MoveByOptions;
export declare class MoveByWithOptions implements Action {
    entity: Entity;
    id: number;
    private _start;
    private _end;
    private _durationMs;
    private _tx;
    private _started;
    private _currentMs;
    private _stopped;
    private _motion;
    private _offset;
    private _easing;
    constructor(entity: Entity, options: MoveByOptions);
    update(elapsed: number): void;
    isComplete(entity: Entity): boolean;
    stop(): void;
    reset(): void;
}
export declare class MoveBy implements Action {
    id: number;
    private _tx;
    private _motion;
    private _entity;
    x: number;
    y: number;
    private _distance;
    private _speed;
    private _start;
    private _offset;
    private _end;
    private _dir;
    private _started;
    private _stopped;
    constructor(entity: Entity, offsetX: number, offsetY: number, speed: number);
    update(elapsed: number): void;
    isComplete(entity: Entity): boolean;
    stop(): void;
    reset(): void;
}
