import type { Entity } from '../../EntityComponentSystem/Entity';
import { Vector } from '../../Math/vector';
import type { EasingFunction } from '../../Util/EasingFunctions';
import type { Action } from '../Action';
export interface MoveToOptions {
    pos: Vector;
    duration: number;
    easing?: EasingFunction;
}
/**
 *
 */
export declare function isMoveToOptions(x: any): x is MoveToOptions;
export declare class MoveToWithOptions implements Action {
    entity: Entity;
    id: number;
    private _end;
    private _durationMs;
    private _tx;
    private _started;
    private _start;
    private _currentMs;
    private _stopped;
    private _motion;
    private _easing;
    constructor(entity: Entity, options: MoveToOptions);
    update(elapsed: number): void;
    isComplete(entity: Entity): boolean;
    stop(): void;
    reset(): void;
}
export declare class MoveTo implements Action {
    entity: Entity;
    id: number;
    private _tx;
    private _motion;
    x: number;
    y: number;
    private _start;
    private _end;
    private _dir;
    private _speed;
    private _distance;
    private _started;
    private _stopped;
    constructor(entity: Entity, destX: number, destY: number, speed: number);
    update(elapsed: number): void;
    isComplete(entity: Entity): boolean;
    stop(): void;
    reset(): void;
}
