import type { Action } from '../Action';
import type { Entity } from '../../EntityComponentSystem/Entity';
import { RotationType } from '../../Math';
export interface RotateByOptions {
    /**
     * Angle in radians to offset from the current and rotate
     */
    angleRadiansOffset: number;
    /**
     * Duration to take in milliseconds
     */
    duration: number;
    /**
     * Optionally provide type of rotation, default is RotationType.ShortestPath
     */
    rotationType?: RotationType;
}
/**
 *
 */
export declare function isRotateByOptions(x: any): x is RotateByOptions;
export declare class RotateByWithOptions implements Action {
    entity: Entity;
    id: number;
    private _durationMs;
    private _tx;
    private _started;
    private _currentMs;
    private _stopped;
    private _motion;
    private _offset;
    private _startAngle;
    private _rotationType;
    private _endAngle;
    constructor(entity: Entity, options: RotateByOptions);
    update(elapsed: number): void;
    isComplete(): boolean;
    stop(): void;
    reset(): void;
}
export declare class RotateBy implements Action {
    id: number;
    private _tx;
    private _motion;
    x: number;
    y: number;
    private _start;
    private _end;
    private _speed;
    private _offset;
    private _rotationType;
    private _direction;
    private _distance;
    private _shortDistance;
    private _longDistance;
    private _shortestPathIsPositive;
    private _currentNonCannonAngle;
    private _started;
    private _stopped;
    constructor(entity: Entity, angleRadiansOffset: number, speed: number, rotationType?: RotationType);
    update(elapsed: number): void;
    isComplete(): boolean;
    stop(): void;
    reset(): void;
}
