import type { Action } from '../Action';
import { RotationType } from '../../Math';
import type { Entity } from '../../EntityComponentSystem/Entity';
export interface RotateToOptions {
    /**
     * Absolute angle to rotate to in radians
     */
    angle: number;
    /**
     * Duration to take in milliseconds
     */
    duration: number;
    /**
     * Optionally provide type of rotation, default is RotationType.ShortestPath
     */
    rotationType?: RotationType;
}
/**
 *
 */
export declare function isRotateToOptions(x: any): x is RotateToOptions;
export declare class RotateToWithOptions implements Action {
    entity: Entity;
    id: number;
    private _durationMs;
    private _tx;
    private _started;
    private _currentMs;
    private _stopped;
    private _motion;
    private _endAngle;
    private _startAngle;
    private _rotationType;
    constructor(entity: Entity, options: RotateToOptions);
    update(elapsed: number): void;
    isComplete(entity: Entity): boolean;
    stop(): void;
    reset(): void;
}
export declare class RotateTo implements Action {
    id: number;
    private _tx;
    private _motion;
    x: number;
    y: number;
    private _start;
    private _end;
    private _speed;
    private _rotationType;
    private _direction;
    private _distance;
    private _shortDistance;
    private _longDistance;
    private _shortestPathIsPositive;
    private _currentNonCannonAngle;
    private _started;
    private _stopped;
    constructor(entity: Entity, angle: number, speed: number, rotationType?: RotationType);
    update(elapsed: number): void;
    isComplete(): boolean;
    stop(): void;
    reset(): void;
}
