import { Vector } from '../../Math/vector';
import type { Entity } from '../../EntityComponentSystem/Entity';
import type { Action } from '../Action';
export interface ScaleByOptions {
    /**
     * Absolute scale to change to
     */
    scaleOffset: Vector;
    /**
     * Duration to take in milliseconds
     */
    duration: number;
}
/**
 *
 */
export declare function isScaleByOptions(x: any): x is ScaleByOptions;
export declare class ScaleByWithOptions implements Action {
    entity: Entity;
    id: number;
    private _durationMs;
    private _tx;
    private _started;
    private _currentMs;
    private _stopped;
    private _motion;
    private _endScale;
    private _scaleOffset;
    private _startScale;
    constructor(entity: Entity, options: ScaleByOptions);
    update(elapsed: number): void;
    isComplete(): boolean;
    stop(): void;
    reset(): void;
}
export declare class ScaleBy implements Action {
    id: number;
    private _tx;
    private _motion;
    x: number;
    y: number;
    private _startScale;
    private _endScale;
    private _offset;
    private _distanceX;
    private _distanceY;
    private _directionX;
    private _directionY;
    private _started;
    private _stopped;
    private _speedX;
    private _speedY;
    constructor(entity: Entity, scaleOffsetX: number, scaleOffsetY: number, speed: number);
    update(elapsed: number): void;
    isComplete(): boolean;
    stop(): void;
    reset(): void;
}
