import type { CollisionContact } from '../Detection/CollisionContact';
import { ContactConstraintPoint } from './ContactConstraintPoint';
import type { CollisionSolver } from './Solver';
import type { DeepRequired } from '../../Util/Required';
import type { PhysicsConfig } from '../PhysicsConfig';
export declare class RealisticSolver implements CollisionSolver {
    config: DeepRequired<Pick<PhysicsConfig, 'realistic'>['realistic']>;
    directionMap: Map<string, "horizontal" | "vertical">;
    distanceMap: Map<string, number>;
    constructor(config: DeepRequired<Pick<PhysicsConfig, 'realistic'>['realistic']>);
    lastFrameContacts: Map<string, CollisionContact>;
    idToContactConstraint: Map<string, ContactConstraintPoint[]>;
    getContactConstraints(id: string): ContactConstraintPoint[];
    solve(contacts: CollisionContact[]): CollisionContact[];
    preSolve(contacts: CollisionContact[]): void;
    postSolve(contacts: CollisionContact[]): void;
    /**
     * Warm up body's based on previous frame contact points
     * @param contacts
     */
    warmStart(contacts: CollisionContact[]): void;
    /**
     * Iteratively solve the position overlap constraint
     * @param contacts
     */
    solvePosition(contacts: CollisionContact[]): void;
    solveVelocity(contacts: CollisionContact[]): void;
}
