import { ColorBlindnessMode } from '../Graphics/PostProcessor/ColorBlindnessMode';
import type { Engine } from '../Engine';
export declare class ColorBlindFlags {
    private _engine;
    private _colorBlindPostProcessor;
    constructor(engine: Engine);
    /**
     * Correct colors for a specified color blindness
     * @param colorBlindness
     */
    correct(colorBlindness: ColorBlindnessMode): void;
    /**
     * Simulate colors for a specified color blindness
     * @param colorBlindness
     */
    simulate(colorBlindness: ColorBlindnessMode): void;
    /**
     * Remove color blindness post processor
     */
    clear(): void;
}
