import type { HTMLImageSource } from '../ExcaliburGraphicsContext';
import type { ExcaliburGraphicsContextWebGL } from '../ExcaliburGraphicsContextWebGL';
import type { RendererPlugin } from '../renderer';
export interface ImageRendererOptions {
    pixelArtSampler: boolean;
    uvPadding: number;
}
export declare class ImageRenderer implements RendererPlugin {
    readonly type = "ex.image";
    priority: number;
    readonly pixelArtSampler: boolean;
    readonly uvPadding: number;
    private _maxImages;
    private _maxTextures;
    private _context;
    private _gl;
    private _shader;
    private _buffer;
    private _layout;
    private _quads;
    private _imageCount;
    private _textures;
    private _textureIndex;
    private _textureToIndex;
    private _images;
    private _vertexIndex;
    constructor(options: ImageRendererOptions);
    initialize(gl: WebGL2RenderingContext, context: ExcaliburGraphicsContextWebGL): void;
    dispose(): void;
    private _transformFragmentSource;
    private _addImageAsTexture;
    private _bindTextures;
    private _getTextureIdForImage;
    private _isFull;
    private _imageToWidth;
    private _getImageWidth;
    private _imageToHeight;
    private _getImageHeight;
    private _view;
    private _dest;
    private _quad;
    private _defaultTint;
    draw(image: HTMLImageSource, sx: number, sy: number, swidth?: number, sheight?: number, dx?: number, dy?: number, dwidth?: number, dheight?: number): void;
    hasPendingDraws(): boolean;
    flush(): void;
}
