import type { GarbageCollector } from '../../GarbageCollector';
import { ImageFiltering } from '../Filtering';
import type { ImageSourceOptions, ImageWrapConfiguration } from '../ImageSource';
import type { HTMLImageSource } from './ExcaliburGraphicsContext';
/**
 * Manages loading image sources into webgl textures, a unique id is associated with all sources
 */
export declare class TextureLoader {
    private _garbageCollector?;
    private static _LOGGER;
    constructor(gl: WebGL2RenderingContext, _garbageCollector?: {
        garbageCollector: GarbageCollector;
        collectionInterval: number;
    });
    dispose(): void;
    /**
     * Sets the default filtering for the Excalibur texture loader, default {@apilink ImageFiltering.Blended}
     */
    static filtering: ImageFiltering;
    static wrapping: ImageWrapConfiguration;
    private _gl;
    private _textureMap;
    private static _MAX_TEXTURE_SIZE;
    /**
     * Get the WebGL Texture from a source image
     * @param image
     */
    get(image: HTMLImageSource): WebGLTexture;
    /**
     * Returns whether a source image has been loaded as a texture
     * @param image
     */
    has(image: HTMLImageSource): boolean;
    /**
     * Loads a graphic into webgl and returns it's texture info, a webgl context must be previously registered
     * @param image Source graphic
     * @param options {ImageSourceOptions} Optionally configure the ImageFiltering and ImageWrapping mode to apply to the loaded texture
     * @param forceUpdate Optionally force a texture to be reloaded, useful if the source graphic has changed
     */
    load(image: HTMLImageSource, options?: ImageSourceOptions, forceUpdate?: boolean): WebGLTexture | null;
    delete(image: HTMLImageSource): void;
    /**
     * Takes an image and returns if it meets size criteria for hardware
     * @param image
     * @returns if the image will be supported at runtime
     */
    static checkImageSizeSupportedAndLog(image: HTMLImageSource): boolean;
    /**
     * Looks for textures that haven't been drawn in a while
     */
    private _collect;
}
