export interface UniformBufferOptions {
    /**
     * WebGL2RenderingContext this layout will be attached to, these cannot be reused across contexts.
     */
    gl: WebGL2RenderingContext;
    /**
     * Size in number of floats, so [4.2, 4.0, 2.1] is size = 3
     *
     * **NOTE It is recommended you use multiples of 4's to avoid hardware implemenetation bugs, vec4's the the most supported**
     *
     * Ignored if data is passed directly
     */
    size?: number;
    /**
     * If the vertices never change switching 'static' can be more efficient on the gpu
     *
     * Default is 'dynamic'
     */
    type?: 'static' | 'dynamic';
    /**
     * Optionally pass pre-seeded data, size parameter is ignored
     */
    data?: Float32Array;
}
export declare class UniformBuffer {
    private _gl;
    /**
     * Access to the webgl buffer handle
     */
    readonly buffer: WebGLBuffer;
    readonly bufferData: Float32Array;
    type: 'static' | 'dynamic';
    private _maxFloats;
    constructor(options: UniformBufferOptions);
    /**
     * Bind this uniform buffer
     */
    bind(): void;
    unbind(): void;
    upload(count?: number): void;
    dispose(): void;
}
