import type { Shader } from './shader';
import type { VertexBuffer } from './vertex-buffer';
export interface VertexLayoutOptions {
    /**
     * WebGL2RenderingContext this layout will be attached to, these cannot be reused across contexts.
     */
    gl: WebGL2RenderingContext;
    /**
     * Shader that this layout will be for, if null you must set a shader before using it.
     */
    shader?: Shader;
    /**
     * Vertex buffer to use for vertex data
     */
    vertexBuffer: VertexBuffer;
    /**
     * Starting index for the attribute pointer
     */
    attributePointerStartIndex?: number;
    /**
     * Specify the attributes that will exist in the vertex buffer
     *
     * **Important** must specify them in the order that they will be in the vertex buffer!!
     */
    attributes: [name: string, numberOfComponents: number, type?: 'int' | 'matrix' | 'float'][];
    /**
     * Optionally suppress any warnings out of vertex layouts
     *
     * **BEWARE** this may cause you to have issues go unnoticed
     */
    suppressWarnings?: boolean;
}
/**
 * Helper around creating vertex attributes in a given {@apilink VertexBuffer}, this is useful for describing
 * the memory layout for your vertices inside a particular buffer
 *
 * Note: This helper assumes interleaved attributes in one {@apilink VertexBuffer}, not many.
 *
 * Working with `gl.vertexAttribPointer` can be tricky, and this attempts to double check you
 */
export declare class VertexLayout {
    private _gl;
    private _logger;
    private _suppressWarnings;
    private _shader;
    private _layout;
    private _attributes;
    private _vertexBuffer;
    private _vao;
    get vertexBuffer(): VertexBuffer;
    get attributes(): readonly [name: string, numberOfComponents: number, type?: 'int' | 'matrix' | 'float'][];
    constructor(options: VertexLayoutOptions);
    private _vertexTotalSizeBytes;
    /**
     * Total number of bytes that the vertex will take up
     */
    get totalVertexSizeBytes(): number;
    set shader(shader: Shader);
    get shader(): Shader;
    private _initialized;
    /**
     * Layouts need shader locations and must be bound to a shader
     */
    initialize(): void;
    /**
     * Bind this layout with it's associated vertex buffer
     * @param uploadBuffer Optionally indicate you wish to upload the buffer to the GPU associated with this layout
     */
    use(uploadBuffer?: boolean, count?: number): void;
}
