/**
 * Return the size of the GlType in bytes
 * @param gl
 * @param type
 */
export declare function getGlTypeSizeBytes(gl: WebGLRenderingContext, type: number): number;
/**
 * Checks if an attribute is present in vertex source
 */
export declare function isAttributeInSource(source: string, variable: string): boolean;
/**
 * Attempt to discern the glType of an attribute from vertex source
 * @param gl
 * @param source
 * @param variable
 */
export declare function getGLTypeFromSource(gl: WebGLRenderingContext, source: string, variable: string): 5121 | 5126 | 5123 | 5124 | 35670 | 5125 | 5120 | 5122;
/**
 * Based on the type return the number of attribute components
 *
 * https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/vertexAttribPointer
 * @param gl
 * @param type
 */
export declare function getAttributeComponentSize(gl: WebGLRenderingContext, type: number): number;
/**
 * Based on the attribute return the corresponding supported attrib pointer type
 * https://developer.mozilla.org/en-US/docs/Web/API/WebGLRenderingContext/vertexAttribPointer
 * @param gl
 * @param type
 */
export declare function getAttributePointerType(gl: WebGLRenderingContext, type: number): 5121 | 5126 | 5123 | 5120 | 5122;
/**
 *
 */
export declare function getMaxShaderComplexity(gl: WebGL2RenderingContext, numIfs: number): number;
