import type { ExcaliburGraphicsContext } from './Context/ExcaliburGraphicsContext';
import type { DebugConfig } from '../Debug';
import { Component } from '../EntityComponentSystem/Component';
/**
 * Provide arbitrary drawing for the purposes of debugging your game
 *
 * Will only show when the Engine is set to debug mode {@apilink Engine.showDebug} or {@apilink Engine.toggleDebug}
 *
 */
export declare class DebugGraphicsComponent extends Component {
    draw: (ctx: ExcaliburGraphicsContext, debugFlags: DebugConfig) => void;
    useTransform: boolean;
    constructor(draw: (ctx: ExcaliburGraphicsContext, debugFlags: DebugConfig) => void, useTransform?: boolean);
}
