import { BoundingBox } from '../Collision/BoundingBox';
import { Color } from '../Color';
import type { ExcaliburGraphicsContext } from './Context/ExcaliburGraphicsContext';
import type { Font } from './Font';
export declare class FontTextInstance {
    readonly font: Font;
    readonly text: string;
    readonly color: Color;
    readonly maxWidth?: number;
    canvas: HTMLCanvasElement;
    ctx: CanvasRenderingContext2D;
    private _textFragments;
    dimensions: BoundingBox;
    disposed: boolean;
    private _lastHashCode;
    constructor(font: Font, text: string, color: Color, maxWidth?: number);
    measureText(text: string, maxWidth?: number): BoundingBox;
    private _setDimension;
    static getHashCode(font: Font, text: string, color?: Color): string;
    getHashCode(includeColor?: boolean): string;
    protected _applyRasterProperties(ctx: CanvasRenderingContext2D): void;
    private _applyFont;
    private _drawText;
    private _splitTextBitmap;
    flagDirty(): void;
    private _dirty;
    private _ex?;
    render(ex: ExcaliburGraphicsContext, x: number, y: number, maxWidth?: number): void;
    dispose(): void;
    /**
     * Return array of lines split based on the \n character, and the maxWidth? constraint
     * @param text
     * @param maxWidth
     */
    private _cachedText?;
    private _cachedLines?;
    private _cachedRenderWidth?;
    private _getLinesFromText;
}
