import type { Engine } from '../Engine';
import { Gamepads } from './Gamepad';
import { InputMapper } from './InputMapper';
import { Keyboard } from './Keyboard';
import { PointerEventReceiver } from './PointerEventReceiver';
export interface InputHostOptions {
    pointerTarget: Document | HTMLCanvasElement;
    grabWindowFocus: boolean;
    engine: Engine;
}
export declare class InputHost {
    private _enabled;
    keyboard: Keyboard;
    pointers: PointerEventReceiver;
    gamepads: Gamepads;
    inputMapper: InputMapper;
    constructor(options: InputHostOptions);
    get enabled(): boolean;
    toggleEnabled(enabled: boolean): void;
    update(): void;
    clear(): void;
}
