import type { World, Query } from '../EntityComponentSystem';
import { System, TransformComponent, SystemType } from '../EntityComponentSystem';
import type { Scene } from '../Scene';
import { PointerComponent } from './PointerComponent';
/**
 * The PointerSystem is responsible for dispatching pointer events to entities
 * that need them.
 *
 * The PointerSystem can be optionally configured by the {@apilink PointerComponent}, by default Entities use
 * the {@apilink Collider}'s shape for pointer events.
 */
export declare class PointerSystem extends System {
    world: World;
    static priority: -5;
    readonly systemType = SystemType.Update;
    private _engine;
    private _receivers;
    private _engineReceiver;
    private _graphicsHashGrid;
    private _graphics;
    private _entityToPointer;
    private _pointerEventDispatcher;
    query: Query<typeof TransformComponent | typeof PointerComponent>;
    constructor(world: World);
    /**
     * Optionally override component configuration for all entities
     */
    overrideUseColliderShape: boolean;
    /**
     * Optionally override component configuration for all entities
     */
    overrideUseGraphicsBounds: boolean;
    private _scene;
    initialize(world: World, scene: Scene): void;
    private _sortedTransforms;
    private _sortedEntities;
    private _zHasChanged;
    private _zIndexUpdate;
    preupdate(): void;
    update(): void;
}
