/**
 * Enum representing the coordinate plane for the position 2D vector in the {@apilink TransformComponent}
 */
export declare enum CoordPlane {
    /**
     * The world coordinate plane (default) represents world space, any entities drawn with world
     * space move when the camera moves.
     */
    World = "world",
    /**
     * The screen coordinate plane represents screen space, entities drawn in screen space are pinned
     * to screen coordinates ignoring the camera.
     */
    Screen = "screen"
}
